/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.observer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import sina.mobile.tianqitong.observer.Event;
import sina.mobile.tianqitong.observer.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Notifier {
    private static Notifier mInstance = new Notifier();
    private Map<String, Collection<Observer>> mObserverMap = new HashMap<String, Collection<Observer>>();

    private Notifier() {
    }

    public static Notifier getInstance() {
        return mInstance;
    }

    public synchronized void addObserver(Observer observer, String command) {
        Collection<Observer> c = this.mObserverMap.get(command);
        if (c == null) {
            c = new HashSet<Observer>();
            this.mObserverMap.put(command, c);
        }
        c.add(observer);
    }

    public synchronized void addObserver(Observer observer, String ... commands) {
        for (String command : commands) {
            Collection<Observer> c = this.mObserverMap.get(command);
            if (c == null) {
                c = new HashSet<Observer>();
                this.mObserverMap.put(command, c);
            }
            c.add(observer);
        }
    }

    public synchronized void addObserver(Observer observer, ArrayList<String> commands) {
        for (String command : commands) {
            Collection<Observer> c = this.mObserverMap.get(command);
            if (c == null) {
                c = new HashSet<Observer>();
                this.mObserverMap.put(command, c);
            }
            c.add(observer);
        }
    }

    public synchronized void removeObserverForCommand(Observer observer, String ... commands) {
        for (String command : commands) {
            Collection<Observer> c = this.mObserverMap.get(command);
            if (c == null || !c.contains(observer)) continue;
            c.remove(observer);
        }
    }

    public synchronized void removeObserverForCommand(Observer observer, ArrayList<String> commands) {
        for (String command : commands) {
            Collection<Observer> c = this.mObserverMap.get(command);
            if (c == null || !c.contains(observer)) continue;
            c.remove(observer);
        }
    }

    public synchronized void removeObserverForCommand(Observer observer, String command) {
        Collection<Observer> c = this.mObserverMap.get(command);
        if (c != null && c.contains(observer)) {
            c.remove(observer);
        }
    }

    public synchronized void removeObserverForAllCommands(Observer observer) {
        Set<Map.Entry<String, Collection<Observer>>> set = this.mObserverMap.entrySet();
        for (Map.Entry<String, Collection<Observer>> entry : set) {
            entry.getValue().remove(observer);
        }
    }

    public synchronized void removeAllObserversForCommand(String command) {
        Collection<Observer> c = this.mObserverMap.get(command);
        if (c != null && !c.isEmpty()) {
            c.clear();
        }
    }

    public synchronized void removeAllObservers() {
        if (!this.mObserverMap.isEmpty()) {
            this.mObserverMap.clear();
        }
    }

    public synchronized void notifyEvent(String command, Object ... param) {
        Event e = Event.createEvent(command, param);
        Collection<Observer> c = this.mObserverMap.get(command);
        if (c != null) {
            for (Observer observer : c) {
                observer.handleEvent(e);
            }
        }
    }
}

