/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.moduleui;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import sina.mobile.tianqitong.constants.Colors;

public class CustomComboBoxUI
extends BasicComboBoxUI {
    private Image backgroundImage = null;
    private Image arrowImage = null;

    private CustomComboBoxUI() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.backgroundImage = tk.getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/choose-frame.png"));
        this.arrowImage = tk.getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/arrow_updown.png"));
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.comboBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ((JComponent)((Object)CustomComboBoxUI.this.comboBox.getRenderer())).setOpaque(true);
                CustomComboBoxUI.this.comboBox.repaint();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((JComponent)((Object)CustomComboBoxUI.this.comboBox.getRenderer())).setOpaque(false);
                CustomComboBoxUI.this.comboBox.repaint();
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        ((JComponent)((Object)this.comboBox.getRenderer())).setOpaque(false);
    }

    public static CustomComboBoxUI createUI(JComboBox c) {
        return new CustomComboBoxUI();
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        g.drawImage(this.backgroundImage, 0, 0, bounds.width + 21, bounds.height + 1, null);
    }

    protected JButton createArrowButton() {
        JButton button = new JButton(){

            public void paint(Graphics g) {
                if (CustomComboBoxUI.this.isPopupVisible(CustomComboBoxUI.this.comboBox)) {
                    g.setColor(Colors.BACKGROUND);
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    g.drawImage(CustomComboBoxUI.this.arrowImage, 4, 2, null);
                }
            }
        };
        button.setOpaque(false);
        return button;
    }
}

