/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class TileLayout
implements LayoutManager {
    protected int hgap;
    protected int vgap;
    protected int column;
    protected int layModel;
    protected Dimension d;
    public static final int INDENTIC_SIZE = 0;
    public static final int PREFER_SIZE = 1;

    public TileLayout() {
        this(20, 20);
    }

    public TileLayout(int column) {
        this(20, 20, column, 0);
    }

    public TileLayout(int hgap, int vgap) {
        this(hgap, vgap, 4, 1);
    }

    public TileLayout(int hgap, int vgap, int column, int model) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.column = column;
        this.layModel = model;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLayModel() {
        return this.layModel;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setModel(int model) {
        this.layModel = model;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension maxCompSize(Container target) {
        Dimension dimen = new Dimension(0, 0);
        Object object = target.getTreeLock();
        synchronized (object) {
            int numbers = target.getComponentCount();
            for (int i = 0; i < numbers; ++i) {
                Dimension di = target.getComponent(i).getPreferredSize();
                dimen = this.union(dimen, di);
            }
            return dimen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.d = this.maxCompSize(parent);
            int num = parent.getComponentCount();
            int r = (num - 1) / this.column + 1;
            int c = this.column;
            int w = c * this.d.width + (c + 1) * this.hgap;
            int h = r * this.d.height + (r + 1) * this.vgap;
            return new Dimension(w, h);
        }
    }

    public Dimension getEssentialLayoutSize(Container parent, int col) {
        this.d = this.maxCompSize(parent);
        int num = parent.getComponentCount();
        int r = (num - 1) / col + 1;
        int c = col;
        int w = c * this.d.width + (c + 1) * this.hgap;
        int h = r * this.d.height + (r + 1) * this.vgap;
        return new Dimension(w, h);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            this.d = this.maxCompSize(parent);
            int numbers = parent.getComponentCount();
            Dimension cd = parent.getSize();
            this.column = cd.width / (this.d.width + this.hgap);
            if (this.column == 0) {
                this.column = 1;
            }
            for (int i = 0; i < numbers; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                int x = i % this.column;
                int y = i / this.column;
                comp.setLocation(x * (this.hgap + this.d.width) + this.hgap, y * (this.vgap + this.d.height) + this.vgap);
                if (this.layModel == 1) {
                    comp.setSize(comp.getPreferredSize());
                    continue;
                }
                if (this.layModel != 0) continue;
                comp.setSize(this.d);
            }
        }
    }

    private Dimension union(Dimension d1, Dimension d2) {
        return new Dimension(d1.width > d2.width ? d1.width : d2.width, d1.height > d2.height ? d1.height : d2.height);
    }
}

