/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.observer.Event;
import sina.mobile.tianqitong.observer.Notifier;
import sina.mobile.tianqitong.observer.Observer;

public class SkinPreviewPane
extends JPanel
implements Observer {
    private static final int SCREEN_X = 19;
    private static final int SCREEN_Y = 58;
    private static final int SCREEN_W = 184;
    private static final int SCREEN_H = 300;
    private static final int OFFSET_Y = 48;
    private File phoneWallpaperFile;
    private BufferedImage bgImg;
    private BufferedImage phoneWallpaperImg;
    private BufferedImage skinImg;
    private static final int ICON_W = 640;
    private static final int ICON_H = 300;
    private static final int ICON2_W = 260;
    private static final int ICON2_H = 178;

    public SkinPreviewPane() {
        this.initComponents();
        this.initBg();
    }

    private void initBg() {
        Notifier.getInstance().addObserver((Observer)this, "update_skin_preview");
        InputStream in = this.getClass().getResourceAsStream("/sina/mobile/tianqitong/resources/phone.png");
        try {
            this.bgImg = ImageIO.read(in);
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void paint(Graphics g) {
        g.setColor(Colors.LIGHT_AREA);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        int paneW = this.getWidth();
        int paneH = this.getHeight();
        int x = (paneW - this.bgImg.getWidth()) / 2;
        int y = (paneH - this.bgImg.getHeight()) / 2;
        g.drawImage(this.bgImg, x, y, null);
        g.setColor(Color.BLACK);
        g.fillRect(x + 19, y + 58, 184, 300);
        if (this.phoneWallpaperFile != null && this.phoneWallpaperFile.exists() && this.phoneWallpaperFile.isFile() && this.phoneWallpaperFile.canRead()) {
            try {
                this.phoneWallpaperImg = ImageIO.read(this.phoneWallpaperFile);
                g.drawImage(this.phoneWallpaperImg, x + 19, y + 58, 184, 300, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.skinImg != null) {
            Image new_img = this.skinImg.getScaledInstance(184, Math.max(1, (int)Math.round((double)(this.skinImg.getHeight() * 184) * 1.0 / (double)this.skinImg.getWidth())), 4);
            g.drawImage(new_img, x + 19 + 0, y + 58 + 48, null);
        }
    }

    public BufferedImage getPreviewIcon2() {
        BufferedImage icon = new BufferedImage(260, 178, 2);
        Graphics g = icon.getGraphics();
        if (this.skinImg == null) {
            return icon;
        }
        int sw = 260;
        int sh = Math.max(1, (int)Math.round((double)(this.skinImg.getHeight() * 260) * 1.0 / (double)this.skinImg.getWidth()));
        if (sh > 178) {
            sw = Math.max(1, (int)Math.round((double)(sw * 178) * 1.0 / (double)sh));
            sh = 178;
        }
        if (this.phoneWallpaperImg == null) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 260, 178);
        } else {
            int pw = 260;
            int ph = Math.max(1, (int)Math.round((double)(this.phoneWallpaperImg.getHeight() * 260) * 1.0 / (double)this.phoneWallpaperImg.getWidth()));
            g.drawImage(this.phoneWallpaperImg.getScaledInstance(pw, ph, 4), 0, 0, null);
        }
        g.drawImage(this.skinImg.getScaledInstance(sw, sh, 4), (260 - sw) / 2, (178 - sh) / 2, null);
        return icon;
    }

    public BufferedImage getPreviewIcon() {
        BufferedImage icon = new BufferedImage(640, 300, 2);
        Graphics g = icon.getGraphics();
        if (this.skinImg == null) {
            return icon;
        }
        int sw = 640;
        int sh = Math.max(1, (int)Math.round((double)(this.skinImg.getHeight() * 640) * 1.0 / (double)this.skinImg.getWidth()));
        if (sh > 300) {
            sw = Math.max(1, (int)Math.round((double)(sw * 300) * 1.0 / (double)sh));
            sh = 300;
        }
        if (this.phoneWallpaperImg == null) {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, 640, 300);
        } else {
            int pw = 640;
            int ph = Math.max(1, (int)Math.round((double)(this.phoneWallpaperImg.getHeight() * 640) * 1.0 / (double)this.phoneWallpaperImg.getWidth()));
            g.drawImage(this.phoneWallpaperImg.getScaledInstance(pw, ph, 4), 0, 0, null);
        }
        g.drawImage(this.skinImg.getScaledInstance(sw, sh, 4), (640 - sw) / 2, (300 - sh) / 2, null);
        return icon;
    }

    public void setSkinImg(BufferedImage skinImg) {
        this.skinImg = skinImg;
        this.repaint();
    }

    public void setPhoneWallpaper(File cellPhoneBackgroundFile) {
        this.phoneWallpaperFile = cellPhoneBackgroundFile;
        this.repaint();
    }

    public void handleEvent(Event event) {
        if ("update_skin_preview".equals(event.getCommand())) {
            this.setPhoneWallpaper(null);
        }
    }
}

