/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class JInfiniteProgressPanel
extends JComponent
implements MouseListener {
    protected Thread animation = null;
    protected boolean started = false;
    protected int alphaLevel = 0;
    protected int rampDelay = 300;
    protected float shield = 0.7f;
    protected String text = "";
    protected float fps = 15.0f;
    protected RenderingHints hints = null;
    protected Image progressBarImage = null;
    protected Image progressBarBgImage = null;
    protected Image loadingPercentBgImage = null;
    protected int rate = 0;

    public JInfiniteProgressPanel() {
        this("");
    }

    public JInfiniteProgressPanel(String text) {
        this.text = text;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.progressBarImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/loading_progress_bar.png"));
        this.progressBarBgImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/loading_frame.png"));
        this.loadingPercentBgImage = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/sina/mobile/tianqitong/resources/loading_percent.png"));
    }

    public JInfiniteProgressPanel(String text, Image progressBarImage, Image progressBarBgImage, Image loadingPercentBgImage) {
        this.text = text;
        this.hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.hints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.progressBarImage = progressBarImage;
        this.progressBarBgImage = progressBarBgImage;
        this.loadingPercentBgImage = loadingPercentBgImage;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public void setRate(int rate) {
        this.rate = rate;
        this.repaint();
    }

    public int getRate() {
        return this.rate;
    }

    public void start() {
        this.rate = 0;
        this.addMouseListener(this);
        this.setVisible(true);
        this.animation = new Thread(new Animator(true));
        this.animation.start();
    }

    public void stop() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.animation = new Thread(new Animator(false));
            this.animation.start();
        }
    }

    public void interrupt() {
        if (this.animation != null) {
            this.animation.interrupt();
            this.animation = null;
            this.removeMouseListener(this);
            this.setVisible(false);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.started) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.hints);
            int alpha = 0;
            if ((int)((float)this.alphaLevel * this.shield) >= 0 && (int)((float)this.alphaLevel * this.shield) <= 255) {
                alpha = (int)((float)this.alphaLevel * this.shield);
            }
            g2.setColor(new Color(58, 58, 58, alpha));
            g2.fillRect(0, 0, width, height);
            if (this.progressBarImage != null) {
                int iw = this.rate;
                if (iw > 100) {
                    iw = 100;
                }
                if (iw < 0) {
                    iw = 0;
                }
                if (this.progressBarBgImage != null) {
                    g.drawImage(this.progressBarBgImage, (width - 300) / 2 - (this.progressBarBgImage.getWidth(null) - 1) / 2, height / 2 + 100, (width - 300) / 2, height / 2 + 100 + this.progressBarBgImage.getHeight(null), 0, 0, (this.progressBarBgImage.getWidth(null) - 1) / 2, this.progressBarBgImage.getHeight(null), null);
                    g.drawImage(this.progressBarBgImage, (width - 300) / 2, height / 2 + 100, (width - 300) / 2 + 300, height / 2 + 100 + this.progressBarBgImage.getHeight(null), (this.progressBarBgImage.getWidth(null) - 1) / 2, 0, (this.progressBarBgImage.getWidth(null) - 1) / 2 + 1, this.progressBarBgImage.getHeight(null), null);
                    g.drawImage(this.progressBarBgImage, (width - 300) / 2 + 300, height / 2 + 100, (width - 300) / 2 + 300 + (this.progressBarBgImage.getWidth(null) - 1) / 2, height / 2 + 100 + this.progressBarBgImage.getHeight(null), (this.progressBarBgImage.getWidth(null) - 1) / 2 + 1, 0, this.progressBarBgImage.getWidth(null), this.progressBarBgImage.getHeight(null), null);
                }
                g.drawImage(this.progressBarImage, (width - 300) / 2 - (this.progressBarImage.getWidth(null) - 1) / 2, height / 2 + 100, (width - 300) / 2, height / 2 + 100 + this.progressBarImage.getHeight(null), 0, 0, (this.progressBarImage.getWidth(null) - 1) / 2, this.progressBarImage.getHeight(null), null);
                g.drawImage(this.progressBarImage, (width - 300) / 2, height / 2 + 100, (width - 300) / 2 + iw * 3, height / 2 + 100 + this.progressBarImage.getHeight(null), (this.progressBarImage.getWidth(null) - 1) / 2, 0, (this.progressBarImage.getWidth(null) - 1) / 2 + 1, this.progressBarImage.getHeight(null), null);
                g.drawImage(this.progressBarImage, (width - 300) / 2 + iw * 3, height / 2 + 100, (width - 300) / 2 + iw * 3 + (this.progressBarImage.getWidth(null) - 1) / 2, height / 2 + 100 + this.progressBarImage.getHeight(null), (this.progressBarImage.getWidth(null) - 1) / 2 + 1, 0, this.progressBarImage.getWidth(null), this.progressBarImage.getHeight(null), null);
                if (this.loadingPercentBgImage != null) {
                    g.drawImage(this.loadingPercentBgImage, (width - this.loadingPercentBgImage.getWidth(null)) / 2, height / 2 + 100 + 24, null);
                }
                FontRenderContext context = g2.getFontRenderContext();
                TextLayout layout = new TextLayout(this.rate + "%", new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12), context);
                Rectangle2D bounds = layout.getBounds();
                g2.setColor(new Color(11403055));
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)(height / 2 + 100) + (float)bounds.getHeight() + 34.0f);
            }
            if (this.text != null && this.text.length() > 0) {
                FontRenderContext context = g2.getFontRenderContext();
                TextLayout layout = new TextLayout(this.text, new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 24), context);
                Rectangle2D bounds = layout.getBounds();
                g2.setColor(Color.WHITE);
                layout.draw(g2, (float)((double)width - bounds.getWidth()) / 2.0f, (float)((double)height - bounds.getHeight()) / 2.0f);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    private class Animator
    implements Runnable {
        private boolean rampUp = true;

        protected Animator(boolean rampUp) {
            this.rampUp = rampUp;
        }

        public void run() {
            long start = System.currentTimeMillis();
            if (JInfiniteProgressPanel.this.rampDelay == 0) {
                JInfiniteProgressPanel.this.alphaLevel = this.rampUp ? 255 : 0;
            }
            JInfiniteProgressPanel.this.started = true;
            boolean inRamp = this.rampUp;
            while (!Thread.interrupted()) {
                block8: {
                    block7: {
                        JInfiniteProgressPanel.this.repaint();
                        if (!this.rampUp) break block7;
                        if (JInfiniteProgressPanel.this.alphaLevel >= 255) break block8;
                        JInfiniteProgressPanel.this.alphaLevel = (int)(255L * (System.currentTimeMillis() - start) / (long)JInfiniteProgressPanel.this.rampDelay);
                        if (JInfiniteProgressPanel.this.alphaLevel < 255) break block8;
                        JInfiniteProgressPanel.this.alphaLevel = 255;
                        inRamp = false;
                        break block8;
                    }
                    if (JInfiniteProgressPanel.this.alphaLevel > 0) {
                        JInfiniteProgressPanel.this.alphaLevel = (int)(255L - 255L * (System.currentTimeMillis() - start) / (long)JInfiniteProgressPanel.this.rampDelay);
                        if (JInfiniteProgressPanel.this.alphaLevel <= 0) {
                            JInfiniteProgressPanel.this.alphaLevel = 0;
                            break;
                        }
                    }
                }
                try {
                    Thread.sleep(inRamp ? 10L : (long)((int)(1000.0f / JInfiniteProgressPanel.this.fps)));
                }
                catch (InterruptedException ie) {
                    // empty catch block
                    break;
                }
            }
            if (!this.rampUp) {
                JInfiniteProgressPanel.this.started = false;
                JInfiniteProgressPanel.this.repaint();
                JInfiniteProgressPanel.this.setVisible(false);
                JInfiniteProgressPanel.this.removeMouseListener(JInfiniteProgressPanel.this);
            }
        }
    }
}

