/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.module;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreviewer
extends JComponent
implements PropertyChangeListener {
    private ImageIcon mThumbnail = null;

    public ImagePreviewer(JFileChooser fileChooser) {
        this.setPreferredSize(new Dimension(120, 50));
        fileChooser.addPropertyChangeListener(this);
    }

    public void loadImage(File file) {
        if (null == file || !file.exists()) {
            this.mThumbnail = null;
        } else {
            if (!file.getName().endsWith(".png") && !file.getName().endsWith(".jpg")) {
                this.mThumbnail = null;
                return;
            }
            ImageIcon tmpIcon = null;
            try {
                BufferedImage image = ImageIO.read(file);
                if (null == image) {
                    return;
                }
                tmpIcon = new ImageIcon(image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == tmpIcon) {
                return;
            }
            this.mThumbnail = tmpIcon.getIconWidth() > 120 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(120, -1, 2)) : tmpIcon;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if ("SelectedFileChangedProperty".equals(prop) && this.isShowing()) {
            this.loadImage((File)event.getNewValue());
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (null != this.mThumbnail) {
            int iconWidth = this.getWidth() / 2 - this.mThumbnail.getIconWidth() / 2;
            int iconHeight = this.getHeight() / 2 - this.mThumbnail.getIconHeight() / 2;
            if (iconHeight < 0) {
                iconHeight = 0;
            }
            if (iconWidth < 5) {
                iconWidth = 5;
            }
            this.mThumbnail.paintIcon(this, graphics, iconWidth, iconHeight);
        }
    }
}

