/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.material;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import sina.mobile.tianqitong.material.MaterialCfg;
import sina.mobile.tianqitong.material.MaterialFunction;
import sina.mobile.tianqitong.util.BufferedImagePool;
import sina.mobile.tianqitong.util.StringUtil;

public class MaterialPkg
implements Cloneable {
    public static final String SUFFIX = ".tsp";
    private MaterialCfg mMaterialCfg;
    private BufferedImage mPreviewImage;
    private File mFile;

    public BufferedImage getPreviewImage() {
        return this.mPreviewImage;
    }

    public void setPreviewImage(BufferedImage previewImage) {
        this.mPreviewImage = previewImage;
    }

    public void readPreviewImage() throws ZipException, IOException {
        if (!(this.mFile != null && this.mFile.exists() && this.mFile.isFile() && this.mFile.canRead() && this.mFile.getName().endsWith(SUFFIX))) {
            return;
        }
        this.mPreviewImage = BufferedImagePool.getZipImage(this.mFile, "preview.png");
    }

    public void readMaterialCfg() throws ZipException, IOException, DocumentException {
        int i;
        if (!(this.mFile != null && this.mFile.exists() && this.mFile.isFile() && this.mFile.canRead() && this.mFile.getName().endsWith(SUFFIX))) {
            return;
        }
        ZipFile zf = new ZipFile(this.mFile);
        ZipEntry ze = zf.getEntry("cfg.xml");
        if (ze == null) {
            return;
        }
        String xmlContent = StringUtil.loadStringFromInputStream(zf.getInputStream(ze), "UTF-8");
        StringBuilder sb = new StringBuilder();
        String[] xmls = xmlContent.split("\n");
        if (xmlContent.contains("xml version")) {
            for (i = 1; i < xmls.length; ++i) {
                sb.append(xmls[i]);
            }
        } else {
            for (i = 0; i < xmls.length; ++i) {
                sb.append(xmls[i]);
            }
        }
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(sb.toString().getBytes("UTF-8")));
        SAXReader sax = new SAXReader();
        InputStreamReader ir = new InputStreamReader((InputStream)bis, "UTF-8");
        Document document = sax.read(ir);
        ir.close();
        bis.close();
        Element root = document.getRootElement();
        MaterialCfg cfg = new MaterialCfg();
        if (root.attributeValue("Style") != null) {
            cfg.style = root.attributeValue("Style");
        }
        if (root.attributeValue("Type") != null) {
            cfg.type = Integer.parseInt(root.attributeValue("Type"));
        }
        if (root.attributeValue("Version") != null) {
            cfg.version = root.attributeValue("Version");
        }
        if (root.attributeValue("Author") != null) {
            cfg.author = root.attributeValue("Author");
        }
        if (root.attributeValue("Description") != null) {
            cfg.description = root.attributeValue("Description");
        }
        Iterator i2 = root.elementIterator("Images");
        while (i2.hasNext()) {
            Element images = (Element)i2.next();
            if (images.attributeValue("Prefix") != null) {
                cfg.prefix = images.attributeValue("Prefix");
            }
            Iterator ii = images.elementIterator("Image");
            while (ii.hasNext()) {
                Element image = (Element)ii.next();
                if (image.attributeValue("FileName") == null || image.attributeValue("NickName") == null) continue;
                cfg.imageStrings.put(image.attributeValue("FileName"), image.attributeValue("NickName"));
                cfg.fileNames.add(image.attributeValue("FileName"));
                BufferedImage buffImg = BufferedImagePool.getZipImage(this.mFile, image.attributeValue("FileName"));
                cfg.imageCacheMap.put(image.attributeValue("FileName"), buffImg);
            }
            ii = images.elementIterator("Function");
            while (ii.hasNext()) {
                Element function = (Element)ii.next();
                MaterialFunction materialFunction = new MaterialFunction();
                if (function.attributeValue("FunctionId") == null) continue;
                materialFunction.functionId = function.attributeValue("FunctionId");
                if (function.attributeValue("Prefix") != null) {
                    materialFunction.prefix = function.attributeValue("Prefix");
                }
                Iterator iii = function.elementIterator("Image");
                while (iii.hasNext()) {
                    Element image = (Element)iii.next();
                    if (image.attributeValue("FileName") == null || image.attributeValue("NickName") == null) continue;
                    materialFunction.imageStrings.put(image.attributeValue("FileName"), image.attributeValue("NickName"));
                    cfg.imageStrings.put(image.attributeValue("FileName"), image.attributeValue("NickName"));
                    materialFunction.fileNames.add(image.attributeValue("FileName"));
                    cfg.fileNames.add(image.attributeValue("FileName"));
                    BufferedImage buffImg = BufferedImagePool.getZipImage(this.mFile, image.attributeValue("FileName"));
                    materialFunction.imageCacheMap.put(image.attributeValue("FileName"), buffImg);
                    cfg.imageCacheMap.put(image.attributeValue("FileName"), buffImg);
                }
                cfg.materialFunctions.add(materialFunction);
            }
        }
        this.mMaterialCfg = cfg;
    }

    public File getFile() {
        return this.mFile;
    }

    public void setFile(File file) {
        this.mFile = file;
    }

    public MaterialCfg getMaterialCfg() {
        return this.mMaterialCfg;
    }

    public void setMaterialCfg(MaterialCfg materialCfg) {
        this.mMaterialCfg = materialCfg;
    }

    public MaterialPkg clone() throws CloneNotSupportedException {
        MaterialPkg pkg = (MaterialPkg)super.clone();
        pkg.mMaterialCfg = this.mMaterialCfg.clone();
        return pkg;
    }
}

