/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.io;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinImage;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinTextArea;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.adapter.SkinUnitAdapter;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.constants.Constants;
import sina.mobile.tianqitong.material.MaterialFunction;
import sina.mobile.tianqitong.material.MaterialPkg;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinUnitOperator {
    public static void addStaticImage(File[] imageFiles) {
        if (null == imageFiles || imageFiles.length <= 0) {
            return;
        }
        String path = SkinUnitOperator.getCachePath();
        for (File file : imageFiles) {
            int count = 1;
            String idStr = SkinAdapter.getGlobalSkinPortUnitID();
            String name = idStr + "static_image";
            File newFile = new File(path + name + ".png");
            String newName = name;
            while (newFile.exists()) {
                newName = name + count++;
                newFile = new File(path + newName + ".png");
            }
            try {
                FileUtil.copyFile(file, newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
            SkinImage skinImage = new SkinImage(skinAdapter.getSkin());
            skinImage.setSrc(newName + ".png");
            SkinUnitAdapter skinUnitAdapter = skinAdapter.addSkinUnit(skinImage);
        }
    }

    public static SkinUnitAdapter addStaticIcon(String fileName, Point location, boolean bottom) {
        int layerIndex;
        if (null == fileName || fileName.trim().equals("")) {
            return null;
        }
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinImage skinImage = new SkinImage(skinAdapter.getSkin());
        skinImage.setSrc(fileName);
        skinImage.setOffsetX(location.x);
        skinImage.setOffsetY(location.y);
        SkinUnitAdapter skinUnitAdapter = skinAdapter.addSkinUnit(skinImage);
        if (bottom && (layerIndex = skinAdapter.indexOf(skinUnitAdapter)) > 0) {
            skinAdapter.swapSkinUnitAdapterBottom(layerIndex);
        }
        return skinUnitAdapter;
    }

    public static void copyMaterial(MaterialPkg materialPkg) {
        String path = SkinUnitOperator.getCachePath();
        HashMap<String, BufferedImage> imageCache = materialPkg.getMaterialCfg().imageCacheMap;
        for (Map.Entry<String, BufferedImage> entry : imageCache.entrySet()) {
            String name = entry.getKey();
            BufferedImage image = entry.getValue();
            if (image == null) continue;
            File file = new File(path + name);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void copyMaterial(MaterialFunction materialFunction, String idStr) {
        String path = SkinUnitOperator.getCachePath();
        HashMap<String, BufferedImage> imageCache = materialFunction.imageCacheMap;
        for (Map.Entry<String, BufferedImage> entry : imageCache.entrySet()) {
            String name = entry.getKey();
            BufferedImage image = entry.getValue();
            if (image == null) continue;
            File file = new File(path + idStr + name);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void copyMaterial(MaterialPkg materialPkg, String idStr) {
        String path = SkinUnitOperator.getCachePath();
        HashMap<String, BufferedImage> imageCache = materialPkg.getMaterialCfg().imageCacheMap;
        for (Map.Entry<String, BufferedImage> entry : imageCache.entrySet()) {
            String name = entry.getKey();
            BufferedImage image = entry.getValue();
            if (image == null) continue;
            File file = new File(path + idStr + name);
            try {
                ImageIO.write((RenderedImage)image, "png", file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void addDynamicIcon(String id, String prefix, String offsetTime) {
        if (null == id || id.trim().equals("")) {
            return;
        }
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinImage skinImage = new SkinImage(skinAdapter.getSkin());
        skinImage.setFunctionId(id);
        String idStr = SkinAdapter.getGlobalSkinPortUnitID();
        skinImage.setPrefix(idStr + prefix);
        if ("f_weather_icon".equals(id) && !"".equals(offsetTime)) {
            skinImage.setOffsetTime(offsetTime);
        }
        SkinUnitAdapter skinUnitAdapter = skinAdapter.addSkinUnit(skinImage);
    }

    public static void addStaticWord(String content) {
        SkinUnitOperator.addDynamicTextArea(content);
    }

    public static void addDynamicText(String id) {
        String text = "{" + id + "}";
        SkinUnitOperator.addDynamicTextArea(text);
    }

    public static void addDynamicTextArea(String text) {
        if (null == text || text.trim().equals("")) {
            return;
        }
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinTextArea skinTextArea = new SkinTextArea(skinAdapter.getSkin());
        skinTextArea.setTextSize(16);
        skinTextArea.setText(text);
        skinAdapter.addSkinUnit(skinTextArea);
    }

    public static SkinUnitAdapter addDynamicIcon(String id, String prefix, String offsetTime, Point location) {
        return SkinUnitOperator.addDynamicIcon(id, prefix, offsetTime, location, null);
    }

    public static SkinUnitAdapter addDynamicIcon(String id, String prefix, String offsetTime, Point location, String referLayoutId) {
        if (null == id || id.trim().equals("")) {
            return null;
        }
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinImage skinImage = new SkinImage(skinAdapter.getSkin());
        skinImage.setFunctionId(id);
        skinImage.setPrefix(prefix);
        skinImage.setOffsetX(location.x);
        skinImage.setOffsetY(location.y);
        if (offsetTime != null && !"".equals(offsetTime)) {
            skinImage.setOffsetTime(offsetTime);
        }
        if (referLayoutId != null && !"".equals(referLayoutId)) {
            skinImage.setDatumHLineLayoutId(referLayoutId);
            skinImage.setDatumVLineLayoutId(referLayoutId);
        }
        SkinUnitAdapter skinUnitAdapter = skinAdapter.addSkinUnit(skinImage);
        return skinUnitAdapter;
    }

    public static void addSkinLayoutModels(ArrayList<SkinLayoutModel> units) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        skinAdapter.addSkinLayoutModels(units);
    }

    public static void addSkinButtons(ArrayList<SkinButton> units) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        skinAdapter.addSkinButtons(units);
    }

    public static SkinButton setButtonIconWithFunctionId(String FunctionId, List<BufferedImage> images) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinButton skinButton = new SkinButton(skinAdapter.getSkin());
        skinButton.setFunctionId(FunctionId);
        if (FunctionId.equals("play_tts")) {
            if (null != images && images.size() == 1) {
                SkinUnitOperator.setButtonIconByImage(images, Constants.TTS_BUTTON_ICON_NAMES[0], skinButton);
            } else if (null != images && images.size() == 2) {
                SkinUnitOperator.setButtonIconByImage(images, Constants.TTS_BUTTON_ICON_NAMES[1], skinButton);
                SkinUnitOperator.setButtonIconByImage(images, Constants.TTS_BUTTON_ICON_NAMES[0], skinButton);
            }
        } else if (FunctionId.equals("change_city")) {
            SkinUnitOperator.setButtonIconByImage(images, "change_city.png", skinButton);
        } else if (FunctionId.equals("update")) {
            SkinUnitOperator.setButtonIconByImage(images, "update.png", skinButton);
        } else if (FunctionId.equals("app")) {
            skinButton.setIntoClock("intoClock");
            skinButton.setPkgName("sina.mobile.tianqitong");
            skinButton.setActivityName("sina.mobile.tianqitong.main.MainActivity");
            SkinUnitOperator.setButtonIconByImage(images, "into_clock.png", skinButton);
        } else if (FunctionId.equals("IntoTqtClock")) {
            SkinUnitOperator.setButtonIconByImage(images, "into_tqt_clock.png", skinButton);
        } else if (FunctionId.equals("IntoCalendar")) {
            SkinUnitOperator.setButtonIconByImage(images, "into_calendar.png", skinButton);
        } else if (FunctionId.equals("IntoSpecialRecommend")) {
            SkinUnitOperator.setButtonIconByImage(images, "into_special_recommend.png", skinButton);
        } else if (FunctionId.equals("share_weibo")) {
            SkinUnitOperator.setButtonIconByImage(images, "share_weibo.png", skinButton);
        } else if (FunctionId.equals("run_weibo")) {
            SkinUnitOperator.setButtonIconByImage(images, "run_weibo.png", skinButton);
        }
        return skinButton;
    }

    public static SkinButton setButtonIconWithNickName(String type, List<File> images) {
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinButton skinButton = new SkinButton(skinAdapter.getSkin());
        if (type.equals(Constants.BUTTON_FUNCTIONS[0])) {
            skinButton.setFunctionId("play_tts");
            if (null != images && images.size() == 1) {
                SkinUnitOperator.setButtonIconByFile(images, Constants.TTS_BUTTON_ICON_NAMES[0], skinButton);
            } else if (null != images && images.size() == 2) {
                SkinUnitOperator.setButtonIconByFile(images, Constants.TTS_BUTTON_ICON_NAMES[1], skinButton);
                SkinUnitOperator.setButtonIconByFile(images, Constants.TTS_BUTTON_ICON_NAMES[0], skinButton);
            }
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[1])) {
            skinButton.setFunctionId("change_city");
            SkinUnitOperator.setButtonIconByFile(images, "change_city.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[2])) {
            skinButton.setFunctionId("update");
            SkinUnitOperator.setButtonIconByFile(images, "update.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[3])) {
            skinButton.setFunctionId("app");
            skinButton.setIntoClock("intoClock");
            skinButton.setPkgName("sina.mobile.tianqitong");
            skinButton.setActivityName("sina.mobile.tianqitong.main.MainActivity");
            SkinUnitOperator.setButtonIconByFile(images, "into_clock.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[4])) {
            skinButton.setFunctionId("IntoTqtClock");
            SkinUnitOperator.setButtonIconByFile(images, "into_tqt_clock.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[5])) {
            skinButton.setFunctionId("IntoCalendar");
            SkinUnitOperator.setButtonIconByFile(images, "into_calendar.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[6])) {
            skinButton.setFunctionId("IntoSpecialRecommend");
            SkinUnitOperator.setButtonIconByFile(images, "into_special_recommend.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[7])) {
            skinButton.setFunctionId("share_weibo");
            SkinUnitOperator.setButtonIconByFile(images, "share_weibo.png", skinButton);
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[8])) {
            skinButton.setFunctionId("run_weibo");
            SkinUnitOperator.setButtonIconByFile(images, "run_weibo.png", skinButton);
        }
        return skinButton;
    }

    public static void setButtonFunction(SkinButton skinButton, String type) {
        if (type.equals(Constants.BUTTON_FUNCTIONS[0])) {
            skinButton.setFunctionId("play_tts");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[1])) {
            skinButton.setFunctionId("change_city");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[2])) {
            skinButton.setFunctionId("update");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[3])) {
            skinButton.setFunctionId("app");
            skinButton.setIntoClock("intoClock");
            skinButton.setPkgName("sina.mobile.tianqitong");
            skinButton.setActivityName("sina.mobile.tianqitong.main.MainActivity");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[4])) {
            skinButton.setFunctionId("IntoTqtClock");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[5])) {
            skinButton.setFunctionId("IntoCalendar");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[6])) {
            skinButton.setFunctionId("IntoSpecialRecommend");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[7])) {
            skinButton.setFunctionId("share_weibo");
        } else if (type.equals(Constants.BUTTON_FUNCTIONS[8])) {
            skinButton.setFunctionId("run_weibo");
        }
    }

    private static void setButtonIconByImage(List<BufferedImage> images, String newName, SkinButton button) {
        if (null == images || images.size() <= 0) {
            return;
        }
        String path = SkinUnitOperator.getCachePath();
        String idStr = SkinAdapter.getGlobalSkinPortUnitID();
        try {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(path + idStr + newName);
            if (Constants.TTS_BUTTON_ICON_NAMES[1].equals(newName)) {
                ImageIO.write((RenderedImage)images.get(1), "png", file);
                button.setStopPlayingSrc(idStr + newName);
            } else {
                ImageIO.write((RenderedImage)images.get(0), "png", file);
                button.setSrc(idStr + newName);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void setButtonIconByFile(List<File> imageFiles, String newName, SkinButton button) {
        if (null == imageFiles || imageFiles.size() <= 0) {
            return;
        }
        String path = SkinUnitOperator.getCachePath();
        String idStr = SkinAdapter.getGlobalSkinPortUnitID();
        try {
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(path + idStr + newName);
            if (Constants.TTS_BUTTON_ICON_NAMES[1].equals(newName)) {
                FileUtil.copyFile(imageFiles.get(1), file);
                button.setStopPlayingSrc(idStr + newName);
            } else {
                FileUtil.copyFile(imageFiles.get(0), file);
                button.setSrc(idStr + newName);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static String getCachePath() {
        Config config = AppData.getInstance().mConfig;
        SkinPkg pkg = AppData.getInstance().getSkinPkg();
        String path = "SkinCache" + File.separator + Config.ORIENTATION_STRING[config.getOrientation()] + "_" + Config.ASPECT_RATIO_STRING[config.getAspectRatio()] + "_" + Config.DENSITY_STRING[config.getDensity()] + "_" + Config.SIZE_STRING[config.getSize()] + File.separator + pkg.getSkinFile().getName().substring(0, pkg.getSkinFile().getName().length() - ".zip".length()) + File.separator + "drawable-" + Config.ORIENTATION_STRING[config.getOrientation()] + File.separator;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    public static void addDiscClock(String prefix, String idStr, Point bgPoint, Point point) {
        ArrayList<SkinLayoutModel> units = new ArrayList<SkinLayoutModel>();
        SkinAdapter skinAdapter = AppData.getInstance().getSkinAdapter();
        SkinImage skinImage = new SkinImage(skinAdapter.getSkin());
        skinImage.setSrc(idStr + "clock_bg.png");
        skinImage.setOffsetX(bgPoint.x);
        skinImage.setOffsetY(bgPoint.y);
        units.add(skinImage);
        String p = "".equals(prefix) ? "clock" : prefix;
        SkinImage skinImage2 = new SkinImage(skinAdapter.getSkin());
        skinImage2.setFunctionId("clock_hourhand");
        skinImage2.setPrefix(idStr + p);
        skinImage2.setOffsetX(point.x);
        skinImage2.setOffsetY(point.y);
        units.add(skinImage2);
        SkinImage skinImage3 = new SkinImage(skinAdapter.getSkin());
        skinImage3.setFunctionId("clock_minutehand");
        skinImage3.setPrefix(idStr + p);
        skinImage3.setOffsetX(point.x);
        skinImage3.setOffsetY(point.y);
        units.add(skinImage3);
        SkinUnitOperator.addSkinLayoutModels(units);
    }
}

