/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.adapter;

import java.util.ArrayList;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.adapter.SkinUnitAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinLayoutModelAdapter
extends SkinUnitAdapter {
    public static final int TOP = 0;
    public static final int VCENTER = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int HCENTER = 1;
    public static final int RIGHT = 2;
    private SkinLayoutModel mSkinUnit;
    private int mHorizontalLine = 0;
    private int mVerticalLine = 0;

    @Override
    public SkinLayoutModelAdapter clone() throws CloneNotSupportedException {
        SkinLayoutModelAdapter clone = (SkinLayoutModelAdapter)super.clone();
        clone.mSkinUnit = this.mSkinUnit.clone();
        return clone;
    }

    public ArrayList<SkinLayoutModelAdapter> getAffectedSkinLayoutModelAdapters() {
        ArrayList<SkinLayoutModelAdapter> skinLayoutModelAdapters = new ArrayList<SkinLayoutModelAdapter>();
        SkinAdapter skinAdapter = this.getSkinAdapter();
        String sid = this.mSkinUnit.getLayoutId();
        if (sid != null) {
            for (int i = skinAdapter.skinUnitAdapterCount() - 1; i >= 0; --i) {
                SkinUnitAdapter unit = skinAdapter.getSkinUnitAdapter(i);
                if (!(unit instanceof SkinLayoutModelAdapter)) continue;
                SkinLayoutModelAdapter skinLayoutModelAdapter = (SkinLayoutModelAdapter)unit;
                if (skinLayoutModelAdapter.getSkinUnit().getDatumVLineLayoutId() != null && skinLayoutModelAdapter.getSkinUnit().getDatumVLineLayoutId().equals(sid) && !skinLayoutModelAdapters.contains(skinLayoutModelAdapter)) {
                    skinLayoutModelAdapters.add(skinLayoutModelAdapter);
                }
                if (skinLayoutModelAdapter.getSkinUnit().getDatumHLineLayoutId() == null || !skinLayoutModelAdapter.getSkinUnit().getDatumHLineLayoutId().equals(sid) || skinLayoutModelAdapters.contains(skinLayoutModelAdapter)) continue;
                skinLayoutModelAdapters.add(skinLayoutModelAdapter);
            }
        }
        return skinLayoutModelAdapters;
    }

    public void offsetX(int x) {
        this.mSkinUnit.setOffsetX(this.mSkinUnit.getOffsetX() + x);
    }

    public void offsetY(int y) {
        this.mSkinUnit.setOffsetY(this.mSkinUnit.getOffsetY() + y);
    }

    public int getHorizontalLine() {
        return this.mHorizontalLine;
    }

    public void setHorizontalLine(int horizontalLine) {
        this.mHorizontalLine = horizontalLine;
        this.setDatumPoint();
    }

    public int getVerticalLine() {
        return this.mVerticalLine;
    }

    public void setVerticalLine(int verticalLine) {
        this.mVerticalLine = verticalLine;
        this.setDatumPoint();
    }

    private void setDatumLine() {
        switch (this.mSkinUnit.getDatumPoint()) {
            case 9: {
                this.mHorizontalLine = 0;
                this.mVerticalLine = 0;
                break;
            }
            case 17: {
                this.mHorizontalLine = 1;
                this.mVerticalLine = 0;
                break;
            }
            case 33: {
                this.mHorizontalLine = 2;
                this.mVerticalLine = 0;
                break;
            }
            case 10: {
                this.mHorizontalLine = 0;
                this.mVerticalLine = 1;
                break;
            }
            case 18: {
                this.mHorizontalLine = 1;
                this.mVerticalLine = 1;
                break;
            }
            case 34: {
                this.mHorizontalLine = 2;
                this.mVerticalLine = 1;
                break;
            }
            case 12: {
                this.mHorizontalLine = 0;
                this.mVerticalLine = 2;
                break;
            }
            case 20: {
                this.mHorizontalLine = 1;
                this.mVerticalLine = 2;
                break;
            }
            case 36: {
                this.mHorizontalLine = 2;
                this.mVerticalLine = 2;
            }
        }
    }

    private void setDatumPoint() {
        if (this.mHorizontalLine == 0) {
            switch (this.mVerticalLine) {
                case 0: {
                    this.mSkinUnit.setDatumPoint(9);
                    break;
                }
                case 1: {
                    this.mSkinUnit.setDatumPoint(10);
                    break;
                }
                case 2: {
                    this.mSkinUnit.setDatumPoint(12);
                }
            }
        } else if (this.mHorizontalLine == 1) {
            switch (this.mVerticalLine) {
                case 0: {
                    this.mSkinUnit.setDatumPoint(17);
                    break;
                }
                case 1: {
                    this.mSkinUnit.setDatumPoint(18);
                    break;
                }
                case 2: {
                    this.mSkinUnit.setDatumPoint(20);
                }
            }
        } else if (this.mHorizontalLine == 2) {
            switch (this.mVerticalLine) {
                case 0: {
                    this.mSkinUnit.setDatumPoint(33);
                    break;
                }
                case 1: {
                    this.mSkinUnit.setDatumPoint(34);
                    break;
                }
                case 2: {
                    this.mSkinUnit.setDatumPoint(36);
                }
            }
        }
    }

    @Override
    public SkinLayoutModel getSkinUnit() {
        return this.mSkinUnit;
    }

    @Override
    public void setSkinUnit(AbSkinUnit skinUnit) {
        this.mSkinUnit = (SkinLayoutModel)skinUnit;
        this.setDatumLine();
    }
}

