/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong.adapter;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinImage;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinText;
import sina.mobile.skin.SkinTextArea;
import sina.mobile.tianqitong.adapter.SkinButtonAdapter;
import sina.mobile.tianqitong.adapter.SkinLayoutModelAdapter;
import sina.mobile.tianqitong.adapter.SkinUnitAdapter;
import sina.mobile.tianqitong.listener.SkinAdapterListener;
import sina.mobile.tianqitong.skin.SkinImageHelper;
import sina.mobile.tianqitong.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinAdapter
implements Cloneable {
    private static final HashMap<String, String> mNameMap = new HashMap();
    private Skin mSkin = null;
    private ArrayList<SkinUnitAdapter> mSkinUnitAdapters = new ArrayList();
    private HashMap<String, SkinUnitAdapter> mIdMap = new HashMap();
    private SkinAdapterListener mListener = null;
    private int mAvailableLayoutID = 0;
    private static int G_SKIN_PORT_UNIT_ID = 0;
    private static int G_SKIN_LAND_UNIT_ID = 0;

    public void recycle() {
        this.mIdMap.clear();
        this.mListener = null;
        if (this.mSkin != null) {
            this.mSkin.recycle();
        }
        this.mSkin = null;
    }

    public SkinAdapter clone() throws CloneNotSupportedException {
        SkinAdapter clone = (SkinAdapter)super.clone();
        clone.mSkin = this.mSkin.clone();
        clone.mSkinUnitAdapters = new ArrayList();
        clone.mIdMap = new HashMap();
        for (SkinUnitAdapter unitAdapter : this.mSkinUnitAdapters) {
            SkinUnitAdapter unitCloneAdapter = unitAdapter.clone();
            unitCloneAdapter.setSkinAdapter(clone);
            clone.mSkinUnitAdapters.add(unitCloneAdapter);
            if (unitAdapter instanceof SkinButtonAdapter) continue;
            clone.mIdMap.put(((SkinLayoutModelAdapter)unitAdapter).getSkinUnit().getLayoutId(), unitCloneAdapter);
        }
        return clone;
    }

    public ArrayList<AbSkinUnit> getAllSameFunctionIdSkinUnits(AbSkinUnit unit) {
        ArrayList<AbSkinUnit> skinUnits = new ArrayList<AbSkinUnit>();
        for (SkinUnitAdapter unitAdapter : this.mSkinUnitAdapters) {
            AbSkinUnit skinUnit = unitAdapter.getSkinUnit();
            if (skinUnit == null || skinUnit.getFunctionId() == null || skinUnit.getClass() != unit.getClass() || !skinUnit.getFunctionId().equals(unit.getFunctionId())) continue;
            skinUnits.add(skinUnit);
        }
        return skinUnits;
    }

    public static String getGlobalSkinPortUnitID() {
        return G_SKIN_PORT_UNIT_ID + "_";
    }

    public static String getGlobalSkinLandUnitID() {
        return G_SKIN_LAND_UNIT_ID + "_";
    }

    public SkinAdapterListener getSkinAdapterListener() {
        return this.mListener;
    }

    public void setSkinAdapterListener(SkinAdapterListener mListener) {
        this.mListener = mListener;
    }

    public void swapSkinUnitAdapterUp(int index) {
        if (index < 0 || index > this.mSkinUnitAdapters.size() - 1) {
            return;
        }
        if (index + 1 != this.getSkinLayoutModelAdaptersCount()) {
            SkinUnitAdapter hold = this.mSkinUnitAdapters.get(index + 1);
            SkinUnitAdapter swap = this.mSkinUnitAdapters.get(index);
            ArrayList<AbSkinUnit> units = this.mSkin.getSkinUnits();
            AbSkinUnit holdUnit = units.get(index + 1);
            AbSkinUnit swapUnit = units.get(index);
            units.set(index + 1, swapUnit);
            units.set(index, holdUnit);
            this.mSkin.setLayoutUnits(units);
            this.mSkinUnitAdapters.set(index + 1, swap);
            this.mSkinUnitAdapters.set(index, hold);
            this.fireSkinChanged();
        }
    }

    public void swapSkinUnitAdapterDown(int index) {
        if (index < 0 || index > this.mSkinUnitAdapters.size() - 1) {
            return;
        }
        if (index - 1 >= 0) {
            SkinUnitAdapter hold = this.mSkinUnitAdapters.get(index - 1);
            SkinUnitAdapter swap = this.mSkinUnitAdapters.get(index);
            ArrayList<AbSkinUnit> units = this.mSkin.getSkinUnits();
            AbSkinUnit holdUnit = units.get(index - 1);
            AbSkinUnit swapUnit = units.get(index);
            units.set(index - 1, swapUnit);
            units.set(index, holdUnit);
            this.mSkin.setLayoutUnits(units);
            this.mSkinUnitAdapters.set(index - 1, swap);
            this.mSkinUnitAdapters.set(index, hold);
            this.fireSkinChanged();
        }
    }

    public void swapSkinUnitAdapterTop(int index) {
        if (index < 0 || index > this.mSkinUnitAdapters.size() - 1) {
            return;
        }
        SkinUnitAdapter swap = this.mSkinUnitAdapters.get(index);
        ArrayList<AbSkinUnit> units = this.mSkin.getSkinUnits();
        AbSkinUnit swapUnit = units.get(index);
        int count = this.getSkinLayoutModelAdaptersCount();
        units.remove(swapUnit);
        units.add(count - 1, swapUnit);
        this.mSkin.setLayoutUnits(units);
        this.mSkinUnitAdapters.remove(swap);
        this.mSkinUnitAdapters.add(count - 1, swap);
        this.fireSkinChanged();
    }

    public void swapSkinUnitAdapterBottom(int index) {
        if (index < 0 || index > this.mSkinUnitAdapters.size() - 1) {
            return;
        }
        SkinUnitAdapter swap = this.mSkinUnitAdapters.get(index);
        ArrayList<AbSkinUnit> units = this.mSkin.getSkinUnits();
        AbSkinUnit swapUnit = units.get(index);
        units.remove(swapUnit);
        units.add(0, swapUnit);
        this.mSkin.setLayoutUnits(units);
        this.mSkinUnitAdapters.remove(swap);
        this.mSkinUnitAdapters.add(0, swap);
        this.fireSkinChanged();
    }

    public SkinButtonAdapter getSkinButtonByID(int id) {
        for (int i = this.skinUnitAdapterCount() - 1; i >= 0; --i) {
            SkinButtonAdapter buttonAdapter;
            SkinButton button;
            SkinUnitAdapter unit = this.getSkinUnitAdapter(i);
            if (!(unit instanceof SkinButtonAdapter) || (button = (buttonAdapter = (SkinButtonAdapter)unit).getSkinUnit()).getFunctionId().equals("app") && button.getIntoClock() == null || button.getIdx() != id) continue;
            return buttonAdapter;
        }
        return null;
    }

    public int getMinAvailableButtonIdx() {
        int i = 0;
        while (this.getSkinButtonByID(i) != null) {
            ++i;
        }
        return i;
    }

    public int getSkinLayoutModelAdaptersCount() {
        int count = 0;
        for (int i = 0; i < this.mSkinUnitAdapters.size(); ++i) {
            if (!(this.mSkinUnitAdapters.get(i) instanceof SkinLayoutModelAdapter)) continue;
            ++count;
        }
        return count;
    }

    public int getSkinButtonAdaptersCount() {
        int count = 0;
        for (int i = 0; i < this.mSkinUnitAdapters.size(); ++i) {
            if (!(this.mSkinUnitAdapters.get(i) instanceof SkinButtonAdapter)) continue;
            ++count;
        }
        return count;
    }

    private void fireSkinChanged() {
        if (this.mListener != null) {
            this.mListener.skinAdapterChanged();
        }
    }

    private void fireSkinLayoutModelAdaptersAdded(ArrayList<SkinLayoutModelAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinLayoutModelAdaptersAdded(units);
        }
    }

    private void fireSkinLayoutModelAdaptersWillAdd(ArrayList<SkinLayoutModelAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinLayoutModelAdaptersWillAdd(units);
        }
    }

    private void fireSkinButtonAdaptersAdded(ArrayList<SkinButtonAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinButtonAdaptersAdded(units);
        }
    }

    private void fireSkinButtonAdaptersWillAdd(ArrayList<SkinButtonAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinButtonAdaptersWillAdd(units);
        }
    }

    private void fireSkinLayoutModelAdaptersRemoved(ArrayList<SkinLayoutModelAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinLayoutModelAdaptersRemoved(units);
        }
    }

    private void fireSkinButtonAdaptersRemoved(ArrayList<SkinButtonAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinButtonAdaptersRemoved(units);
        }
    }

    private void fireSkinButtonAdaptersWillRemove(ArrayList<SkinButtonAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinButtonAdaptersWillRemove(units);
        }
    }

    private void fireSkinLayoutModelAdaptersWillRemove(ArrayList<SkinLayoutModelAdapter> units) {
        if (this.mListener != null) {
            this.mListener.skinLayoutModelAdaptersWillRemove(units);
        }
    }

    private void fireSkinUnitAdded(SkinUnitAdapter unit) {
        if (this.mListener != null) {
            this.mListener.skinUnitAdapterAdded(unit);
        }
    }

    private void fireSkinUnitRemoved(SkinUnitAdapter unit) {
        if (this.mListener != null) {
            this.mListener.skinUnitAdapterRemoved(unit);
        }
    }

    private void fireSkinUnitWillAdd(SkinUnitAdapter unit) {
        if (this.mListener != null) {
            this.mListener.skinUnitAdapterWillAdd(unit);
        }
    }

    private void fireSkinUnitWillRemove(SkinUnitAdapter unit) {
        if (this.mListener != null) {
            this.mListener.skinUnitAdapterWillRemove(unit);
        }
    }

    public SkinUnitAdapter getSkinUnitAdapterByLayoutID(String id) {
        return this.mIdMap.get(id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSkinUnitAdapterName(SkinUnitAdapter skinUnitAdapter) {
        AbSkinUnit unit = skinUnitAdapter.getSkinUnit();
        if (unit instanceof SkinButton) {
            if (skinUnitAdapter.getName() != null) return;
            SkinButton button = (SkinButton)unit;
            String fid = button.getFunctionId();
            if (fid == null) throw new IllegalArgumentException();
            if (fid.equals("app") && button.getIntoClock() != null) {
                skinUnitAdapter.setName("\u6253\u5f00\u7cfb\u7edf\u65f6\u949f");
                return;
            } else {
                skinUnitAdapter.setName(mNameMap.get(fid));
            }
            return;
        } else if (unit instanceof SkinImage) {
            SkinImage img = (SkinImage)unit;
            if (skinUnitAdapter.getName() == null) {
                String fid = img.getFunctionId();
                if (fid != null) {
                    if (img.getOffsetTime() != null) {
                        skinUnitAdapter.setName(mNameMap.get(fid) + "_" + img.getOffsetTime());
                    } else {
                        skinUnitAdapter.setName(mNameMap.get(fid));
                    }
                } else {
                    skinUnitAdapter.setName(img.getSrc());
                }
            }
            if (img.getLayoutId() == null) return;
            this.mIdMap.put(img.getLayoutId(), skinUnitAdapter);
            return;
        } else if (unit instanceof SkinText) {
            SkinText text = (SkinText)unit;
            if (skinUnitAdapter.getName() == null) {
                String fid = text.getFunctionId();
                if (fid != null) {
                    if (text.getOffsetTime() != null) {
                        skinUnitAdapter.setName(mNameMap.get(fid) + "_" + text.getOffsetTime());
                    } else {
                        skinUnitAdapter.setName(mNameMap.get(fid));
                    }
                } else {
                    skinUnitAdapter.setName(text.getText());
                }
            }
            if (text.getLayoutId() == null) return;
            this.mIdMap.put(text.getLayoutId(), skinUnitAdapter);
            return;
        } else {
            if (!(unit instanceof SkinTextArea)) return;
            SkinTextArea text = (SkinTextArea)unit;
            if (skinUnitAdapter.getName() == null) {
                String name = text.getText();
                Set<Map.Entry<String, String>> set = mNameMap.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    String key = entry.getKey();
                    name = name.replaceAll("\\{" + key + ":?.*?\\}", entry.getValue());
                }
                if (text.getOffsetTime() != null) {
                    skinUnitAdapter.setName(name + "_" + text.getOffsetTime());
                } else {
                    skinUnitAdapter.setName(name);
                }
            }
            if (text.getLayoutId() == null) return;
            this.mIdMap.put(text.getLayoutId(), skinUnitAdapter);
        }
    }

    public Skin getSkin() {
        return this.mSkin;
    }

    public void setSkin(Skin skin) {
        this.mSkin = skin;
        this.mSkinUnitAdapters.clear();
        this.mIdMap.clear();
        if (skin.isPortrait()) {
            G_SKIN_PORT_UNIT_ID = 0;
        } else {
            G_SKIN_LAND_UNIT_ID = 0;
        }
        for (int i = 0; i < skin.getSkinUnits().size(); ++i) {
            AbSkinUnit unit = skin.getSkinUnits().get(i);
            SkinUnitAdapter skinUnitAdapter = this.skinUnitToSkinUnitAdapter(unit);
            this.mSkinUnitAdapters.add(skinUnitAdapter);
            if (skin.isPortrait()) {
                ++G_SKIN_PORT_UNIT_ID;
                continue;
            }
            ++G_SKIN_LAND_UNIT_ID;
        }
        this.fireSkinChanged();
    }

    public void measureSkinUnitAdapterRect() {
        for (int i = 0; i < this.mSkinUnitAdapters.size(); ++i) {
            SkinUnitAdapter skinUnitAdapter = this.mSkinUnitAdapters.get(i);
            if (skinUnitAdapter instanceof SkinLayoutModelAdapter) {
                if (((SkinLayoutModelAdapter)skinUnitAdapter).getWidth() == -1) {
                    ((SkinLayoutModelAdapter)skinUnitAdapter).setWidth(((SkinLayoutModel)skinUnitAdapter.getSkinUnit()).getDrawRect().width());
                }
                if (((SkinLayoutModelAdapter)skinUnitAdapter).getHeight() != -1) continue;
                ((SkinLayoutModelAdapter)skinUnitAdapter).setHeight(((SkinLayoutModel)skinUnitAdapter.getSkinUnit()).getDrawRect().height());
                continue;
            }
            if (skinUnitAdapter instanceof SkinButtonAdapter) {
                if (((SkinButtonAdapter)skinUnitAdapter).getWidth() == -1 && ((SkinButton)skinUnitAdapter.getSkinUnit()).getSrcCachePicture() != null) {
                    ((SkinButtonAdapter)skinUnitAdapter).setWidth(((SkinButton)skinUnitAdapter.getSkinUnit()).getSrcCachePicture().getWidth());
                }
                if (((SkinButtonAdapter)skinUnitAdapter).getHeight() != -1 || ((SkinButton)skinUnitAdapter.getSkinUnit()).getSrcCachePicture() == null) continue;
                ((SkinButtonAdapter)skinUnitAdapter).setHeight(((SkinButton)skinUnitAdapter.getSkinUnit()).getSrcCachePicture().getHeight());
                continue;
            }
            Log.info("\u65e0\u6548\u7684\u76ae\u80a4\u5355\u5143\uff01Class:SkinAdapter");
        }
    }

    private boolean isLayoutIDExist(String id) {
        for (int i = 0; i < this.mSkin.getSkinUnits().size(); ++i) {
            AbSkinUnit unit = this.mSkin.getSkinUnits().get(i);
            if (unit instanceof SkinButton || !id.equals(((SkinLayoutModel)unit).getLayoutId())) continue;
            return true;
        }
        return false;
    }

    private SkinUnitAdapter skinUnitToSkinUnitAdapter(AbSkinUnit skinUnit) {
        if (skinUnit instanceof SkinImage) {
            SkinImage img = (SkinImage)skinUnit;
            ArrayList<String> filenames = SkinImageHelper.getFilenames(img);
            try {
                for (int j = 0; j < filenames.size(); ++j) {
                    img.addImageCache(filenames.get(j));
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        SkinUnitAdapter skinUnitAdapter = null;
        if (skinUnit instanceof SkinButton) {
            skinUnitAdapter = new SkinButtonAdapter();
        } else {
            skinUnitAdapter = new SkinLayoutModelAdapter();
            if (((SkinLayoutModel)skinUnit).getLayoutId() == null) {
                String id = "LAYOUT_ID_" + this.mAvailableLayoutID;
                while (this.isLayoutIDExist(id)) {
                    this.mAvailableLayoutID += 10;
                    id = "LAYOUT_ID_" + this.mAvailableLayoutID;
                }
                ((SkinLayoutModel)skinUnit).setLayoutId(id);
            }
        }
        skinUnitAdapter.setSkinUnit(skinUnit);
        skinUnitAdapter.setSkinAdapter(this);
        this.setSkinUnitAdapterName(skinUnitAdapter);
        return skinUnitAdapter;
    }

    public ArrayList<SkinLayoutModelAdapter> addSkinLayoutModels(ArrayList<SkinLayoutModel> skinUnits) {
        int i;
        ArrayList<SkinLayoutModelAdapter> units = new ArrayList<SkinLayoutModelAdapter>();
        for (i = 0; i < skinUnits.size(); ++i) {
            AbSkinUnit unit = skinUnits.get(i);
            if (unit == null) continue;
            units.add((SkinLayoutModelAdapter)this.skinUnitToSkinUnitAdapter(skinUnits.get(i)));
        }
        this.fireSkinLayoutModelAdaptersWillAdd(units);
        for (i = 0; i < units.size(); ++i) {
            this.addSkinUnitAdapter(units.get(i));
        }
        this.fireSkinLayoutModelAdaptersAdded(units);
        return units;
    }

    public ArrayList<SkinButtonAdapter> addSkinButtons(ArrayList<SkinButton> skinUnits) {
        int i;
        ArrayList<SkinButtonAdapter> units = new ArrayList<SkinButtonAdapter>();
        for (i = 0; i < skinUnits.size(); ++i) {
            AbSkinUnit unit = skinUnits.get(i);
            if (unit == null) continue;
            units.add((SkinButtonAdapter)this.skinUnitToSkinUnitAdapter(skinUnits.get(i)));
        }
        this.fireSkinButtonAdaptersWillAdd(units);
        for (i = 0; i < units.size(); ++i) {
            this.addSkinUnitAdapter(units.get(i));
        }
        this.fireSkinButtonAdaptersAdded(units);
        return units;
    }

    public SkinUnitAdapter addSkinUnit(AbSkinUnit skinUnit) {
        SkinUnitAdapter skinUnitAdapter = this.skinUnitToSkinUnitAdapter(skinUnit);
        this.fireSkinUnitWillAdd(skinUnitAdapter);
        this.addSkinUnitAdapter(skinUnitAdapter);
        this.fireSkinUnitAdded(skinUnitAdapter);
        return skinUnitAdapter;
    }

    private void addSkinUnitAdapter(SkinUnitAdapter skinUnitAdapter) {
        if (skinUnitAdapter instanceof SkinButtonAdapter) {
            this.mSkinUnitAdapters.add(skinUnitAdapter);
            this.mSkin.getSkinUnits().add(skinUnitAdapter.getSkinUnit());
        } else {
            int count = this.getSkinLayoutModelAdaptersCount();
            this.mSkinUnitAdapters.add(count, skinUnitAdapter);
            this.mSkin.getSkinUnits().add(count, skinUnitAdapter.getSkinUnit());
        }
        if (skinUnitAdapter.getSkinUnit().getSkin().isPortrait()) {
            ++G_SKIN_PORT_UNIT_ID;
        } else {
            ++G_SKIN_LAND_UNIT_ID;
        }
    }

    public void addSkinUnitAdapterWithoutFeedback(SkinUnitAdapter skinUnitAdapter, int index) {
        this.mSkinUnitAdapters.add(index, skinUnitAdapter);
        this.mSkin.getSkinUnits().add(index, skinUnitAdapter.getSkinUnit());
    }

    public void removeSkinLayoutModelAdapters(ArrayList<SkinLayoutModelAdapter> skinUnitAdapters) {
        this.fireSkinLayoutModelAdaptersWillRemove(skinUnitAdapters);
        for (int i = 0; i < skinUnitAdapters.size(); ++i) {
            SkinUnitAdapter skinUnitAdapter = skinUnitAdapters.get(i);
            this.mSkin.getSkinUnits().remove(skinUnitAdapter.getSkinUnit());
            this.mSkinUnitAdapters.remove(skinUnitAdapter);
        }
        this.fireSkinLayoutModelAdaptersRemoved(skinUnitAdapters);
    }

    public void removeSkinButtonAdapters(ArrayList<SkinButtonAdapter> skinUnitAdapters) {
        this.fireSkinButtonAdaptersWillRemove(skinUnitAdapters);
        for (int i = 0; i < skinUnitAdapters.size(); ++i) {
            SkinUnitAdapter skinUnitAdapter = skinUnitAdapters.get(i);
            this.mSkin.getSkinUnits().remove(skinUnitAdapter.getSkinUnit());
            this.mSkinUnitAdapters.remove(skinUnitAdapter);
        }
        this.fireSkinButtonAdaptersRemoved(skinUnitAdapters);
    }

    public void removeSkinUnitAdapter(SkinUnitAdapter skinUnitAdapter) {
        this.fireSkinUnitWillRemove(skinUnitAdapter);
        this.mSkin.getSkinUnits().remove(skinUnitAdapter.getSkinUnit());
        this.mSkinUnitAdapters.remove(skinUnitAdapter);
        this.fireSkinUnitRemoved(skinUnitAdapter);
    }

    public void removeSkinUnitAdapterWithoutFeedback(SkinUnitAdapter skinUnitAdapter) {
        this.mSkin.getSkinUnits().remove(skinUnitAdapter.getSkinUnit());
        this.mSkinUnitAdapters.remove(skinUnitAdapter);
    }

    public int skinUnitAdapterCount() {
        return this.mSkinUnitAdapters.size();
    }

    public SkinUnitAdapter getSkinUnitAdapter(int index) {
        return this.mSkinUnitAdapters.get(index);
    }

    public int indexOf(SkinUnitAdapter skinUnitAdapter) {
        return this.mSkinUnitAdapters.indexOf(skinUnitAdapter);
    }

    static {
        mNameMap.put("app", "\u4e07\u80fd\u6309\u94ae");
        mNameMap.put("play_tts", "\u64ad\u653e\u8bed\u97f3");
        mNameMap.put("set_tts", "\u8bbe\u7f6e\u5929\u6c14\u95f9\u949f");
        mNameMap.put("update", "\u66f4\u65b0\u5929\u6c14\u6570\u636e");
        mNameMap.put("change_city", "\u5207\u6362\u57ce\u5e02");
        mNameMap.put("IntoTqtClock", "\u6253\u5f00\u5929\u6c14\u95f9\u949f");
        mNameMap.put("IntoCalendar", "\u6253\u5f00\u7cfb\u7edf\u65e5\u5386");
        mNameMap.put("IntoSpecialRecommend", "\u6253\u5f00\u7cbe\u54c1\u63a8\u8350");
        mNameMap.put("share_weibo", "\u5fae\u535a\u5206\u4eab");
        mNameMap.put("run_weibo", "\u6253\u5f00\u65b0\u6d6a\u5fae\u535a");
        mNameMap.put("c_weather_icon", "\u5b9e\u51b5\u5929\u6c14\u56fe\u6807");
        mNameMap.put("day_weather_icon", "\u767d\u5929\u9884\u62a5\u56fe\u6807");
        mNameMap.put("night_weather_icon", "\u591c\u95f4\u9884\u62a5\u56fe\u6807");
        mNameMap.put("f_weather_icon", "\u9884\u62a5\u5929\u6c14\u56fe\u6807");
        mNameMap.put("clock_ampm", "\u65f6\u949f\u7684am/pm");
        mNameMap.put("clock_hourhand", "\u5706\u76d8\u65f6\u949f\u65f6\u9488\u56fe\u6807");
        mNameMap.put("clock_minutehand", "\u5706\u76d8\u65f6\u949f\u5206\u9488\u56fe\u6807");
        mNameMap.put("clock_hd", "\u65f6\u949f\u5c0f\u65f6\u5341\u4f4d\u56fe\u6807");
        mNameMap.put("clock_hu", "\u65f6\u949f\u5c0f\u65f6\u4e2a\u4f4d\u56fe\u6807");
        mNameMap.put("clock_md", "\u65f6\u949f\u5206\u949f\u5341\u4f4d\u56fe\u6807");
        mNameMap.put("clock_mu", "\u65f6\u949f\u5206\u949f\u4e2a\u4f4d\u56fe\u6807");
        mNameMap.put("clock_h", "\u65f6\u949f\u7684\u5c0f\u65f6");
        mNameMap.put("clock_h24", "24\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6");
        mNameMap.put("clock_h12", "12\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6");
        mNameMap.put("clock_m", "\u65f6\u949f\u5206\u949f\u56fe\u6807");
        mNameMap.put("clock_h24d", "24\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6\u7684\u5341\u4f4d");
        mNameMap.put("clock_h12d", "12\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6\u7684\u5341\u4f4d");
        mNameMap.put("clock_h24u", "24\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6\u7684\u4e2a\u4f4d");
        mNameMap.put("clock_h12u", "12\u5c0f\u65f6\u5236\u65f6\u949f\u7684\u5c0f\u65f6\u7684\u4e2a\u4f4d");
        mNameMap.put("temperature", "\u5b9e\u51b5\u6e29\u5ea6");
        mNameMap.put("htemperature", "\u6700\u9ad8\u6e29\u5ea6");
        mNameMap.put("ltemperature", "\u6700\u4f4e\u6e29\u5ea6");
        mNameMap.put("humidity", "\u6e7f\u5ea6");
        mNameMap.put("warn", "\u9884\u8b66");
        mNameMap.put("car", "\u5c3e\u53f7\u9650\u884c");
        mNameMap.put("yyyy", "\u516c\u5386\u5e74 yyyy");
        mNameMap.put("yy", "\u516c\u5386\u5e74 yy");
        mNameMap.put("mm", "\u516c\u5386\u6708 mm");
        mNameMap.put("m", "\u516c\u5386\u6708 m");
        mNameMap.put("dd", "\u516c\u5386\u65e5 dd");
        mNameMap.put("d", "\u516c\u5386\u65e5 d");
        mNameMap.put("week", "\u661f\u671f");
        mNameMap.put("chn_zodiacs", "\u751f\u8096");
        mNameMap.put("chn_y", "\u519c\u5386\u5e74");
        mNameMap.put("chn_m", "\u519c\u5386\u6708");
        mNameMap.put("chn_d", "\u519c\u5386\u65e5");
        mNameMap.put("city_name", "\u57ce\u5e02\u540d\u79f0(\u4e2d\u6587)");
        mNameMap.put("chn_solar_term", "\u519c\u5386\u8282\u6c14");
        mNameMap.put("chn_y", "\u519c\u5386\u5e74");
        mNameMap.put("chn_m", "\u519c\u5386\u6708");
        mNameMap.put("chn_d", "\u519c\u5386\u65e5");
        mNameMap.put("yyyy", "\u516c\u5386\u5e74 yyyy");
        mNameMap.put("yy", "\u516c\u5386\u5e74 yy");
        mNameMap.put("mm", "\u516c\u5386\u6708 mm");
        mNameMap.put("m", "\u516c\u5386\u6708 m");
        mNameMap.put("mm0_en", "\u516c\u5386\u6708 Month");
        mNameMap.put("mm1_en", "\u516c\u5386\u6708 Mon.");
        mNameMap.put("dd", "\u516c\u5386\u65e5 dd");
        mNameMap.put("d", "\u516c\u5386\u65e5 d");
        mNameMap.put("d0_en", "<html><font>\u516c\u5386\u65e5 1</font><sup>st</sup></html>");
        mNameMap.put("d1_en", "\u516c\u5386\u65e5 1st");
        mNameMap.put("w0", "\u661f\u671f\u4e00");
        mNameMap.put("w1", "\u5468\u4e00");
        mNameMap.put("w2", "\u4e00");
        mNameMap.put("c_weather", "\u5b9e\u51b5\u5929\u6c14");
        mNameMap.put("c_weather0_en", "\u5b9e\u51b5\u5929\u6c14\u7684\u82f1\u6587\u5c0f\u5199");
        mNameMap.put("c_weather1_en", "\u5b9e\u51b5\u5929\u6c14\u7684\u82f1\u6587\u5927\u5199");
        mNameMap.put("wind", "\u98ce\u529b\u98ce\u5411");
        mNameMap.put("temperature", "\u5b9e\u51b5\u6e29\u5ea6");
        mNameMap.put("humidity", "\u5b9e\u51b5\u6e7f\u5ea6");
        mNameMap.put("day_weather", "\u767d\u5929\u5929\u6c14");
        mNameMap.put("night_weather", "\u591c\u95f4\u5929\u6c14");
        mNameMap.put("hltemperature", "\u6700\u9ad8\u6700\u4f4e\u6e29\u5ea6");
        mNameMap.put("uv", "\u7d2b\u5916\u7ebf");
        mNameMap.put("cwash", "\u6d17\u8f66");
        mNameMap.put("cold", "\u611f\u5192");
        mNameMap.put("comfort", "\u8212\u9002\u5ea6");
        mNameMap.put("cloth", "\u7a7f\u8863");
        mNameMap.put("umbrella", "\u96e8\u4f1e");
        mNameMap.put("insolate", "\u667e\u6652");
        mNameMap.put("sport", "\u8fd0\u52a8");
        mNameMap.put("sun_rise", "\u65e5\u51fa\u65f6\u95f4");
        mNameMap.put("sun_set", "\u65e5\u843d\u65f6\u95f4");
        mNameMap.put("city_name1", "\u57ce\u5e02\u540d\u79f0(\u82f1\u6587)");
        mNameMap.put("f_weather", "\u9884\u62a5\u5929\u6c14");
        mNameMap.put("pub_time", "\u5929\u6c14\u4fe1\u606f\u53d1\u5e03\u65e5\u671f\u65f6\u95f4");
        mNameMap.put("pub_time_brief", "\u5929\u6c14\u4fe1\u606f\u53d1\u5e03\u65f6\u95f4");
        mNameMap.put("htemperature", "\u6700\u9ad8\u6e29\u5ea6");
        mNameMap.put("ltemperature", "\u6700\u4f4e\u6e29\u5ea6");
        mNameMap.put("car", "\u5c3e\u53f7\u9650\u884c");
        mNameMap.put("warn", "\u9884\u8b66\u4fe1\u606f");
        mNameMap.put("PM_25", "PM2.5\u503c");
        mNameMap.put("PM_10", "PM10\u503c");
        mNameMap.put("NO_2", "\u4e8c\u6c27\u5316\u6c2e\u503c");
        mNameMap.put("SO_2", "\u4e8c\u6c27\u5316\u786b\u503c");
        mNameMap.put("Api_value", "\u6c61\u67d3\u6307\u6570\u503c");
        mNameMap.put("Api_qulity", "\u7a7a\u6c14\u8d28\u91cf");
        mNameMap.put("Api_time", "\u6c61\u67d3\u6307\u6570\u53d1\u5e03\u65f6\u95f4");
        mNameMap.put("Api_source", "\u6c61\u67d3\u6307\u6570\u6765\u6e90");
        mNameMap.put("w0_en", "Monday");
        mNameMap.put("w1_en", "Mon.");
    }
}

