/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.config.Config;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.constants.Constants;
import sina.mobile.tianqitong.module.DynamicImagePane;
import sina.mobile.tianqitong.moduleui.CustomScrollBarUI;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetWeatherImageDialog
extends JDialog {
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton mCancelButton;
    private JButton mOkButton;
    private JScrollPane mScrollPane1;
    private List<File> mFileList;
    private ArrayList<JComboBox> mNameList = new ArrayList();
    private String mPrefix = "";
    private int mResultMod = 1;
    private final Cursor waitCursor = new Cursor(3);
    private final Cursor normalCursor = new Cursor(0);
    private Frame mParentFrame;

    public SetWeatherImageDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mParentFrame = parent;
        this.initComponents();
    }

    public JPanel setPanel(int count, List<File> files, String[] names) {
        if (files.isEmpty() || count != files.size()) {
            throw new IllegalArgumentException("The files is empty or the count is not equals files' size.");
        }
        this.mFileList = files;
        JPanel panel = new JPanel();
        for (int i = 0; i < count; ++i) {
            DynamicImagePane p = new DynamicImagePane(this.mFileList.get(i), names);
            JComboBox spinner = p.getSelectedNameList();
            this.initSpinnerSelectItem(this.mFileList.get(i), spinner, 1, 17);
            this.mNameList.add(spinner);
            panel.add(p);
        }
        return panel;
    }

    public void setLayout(int rows, int cols, JPanel panel) {
        if (rows == 0 && cols == 0) {
            throw new IllegalArgumentException("rows and cols cannot both be zero");
        }
        panel.setLayout(new GridLayout(rows, cols, 10, 15));
        this.mScrollPane1.setViewportView(panel);
    }

    public void setDialogSize(int width, int height) {
        this.setSize(width, height);
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public int getResultVaule() {
        return this.mResultMod;
    }

    private void copyIcons() {
        this.mParentFrame.setCursor(this.waitCursor);
        Config config = AppData.getInstance().mConfig;
        SkinPkg pkg = AppData.getInstance().getSkinPkg();
        String path = "SkinCache" + File.separator + Config.ORIENTATION_STRING[config.getOrientation()] + "_" + Config.ASPECT_RATIO_STRING[config.getAspectRatio()] + "_" + Config.DENSITY_STRING[config.getDensity()] + "_" + Config.SIZE_STRING[config.getSize()] + File.separator + pkg.getSkinFile().getName().substring(0, pkg.getSkinFile().getName().length() - ".zip".length()) + File.separator + "drawable-" + Config.ORIENTATION_STRING[config.getOrientation()] + File.separator;
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        for (int i = 0; i < this.mFileList.size(); ++i) {
            try {
                String idStr = SkinAdapter.getGlobalSkinPortUnitID();
                String newName = idStr + this.mPrefix + "_" + Constants.WEATHER_IDS[this.mNameList.get(i).getSelectedIndex()];
                File newFile = new File(path + newName);
                FileUtil.copyFile(this.mFileList.get(i), newFile);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mParentFrame.setCursor(this.normalCursor);
    }

    private boolean checkOperatingIsRepeat() {
        for (int i = 0; i < this.mNameList.size(); ++i) {
            for (int j = i + 1; j < this.mNameList.size(); ++j) {
                if (!this.mNameList.get(i).getSelectedItem().equals(this.mNameList.get(j).getSelectedItem())) continue;
                return true;
            }
        }
        return false;
    }

    private void initSpinnerSelectItem(File file, JComboBox spinner, int small, int large) {
        String fileName = file.getName();
        for (int i = small; i <= large; ++i) {
            if (i < 10) {
                if (!fileName.contains("0" + i) && !fileName.contains(i + "")) continue;
                spinner.setSelectedIndex(i - 1);
                continue;
            }
            if (i < 10 || !fileName.contains(i + "")) continue;
            spinner.setSelectedIndex(i - 1);
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        this.mScrollPane1 = new JScrollPane();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(265, 200));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                SetWeatherImageDialog.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBackground(Colors.BACKGROUND);
        this.mOkButton.setBackground(Colors.BACKGROUND);
        this.mOkButton.setText("\u786e\u5b9a");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetWeatherImageDialog.this.mOkButtonActionPerformed(evt);
            }
        });
        this.mCancelButton.setBackground(Colors.BACKGROUND);
        this.mCancelButton.setText("\u53d6\u6d88");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SetWeatherImageDialog.this.mCancelButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(350, Short.MAX_VALUE).addComponent(this.mOkButton, -2, 81, -2).addGap(18, 18, 18).addComponent(this.mCancelButton, -2, 81, -2).addGap(22, 22, 22)));
        jPanel2Layout.linkSize(0, this.mCancelButton, this.mOkButton);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mCancelButton).addComponent(this.mOkButton)).addContainerGap(12, Short.MAX_VALUE)));
        this.mScrollPane1.setBackground(Colors.BACKGROUND);
        this.mScrollPane1.setBorder(null);
        this.mScrollPane1.setHorizontalScrollBarPolicy(31);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.mScrollPane1, -1, 552, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.mScrollPane1, -1, 297, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void mCancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void mOkButtonActionPerformed(ActionEvent evt) {
        if (this.checkOperatingIsRepeat()) {
            JOptionPane.showMessageDialog(this, "\u60a8\u9009\u62e9\u4e86\u76f8\u540c\u7684\u540d\u5b57\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", "\u8b66\u544a", 2);
            return;
        }
        this.copyIcons();
        this.mResultMod = 0;
        this.dispose();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.mScrollPane1.getVerticalScrollBar().setUI(CustomScrollBarUI.createUI());
        this.mScrollPane1.getHorizontalScrollBar().setUI(CustomScrollBarUI.createUI());
    }
}

