/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sina.mobile.skin.SkinHelper;
import sina.mobile.tianqitong.AppData;
import sina.mobile.tianqitong.AppMainFrame;
import sina.mobile.tianqitong.UploadDialog;
import sina.mobile.tianqitong.constants.AppPreferences;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.io.ExportTQTSkinZipPkg;
import sina.mobile.tianqitong.module.CustomFileChooser;
import sina.mobile.tianqitong.moduleui.CustomFileChooserUI;
import sina.mobile.tianqitong.skin.SkinCfg;
import sina.mobile.tianqitong.skin.SkinPkg;
import sina.mobile.tianqitong.util.FileUtil;
import sina.mobile.tianqitong.util.StringUtil;

public class ExportDialog
extends JDialog {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField mAuthorName;
    private JButton mCancelButton;
    private JButton mOkButton;
    private JTextField mSkinName;
    private AppMainFrame mParentFrame;
    private static final Cursor waitCursor = new Cursor(3);
    private static final Cursor normalCursor = new Cursor(0);

    public ExportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.mParentFrame = (AppMainFrame)parent;
        this.initComponents();
        this.initSkinNameTextField();
    }

    private void initSkinNameTextField() {
        this.mSkinName.setDocument(new PlainDocument(){

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                String text = ExportDialog.this.mSkinName.getText();
                if (StringUtil.getLength(text) >= 20) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                super.insertString(offs, str, a);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.mSkinName = new JTextField();
        this.mAuthorName = new JTextField();
        this.jLabel3 = new JLabel();
        this.mOkButton = new JButton();
        this.mCancelButton = new JButton();
        this.jLabel4 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u76ae\u80a4\u5305\u547d\u540d");
        this.setResizable(false);
        this.jPanel1.setBackground(Colors.BACKGROUND);
        this.jLabel1.setBackground(Colors.BACKGROUND);
        this.jLabel1.setForeground(new Color(255, 255, 255));
        this.jLabel1.setText("\u76ae\u80a4\u5305\u540d\u79f0");
        this.jLabel2.setBackground(Colors.BACKGROUND);
        this.jLabel2.setForeground(new Color(255, 255, 255));
        this.jLabel2.setText("\u4f5c\u8005\u540d");
        this.mSkinName.setBackground(Colors.LIGHT_AREA);
        this.mSkinName.setForeground(new Color(255, 255, 255));
        this.mSkinName.setToolTipText("\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26\u621610\u4e2a\u6c49\u5b57");
        this.mAuthorName.setBackground(Colors.LIGHT_AREA);
        this.mAuthorName.setForeground(new Color(255, 255, 255));
        this.jLabel3.setBackground(Colors.BACKGROUND);
        this.jLabel3.setForeground(new Color(255, 255, 255));
        this.jLabel3.setText("\u4f1a\u5728\u624b\u673a\u4e0a\u663e\u793a\u4f60\u7684\u76ae\u80a4\u540d\u5662\uff01");
        this.mOkButton.setBackground(Colors.BACKGROUND);
        this.mOkButton.setText("\u786e\u5b9a");
        this.mOkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.mOkButtonActionPerformed(evt);
            }
        });
        this.mCancelButton.setBackground(Colors.BACKGROUND);
        this.mCancelButton.setText("\u53d6\u6d88");
        this.mCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ExportDialog.this.mCancelButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setBackground(Colors.BACKGROUND);
        this.jLabel4.setForeground(new Color(255, 255, 255));
        this.jLabel4.setText("\u5efa\u8bae\u8f93\u5165\u4f60\u7684\u65b0\u6d6a\u5fae\u535a\u540d\u79f0\u54e6\uff01");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.mOkButton, -2, 78, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3).addComponent(this.mSkinName).addComponent(this.mAuthorName, -2, 192, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.mCancelButton, -2, 75, -2).addComponent(this.jLabel4))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.mCancelButton, this.mOkButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mSkinName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(14, 14, 14).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.mAuthorName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mOkButton).addComponent(this.mCancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void mOkButtonActionPerformed(ActionEvent evt) {
        String skinName = this.mSkinName.getText().trim();
        String author = this.mAuthorName.getText().trim();
        if (null == skinName || "".equals(skinName)) {
            JOptionPane.showMessageDialog(this, "\u76ae\u80a4\u5305\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.", "\u63d0\u793a", 1);
            return;
        }
        if (null == author || "".equals(author)) {
            JOptionPane.showMessageDialog(this, "\u4f5c\u8005\u540d\u4e0d\u80fd\u4e3a\u7a7a.", "\u63d0\u793a", 1);
            return;
        }
        final CustomFileChooser chooser = new CustomFileChooser(AppPreferences.getLastSavePath("lastSavePath"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new ZIPFileFilter());
        chooser.setSelectedFile(new File(skinName));
        chooser.setUI(CustomFileChooserUI.createUI(chooser));
        if (0 == chooser.showSaveDialog(this)) {
            AppPreferences.putSavePath("lastSavePath", chooser.getSelectedFile().getParent());
            ArrayList<String> names = FileUtil.getFileNamesInDir(chooser.getSelectedFile().getParentFile());
            if (null != names && names.size() > 0 && null != chooser.getSelectedFile()) {
                String name = chooser.getSelectedFile().getName().trim();
                name = name + (name.endsWith(".zip") ? "" : ".zip");
                for (String n : names) {
                    if (n.compareToIgnoreCase(name) != 0 || 2 != JOptionPane.showConfirmDialog(this, "\u8be5\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", "\u8b66\u544a", 2)) continue;
                    this.mOkButtonActionPerformed(null);
                    return;
                }
            }
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ExportDialog.this.mParentFrame.setCursor(waitCursor);
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.start();
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.setRate(0);
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.setText("\u6b63\u5728\u4fdd\u5b58...");
                    SkinCfg cfg = AppData.getInstance().getSkinPkg().getSkinCfg();
                    File file = new File("SkinZip" + File.separator + cfg.Name);
                    new ExportTQTSkinZipPkg().getSkinZipPath(ExportDialog.this.mSkinName.getText().trim());
                    try {
                        FileUtil.copyDir(file, new File("SkinZip" + File.separator + ExportDialog.this.mSkinName.getText().trim()));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.setRate(30);
                    new ExportTQTSkinZipPkg().exportSkinZip(chooser.getSelectedFile().getPath(), ExportDialog.this.mSkinName.getText().trim(), ExportDialog.this.mSkinName.getText().trim(), ExportDialog.this.mAuthorName.getText().trim(), ((ExportDialog)ExportDialog.this).mParentFrame.mSkinPreviewPane.getPreviewIcon(), ((ExportDialog)ExportDialog.this).mParentFrame.mSkinPreviewPane.getPreviewIcon2(), this);
                    4 ex = this;
                    synchronized (ex) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    String name = chooser.getSelectedFile().getName().trim();
                    name = name + (name.endsWith(".zip") ? "" : ".zip");
                    File f = new File(chooser.getSelectedFile().getParent() + File.separator + name);
                    File dir = new File(AppData.getInstance().getDefaultSkinCacheDir(), AppData.getInstance().getSkinPkg().getSkinFile().getName().substring(0, AppData.getInstance().getSkinPkg().getSkinFile().getName().length() - ".zip".length()));
                    File newDir = new File(AppData.getInstance().getDefaultSkinCacheDir(), name.substring(0, name.length() - ".zip".length()));
                    dir.renameTo(newDir);
                    SkinPkg pkg = AppData.getInstance().getSkinPkg();
                    pkg.setSkinFile(f);
                    pkg.getSkinCfg().Name = ExportDialog.this.mSkinName.getText().trim();
                    pkg.getSkinCfg().Author = ExportDialog.this.mAuthorName.getText().trim();
                    pkg.getPortSkinAdapter().getSkin().setSkinZipFile(f);
                    pkg.getLandSkinAdapter().getSkin().setSkinZipFile(f);
                    SkinHelper.setCacheDir(newDir);
                    ExportDialog.this.mParentFrame.setTitle("\u5929\u6c14\u901a\u76ae\u80a4\u7f16\u8f91\u56682.3.1 - " + name);
                    ((ExportDialog)ExportDialog.this).mParentFrame.mIsExportProject = true;
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.setText("\u4fdd\u5b58\u6210\u529f");
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.setRate(100);
                    ((ExportDialog)ExportDialog.this).mParentFrame.gGrassPane.stop();
                    ExportDialog.this.mParentFrame.setCursor(normalCursor);
                    UploadDialog uploadDialog = new UploadDialog((Frame)ExportDialog.this.mParentFrame, true);
                    uploadDialog.setDefaultCloseOperation(1);
                    uploadDialog.setLocationRelativeTo(null);
                    uploadDialog.setVisible(true);
                }
            };
            Executors.newCachedThreadPool().execute(task);
            this.dispose();
        }
    }

    private void mCancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private static final class ZIPFileFilter
    extends FileFilter {
        private ZIPFileFilter() {
        }

        public boolean accept(File f) {
            return f.isFile() && f.getName().toLowerCase().endsWith(".zip") || f.isDirectory();
        }

        public String getDescription() {
            return "\u76ae\u80a4\u5305\u683c\u5f0f\uff08*.zip\uff09";
        }
    }
}

