/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.tianqitong;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import sina.mobile.tianqitong.adapter.SkinAdapter;
import sina.mobile.tianqitong.constants.Colors;
import sina.mobile.tianqitong.constants.Constants;
import sina.mobile.tianqitong.io.SkinUnitOperator;
import sina.mobile.tianqitong.material.MaterialFunction;
import sina.mobile.tianqitong.material.MaterialPkg;

public class DragButtonIconDialog
extends JDialog {
    private ArrayList<JCheckBox> mCheckBoxs = new ArrayList();
    private MaterialPkg mMaterialPkg;
    private Point mPoint = null;
    private JButton cancleButton;
    private JPanel jPanel1;
    private JButton okButton;

    public DragButtonIconDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(null);
    }

    public Point getPoint() {
        return this.mPoint;
    }

    public void setPoint(Point point) {
        this.mPoint = point;
    }

    public void setMaterialPkg(MaterialPkg mMaterialPkg) {
        this.mMaterialPkg = mMaterialPkg;
        ArrayList<MaterialFunction> functions = mMaterialPkg.getMaterialCfg().materialFunctions;
        for (int i = 0; i < functions.size(); ++i) {
            MaterialFunction function = functions.get(i);
            String name = Constants.BUTTON_NICK_NAME_MAP.get(function.functionId);
            JCheckBox radioButton = new JCheckBox(name);
            radioButton.setName(function.functionId);
            radioButton.setBounds(10, 10 + i * 25, 200, 23);
            radioButton.setIcon(new ImageIcon(this.getClass().getResource("/sina/mobile/tianqitong/resources/icon_choose.png")));
            radioButton.setSelectedIcon(new ImageIcon(this.getClass().getResource("/sina/mobile/tianqitong/resources/icon_choose_selected.png")));
            radioButton.setSelected(true);
            radioButton.setBackground(Colors.BACKGROUND);
            radioButton.setForeground(new Color(255, 255, 255));
            this.mCheckBoxs.add(radioButton);
            this.jPanel1.add(radioButton);
        }
        this.setSize(189, functions.size() * 25 + 96);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancleButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("\u8bf7\u9009\u62e9\u63a7\u4ef6\u5c5e\u6027");
        this.setResizable(false);
        this.cancleButton.setText("\u53d6\u6d88");
        this.cancleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DragButtonIconDialog.this.cancleButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("\u786e\u5b9a");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DragButtonIconDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addComponent(this.cancleButton).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(221, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancleButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        String functionId = null;
        MaterialFunction materialFunction = null;
        int mulite = 0;
        for (MaterialFunction function : this.mMaterialPkg.getMaterialCfg().materialFunctions) {
            for (int i = 0; i < this.mCheckBoxs.size(); ++i) {
                JCheckBox button = this.mCheckBoxs.get(i);
                if (!button.isSelected() || !(functionId = button.getName()).equals(function.functionId)) continue;
                materialFunction = function;
                String idStr = SkinAdapter.getGlobalSkinPortUnitID();
                SkinUnitOperator.copyMaterial(materialFunction, idStr);
                HashMap<String, BufferedImage> imageCache = materialFunction.imageCacheMap;
                for (Map.Entry<String, BufferedImage> entry : imageCache.entrySet()) {
                    String name = entry.getKey();
                    SkinUnitOperator.addStaticIcon(idStr + name, this.getPoint(mulite), false);
                    ++mulite;
                }
            }
        }
        if (functionId == null) {
            JOptionPane.showMessageDialog(this, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u79cd\u683c\u5f0f\u624d\u80fd\u6dfb\u52a0", "\u63d0\u793a", 2);
            return;
        }
        this.dispose();
    }

    private Point getPoint(int mulite) {
        int dx = 20;
        int dy = 20;
        Point point = new Point(this.mPoint.x + mulite * dx, this.mPoint.y + mulite * dy);
        return point;
    }

    private void cancleButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

