/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin.weather;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import sina.mobile.skin.Utility;
import sina.mobile.skin.weather.AirPiInfoHelper;
import sina.mobile.skin.weather.AirPollutionInfo;
import sina.mobile.skin.weather.ForecastWeather;
import sina.mobile.skin.weather.LifeExponent;
import sina.mobile.skin.weather.LiveWeather;
import sina.mobile.skin.weather.Warning;

public class WeatherInfo {
    private String _pubdate = "0000-00-00 00:00";
    private int _pubdateYearNum = -1;
    private int _pubdateMonthNum = -1;
    private int _pubdateDayNum = -1;
    private int _pubdateHourNum = -1;
    private int _pubdateMinuteNum = -1;
    private String _gmt = "0000-00-00 00:00";
    private int _gmtYearNum = -1;
    private int _gmtMonthNum = -1;
    private int _gmtDayNum = -1;
    private int _gmtHourNum = -1;
    private int _gmtMinuteNum = -1;
    private boolean _valid = false;
    private String _location = "\u4e4c\u6709";
    private String _cityCode = "\u5b50\u865a";
    private LiveWeather _condition;
    private Warning _warning;
    private LifeExponent _lifedex;
    private ForecastWeather[] _forecasts;
    private AirPollutionInfo _airPiInfo = null;
    private String _sunRise = "05:00";
    private int[] _sunRiseTime = new int[]{5, 0};
    private String _sunSet = "18:00";
    private int[] _sunSetTime = new int[]{18, 0};
    private int _gmt2locOffset = 8;
    private long _pubdateTimeMillis = 0L;
    private boolean _correctByTimeZone = false;
    public static final String[] WEATHER_STRING_EN_0 = new String[]{"tornado", "tropical storm", "hurricane", "severe thunderstorms", "thunderstorms", "mixed rain and snow", "mixed rain and sleet", "mixed snow and sleet", "freezing drizzle", "drizzle", "freezing rain", "drizzle", "rain", "snow flurries", "light snow showers", "blowing snow", "snow", "hail", "sleet", "dust", "foggy", "haze", "smoky", "blustery", "windy", "cold", "cloudy", "mostly cloudy", "mostly cloudy", "partly cloudy", "partly cloudy", "clear", "sunny", "clear", "sunny", "mixed rain and hail", "hot", "isolated thunderstorms", "scattered thunderstorms", "showers", "scattered showers", "heavy snow", "scattered snow showers", "heavy snow", "partly cloudy", "thundershowers", "snow showers", "isolated thundershowers", "not available", "weather unknown"};
    public static final String[] WEATHER_STRING_EN_1 = new String[]{"Tornado", "Tropical Storm", "Hurricane", "Severe Thunderstorms", "Thunderstorms", "Mixed Rain And Snow", "Mixed Rain and Sleet", "Mixed Snow and Sleet", "Freezing Drizzle", "Drizzle", "Freezing Rain", "Drizzle", "Rain", "Snow Flurries", "Light Snow Showers", "Blowing Snow", "Snow", "Hail", "Sleet", "Dust", "Foggy", "Haze", "Smoky", "Blustery", "Windy", "Cold", "Cloudy", "Mostly Cloudy", "Mostly Cloudy", "Partly Cloudy", "Partly Cloudy", "Clear", "Sunny", "Clear", "Sunny", "Mixed Rain And Hail", "Hot", "Isolated Thunderstorms", "Scattered Thunderstorms", "Showers", "Scattered Showers", "Heavy Snow", "Scattered Snow Showers", "Heavy Snow", "Partly Cloudy", "Thundershowers", "Snow Showers", "Isolated Thundershowers", "Not Available", "Weather Unknown"};
    public static final String[] WEATHER_STRING = new String[]{"\u9f99\u5377\u98ce", "\u70ed\u5e26\u98ce\u66b4", "\u98d3\u98ce", "\u5f3a\u96f7\u96e8", "\u96f7\u96e8", "\u96e8\u593e\u96ea", "\u96e8\u593e\u51b0", "\u96ea\u5939\u51b0", "\u5c0f\u51bb\u96e8", "\u5c0f\u96e8", "\u51bb\u96e8", "\u5c0f\u96e8", "\u96e8", "\u9635\u96ea", "\u5c0f\u96ea", "\u5439\u96ea", "\u96ea", "\u51b0\u96f9", "\u96e8\u5939\u96ea", "\u6d6e\u5c18", "\u96fe", "\u973e", "\u70df", "\u5927\u98ce", "\u98ce", "\u5bd2\u51b7", "\u9634", "\u591a\u4e91", "\u591a\u4e91", "\u5c11\u4e91", "\u5c11\u4e91", "\u6674", "\u6674", "\u6674", "\u6674", "\u96e8\u5939\u51b0\u96f9", "\u708e\u70ed", "\u5c40\u90e8\u96f7\u96e8", "\u96f6\u661f\u96f7\u96e8", "\u9635\u96e8", "\u96f6\u661f\u9635\u96e8", "\u5927\u96ea", "\u96f6\u661f\u9635\u96ea", "\u5927\u96ea", "\u5c11\u4e91", "\u96f7\u9635\u96e8", "\u9635\u96ea", "\u5c40\u90e8\u96f7\u9635\u96e8", "\u5929\u6c14\u672a\u77e5", "\u5929\u6c14\u60c5\u51b5\u672a\u77e5"};

    public WeatherInfo() {
        this._condition = new LiveWeather();
        this._warning = new Warning();
        this._lifedex = new LifeExponent();
        this._forecasts = new ForecastWeather[0];
        try {
            this._airPiInfo = AirPiInfoHelper.getDefaultAirPiInfo();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public AirPollutionInfo getAirPiInfo() {
        return this._airPiInfo;
    }

    public void setAirPiInfo(AirPollutionInfo _airPiInfo) {
        this._airPiInfo = _airPiInfo;
    }

    public boolean isCorrectByTimeZone() {
        return this._correctByTimeZone;
    }

    public void setCorrectByTimeZone(boolean _correctByTimeZone) {
        this._correctByTimeZone = _correctByTimeZone;
    }

    public int getGmt2locOffset() {
        return this._gmt2locOffset;
    }

    public void setGmt2locOffset(int _gmt2locOffset) {
        this._gmt2locOffset = _gmt2locOffset;
    }

    public long getPubdateTimeMillis() {
        return this._pubdateTimeMillis;
    }

    public void setPubdateTimeMillis(long _pubdateTimeMillis) {
        this._pubdateTimeMillis = _pubdateTimeMillis;
    }

    public String getCityCode() {
        return this._cityCode;
    }

    public void setCityCode(String _cityCode) {
        this._cityCode = _cityCode;
    }

    public LiveWeather getCondition() {
        return this._condition;
    }

    public void setCondition(LiveWeather _condition) {
        this._condition = _condition;
    }

    public ForecastWeather[] getForecasts() {
        return this._forecasts;
    }

    public void setForecasts(ForecastWeather[] _forecasts) {
        this._forecasts = _forecasts;
    }

    public String getGmt() {
        return this._gmt;
    }

    public void setGmt(String _gmt) {
        this._gmt = _gmt;
    }

    public int getGmtDayNum() {
        return this._gmtDayNum;
    }

    public void setGmtDayNum(int _gmtDayNum) {
        this._gmtDayNum = _gmtDayNum;
    }

    public int getGmtHourNum() {
        return this._gmtHourNum;
    }

    public void setGmtHourNum(int _gmtHourNum) {
        this._gmtHourNum = _gmtHourNum;
    }

    public int getGmtMinuteNum() {
        return this._gmtMinuteNum;
    }

    public void setGmtMinuteNum(int _gmtMinuteNum) {
        this._gmtMinuteNum = _gmtMinuteNum;
    }

    public int getGmtMonthNum() {
        return this._gmtMonthNum;
    }

    public void setGmtMonthNum(int _gmtMonthNum) {
        this._gmtMonthNum = _gmtMonthNum;
    }

    public int getGmtYearNum() {
        return this._gmtYearNum;
    }

    public void setGmtYearNum(int _gmtYearNum) {
        this._gmtYearNum = _gmtYearNum;
    }

    public LifeExponent getLifedex() {
        return this._lifedex;
    }

    public void setLifedex(LifeExponent _lifedex) {
        this._lifedex = _lifedex;
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String _location) {
        this._location = _location;
    }

    public int[] getPubdateYMDHMNumForCurrent() {
        return this.YMDHMSMsStr2Nums(this._pubdate);
    }

    public boolean pubdateIsThisYear() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        int curyear = c.get(1);
        int[] pubdateints = this.getPubdateYMDHMNumForCurrent();
        int pubdateyear = pubdateints[0];
        return curyear == pubdateyear;
    }

    public int getPubdateToTodayOffsetDay() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long cur = c.getTimeInMillis();
        int[] pubdateints = this.getPubdateYMDHMNumForCurrent();
        c.set(1, pubdateints[0]);
        c.set(2, pubdateints[1] - 1);
        c.set(5, pubdateints[2]);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long pubdate = c.getTimeInMillis();
        int r = (int)((pubdate - cur) / 86400000L);
        return r;
    }

    public String getPubdate() {
        boolean isYestoday;
        StringBuilder sb = new StringBuilder();
        int[] pubDate = this.getPubdateYMDHMNumForCurrent();
        if (!this.pubdateIsThisYear()) {
            sb.append(pubDate[0]).append("/");
        }
        boolean isToday = this.getPubdateToTodayOffsetDay() == 0;
        boolean bl = isYestoday = this.getPubdateToTodayOffsetDay() == -1;
        if (!isToday) {
            if (isYestoday) {
                sb.append("\u6628\u5929 ");
            } else {
                if (pubDate[1] < 10) {
                    sb.append("0");
                }
                sb.append(pubDate[1]);
                sb.append("/");
                if (pubDate[2] < 10) {
                    sb.append("0");
                }
                sb.append(pubDate[2]);
                sb.append(" ");
            }
        }
        if (pubDate[3] < 10) {
            sb.append("0");
        }
        sb.append(pubDate[3]);
        sb.append(":");
        if (pubDate[4] < 10) {
            sb.append("0");
        }
        sb.append(pubDate[4]);
        sb.append("\u53d1\u5e03");
        return sb.toString();
    }

    public String getBriefPubdate() {
        StringBuilder sb = new StringBuilder();
        int[] pubDate = this.getPubdateYMDHMNumForCurrent();
        if (pubDate[3] < 10) {
            sb.append("0");
        }
        sb.append(pubDate[3]);
        sb.append(":");
        if (pubDate[4] < 10) {
            sb.append("0");
        }
        sb.append(pubDate[4]);
        return sb.toString();
    }

    private int[] YMDHMSMsStr2Nums(String str) {
        return this.YMDHMSMsStr2Nums(str, "-", " ", ":");
    }

    private int[] YMDHMSMsStr2Nums(String str, String ymd, String dh, String hmsms) {
        int[] r = new int[7];
        Arrays.fill(r, -1);
        String[] tmp = Utility.split(str.trim(), dh);
        if (tmp.length == 2) {
            this.makeYMDNums(tmp[0].trim(), r, ymd);
            this.makeHMSMsNums(tmp[1].trim(), r, hmsms);
        } else if (tmp.length == 1) {
            this.makeYMDNums(tmp[0].trim(), r, ymd);
            this.makeHMSMsNums(tmp[0].trim(), r, hmsms);
        }
        return r;
    }

    private void makeYMDNums(String str, int[] r, String ymd) {
        String[] tmp1 = Utility.split(str, ymd);
        if (tmp1.length == 3) {
            r[0] = this.str2int(tmp1[0].trim());
            r[1] = this.str2int(tmp1[1].trim());
            r[2] = this.str2int(tmp1[2].trim());
        } else if (tmp1.length == 2) {
            r[0] = -1;
            r[1] = this.str2int(tmp1[0].trim());
            r[2] = this.str2int(tmp1[1].trim());
        }
    }

    private int str2int(String str) {
        try {
            int r = Integer.parseInt(str);
            return r;
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return -1;
        }
    }

    private void makeHMSMsNums(String str, int[] r, String hmsms) {
        String[] tmp1 = Utility.split(str, hmsms);
        if (tmp1.length == 4) {
            r[3] = this.str2int(tmp1[0].trim());
            r[4] = this.str2int(tmp1[1].trim());
            r[5] = this.str2int(tmp1[2].trim());
            r[6] = this.str2int(tmp1[3].trim());
        } else if (tmp1.length == 3) {
            r[3] = this.str2int(tmp1[0].trim());
            r[4] = this.str2int(tmp1[1].trim());
            r[5] = this.str2int(tmp1[2].trim());
            r[6] = -1;
        } else if (tmp1.length == 2) {
            r[3] = this.str2int(tmp1[0].trim());
            r[4] = this.str2int(tmp1[1].trim());
            r[5] = -1;
            r[6] = -1;
        }
    }

    public String getPubdateString() {
        return this._pubdate;
    }

    public void setPubdateString(String _pubdate) {
        this._pubdate = _pubdate;
    }

    public int getPubdateDayNum() {
        return this._pubdateDayNum;
    }

    public void setPubdateDayNum(int _pubdateDayNum) {
        this._pubdateDayNum = _pubdateDayNum;
    }

    public int getPubdateHourNum() {
        return this._pubdateHourNum;
    }

    public void setPubdateHourNum(int _pubdateHourNum) {
        this._pubdateHourNum = _pubdateHourNum;
    }

    public int getPubdateMinuteNum() {
        return this._pubdateMinuteNum;
    }

    public void setPubdateMinuteNum(int _pubdateMinuteNum) {
        this._pubdateMinuteNum = _pubdateMinuteNum;
    }

    public int getPubdateMonthNum() {
        return this._pubdateMonthNum;
    }

    public void setPubdateMonthNum(int _pubdateMonthNum) {
        this._pubdateMonthNum = _pubdateMonthNum;
    }

    public int getPubdateYearNum() {
        return this._pubdateYearNum;
    }

    public void setPubdateYearNum(int _pubdateYearNum) {
        this._pubdateYearNum = _pubdateYearNum;
    }

    public String getSunRise() {
        return this._sunRise;
    }

    public void setSunRise(String _sunRise) {
        this._sunRise = _sunRise;
    }

    public int[] getSunRiseTime() {
        return this._sunRiseTime;
    }

    public void setSunRiseTime(int[] _sunRiseTime) {
        this._sunRiseTime = _sunRiseTime;
    }

    public String getSunSet() {
        return this._sunSet;
    }

    public void setSunSet(String _sunSet) {
        this._sunSet = _sunSet;
    }

    public int[] getSunSetTime() {
        return this._sunSetTime;
    }

    public void setSunSetTime(int[] _sunSetTime) {
        this._sunSetTime = _sunSetTime;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setValid(boolean _valid) {
        this._valid = _valid;
    }

    public Warning getWarning() {
        return this._warning;
    }

    public void setWarning(Warning _warning) {
        this._warning = _warning;
    }

    private long getLocCurrentMillis() {
        Calendar c = Calendar.getInstance();
        TimeZone tz = c.getTimeZone();
        long currentTimeMillis = System.currentTimeMillis();
        long gmtMillis = currentTimeMillis - (long)tz.getOffset(currentTimeMillis);
        return gmtMillis + (long)this._gmt2locOffset * 3600000L;
    }

    public final int getYCodeUsingSunRiseAndSet() {
        int ycode = this._condition.getYCode();
        boolean isDay = this.isDay();
        switch (ycode) {
            case 27: {
                if (!isDay) break;
                ycode = 28;
                break;
            }
            case 28: {
                if (isDay) break;
                ycode = 27;
                break;
            }
            case 29: {
                if (!isDay) break;
                ycode = 30;
                break;
            }
            case 30: {
                if (isDay) break;
                ycode = 29;
                break;
            }
            case 31: 
            case 33: {
                if (!isDay) break;
                ycode = 32;
                break;
            }
            case 32: 
            case 34: {
                if (isDay) break;
                ycode = 31;
                break;
            }
        }
        return ycode;
    }

    public static String getWeatherStrFromYahooCode(int ycode) {
        return WEATHER_STRING[ycode];
    }

    public static String getWeatherStrEn0FromYahooCode(int ycode) {
        return WEATHER_STRING_EN_0[ycode];
    }

    public static String getWeatherStrEn1FromYahooCode(int ycode) {
        return WEATHER_STRING_EN_1[ycode];
    }

    private int[] correctSunRiseOrSunSet(int[] riseOrSet) {
        Calendar c = Calendar.getInstance();
        TimeZone tz = c.getTimeZone();
        long currentTimeMillis = System.currentTimeMillis();
        int gmt2curOffset = tz.getOffset(currentTimeMillis) / 3600000;
        int loc2curOffset = this._gmt2locOffset - gmt2curOffset;
        c.set(1, this._pubdateYearNum);
        c.set(2, this._pubdateMonthNum - 1);
        c.set(5, this._pubdateDayNum);
        c.set(11, riseOrSet[0]);
        c.set(12, riseOrSet[1]);
        long locSunRiseTimeMillis = c.getTimeInMillis();
        long curSunRiseTimeMillis = locSunRiseTimeMillis - (long)loc2curOffset * 3600L * 1000L;
        c.setTimeInMillis(curSunRiseTimeMillis);
        int curYearNum = c.get(1);
        int curMonthNum = c.get(2) + 1;
        int curDayNum = c.get(5);
        int curHourNum = c.get(11);
        int curMinuteNum = c.get(12);
        return new int[]{curHourNum, curMinuteNum};
    }

    public String getSunRiseStrForLocal() {
        if (this._correctByTimeZone) {
            int[] tmp = this.getSunRiseTimeForLocal();
            return Utility.hourAndMinute2StrHourAndMinuteWithColon(tmp[0], tmp[1]);
        }
        return this._sunRise;
    }

    public int[] getSunRiseTimeForLocal() {
        if (this._correctByTimeZone) {
            return this.correctSunRiseOrSunSet(this._sunRiseTime);
        }
        return this._sunRiseTime;
    }

    public String getSunSetStrForLocal() {
        if (this._correctByTimeZone) {
            int[] tmp = this.getSunSetTimeForLocal();
            return Utility.hourAndMinute2StrHourAndMinuteWithColon(tmp[0], tmp[1]);
        }
        return this._sunSet;
    }

    public int[] getSunSetTimeForLocal() {
        if (this._correctByTimeZone) {
            return this.correctSunRiseOrSunSet(this._sunSetTime);
        }
        return this._sunSetTime;
    }

    public boolean isDay() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getLocCurrentMillis());
        int hourOfDay = c.get(11);
        int minute = c.get(12);
        return this.isDay(hourOfDay, minute);
    }

    public boolean isDay(int hourOfDay, int minute) {
        int[] riseTime = this._sunRiseTime;
        int riseHour = riseTime[0];
        int riseMinute = riseTime[1];
        int[] setTime = this._sunSetTime;
        int setHour = setTime[0];
        int setMinute = setTime[1];
        int tmpCur = hourOfDay * 100 + minute;
        int tmpRise = riseHour * 100 + riseMinute;
        int tmpSet = setHour * 100 + setMinute;
        return tmpCur > tmpRise && tmpCur < tmpSet;
    }

    public ForecastWeather[] getForecastsForCurrent(int size) {
        Object[] r = new ForecastWeather[size];
        Arrays.fill(r, ForecastWeather.EMPTY);
        Calendar c = Calendar.getInstance();
        long forecasts1stDayMillisecond = 0L;
        c.set(1, this._forecasts[0].getDateYearNum());
        c.set(2, this._forecasts[0].getDateMonthNum() - 1);
        c.set(5, this._forecasts[0].getDateDayNum());
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        forecasts1stDayMillisecond = c.getTimeInMillis();
        long current = 0L;
        c.setTimeInMillis(System.currentTimeMillis());
        c.set(11, 12);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        current = c.getTimeInMillis();
        int offsetDay = (int)((current - forecasts1stDayMillisecond) / 86400000L);
        if (offsetDay + size <= 0 || offsetDay >= this._forecasts.length) {
            return r;
        }
        for (int i = 0; i < size; ++i) {
            r[i] = offsetDay < 0 ? ForecastWeather.EMPTY : (offsetDay >= this._forecasts.length ? ForecastWeather.EMPTY : this._forecasts[offsetDay]);
            ++offsetDay;
        }
        return r;
    }
}

