/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin.weather;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import sina.mobile.skin.Utility;
import sina.mobile.skin.weather.ForecastWeather;
import sina.mobile.skin.weather.WeatherInfo;

public class WeatherHelper {
    private static WeatherInfo mWeather = null;

    public static int getForecastYcode(WeatherInfo wi, int offsetDay) {
        int ycode = wi.getForecastsForCurrent(5)[offsetDay].getHighPriorityLvYcode();
        if (wi.isDay()) {
            return WeatherHelper.getDayYcode(ycode);
        }
        return WeatherHelper.getNightYcode(ycode);
    }

    private static String createWeatherInfoString(int year, int month, int day) {
        String yyyy = "" + year;
        String mm = "" + month;
        if (month < 10) {
            mm = "0" + mm;
        }
        String dd = "" + day;
        if (day < 10) {
            dd = "0" + dd;
        }
        return "<weather valid=\"yes\" pubdate=\"" + yyyy + "-" + mm + "-" + dd + " 11:00\" gmt=\"" + yyyy + "-" + mm + "-" + dd + " 03:00\" location=\"\u4e4c\u9c81\u6728\u9f50\" citycode=\"CHXX0135\">" + "<condition ycode=\"45\" code=\"10\" temp=\"-19\" wind=\"\u897f\u5357\u98ce3\u7ea7\" humidity=\"13\" pm=\"1\"/>" + "<sun rise=\"05:49\" set=\"18:43\"/>" + "<lifedex cloth=\"\u6696\" cold=\"\u8f83\u6613\u53d1\" comfort=\"\u8212\u9002\" uv=\"\u4e2d\u7b49\" cwash=\"\u4e0d\u5b9c\" sport=\"\u8f83\u9002\u5b9c\" insolate=\"\u9002\u5b9c\" umbrella=\"\u4e0d\u5e26\u4f1e\" car=\"3,8\"/>" + "<lifedex2 car=\"\u4e0d\u9650\"/>" + "<warning level=\"\u9ec4\u8272\" type=\"\u66b4\u96e8\" pubdate=\"" + yyyy + "-" + mm + "-" + dd + " 11:00\"/>" + "<forecasts>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + "\" ycode=\"47\" code=\"10\" code2=\"1\" text=\"\u96f7\u9635\u96e8\u8f6c\u591a\u4e91\" low=\"-21\" high=\"-11\" wind=\"\u5fae\u98ce\"/>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + 1 + "\" code=\"0\" code2=\"0\" text=\"\u6674\" low=\"-12\" high=\"-10\" wind=\"\u5fae\u98ce\u8f6c\u5317\u98ce3-4\u7ea7\"/>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + 2 + "\" code=\"0\" code2=\"0\" text=\"\u6674\" low=\"-13\" high=\"-11\" wind=\"\u5fae\u98ce\"/>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + 3 + "\" code=\"0\" code2=\"0\" text=\"\u6674\" low=\"-14\" high=\"-12\" wind=\"\u5fae\u98ce\"/>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + 4 + "\" code=\"0\" code2=\"0\" text=\"\u6674\" low=\"-15\" high=\"-13\" wind=\"\u5317\u98ce4-5\u7ea7\"/>" + "<foreca date=\"" + yyyy + "-" + mm + "-" + dd + 5 + "\" code=\"0\" code2=\"0\" text=\"\u6674\" low=\"-16\" high=\"-14\" wind=\"\u5317\u98ce3-4\u7ea7\u8f6c\u5fae\u98ce\"/>" + "</forecasts>" + "<ginfo use_cache=\"no\" utime=\"" + yyyy + "-" + mm + "-" + dd + " 11:35\"/>" + "</weather>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WeatherInfo getDefaultWeatherInfo() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        if (mWeather == null) {
            String weatherInfoString = WeatherHelper.createWeatherInfoString(year, month + 1, day);
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(weatherInfoString.getBytes("UTF-8"));
                try {
                    mWeather = WeatherHelper.parseWeatherInfo(is, true);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return mWeather;
    }

    public static WeatherInfo parseWeatherInfo(InputStream is, boolean useTimeZone) throws IOException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(is, "utf-8");
            int eventType = xpp.getEventType();
            WeatherInfo wi = new WeatherInfo();
            ArrayList<ForecastWeather> fcal = new ArrayList<ForecastWeather>();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        if (xpp.getName().equals("weather")) {
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("pubdate")) {
                                    String pubdate = attrValue;
                                    wi.setPubdateString(pubdate);
                                    String[] tmp = Utility.split(pubdate, ' ');
                                    String[] tmp1 = Utility.split(tmp[0], '-');
                                    try {
                                        wi.setPubdateYearNum(Integer.parseInt(tmp1[0]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setPubdateMonthNum(Integer.parseInt(tmp1[1]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setPubdateDayNum(Integer.parseInt(tmp1[2]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    tmp1 = Utility.split(tmp[1], ':');
                                    try {
                                        wi.setPubdateHourNum(Integer.parseInt(tmp1[0]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setPubdateMinuteNum(Integer.parseInt(tmp1[1]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    continue;
                                }
                                if (attrName.equals("gmt")) {
                                    String gmt = attrValue;
                                    wi.setGmt(gmt);
                                    String[] tmp = Utility.split(gmt, ' ');
                                    String[] tmp1 = Utility.split(tmp[0], '-');
                                    try {
                                        wi.setGmtYearNum(Integer.parseInt(tmp1[0]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setGmtMonthNum(Integer.parseInt(tmp1[1]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setGmtDayNum(Integer.parseInt(tmp1[2]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    tmp1 = Utility.split(tmp[1], ':');
                                    try {
                                        wi.setGmtHourNum(Integer.parseInt(tmp1[0]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    try {
                                        wi.setGmtMinuteNum(Integer.parseInt(tmp1[1]));
                                    }
                                    catch (NumberFormatException nfe) {
                                        nfe.printStackTrace();
                                    }
                                    continue;
                                }
                                if (attrName.equals("citycode")) {
                                    wi.setCityCode(attrValue);
                                    continue;
                                }
                                if (attrName.equals("location")) {
                                    wi.setLocation(attrValue);
                                    continue;
                                }
                                if (!attrName.equals("valid")) continue;
                                wi.setValid(attrValue.equals("yes"));
                            }
                            break;
                        }
                        if (xpp.getName().equals("condition")) {
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("ycode")) {
                                    wi.getCondition().setYcode(Integer.parseInt(attrValue));
                                    continue;
                                }
                                if (attrName.equals("code")) {
                                    wi.getCondition().setCode(Integer.parseInt(attrValue));
                                    continue;
                                }
                                if (attrName.equals("temp")) {
                                    float temp = -274.0f;
                                    try {
                                        temp = Float.parseFloat(attrValue);
                                    }
                                    catch (NumberFormatException nfe) {
                                        // empty catch block
                                    }
                                    int t = temp > 0.0f ? (int)(temp + 0.5f) : (int)(temp - 0.5f);
                                    wi.getCondition().setTemp(t);
                                    continue;
                                }
                                if (attrName.equals("wind")) {
                                    wi.getCondition().setWind(attrValue);
                                    continue;
                                }
                                if (attrName.equals("humidity")) {
                                    int humidity = 101;
                                    try {
                                        humidity = Integer.parseInt(attrValue);
                                    }
                                    catch (NumberFormatException nfe) {
                                        // empty catch block
                                    }
                                    wi.getCondition().setHumidity(humidity);
                                    continue;
                                }
                                if (!attrName.equals("pm")) continue;
                                int api = 0;
                                try {
                                    api = Integer.parseInt(attrValue);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                                wi.getCondition().setPm(api);
                            }
                            break;
                        }
                        if (xpp.getName().equals("lifedex")) {
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("uv")) {
                                    wi.getLifedex().setUv(attrValue);
                                    continue;
                                }
                                if (attrName.equals("cloth")) {
                                    wi.getLifedex().setCloth(attrValue);
                                    continue;
                                }
                                if (attrName.equals("comfort")) {
                                    wi.getLifedex().setComfort(attrValue);
                                    continue;
                                }
                                if (attrName.equals("cold")) {
                                    wi.getLifedex().setCold(attrValue);
                                    continue;
                                }
                                if (attrName.equals("umbrella")) {
                                    wi.getLifedex().setUmbrella(attrValue);
                                    continue;
                                }
                                if (attrName.equals("insolate")) {
                                    wi.getLifedex().setInsolate(attrValue);
                                    continue;
                                }
                                if (attrName.equals("sport")) {
                                    wi.getLifedex().setSport(attrValue);
                                    continue;
                                }
                                if (attrName.equals("cwash")) {
                                    wi.getLifedex().setCwash(attrValue);
                                    continue;
                                }
                                if (!attrName.equals("car")) continue;
                                wi.getLifedex().setIndexCar(attrValue);
                            }
                        } else if (xpp.getName().equals("warning")) {
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("type")) {
                                    wi.getWarning().setType(attrValue);
                                    continue;
                                }
                                if (attrName.equals("level")) {
                                    wi.getWarning().setLevel(attrValue);
                                    continue;
                                }
                                if (!attrName.equals("pubdate")) continue;
                                wi.getWarning().setPubdate(attrValue);
                            }
                        } else if (xpp.getName().equals("lifedex2")) {
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i).trim();
                                String attrValue = xpp.getAttributeValue(i).trim();
                                if (!attrName.equals("car")) continue;
                                wi.getLifedex().setIndex2Car(attrValue);
                            }
                        } else {
                            if (xpp.getName().equals("foreca") || xpp.getName().equals("night")) {
                                String date = "0000-00-00 00:00";
                                int code = -1;
                                int code2 = -1;
                                String text = "N/A";
                                int low = -274;
                                int high = -274;
                                String wind = "\u4e0a\u4e0b\u98ce";
                                int ycode = 48;
                                int ycode2 = 48;
                                for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                    String attrName = xpp.getAttributeName(i);
                                    String attrValue = xpp.getAttributeValue(i);
                                    if (attrName.equals("date")) {
                                        date = attrValue;
                                        continue;
                                    }
                                    if (attrName.equals("code")) {
                                        code = Integer.parseInt(attrValue);
                                        continue;
                                    }
                                    if (attrName.equals("code2")) {
                                        code2 = Integer.parseInt(attrValue);
                                        continue;
                                    }
                                    if (attrName.equals("ycode")) {
                                        ycode = Integer.parseInt(attrValue);
                                        continue;
                                    }
                                    if (attrName.equals("ycode2")) {
                                        ycode2 = Integer.parseInt(attrValue);
                                        continue;
                                    }
                                    if (attrName.equals("text")) {
                                        text = attrValue;
                                        continue;
                                    }
                                    if (attrName.equals("low")) {
                                        try {
                                            low = Integer.parseInt(attrValue);
                                        }
                                        catch (NumberFormatException nfe) {
                                            nfe.printStackTrace();
                                        }
                                        continue;
                                    }
                                    if (attrName.equals("high")) {
                                        try {
                                            high = Integer.parseInt(attrValue);
                                        }
                                        catch (NumberFormatException nfe) {
                                            nfe.printStackTrace();
                                        }
                                        continue;
                                    }
                                    if (!attrName.equals("wind")) continue;
                                    wind = attrValue;
                                }
                                int fctype = xpp.getName().equals("foreca") ? 0 : 1;
                                ForecastWeather fc = new ForecastWeather(date, code, code2, text, low, high, wind, fctype);
                                if (ycode != 48) {
                                    fc.setYcode(ycode);
                                }
                                if (ycode2 != 48) {
                                    fc.setYcode2(ycode2);
                                }
                                fcal.add(fc);
                                break;
                            }
                            if (!xpp.getName().equals("sun")) break;
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("rise")) {
                                    wi.setSunRise(attrValue);
                                    String[] riseTime = Utility.split(attrValue, ':');
                                    int riseHour = Utility._2CharNum2Int(riseTime[0]);
                                    int riseMinute = Utility._2CharNum2Int(riseTime[1]);
                                    wi.setSunRiseTime(new int[]{riseHour, riseMinute});
                                    continue;
                                }
                                if (!attrName.equals("set")) continue;
                                wi.setSunSet(attrValue);
                                String[] setTime = Utility.split(attrValue, ':');
                                int setHour = Utility._2CharNum2Int(setTime[0]);
                                int setMinute = Utility._2CharNum2Int(setTime[1]);
                                wi.setSunSetTime(new int[]{setHour, setMinute});
                            }
                        }
                        break;
                    }
                }
                eventType = xpp.next();
            }
            ForecastWeather[] forecasts = new ForecastWeather[fcal.size()];
            fcal.toArray(forecasts);
            wi.setForecasts(forecasts);
            if (wi == null || wi.getForecasts().length < 3) {
                return null;
            }
            for (ForecastWeather fc : wi.getForecasts()) {
                boolean dayEqual;
                boolean yearEqual = fc.getDateYearNum() == wi.getPubdateYearNum();
                boolean monthEqual = fc.getDateMonthNum() == wi.getPubdateMonthNum();
                boolean bl = dayEqual = fc.getDateDayNum() == wi.getPubdateDayNum();
                if (!yearEqual || !monthEqual || !dayEqual) continue;
                if (wi.getCondition().getYCode() == 48) {
                    int ycode = fc.getYcode();
                    if (ycode == 48) {
                        ycode = fc.getYcode2();
                    }
                    if (!wi.isDay(wi.getPubdateHourNum(), wi.getPubdateMinuteNum())) {
                        if (ycode == 32) {
                            ycode = 31;
                        } else if (ycode == 28) {
                            ycode = 27;
                        } else if (ycode == 39) {
                            ycode = 9;
                        }
                    }
                    wi.getCondition().setYcode(ycode);
                }
                int[] riseTime = wi.getSunRiseTime();
                int riseHour = riseTime[0];
                int riseMinute = riseTime[1];
                int[] setTime = wi.getSunSetTime();
                int setHour = setTime[0];
                int setMinute = setTime[1];
                int tmpPub = wi.getPubdateHourNum() * 100 + wi.getPubdateMinuteNum();
                int tmpRise = riseHour * 100 + riseMinute;
                int tmpSet = setHour * 100 + setMinute;
                if (tmpPub > tmpSet && tmpPub < 2359) {
                    fc.setType(1);
                    break;
                }
                if (fc.getYcode() == 48) break;
                fc.setType(0);
                break;
            }
            Calendar c = Calendar.getInstance();
            c.set(1, wi.getPubdateYearNum());
            c.set(2, wi.getPubdateMonthNum() - 1);
            c.set(5, wi.getPubdateDayNum());
            c.set(11, wi.getPubdateHourNum());
            c.set(12, wi.getPubdateMinuteNum());
            wi.setPubdateTimeMillis(c.getTimeInMillis());
            c.set(1, wi.getGmtYearNum());
            c.set(2, wi.getGmtMonthNum() - 1);
            c.set(5, wi.getGmtDayNum());
            c.set(11, wi.getGmtHourNum());
            c.set(12, wi.getGmtMinuteNum());
            long gmtTimeMillis = c.getTimeInMillis();
            wi.setGmt2locOffset((int)((wi.getPubdateTimeMillis() - gmtTimeMillis) / 3600000L));
            wi.setCorrectByTimeZone(useTimeZone);
            return wi;
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getDayYcode(int ycode) {
        switch (ycode) {
            case 27: {
                ycode = 28;
                break;
            }
            case 29: {
                ycode = 30;
                break;
            }
            case 31: 
            case 33: {
                ycode = 32;
            }
        }
        return ycode;
    }

    public static int getNightYcode(int ycode) {
        switch (ycode) {
            case 28: {
                ycode = 27;
                break;
            }
            case 30: {
                ycode = 29;
                break;
            }
            case 32: 
            case 34: {
                ycode = 31;
            }
        }
        return ycode;
    }
}

