/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin.weather;

import sina.mobile.skin.Utility;

public class ForecastWeather {
    private int _code = -1;
    private int _code2 = -1;
    private int _ycode = 48;
    private int _ycode2 = 48;
    private String _text = "N/A";
    private int _low = -274;
    private int _high = -274;
    private String _wind = "\u4e0a\u4e0b\u98ce";
    private int _type = 0;
    private int _dateYearNum = -1;
    private int _dateMonthNum = -1;
    private int _dateDayNum = -1;
    private String _text0 = "N/A";
    private String _text1 = "N/A";
    private String _wind0 = "\u4e0a\u4e0b\u98ce";
    private String _wind1 = "\u4e0a\u4e0b\u98ce";
    public static final int TYPE_ALL_DAY = 0;
    public static final int TYPE_NIGHT = 1;
    public static final ForecastWeather EMPTY = new ForecastWeather();
    public static final int[] code2YcodeMap = new int[32];
    private static final int[] YCODES_LEVEL;

    private ForecastWeather() {
    }

    public ForecastWeather(String date, int code, int code2, String text, int low, int high, String wind, int type) {
        String[] tmp;
        if (date != null && date.trim().length() != 0) {
            tmp = Utility.split(date, '-');
            try {
                this._dateYearNum = Integer.parseInt(tmp[0]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                this._dateMonthNum = Integer.parseInt(tmp[1]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            try {
                this._dateDayNum = Integer.parseInt(tmp[2]);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this._code = code;
        this._code2 = code2;
        if (this._code != -1) {
            this._ycode = code2YcodeMap[this._code];
        }
        if (this._code2 != -1) {
            this._ycode2 = code2YcodeMap[this._code2];
            if (this._ycode2 == 32) {
                this._ycode2 = 31;
            } else if (this._ycode2 == 28) {
                this._ycode2 = 27;
            } else if (this._ycode2 == 39) {
                this._ycode2 = 9;
            }
        }
        if (text != null && text.trim().length() != 0 && !text.equals("N/A")) {
            this._text = text;
            tmp = Utility.split(text, '\u8f6c');
            this._text0 = tmp[0];
            this._text1 = tmp.length == 2 ? tmp[1] : tmp[0];
        } else {
            this._text = "N/A";
            this._text0 = "N/A";
            this._text1 = "N/A";
        }
        if (this._code == 0 && this._text0.equals("\u5c11\u4e91")) {
            this._ycode = 30;
        }
        if (this._code2 == 0 && this._text0.equals("\u5c11\u4e91")) {
            this._ycode2 = 29;
        }
        this._low = low;
        this._high = high;
        if (wind != null && wind.length() != 0 && !wind.equals("\u4e0a\u4e0b\u98ce")) {
            this._wind = wind;
            tmp = Utility.split(wind, '\u8f6c');
            this._wind0 = tmp[0];
            this._wind1 = tmp.length == 2 ? tmp[1] : tmp[0];
        } else {
            this._wind0 = "\u4e0a\u4e0b\u98ce";
            this._wind1 = "\u4e0a\u4e0b\u98ce";
            this._wind = "\u4e0a\u4e0b\u98ce";
        }
        this._type = type;
    }

    public int getHighPriorityLvYcode() {
        int dayLevel = YCODES_LEVEL[this._ycode];
        int nightLevel = YCODES_LEVEL[this._ycode2];
        int r = 48;
        r = dayLevel > nightLevel ? this._ycode : this._ycode2;
        return r;
    }

    public int getDayOrNightYcode(boolean isDay) {
        if (isDay) {
            return this.getYcode();
        }
        return this.getYcode2();
    }

    public void setCode(int _code) {
        this._code = _code;
    }

    public void setCode2(int _code2) {
        this._code2 = _code2;
    }

    public void setDateDayNum(int _dateDayNum) {
        this._dateDayNum = _dateDayNum;
    }

    public void setDateMonthNum(int _dateMonthNum) {
        this._dateMonthNum = _dateMonthNum;
    }

    public void setDateYearNum(int _dateYearNum) {
        this._dateYearNum = _dateYearNum;
    }

    public void setHigh(int _high) {
        this._high = _high;
    }

    public void setLow(int _low) {
        this._low = _low;
    }

    public void setText(String _text) {
        this._text = _text;
    }

    public void setText0(String _text0) {
        this._text0 = _text0;
    }

    public void setText1(String _text1) {
        this._text1 = _text1;
    }

    public void setType(int _type) {
        this._type = _type;
    }

    public void setWind(String _wind) {
        this._wind = _wind;
    }

    public void setWind0(String _wind0) {
        this._wind0 = _wind0;
    }

    public void setWind1(String _wind1) {
        this._wind1 = _wind1;
    }

    public void setYcode(int _ycode) {
        this._ycode = _ycode;
    }

    public void setYcode2(int _ycode2) {
        this._ycode2 = _ycode2;
    }

    public String getText0() {
        return this._text0;
    }

    public String getText1() {
        return this._text1;
    }

    public String getWind0() {
        return this._wind0;
    }

    public String getWind1() {
        return this._wind1;
    }

    public int getType() {
        return this._type;
    }

    public int getDateYearNum() {
        return this._dateYearNum;
    }

    public int getDateMonthNum() {
        return this._dateMonthNum;
    }

    public int getDateDayNum() {
        return this._dateDayNum;
    }

    public int getCode() {
        return this._code;
    }

    public int getCode2() {
        return this._code2;
    }

    public int getYcode() {
        return this._ycode;
    }

    public int getYcode2() {
        return this._ycode2;
    }

    public String getText() {
        return this._text;
    }

    public String getDayText() {
        return this._text0;
    }

    public String getNightText() {
        return this._text1;
    }

    public int getLow() {
        return this._low;
    }

    public int getHigh() {
        return this._high;
    }

    public String getWind() {
        return this._wind;
    }

    public String getDayWind() {
        return this._wind0;
    }

    public String getNightWind() {
        return this._wind1;
    }

    static {
        ForecastWeather.code2YcodeMap[0] = 32;
        ForecastWeather.code2YcodeMap[1] = 28;
        ForecastWeather.code2YcodeMap[2] = 26;
        ForecastWeather.code2YcodeMap[3] = 39;
        ForecastWeather.code2YcodeMap[4] = 45;
        ForecastWeather.code2YcodeMap[5] = 45;
        ForecastWeather.code2YcodeMap[6] = 5;
        ForecastWeather.code2YcodeMap[7] = 9;
        ForecastWeather.code2YcodeMap[8] = 12;
        ForecastWeather.code2YcodeMap[9] = 12;
        ForecastWeather.code2YcodeMap[10] = 12;
        ForecastWeather.code2YcodeMap[11] = 12;
        ForecastWeather.code2YcodeMap[12] = 12;
        ForecastWeather.code2YcodeMap[13] = 13;
        ForecastWeather.code2YcodeMap[14] = 14;
        ForecastWeather.code2YcodeMap[15] = 16;
        ForecastWeather.code2YcodeMap[16] = 16;
        ForecastWeather.code2YcodeMap[17] = 16;
        ForecastWeather.code2YcodeMap[18] = 20;
        ForecastWeather.code2YcodeMap[19] = 10;
        ForecastWeather.code2YcodeMap[20] = 19;
        ForecastWeather.code2YcodeMap[21] = 9;
        ForecastWeather.code2YcodeMap[22] = 12;
        ForecastWeather.code2YcodeMap[23] = 12;
        ForecastWeather.code2YcodeMap[24] = 12;
        ForecastWeather.code2YcodeMap[25] = 12;
        ForecastWeather.code2YcodeMap[26] = 14;
        ForecastWeather.code2YcodeMap[27] = 16;
        ForecastWeather.code2YcodeMap[28] = 16;
        ForecastWeather.code2YcodeMap[29] = 19;
        ForecastWeather.code2YcodeMap[30] = 19;
        ForecastWeather.code2YcodeMap[31] = 19;
        YCODES_LEVEL = new int[]{18, 18, 18, 18, 17, 14, 14, 14, 13, 13, 13, 13, 16, 13, 13, 13, 16, 15, 14, 8, 8, 9, 9, 7, 7, 6, 6, 5, 5, 4, 4, 2, 2, 2, 2, 15, 3, 12, 12, 11, 10, 17, 10, 17, 4, 16, 11, 12, 1, 1};
    }
}

