/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin.weather;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import sina.mobile.skin.weather.AirPollutionConcentration;
import sina.mobile.skin.weather.AirPollutionIndex;
import sina.mobile.skin.weather.AirPollutionInfo;
import sina.mobile.skin.weather.TmpPm25;

public class AirPiInfoHelper {
    private static AirPollutionInfo mAirPi = null;

    private static String createAirPiInfoString(int year, int month, int day) {
        String yyyy = "" + year;
        String mm = "" + month;
        if (month < 10) {
            mm = "0" + mm;
        }
        String dd = "" + day;
        if (day < 10) {
            dd = "0" + dd;
        }
        return "<response result=\"success\"><tmppm25 v=\"60\" h=\"14\" m=\"00\" ms=\"\u8f66\u516c\u5e84\u89c2\u6d4b\u7ad9\" lv=\"\u826f\"/><api value=\"78\" critical_pollutants=\"\u53ef\u5438\u5165\u9897\u7c92\u7269\" level=\"2\" description=\"\u826f\" brief=\"\u826f\" time=\"2012-07-17 00:00:00\" source=\"\u4e2d\u56fd\u73af\u76d1\u603b\u7ad9\"/><apc time=\"" + yyyy + "-" + mm + "-" + dd + " 12:00:00\" pm10=\"126\" so2=\"20\" no2=\"31\" pm25=\"60\"/>" + "</response>";
    }

    public static AirPollutionInfo getDefaultAirPiInfo() throws IOException {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        if (mAirPi == null) {
            String airPiInfoString = AirPiInfoHelper.createAirPiInfoString(year, month + 1, day);
            ByteArrayInputStream is = new ByteArrayInputStream(airPiInfoString.getBytes("UTF-8"));
            mAirPi = AirPiInfoHelper.parseAirPiInfo(is);
        }
        return mAirPi;
    }

    private static AirPollutionInfo parseAirPiInfo(InputStream is) throws IOException {
        AirPollutionInfo airPiInfo = new AirPollutionInfo();
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(is, null);
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        String attrValue;
                        if (xpp.getName().equals("response")) {
                            String result = null;
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                String attrValue2 = xpp.getAttributeValue(i);
                                if (!attrName.equals("result")) continue;
                                result = attrValue2;
                            }
                            if (result != null && !result.equals("error")) break;
                            return null;
                        }
                        if (xpp.getName().equals("tmppm25")) {
                            airPiInfo.mTmpPm25 = new TmpPm25();
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("v")) {
                                    airPiInfo.mTmpPm25.mValue = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("m")) {
                                    airPiInfo.mTmpPm25.mMinute = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("h")) {
                                    airPiInfo.mTmpPm25.mHour = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("ms")) {
                                    airPiInfo.mTmpPm25.mMonitoringStation = attrValue;
                                    continue;
                                }
                                if (!attrName.equals("lv")) continue;
                                airPiInfo.mTmpPm25.mLevel = attrValue;
                            }
                            break;
                        }
                        if (xpp.getName().equals("apc")) {
                            airPiInfo.mApc = new AirPollutionConcentration();
                            for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                                String attrName = xpp.getAttributeName(i);
                                attrValue = xpp.getAttributeValue(i);
                                if (attrName.equals("pm10")) {
                                    airPiInfo.mApc.mPm10 = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("pm25")) {
                                    airPiInfo.mApc.mPm25 = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("so2")) {
                                    airPiInfo.mApc.mSo2 = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (attrName.equals("no2")) {
                                    airPiInfo.mApc.mNo2 = Integer.parseInt(attrValue);
                                    continue;
                                }
                                if (!attrName.equals("time")) continue;
                                airPiInfo.mApc.mTime = attrValue;
                            }
                            break;
                        }
                        if (!xpp.getName().equals("api")) break;
                        airPiInfo.mApi = new AirPollutionIndex();
                        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                            String attrName = xpp.getAttributeName(i);
                            attrValue = xpp.getAttributeValue(i);
                            if (attrName.equals("value")) {
                                airPiInfo.mApi.mValue = Integer.parseInt(attrValue);
                                continue;
                            }
                            if (attrName.equals("time")) {
                                airPiInfo.mApi.mTime = attrValue;
                                continue;
                            }
                            if (attrName.equals("source")) {
                                airPiInfo.mApi.mSource = attrValue;
                                continue;
                            }
                            if (attrName.equals("critical_pollutants")) {
                                airPiInfo.mApi.mPrimaryAirPollutionSubject = attrValue;
                                continue;
                            }
                            if (attrName.equals("level")) {
                                airPiInfo.mApi.mLevel = Integer.parseInt(attrValue);
                                continue;
                            }
                            if (attrName.equals("description")) {
                                airPiInfo.mApi.mQulity = attrValue;
                                continue;
                            }
                            if (!attrName.equals("brief")) continue;
                            airPiInfo.mApi.mBrief = attrValue;
                        }
                        airPiInfo.mApi.mDetail = xpp.getText();
                    }
                }
                eventType = xpp.next();
            }
            return airPiInfo;
        }
        catch (XmlPullParserException e) {
            return null;
        }
    }
}

