/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.util.ArrayList;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinColor;
import sina.mobile.skin.SkinFont;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinPaint;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;
import sina.mobile.skin.SkinText;
import sina.mobile.skin.Utility;
import sina.mobile.skin.weather.WeatherInfo;

public class SkinTextArea
extends SkinLayoutModel {
    private String Text = null;
    private int TextColor = -16777216;
    private int TextSize = 0;
    private int LineGap = 0;
    private String Suffix = "...";
    private int w = Integer.MIN_VALUE;
    private int h = Integer.MIN_VALUE;
    private ArrayList<String> mLines = new ArrayList();
    private int mRealWidth = 0;
    private int mRealHeight = 0;
    private boolean HasShadow = false;
    private int ShadowColor = -2013265920;
    private int ShadowPosX = 3;
    private int ShadowPosY = 3;
    private String OffsetTime = null;
    private boolean mOffsetTimeAvailable = false;
    private String mTempFunctionId;
    private String mTempText;
    private String mTempOffsetTime;

    public SkinTextArea clone() throws CloneNotSupportedException {
        SkinTextArea clone = (SkinTextArea)super.clone();
        return clone;
    }

    public boolean isHasShadow() {
        return this.HasShadow;
    }

    public void setHasShadow(boolean HasShadow) {
        this.HasShadow = HasShadow;
    }

    public int getShadowColor() {
        return this.ShadowColor;
    }

    public void setShadowColor(int ShadowColor) {
        this.ShadowColor = ShadowColor;
    }

    public int getShadowPosX() {
        return this.ShadowPosX;
    }

    public void setShadowPosX(int ShadowPosX) {
        this.ShadowPosX = ShadowPosX;
    }

    public int getShadowPosY() {
        return this.ShadowPosY;
    }

    public void setShadowPosY(int ShadowPosY) {
        this.ShadowPosY = ShadowPosY;
    }

    public void setLineGap(int LineGap) {
        this.LineGap = LineGap;
    }

    public void setSuffix(String Suffix) {
        this.Suffix = Suffix;
    }

    public void setText(String Text) {
        this.Text = Text;
    }

    public void setTextColor(int TextColor) {
        this.TextColor = TextColor;
    }

    public void setTextSize(int TextSize) {
        this.TextSize = TextSize;
    }

    public void setH(int h) {
        this.h = h;
    }

    public void setW(int w) {
        this.w = w;
    }

    public String getSuffix() {
        return this.Suffix;
    }

    public int getLineGap() {
        return this.LineGap;
    }

    public String getText() {
        return this.Text;
    }

    public int getTextColor() {
        return this.TextColor;
    }

    public int getTextSize() {
        return this.TextSize;
    }

    public int getH() {
        return this.h;
    }

    public int getW() {
        return this.w;
    }

    public String getOffsetTime() {
        return this.OffsetTime;
    }

    public void setOffsetTime(String offsetTime) {
        this.OffsetTime = offsetTime;
        StringBuilder allTextSb = new StringBuilder();
        StringBuilder functionId = new StringBuilder();
        boolean isFunctionId = false;
        for (int i = 0; i < this.Text.length(); ++i) {
            char c = this.Text.charAt(i);
            if (isFunctionId) {
                if (c != '}') {
                    functionId.append(c);
                    continue;
                }
                isFunctionId = false;
                String[] tmp = Utility.split(functionId.toString(), ':');
                String functionid = tmp[0];
                for (String f : SkinText.G_FORECAST_FUNCTIONIDS) {
                    if (!functionid.equals(f)) continue;
                    this.mOffsetTimeAvailable = true;
                }
                allTextSb.append(functionid);
                int offsetDay = 0;
                int daySign = 1;
                if (this.OffsetTime != null) {
                    if (this.OffsetTime.startsWith("-")) {
                        daySign = -1;
                        this.OffsetTime = this.OffsetTime.substring(1);
                    } else if (this.OffsetTime.startsWith("+")) {
                        daySign = 1;
                        this.OffsetTime = this.OffsetTime.substring(1);
                    } else {
                        daySign = 1;
                        this.OffsetTime = this.OffsetTime.substring(0);
                    }
                    if (this.OffsetTime.endsWith("d")) {
                        offsetDay = daySign * Integer.parseInt(this.OffsetTime.substring(0, this.OffsetTime.length() - 1));
                    }
                    allTextSb.append(":").append(offsetDay).append("d");
                }
                functionId = new StringBuilder();
                allTextSb.append(c);
                continue;
            }
            if (c == '{') {
                isFunctionId = true;
                allTextSb.append(c);
                continue;
            }
            allTextSb.append(c);
        }
        this.Text = allTextSb.toString();
    }

    public boolean isOffsetTimeAvailable() {
        return this.mOffsetTimeAvailable;
    }

    public SkinTextArea(Skin skin) {
        super(skin);
    }

    protected SkinRect measureDrawRect() {
        return new SkinRect(0, 0, this.mRealWidth, this.mRealHeight);
    }

    protected void setWeatherInfo(WeatherInfo wi) {
        int width1;
        this.mLines.clear();
        if (this.Text == null || this.Text.length() == 0) {
            this.mRealWidth = this.w != Integer.MIN_VALUE ? this.w : 0;
            this.mRealHeight = this.h != Integer.MIN_VALUE ? this.h : 0;
            return;
        }
        String allText = "";
        StringBuilder allTextSb = new StringBuilder();
        StringBuilder functionId = new StringBuilder();
        boolean isFunctionId = false;
        for (int i = 0; i < this.Text.length(); ++i) {
            char c = this.Text.charAt(i);
            if (isFunctionId) {
                if (c != '}') {
                    functionId.append(c);
                    continue;
                }
                isFunctionId = false;
                String[] tmp = Utility.split(functionId.toString(), ':');
                String functionid = tmp[0];
                for (String f : SkinText.G_FORECAST_FUNCTIONIDS) {
                    if (!functionid.equals(f)) continue;
                    this.mOffsetTimeAvailable = true;
                }
                String offsetTime = null;
                if (tmp.length > 1) {
                    this.OffsetTime = offsetTime = tmp[1];
                }
                String text = SkinText.getTextByFunctionIdAndTimeOffset(wi, functionid, offsetTime);
                allTextSb.append(text);
                functionId = new StringBuilder();
                continue;
            }
            if (c == '{') {
                isFunctionId = true;
                continue;
            }
            allTextSb.append(c);
        }
        allText = allTextSb.toString();
        int lineHeight = this.TextSize + this.LineGap;
        SkinFont font = new SkinFont();
        font.setTextSize(this.TextSize);
        if (this.w != Integer.MIN_VALUE) {
            this.mRealWidth = this.w;
            char c = allText.charAt(0);
            int width = font.stringWidth(c + "");
            if (this.w <= width) {
                this.mRealHeight = this.h != Integer.MIN_VALUE ? this.h : 0;
                return;
            }
        }
        if (this.h != Integer.MIN_VALUE) {
            this.mRealHeight = this.h;
            if (this.h <= lineHeight) {
                this.mRealWidth = this.w != Integer.MIN_VALUE ? this.w : 0;
                return;
            }
        }
        if (this.w != Integer.MIN_VALUE) {
            this.mRealWidth = this.w;
            if (this.h != Integer.MIN_VALUE) {
                this.mRealHeight = this.h;
                StringBuilder currentLineSb = new StringBuilder();
                ArrayList<String> linesList = new ArrayList<String>();
                int countHeight = lineHeight;
                for (int i = 0; i < allText.length(); ++i) {
                    char currentChar = allText.charAt(i);
                    int width12 = font.stringWidth(currentChar + "");
                    int width2 = font.stringWidth(currentLineSb.toString());
                    int currentCharWidth = width12;
                    int currentLineWidth = width2;
                    if ((currentLineWidth += currentCharWidth) >= this.w) {
                        if (countHeight + lineHeight >= this.h) {
                            CharSequence sub = currentLineSb.subSequence(0, currentLineSb.length() - 1);
                            currentLineSb = new StringBuilder();
                            currentLineSb.append(sub);
                            currentLineSb.append(this.Suffix);
                            linesList.add(currentLineSb.toString());
                            currentLineSb = new StringBuilder();
                            break;
                        }
                        linesList.add(currentLineSb.toString());
                        currentLineSb = new StringBuilder();
                        countHeight += lineHeight;
                        currentLineSb.append(currentChar);
                        continue;
                    }
                    currentLineSb.append(currentChar);
                }
                if (currentLineSb.length() != 0) {
                    linesList.add(currentLineSb.toString());
                    countHeight += lineHeight;
                }
                this.mLines.addAll(linesList);
            } else {
                StringBuilder currentLineSb = new StringBuilder();
                ArrayList<String> linesList = new ArrayList<String>();
                this.mRealHeight = lineHeight;
                for (int i = 0; i < allText.length(); ++i) {
                    char currentChar = allText.charAt(i);
                    int width13 = font.stringWidth(currentChar + "");
                    int width2 = font.stringWidth(currentLineSb.toString());
                    int currentCharWidth = width13;
                    int currentLineWidth = width2;
                    if ((currentLineWidth += currentCharWidth) >= this.w) {
                        linesList.add(currentLineSb.toString());
                        currentLineSb = new StringBuilder();
                        this.mRealHeight += lineHeight;
                    }
                    currentLineSb.append(currentChar);
                }
                linesList.add(currentLineSb.toString());
                this.mRealHeight += lineHeight;
                this.mLines.addAll(linesList);
            }
        } else if (this.h != Integer.MIN_VALUE) {
            this.mRealHeight = this.h;
            if (this.h < lineHeight) {
                this.mRealWidth = 0;
            } else {
                this.mRealWidth = width1 = font.stringWidth(allText.toString());
                this.mLines.add(allText);
            }
        } else {
            this.mRealHeight = lineHeight;
            this.mRealWidth = width1 = font.stringWidth(allText.toString());
            this.mLines.add(allText);
        }
    }

    protected boolean setValue(String attrName, String attrValue) {
        if (attrName.equals("Text")) {
            this.mTempText = attrValue;
            this.refreshText();
        } else if (attrName.equals("FunctionId")) {
            this.mTempFunctionId = attrValue;
            this.refreshText();
        } else if (attrName.equals("TextColor")) {
            String intu = attrValue.substring(0, 4);
            String intl = attrValue.substring(4);
            int int0 = Integer.parseInt(intu.toUpperCase(), 16);
            int int1 = Integer.parseInt(intl.toUpperCase(), 16);
            this.TextColor = int0 << 16 | int1;
        } else if (attrName.equals("TextSize")) {
            this.TextSize = SkinHelper.px(attrValue);
        } else if (attrName.equals("HasShadow")) {
            this.HasShadow = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("Shadow_color")) {
            String intu = attrValue.substring(0, 4);
            String intl = attrValue.substring(4);
            int int0 = Integer.parseInt(intu.toUpperCase(), 16);
            int int1 = Integer.parseInt(intl.toUpperCase(), 16);
            this.ShadowColor = int0 << 16 | int1;
        } else if (attrName.equals("Shadow_pos_x")) {
            this.ShadowPosX = SkinHelper.px(attrValue);
        } else if (attrName.equals("Shadow_pos_y")) {
            this.ShadowPosY = SkinHelper.px(attrValue);
        } else if (attrName.equals("LineGap")) {
            this.LineGap = SkinHelper.px(attrValue);
        } else if (attrName.equals("w")) {
            this.w = SkinHelper.px(attrValue);
        } else if (attrName.equals("h")) {
            this.h = SkinHelper.px(attrValue);
        } else if (attrName.equals("Suffix")) {
            this.Suffix = attrValue;
        } else if (attrName.equals("OffsetTime")) {
            this.mTempOffsetTime = attrValue;
            this.refreshText();
        } else if (!super.setValue(attrName, attrValue)) {
            return false;
        }
        return true;
    }

    private void refreshText() {
        if (this.mTempText != null) {
            this.Text = this.mTempText;
        } else if (this.mTempFunctionId != null) {
            this.Text = this.mTempOffsetTime != null ? "{" + this.mTempFunctionId + ":" + this.mTempOffsetTime + "}" : "{" + this.mTempFunctionId + "}";
        }
    }

    protected void draw(SkinRender c) {
        int ty;
        SkinPaint paint;
        if (this.HasShadow) {
            paint = new SkinPaint();
            paint.setColor(new SkinColor(this.ShadowColor));
            paint.setFont(new SkinFont(this.TextSize));
            ty = this.mDrawRect.top + this.TextSize + this.LineGap + this.ShadowPosY;
            for (String line : this.mLines) {
                c.drawSkinText(line, this.mDrawRect.left + this.ShadowPosX, ty, paint);
                ty += this.TextSize + this.LineGap;
            }
        }
        paint = new SkinPaint();
        paint.setColor(new SkinColor(this.TextColor));
        paint.setFont(new SkinFont(this.TextSize));
        ty = this.mDrawRect.top + this.TextSize + this.LineGap;
        for (String line : this.mLines) {
            c.drawSkinText(line, this.mDrawRect.left, ty, paint);
            ty += this.TextSize + this.LineGap;
        }
    }

    public void recycle() {
        this.Text = null;
        this.mLines.clear();
        this.OffsetTime = null;
        this.mTempFunctionId = null;
        this.mTempText = null;
        this.mTempOffsetTime = null;
    }
}

