/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.util.Calendar;
import sina.mobile.skin.Lunar;
import sina.mobile.skin.LunarHelper;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinColor;
import sina.mobile.skin.SkinFont;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinPaint;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;
import sina.mobile.skin.weather.AirPollutionConcentration;
import sina.mobile.skin.weather.AirPollutionIndex;
import sina.mobile.skin.weather.ForecastWeather;
import sina.mobile.skin.weather.WeatherInfo;

public class SkinText
extends SkinLayoutModel {
    protected String Text = null;
    protected int TextColor = -16777216;
    protected int TextSize = 0;
    protected boolean HasShadow = false;
    protected int ShadowColor = -2013265920;
    protected int ShadowPosX = 3;
    protected int ShadowPosY = 3;
    private String OffsetTime = null;
    private String mText = null;
    private static final String[] days_of_week = new String[]{"\u661f\u671f\u5929", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
    private static final String[] days_of_week_simple = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
    private static final String[] brief_days_of_week = new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"};
    private static final String[] days_of_week_en = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] brief_days_of_week_en = new String[]{"Sun.", "Mon.", "Tue.", "Wed.", "Thur.", "Fri.", "Sat."};
    private static final String[] month_of_year_en = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] brief_month_of_year_en = new String[]{"Jan.", "Feb.", "Mar.", "Apr.", "May.", "Jun.", "Jul.", "Aug.", "Sep.", "Oct.", "Nov.", "Dec."};
    public static final String[] G_FORECAST_FUNCTIONIDS = new String[]{"day_weather", "night_weather", "f_weather", "hltemperature", "htemperature", "ltemperature", "yyyy", "yy", "mm", "m", "mm0_en", "mm1_en", "dd", "d", "d0_en", "d1_en", "w0", "w1", "w2", "w0_en", "w1_en"};

    public SkinText clone() throws CloneNotSupportedException {
        SkinText clone = (SkinText)super.clone();
        return clone;
    }

    public boolean offsetTimeAvailable() {
        if (this.FunctionId == null) {
            return false;
        }
        for (String f : G_FORECAST_FUNCTIONIDS) {
            if (!this.FunctionId.equals(f)) continue;
            return true;
        }
        return false;
    }

    public String getOffsetTime() {
        return this.OffsetTime;
    }

    public void setOffsetTime(String OffsetTime) {
        this.OffsetTime = OffsetTime;
    }

    public boolean isHasShadow() {
        return this.HasShadow;
    }

    public void setHasShadow(boolean HasShadow) {
        this.HasShadow = HasShadow;
    }

    public int getTextColor() {
        return this.TextColor;
    }

    public void setTextColor(int TextColor) {
        this.TextColor = TextColor;
    }

    public int getTextSize() {
        return this.TextSize;
    }

    public void setTextSize(int TextSize) {
        this.TextSize = TextSize;
    }

    public SkinText(Skin skin) {
        super(skin);
    }

    public SkinText() {
    }

    public void setText(String Text) {
        this.Text = Text;
    }

    public String getText() {
        return this.Text;
    }

    public int getShadowColor() {
        return this.ShadowColor;
    }

    public void setShadowColor(int ShadowColor) {
        this.ShadowColor = ShadowColor;
    }

    public int getShadowPosX() {
        return this.ShadowPosX;
    }

    public void setShadowPosX(int ShadowPosX) {
        this.ShadowPosX = ShadowPosX;
    }

    public int getShadowPosY() {
        return this.ShadowPosY;
    }

    public void setShadowPosY(int ShadowPosY) {
        this.ShadowPosY = ShadowPosY;
    }

    public static String getTextByFunctionIdAndTimeOffset(WeatherInfo wi, String FunctionId, String OffsetTime) {
        String mText = null;
        int offsetDay = 0;
        int daySign = 1;
        if (OffsetTime != null) {
            if (OffsetTime.startsWith("-")) {
                daySign = -1;
                OffsetTime = OffsetTime.substring(1);
            } else if (OffsetTime.startsWith("+")) {
                daySign = 1;
                OffsetTime = OffsetTime.substring(1);
            } else {
                daySign = 1;
                OffsetTime = OffsetTime.substring(0);
            }
            if (OffsetTime.endsWith("d")) {
                offsetDay = daySign * Integer.parseInt(OffsetTime.substring(0, OffsetTime.length() - 1));
            }
        }
        if (FunctionId.equals("city_name")) {
            String cityName = wi.getLocation();
            int idx = wi.getLocation().indexOf(46);
            mText = idx != -1 ? cityName.substring(idx + 1, cityName.length()) : cityName;
            return mText;
        }
        if (FunctionId.equals("city_name1")) {
            mText = "jingdezhen";
            return mText;
        }
        if (FunctionId.equals("c_weather")) {
            int ycode = wi.getYCodeUsingSunRiseAndSet();
            mText = WeatherInfo.getWeatherStrFromYahooCode(ycode);
        } else if (FunctionId.equals("c_weather0_en")) {
            int ycode = wi.getYCodeUsingSunRiseAndSet();
            mText = WeatherInfo.getWeatherStrEn0FromYahooCode(ycode);
        } else if (FunctionId.equals("c_weather1_en")) {
            int ycode = wi.getYCodeUsingSunRiseAndSet();
            mText = WeatherInfo.getWeatherStrEn1FromYahooCode(ycode);
        } else if (FunctionId.equals("wind")) {
            mText = wi.getCondition().getWind();
            if (mText.equals("\u4e0a\u4e0b\u98ce")) {
                mText = "";
            }
        } else if (FunctionId.equals("temperature")) {
            int temp = wi.getCondition().getTemperature();
            mText = (float)temp == -274.0f ? "" : temp + "";
        } else if (FunctionId.equals("humidity")) {
            int humidity = wi.getCondition().getHumidity();
            mText = humidity == 101 ? "" : humidity + "";
        } else if (FunctionId.equals("uv")) {
            mText = wi.getLifedex().getUv();
        } else if (FunctionId.equals("cwash")) {
            mText = wi.getLifedex().getCwash();
        } else if (FunctionId.equals("cold")) {
            mText = wi.getLifedex().getCold();
        } else if (FunctionId.equals("comfort")) {
            mText = wi.getLifedex().getComfort();
        } else if (FunctionId.equals("cloth")) {
            mText = wi.getLifedex().getCloth();
        } else if (FunctionId.equals("umbrella")) {
            mText = wi.getLifedex().getUmbrella();
        } else if (FunctionId.equals("insolate")) {
            mText = wi.getLifedex().getInsolate();
        } else if (FunctionId.equals("sport")) {
            mText = wi.getLifedex().getSport();
        } else if (FunctionId.equals("sun_rise")) {
            mText = wi.getSunRiseStrForLocal();
        } else if (FunctionId.equals("sun_set")) {
            mText = wi.getSunSetStrForLocal();
        } else if (FunctionId.equals("car")) {
            int[] carArray = wi.getLifedex().getIndexCarNums();
            if (carArray.length > 0 && carArray[0] != -1) {
                mText = "\u4eca\u5929" + SkinText.forMatCarNum(carArray[0]);
                if (carArray[1] != -1 && -2 != carArray[1]) {
                    mText = mText + "," + carArray[1];
                }
            } else {
                mText = "\u672a\u77e5";
            }
        } else if (FunctionId.equals("pub_time")) {
            mText = wi.getPubdate();
        } else if (FunctionId.equals("pub_time_brief")) {
            mText = wi.getBriefPubdate();
        } else if (FunctionId.equals("warn") && (mText = wi.getWarning().getWarningLevel() + wi.getWarning().getWarningType()).equals("")) {
            mText = "\u65e0\u9884\u8b66\u4fe1\u606f";
        }
        if (mText != null) {
            return mText;
        }
        AirPollutionIndex api = wi.getAirPiInfo().getAirPollutionIndex();
        AirPollutionConcentration apc = wi.getAirPiInfo().getAirPollutionConcentration();
        if (FunctionId.equals("Api_value")) {
            mText = api != null ? String.valueOf(api.getValue()) : "N/A";
        } else if (FunctionId.equals("Api_qulity")) {
            mText = api != null ? api.getmQulity() : "N/A";
        } else if (FunctionId.equals("Api_time")) {
            mText = api != null ? api.getTime() : "N/A";
        } else if (FunctionId.equals("Api_source")) {
            mText = api != null ? api.getSource() : "N/A";
        } else if (FunctionId.equals("PM_25")) {
            mText = api != null ? apc.getPm25() + "\u03bcg/m\u00b3" : "N/A";
        } else if (FunctionId.equals("PM_10")) {
            mText = api != null ? apc.getPm10() + "\u03bcg/m\u00b3" : "N/A";
        } else if (FunctionId.equals("NO_2")) {
            mText = api != null ? apc.getNo2() + "\u03bcg/m\u00b3" : "N/A";
        } else if (FunctionId.equals("SO_2")) {
            mText = api != null ? apc.getSo2() + "\u03bcg/m\u00b3" : "N/A";
        }
        if (mText != null) {
            return mText;
        }
        ForecastWeather careForecast = null;
        ForecastWeather careTomorrowForecast = null;
        ForecastWeather[] fcs = wi.getForecastsForCurrent(5);
        careForecast = fcs[offsetDay];
        if (careForecast == ForecastWeather.EMPTY) {
            careForecast = null;
        }
        if (offsetDay + 1 >= fcs.length) {
            careTomorrowForecast = null;
        } else {
            careTomorrowForecast = fcs[offsetDay + 1];
            if (careTomorrowForecast == ForecastWeather.EMPTY) {
                careTomorrowForecast = null;
            }
        }
        if (FunctionId.equals("day_weather")) {
            if (careForecast != null) {
                int ycode = careForecast.getYcode();
                mText = WeatherInfo.getWeatherStrFromYahooCode(ycode);
            } else {
                mText = "";
            }
        } else if (FunctionId.equals("night_weather")) {
            if (careForecast != null) {
                int ycode = careForecast.getYcode2();
                mText = WeatherInfo.getWeatherStrFromYahooCode(ycode);
            } else {
                mText = "";
            }
        } else if (FunctionId.equals("f_weather")) {
            mText = careForecast != null ? careForecast.getText() : "";
        } else if (FunctionId.equals("hltemperature")) {
            StringBuilder str = new StringBuilder();
            if (careForecast != null) {
                str.append(careForecast.getLow());
                if ((float)careForecast.getHigh() != -274.0f) {
                    str.append("/");
                    str.append(careForecast.getHigh());
                } else if (careTomorrowForecast != ForecastWeather.EMPTY) {
                    str.append("/");
                    str.append(careTomorrowForecast.getHigh());
                }
            }
            mText = str.toString();
        } else if (FunctionId.equals("htemperature")) {
            String str = "";
            if (careForecast != null) {
                if ((float)careForecast.getHigh() != -274.0f) {
                    str = careForecast.getHigh() + "";
                } else if (careTomorrowForecast != ForecastWeather.EMPTY) {
                    str = careTomorrowForecast.getHigh() + "";
                }
            }
            mText = str;
        } else if (FunctionId.equals("ltemperature")) {
            String str = "";
            if (careForecast != null) {
                str = careForecast.getLow() + "";
            }
            mText = str;
        }
        careTomorrowForecast = null;
        careForecast = null;
        if (mText != null) {
            return mText;
        }
        Calendar calendar = Calendar.getInstance();
        long curtime = System.currentTimeMillis();
        if (System.getProperty("skin.useCustomTime") != null && System.getProperty("skin.useCustomTime").equals("true")) {
            curtime = Long.parseLong(System.getProperty("skin.customTime"));
        }
        calendar.setTimeInMillis(curtime += (long)offsetDay * 3600000L * 24L);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int week = calendar.get(7);
        if (FunctionId.equals("yyyy")) {
            mText = year + "";
        } else if (FunctionId.equals("yy")) {
            mText = (year + "").substring(2);
        } else if (FunctionId.equals("mm")) {
            mText = SkinHelper.num(month + 1);
        } else if (FunctionId.equals("mm0_en")) {
            mText = month_of_year_en[month];
        } else if (FunctionId.equals("mm1_en")) {
            mText = brief_month_of_year_en[month];
        } else if (FunctionId.equals("m")) {
            mText = month + 1 + "";
        } else if (FunctionId.equals("dd")) {
            mText = SkinHelper.num(day);
        } else if (FunctionId.equals("d")) {
            mText = day + "";
        } else if (FunctionId.equals("d0_en")) {
            mText = SkinHelper.formatDay(day);
        } else if (FunctionId.equals("d1_en")) {
            mText = SkinHelper.formatDay(day);
        } else if (FunctionId.equals("w0")) {
            mText = days_of_week[week - 1];
        } else if (FunctionId.equals("w1")) {
            mText = days_of_week_simple[week - 1];
        } else if (FunctionId.equals("w2")) {
            mText = brief_days_of_week[week - 1];
        } else if (FunctionId.equals("w0_en")) {
            mText = days_of_week_en[week - 1];
        } else if (FunctionId.equals("w1_en")) {
            mText = brief_days_of_week_en[week - 1];
        }
        if (mText != null) {
            return mText;
        }
        Lunar cd = LunarHelper.getLunar(calendar);
        String term = "\u65e0\u8282\u6c14";
        String chny = "\u5e74";
        String chnm = "\u6708";
        String chnd = "\u65e5";
        if (cd != null) {
            if (cd.isSolarTerm()) {
                term = LunarHelper.getSorlarTermStr(cd);
            }
            chny = LunarHelper.getYearStr(cd);
            chnm = LunarHelper.getMonthStr(cd);
            chnd = LunarHelper.getDayStr(cd);
        }
        if (FunctionId.equals("chn_solar_term")) {
            mText = term;
        } else if (FunctionId.equals("chn_y")) {
            mText = chny;
        } else if (FunctionId.equals("chn_m")) {
            mText = chnm;
        } else if (FunctionId.equals("chn_d")) {
            mText = chnd;
        }
        return mText;
    }

    public static String forMatCarNum(int carNumber) {
        if (carNumber == -2) {
            return "\u4e0d\u9650\u884c";
        }
        return "" + carNumber;
    }

    protected SkinRect measureDrawRect() {
        if (this.mText == null) {
            return new SkinRect(0, 0);
        }
        SkinFont font = new SkinFont();
        font.setTextSize(this.TextSize);
        return new SkinRect(0, 0, font.stringWidth(this.mText), this.TextSize);
    }

    protected void setWeatherInfo(WeatherInfo wi) {
        this.mText = this.Text != null ? this.Text : SkinText.getTextByFunctionIdAndTimeOffset(wi, this.FunctionId, this.OffsetTime);
    }

    protected boolean setValue(String attrName, String attrValue) {
        if (attrName.equals("FunctionId")) {
            this.FunctionId = attrValue;
        } else if (attrName.equals("Text")) {
            this.Text = attrValue;
        } else if (attrName.equals("TextColor")) {
            String intu = attrValue.substring(0, 4);
            String intl = attrValue.substring(4);
            int int0 = Integer.parseInt(intu.toUpperCase(), 16);
            int int1 = Integer.parseInt(intl.toUpperCase(), 16);
            this.TextColor = int0 << 16 | int1;
        } else if (attrName.equals("TextSize")) {
            this.TextSize = SkinHelper.px(attrValue);
        } else if (attrName.equals("HasShadow")) {
            this.HasShadow = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("OffsetTime")) {
            this.OffsetTime = attrValue;
        } else if (attrName.equals("Shadow_color")) {
            String intu = attrValue.substring(0, 4);
            String intl = attrValue.substring(4);
            int int0 = Integer.parseInt(intu.toUpperCase(), 16);
            int int1 = Integer.parseInt(intl.toUpperCase(), 16);
            this.ShadowColor = int0 << 16 | int1;
        } else if (attrName.equals("Shadow_pos_x")) {
            this.ShadowPosX = SkinHelper.px(attrValue);
        } else if (attrName.equals("Shadow_pos_y")) {
            this.ShadowPosY = SkinHelper.px(attrValue);
        } else if (!super.setValue(attrName, attrValue)) {
            return false;
        }
        return true;
    }

    protected void draw(SkinRender c) {
        if (this.mText == null) {
            return;
        }
        if ("d0_en".equals(this.FunctionId) && this.mText.length() > 2) {
            SkinFont font1;
            SkinPaint paint1;
            int text_height;
            int text_width;
            SkinFont font;
            SkinPaint paint;
            String smallText;
            String largeText;
            if (this.HasShadow) {
                largeText = this.mText.substring(0, this.mText.length() - 2);
                smallText = this.mText.substring(this.mText.length() - 2);
                paint = new SkinPaint();
                paint.setColor(new SkinColor(this.ShadowColor));
                font = new SkinFont(this.TextSize);
                paint.setFont(font);
                c.drawSkinText(largeText, this.mDrawRect.left + this.ShadowPosX, this.mDrawRect.bottom + this.ShadowPosY, paint);
                text_width = font.stringWidth(largeText);
                text_height = this.TextSize / 2;
                paint1 = new SkinPaint();
                paint1.setColor(new SkinColor(this.ShadowColor));
                font1 = new SkinFont(text_height);
                paint1.setFont(font1);
                c.drawSkinText(smallText, this.mDrawRect.left + text_width + this.ShadowPosX, this.mDrawRect.bottom - text_height + this.ShadowPosY, paint1);
            }
            largeText = this.mText.substring(0, this.mText.length() - 2);
            smallText = this.mText.substring(this.mText.length() - 2);
            paint = new SkinPaint();
            paint.setColor(new SkinColor(this.ShadowColor));
            font = new SkinFont(this.TextSize);
            paint.setFont(font);
            c.drawSkinText(largeText, this.mDrawRect.left, this.mDrawRect.bottom, paint);
            text_width = font.stringWidth(largeText);
            text_height = this.TextSize / 2;
            paint1 = new SkinPaint();
            paint1.setColor(new SkinColor(this.ShadowColor));
            font1 = new SkinFont(text_height);
            paint1.setFont(font1);
            c.drawSkinText(smallText, this.mDrawRect.left + text_width, this.mDrawRect.bottom - text_height, paint1);
        } else {
            SkinPaint paint;
            if (this.HasShadow) {
                paint = new SkinPaint();
                paint.setColor(new SkinColor(this.ShadowColor));
                paint.setFont(new SkinFont(this.TextSize));
                c.drawSkinText(this.mText, this.mDrawRect.left + this.ShadowPosX, this.mDrawRect.bottom + this.ShadowPosY, paint);
            }
            paint = new SkinPaint();
            paint.setColor(new SkinColor(this.TextColor));
            paint.setFont(new SkinFont(this.TextSize));
            c.drawSkinText(this.mText, this.mDrawRect.left, this.mDrawRect.bottom, paint);
        }
    }

    public void recycle() {
        this.Text = null;
        this.OffsetTime = null;
        this.mText = null;
    }
}

