/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.util.HashMap;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.Utility;
import sina.mobile.skin.weather.WeatherInfo;

public abstract class SkinLayoutModel
extends AbSkinUnit {
    protected int x = Integer.MIN_VALUE;
    protected int y = Integer.MIN_VALUE;
    protected String LayoutId = null;
    protected int OffsetX = 0;
    protected int OffsetY = 0;
    public static final int LEFT = 1;
    public static final int HCENTER = 2;
    public static final int RIGHT = 4;
    public static final int TOP = 8;
    public static final int VCENTER = 16;
    public static final int BOTTOM = 32;
    protected static final int H_MASK = 7;
    protected static final int V_MASK = 56;
    protected int DatumPoint = 9;
    protected int DatumHLine = 0;
    protected int DatumVLine = 0;
    protected String DatumHLineLayoutId = null;
    protected String DatumVLineLayoutId = null;
    protected SkinRect mDrawRect = null;
    protected static final HashMap<String, Integer> mStrDatum2IntDatum = new HashMap();

    public SkinLayoutModel(Skin skin) {
        super(skin);
    }

    public SkinLayoutModel() {
    }

    public SkinLayoutModel clone() throws CloneNotSupportedException {
        SkinLayoutModel clone = (SkinLayoutModel)super.clone();
        clone.mDrawRect = this.mDrawRect.clone();
        return clone;
    }

    public int getOffsetX() {
        return this.OffsetX;
    }

    public void setOffsetX(int OffsetX) {
        this.OffsetX = OffsetX;
    }

    public int getOffsetY() {
        return this.OffsetY;
    }

    public void setOffsetY(int OffsetY) {
        this.OffsetY = OffsetY;
    }

    public int getDatumHLine() {
        return this.DatumHLine;
    }

    public void setDatumHLine(int DatumHLine) {
        this.DatumHLine = DatumHLine;
    }

    public String getDatumHLineLayoutId() {
        return this.DatumHLineLayoutId;
    }

    public void setDatumHLineLayoutId(String DatumHLineLayoutId) {
        this.DatumHLineLayoutId = DatumHLineLayoutId;
    }

    public int getDatumPoint() {
        return this.DatumPoint;
    }

    public void setDatumPoint(int DatumPoint) {
        this.DatumPoint = DatumPoint;
    }

    public int getDatumVLine() {
        return this.DatumVLine;
    }

    public void setDatumVLine(int DatumVLine) {
        this.DatumVLine = DatumVLine;
    }

    public String getDatumVLineLayoutId() {
        return this.DatumVLineLayoutId;
    }

    public void setDatumVLineLayoutId(String DatumVLineLayoutId) {
        this.DatumVLineLayoutId = DatumVLineLayoutId;
    }

    public String getLayoutId() {
        return this.LayoutId;
    }

    public void setLayoutId(String LayoutId) {
        this.LayoutId = LayoutId;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    protected abstract SkinRect measureDrawRect();

    protected abstract void setWeatherInfo(WeatherInfo var1);

    protected boolean setValue(String attrName, String attrValue) {
        if (attrName.equals("Visible")) {
            this.visible = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("x")) {
            this.x = SkinHelper.px(attrValue);
        } else if (attrName.equals("y")) {
            this.y = SkinHelper.px(attrValue);
        } else if (attrName.equals("LayoutId")) {
            this.LayoutId = attrValue;
        } else if (attrName.equals("OffsetX")) {
            this.OffsetX = SkinHelper.px(attrValue);
        } else if (attrName.equals("OffsetY")) {
            this.OffsetY = SkinHelper.px(attrValue);
        } else if (attrName.equals("DatumPoint")) {
            this.DatumPoint = SkinLayoutModel.getIntDatumPoint(attrValue);
        } else if (attrName.equals("DatumHLine")) {
            this.DatumHLine = SkinLayoutModel.getIntDatumLine(attrValue);
        } else if (attrName.equals("DatumVLine")) {
            this.DatumVLine = SkinLayoutModel.getIntDatumLine(attrValue);
        } else if (attrName.equals("DatumHLineLayoutId")) {
            this.DatumHLineLayoutId = attrValue;
        } else if (attrName.equals("DatumVLineLayoutId")) {
            this.DatumVLineLayoutId = attrValue;
        } else if (attrName.equals("Name")) {
            this.name = attrValue;
        } else {
            return false;
        }
        return true;
    }

    protected static int getIntDatumPoint(String strDatumPoint) {
        String[] tmp = Utility.split(strDatumPoint, '|');
        int a = mStrDatum2IntDatum.get(tmp[0]);
        int b = mStrDatum2IntDatum.get(tmp[1]);
        return a | b;
    }

    protected static int getIntDatumLine(String strDatumLine) {
        return mStrDatum2IntDatum.get(strDatumLine);
    }

    public void setDrawRect(SkinRect mDrawRect) {
        this.mDrawRect = mDrawRect;
    }

    public SkinRect getDrawRect() {
        return this.mDrawRect;
    }

    static {
        mStrDatum2IntDatum.put("left", 1);
        mStrDatum2IntDatum.put("hcenter", 2);
        mStrDatum2IntDatum.put("right", 4);
        mStrDatum2IntDatum.put("top", 8);
        mStrDatum2IntDatum.put("vcenter", 16);
        mStrDatum2IntDatum.put("bottom", 32);
    }
}

