/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import sina.mobile.skin.Picture;
import sina.mobile.skin.PictureHelper;
import sina.mobile.skin.PictureIO;
import sina.mobile.skin.Utility;
import sina.mobile.tianqitong.util.Log;

public class SkinHelper {
    private static final String APPWIDGETSKIN_ICON_FILENAME = "icon.png";
    private static final String APPWIDGETSKIN_ICON2_FILENAME = "icon2.png";
    public static final String APPWIDGETSKIN_LAND_DRAWABLE_CACHE_FILENAME = "land_drawable_cache.txt";
    public static final String APPWIDGETSKIN_PORT_DRAWABLE_CACHE_FILENAME = "port_drawable_cache.txt";
    private static final String APPWIDGETSKIN_LAND_LAYOUT_CACHE_FILENAME = "layout-land.xml";
    private static final String APPWIDGETSKIN_PORT_LAYOUT_CACHE_FILENAME = "layout-port.xml";
    public static final String APPWIDGETSKIN_LAND_DRAWABLE_DIRNAME = "drawable-land";
    public static final String APPWIDGETSKIN_PORT_DRAWABLE_DIRNAME = "drawable-port";
    public static final String APPWIDGETSKIN_CACHE_IDFILE = "skin.txt";
    private static final float XHDPI = 320.0f;
    private static final float HDPI = 240.0f;
    private static final float MDPI = 160.0f;
    private static final float LDPI = 120.0f;
    private static int densityDpi = 320;
    private static float density = 2.0f;
    private static File cacheDir = null;
    private static boolean lazyLoad = true;

    public static boolean isLazyLoad() {
        return lazyLoad;
    }

    public static void setLazyLoad(boolean lazyLoad) {
        SkinHelper.lazyLoad = lazyLoad;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public static void setCacheDir(File mCacheDir) {
        cacheDir = mCacheDir;
    }

    public static void init() {
        density = Float.parseFloat(System.getProperty("skin.density", "2.0"));
        densityDpi = Integer.parseInt(System.getProperty("skin.densityDpi", "320"));
    }

    public static void init(float density, int densityDpi) {
        SkinHelper.density = density;
        SkinHelper.densityDpi = densityDpi;
    }

    public static int getOffsetDay(String OffsetTime) {
        int offsetDay = 0;
        int daySign = 1;
        if (OffsetTime != null) {
            if (OffsetTime.startsWith("-")) {
                daySign = -1;
                OffsetTime = OffsetTime.substring(1);
            } else if (OffsetTime.startsWith("+")) {
                daySign = 1;
                OffsetTime = OffsetTime.substring(1);
            } else {
                daySign = 1;
                OffsetTime = OffsetTime.substring(0);
            }
            if (OffsetTime.endsWith("d")) {
                offsetDay = daySign * Integer.parseInt(OffsetTime.substring(0, OffsetTime.length() - 1));
            }
        }
        return offsetDay;
    }

    public static String formatDay(int day) {
        String hz = "";
        hz = day == 1 ? "st" : (day == 2 ? "nd" : (day == 3 ? "rd" : "th"));
        return day + hz;
    }

    public static int px(String attrValue) {
        int dip = Integer.parseInt(attrValue);
        return Math.round((float)dip * density);
    }

    public static String num(int num) {
        return (num <= 9 ? "0" : "") + num + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Picture getPictureByFilename(File zipFile, String filename, boolean mIsPortrait) throws FileNotFoundException, IOException {
        String tqtbmpfn;
        if (filename == null) {
            Log.info("Picture filename is null!");
            return null;
        }
        File tqtbmp = null;
        File drawableDir = null;
        drawableDir = mIsPortrait ? new File(cacheDir, APPWIDGETSKIN_PORT_DRAWABLE_DIRNAME) : new File(cacheDir, APPWIDGETSKIN_LAND_DRAWABLE_DIRNAME);
        if (!drawableDir.exists()) {
            drawableDir.mkdirs();
        }
        if ((tqtbmp = new File(drawableDir, tqtbmpfn = filename.substring(0, filename.length() - ".png".length()) + ".png")).isFile() && tqtbmp.exists()) {
            Picture image = PictureIO.read(tqtbmp);
            return image;
        }
        File cacheFile = null;
        cacheFile = mIsPortrait ? new File(cacheDir, APPWIDGETSKIN_PORT_DRAWABLE_CACHE_FILENAME) : new File(cacheDir, APPWIDGETSKIN_LAND_DRAWABLE_CACHE_FILENAME);
        if (cacheFile.isDirectory() || !cacheFile.exists()) {
            return null;
        }
        BufferedReader br = null;
        String zipEntryName = null;
        String dir = null;
        try {
            br = new BufferedReader(new FileReader(cacheFile));
            zipEntryName = br.readLine();
            while (zipEntryName != null) {
                String[] tmp = Utility.split(zipEntryName, '/');
                if (tmp[1].equals(filename)) {
                    dir = tmp[0];
                    break;
                }
                zipEntryName = br.readLine();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (zipEntryName == null) {
            return null;
        }
        InputStream pngis = null;
        Picture bmp = null;
        ZipFile zf = new ZipFile(zipFile);
        try {
            ZipEntry ze = zf.getEntry(zipEntryName);
            pngis = new BufferedInputStream(zf.getInputStream(ze));
            bmp = PictureIO.read(pngis);
        }
        finally {
            if (pngis != null) {
                try {
                    pngis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (zf != null) {
                zf.close();
            }
        }
        int dstWidth = -1;
        int dstHeight = -1;
        dstHeight = bmp.getHeight();
        dstWidth = bmp.getWidth();
        float s = dir.contains("xhdpi") ? (float)densityDpi / 320.0f : (dir.contains("hdpi") ? (float)densityDpi / 240.0f : (dir.contains("mdpi") ? (float)densityDpi / 160.0f : (dir.contains("ldpi") ? (float)densityDpi / 120.0f : (float)densityDpi / 160.0f)));
        dstWidth = Math.max(1, (int)((float)dstWidth * s));
        dstHeight = Math.max(1, (int)((float)dstHeight * s));
        bmp = PictureHelper.resize(bmp, dstWidth, dstHeight);
        if (tqtbmp.exists()) {
            tqtbmp.delete();
        }
        try {
            tqtbmp.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        PictureIO.write(bmp, "png", tqtbmp);
        return bmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkCacheDir(File mZipSkinFile, File dir) {
        if (!dir.exists()) return false;
        if (dir.isFile()) {
            return false;
        }
        File skintxt = new File(dir, APPWIDGETSKIN_CACHE_IDFILE);
        if (!skintxt.exists()) return false;
        if (skintxt.isDirectory()) {
            return false;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(skintxt));
            String fn = br.readLine();
            if (fn == null) {
                boolean bl = false;
                return bl;
            }
            if (!fn.equals(mZipSkinFile.getName())) {
                boolean bl = false;
                return bl;
            }
            long length = Long.parseLong(br.readLine());
            if (length != mZipSkinFile.length()) {
                boolean bl = false;
                return bl;
            }
            long lastModified = Long.parseLong(br.readLine());
            if (lastModified != mZipSkinFile.lastModified()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeCacheDir(File mZipSkinFile, File cacheDir, String size, String aspect, String dpi) throws IOException {
        BufferedWriter bw;
        String landZipEntryName;
        if (size == null) {
            size = System.getProperty("skin.size", "normal");
        }
        if (aspect == null) {
            aspect = System.getProperty("skin.aspectRadio", "notlong");
        }
        if (dpi == null) {
            dpi = System.getProperty("skin.dpi", "xhdpi");
        }
        if (!mZipSkinFile.isFile() || !mZipSkinFile.exists()) {
            throw new IllegalArgumentException();
        }
        String[] zipEntryNames = new String[]{};
        ZipFile pkgZipFile = null;
        pkgZipFile = new ZipFile(mZipSkinFile);
        HashSet<String> zipEntryNameSet = new HashSet<String>();
        ArrayList<String> zipEntryNameList = new ArrayList<String>();
        Enumeration e = pkgZipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry ze = (ZipEntry)e.nextElement();
            if (ze.isDirectory()) continue;
            zipEntryNameList.add(ze.getName());
            zipEntryNameSet.add(ze.getName());
        }
        if (!zipEntryNameSet.contains("cfg.xml")) {
            throw new IllegalArgumentException();
        }
        zipEntryNames = new String[zipEntryNameList.size()];
        zipEntryNameList.toArray(zipEntryNames);
        HashMap<String, String[]> imageZEName2DirZENamesMap = new HashMap<String, String[]>();
        String[] layoutZENames = new String[]{};
        HashSet<String> layoutZENameSet = new HashSet<String>();
        HashMap<String, HashSet<String>> imageFn2DrawableDirSetMap = new HashMap<String, HashSet<String>>();
        for (int i = 0; i < zipEntryNames.length; ++i) {
            String zename = zipEntryNames[i];
            if (zename.startsWith("layout")) {
                if (!zename.endsWith(".xml")) continue;
                layoutZENameSet.add(zename);
                continue;
            }
            if (!zename.endsWith(".png") || zename.equals(APPWIDGETSKIN_ICON_FILENAME) || zename.equals(APPWIDGETSKIN_ICON2_FILENAME)) continue;
            String[] tmp = Utility.split(zename, '/');
            if (tmp.length != 2) {
                throw new IllegalArgumentException();
            }
            String dir = tmp[0];
            String fn = tmp[1];
            HashSet<String> diral = (HashSet<String>)imageFn2DrawableDirSetMap.get(fn);
            if (diral == null) {
                diral = new HashSet<String>();
                imageFn2DrawableDirSetMap.put(fn, diral);
            }
            diral.add(dir);
        }
        if (layoutZENameSet.isEmpty()) {
            throw new IllegalArgumentException();
        }
        layoutZENames = new String[layoutZENameSet.size()];
        layoutZENameSet.toArray(layoutZENames);
        for (String imageZEName : imageFn2DrawableDirSetMap.keySet()) {
            HashSet DirZENameSet = (HashSet)imageFn2DrawableDirSetMap.get(imageZEName);
            String[] dirZENames = new String[DirZENameSet.size()];
            DirZENameSet.toArray(dirZENames);
            imageZEName2DirZENamesMap.put(imageZEName, dirZENames);
        }
        String portZipEntryName = SkinHelper.getMatchingFilename(size, aspect, "port", dpi, layoutZENames);
        if (portZipEntryName != null) {
            BufferedReader br = null;
            BufferedWriter bw2 = null;
            try {
                File f = new File(cacheDir, APPWIDGETSKIN_PORT_LAYOUT_CACHE_FILENAME);
                f.delete();
                f.createNewFile();
                ZipEntry ze = pkgZipFile.getEntry(portZipEntryName);
                br = new BufferedReader(new InputStreamReader(pkgZipFile.getInputStream(ze), "utf-8"));
                bw2 = new BufferedWriter(new FileWriter(f));
                String line = br.readLine();
                while (line != null) {
                    bw2.append(line);
                    bw2.newLine();
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                if (bw2 != null) {
                    try {
                        bw2.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        if ((landZipEntryName = SkinHelper.getMatchingFilename(size, aspect, "land", dpi, layoutZENames)) != null) {
            BufferedReader br = null;
            bw = null;
            try {
                File f = new File(cacheDir, APPWIDGETSKIN_LAND_LAYOUT_CACHE_FILENAME);
                f.delete();
                f.createNewFile();
                ZipEntry ze = pkgZipFile.getEntry(landZipEntryName);
                br = new BufferedReader(new InputStreamReader(pkgZipFile.getInputStream(ze), "utf-8"));
                bw = new BufferedWriter(new FileWriter(f));
                String line = br.readLine();
                while (line != null) {
                    bw.append(line);
                    bw.newLine();
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e4) {}
                }
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException e5) {}
                }
            }
        }
        if (pkgZipFile != null) {
            pkgZipFile.close();
        }
        ArrayList<Object> portImgNameList = new ArrayList<Object>();
        ArrayList<Object> landImgNameList = new ArrayList<Object>();
        File landDrawableCacheFile = new File(cacheDir, APPWIDGETSKIN_LAND_DRAWABLE_CACHE_FILENAME);
        File portDrawableCacheFile = new File(cacheDir, APPWIDGETSKIN_PORT_DRAWABLE_CACHE_FILENAME);
        BufferedWriter landbw = null;
        BufferedWriter portbw = null;
        try {
            landDrawableCacheFile.createNewFile();
            portDrawableCacheFile.createNewFile();
            landbw = new BufferedWriter(new FileWriter(landDrawableCacheFile));
            portbw = new BufferedWriter(new FileWriter(portDrawableCacheFile));
            Set imageZENameSet = imageZEName2DirZENamesMap.keySet();
            Object[] imageZENames = new String[imageZENameSet.size()];
            imageZENameSet.toArray(imageZENames);
            Arrays.sort(imageZENames);
            for (Object imageZEName : imageZENames) {
                String landDirZipEntryName;
                String[] dirZENames = (String[])imageZEName2DirZENamesMap.get(imageZEName);
                String portDirZipEntryName = SkinHelper.getMatchingFilename(size, aspect, "port", dpi, dirZENames);
                if (portDirZipEntryName != null) {
                    portbw.append(portDirZipEntryName);
                    portbw.append("/");
                    portbw.append((CharSequence)imageZEName);
                    portbw.newLine();
                    portImgNameList.add(imageZEName);
                }
                if ((landDirZipEntryName = SkinHelper.getMatchingFilename(size, aspect, "land", dpi, dirZENames)) == null) continue;
                landbw.append(landDirZipEntryName);
                landbw.append("/");
                landbw.append((CharSequence)imageZEName);
                landbw.newLine();
                landImgNameList.add(imageZEName);
            }
        }
        finally {
            if (portbw != null) {
                try {
                    portbw.close();
                }
                catch (IOException e6) {}
            }
            if (landbw != null) {
                try {
                    landbw.close();
                }
                catch (IOException e7) {}
            }
        }
        if (!lazyLoad) {
            for (int i = 0; i < portImgNameList.size(); ++i) {
                SkinHelper.getPictureByFilename(mZipSkinFile, (String)portImgNameList.get(i), true);
            }
        }
        File skintxt = new File(cacheDir, APPWIDGETSKIN_CACHE_IDFILE);
        bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(skintxt));
            bw.append(mZipSkinFile.getName());
            bw.newLine();
            bw.append(mZipSkinFile.length() + "");
            bw.newLine();
            bw.append(mZipSkinFile.lastModified() + "");
            bw.flush();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e8) {
                    e8.printStackTrace();
                }
            }
        }
    }

    public static String getMatchingFilename(String size, String aspect, String orientation, String dpi, String[] filenames) {
        int[] cfgPriority;
        HashMap<Object[], String> cfg2filenameMap = new HashMap<Object[], String>();
        int IDX_SIZE = 0;
        int IDX_ASPECT = 1;
        int IDX_ORIENTATION = 2;
        int IDX_DPI = 3;
        HashSet<String> sizes = new HashSet<String>();
        sizes.add("small");
        sizes.add("normal");
        sizes.add("large");
        HashSet<String> aspects = new HashSet<String>();
        aspects.add("long");
        aspects.add("notlong");
        HashSet<String> orientations = new HashSet<String>();
        orientations.add("port");
        orientations.add("land");
        HashSet<String> dpis = new HashSet<String>();
        dpis.add("ldpi");
        dpis.add("mdpi");
        dpis.add("hdpi");
        dpis.add("xhdpi");
        for (String fn : filenames) {
            String filename = Utility.split(fn, '.')[0];
            String[] tmp = Utility.split(filename, '-');
            String[] tmpcfgs = new String[tmp.length - 1];
            System.arraycopy(tmp, 1, tmpcfgs, 0, tmpcfgs.length);
            Object[] cfgs = new String[4];
            Arrays.fill(cfgs, "");
            for (String cfg : tmpcfgs) {
                if (sizes.contains(cfg)) {
                    cfgs[IDX_SIZE] = cfg;
                    continue;
                }
                if (aspects.contains(cfg)) {
                    cfgs[IDX_ASPECT] = cfg;
                    continue;
                }
                if (orientations.contains(cfg)) {
                    cfgs[IDX_ORIENTATION] = cfg;
                    continue;
                }
                if (!dpis.contains(cfg)) continue;
                cfgs[IDX_DPI] = cfg;
            }
            cfg2filenameMap.put(cfgs, fn);
        }
        Iterator iterator = cfg2filenameMap.entrySet().iterator();
        while (iterator.hasNext()) {
            String[] cur = (String[])iterator.next().getKey();
            if (cur[IDX_ASPECT].length() != 0 && !cur[IDX_ASPECT].equals(aspect)) {
                iterator.remove();
                continue;
            }
            if (cur[IDX_ORIENTATION].length() != 0 && !cur[IDX_ORIENTATION].equals(orientation)) {
                iterator.remove();
                continue;
            }
            if (cur[IDX_SIZE].length() == 0 || cur[IDX_SIZE].equals(size)) continue;
            iterator.remove();
        }
        if (cfg2filenameMap.isEmpty()) {
            return null;
        }
        for (int ttcfg : cfgPriority = new int[]{IDX_SIZE, IDX_ASPECT, IDX_ORIENTATION}) {
            HashMap tempAl = new HashMap();
            for (Map.Entry cure : cfg2filenameMap.entrySet()) {
                String[] cur = (String[])cure.getKey();
                if (cur[ttcfg].length() == 0) continue;
                tempAl.put(cur, cure.getValue());
            }
            if (!tempAl.isEmpty()) {
                cfg2filenameMap = tempAl;
            }
            if (!cfg2filenameMap.isEmpty()) continue;
            return null;
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (!cur[IDX_DPI].equals(dpi)) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (cur[IDX_DPI].length() != 0) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (!cur[IDX_DPI].equals("xhdpi")) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (!cur[IDX_DPI].equals("hdpi")) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (!cur[IDX_DPI].equals("mdpi")) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        for (String[] cur : cfg2filenameMap.keySet()) {
            if (!cur[IDX_DPI].equals("ldpi")) continue;
            return (String)cfg2filenameMap.get(cur);
        }
        return null;
    }
}

