/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.io.FileNotFoundException;
import java.io.IOException;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.Picture;
import sina.mobile.skin.Skin;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;

public class SkinButton
extends AbSkinUnit {
    private int Idx = -1;
    private String Src = null;
    private String StopPlayingSrc = null;
    private String PkgName = null;
    private String ActivityName = null;
    private String IntoClock = null;
    private SkinRect pictureRect = null;

    public SkinButton(Skin skin) {
        super(skin);
    }

    public SkinButton() {
    }

    public SkinButton clone() throws CloneNotSupportedException {
        SkinButton clone = (SkinButton)super.clone();
        clone.pictureRect = this.pictureRect.clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SkinButton)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.Idx;
        hash = 79 * hash + (this.FunctionId != null ? this.FunctionId.hashCode() : 0);
        hash = 79 * hash + (this.Src != null ? this.Src.hashCode() : 0);
        hash = 79 * hash + (this.StopPlayingSrc != null ? this.StopPlayingSrc.hashCode() : 0);
        hash = 79 * hash + (this.PkgName != null ? this.PkgName.hashCode() : 0);
        hash = 79 * hash + (this.ActivityName != null ? this.ActivityName.hashCode() : 0);
        hash = 79 * hash + (this.IntoClock != null ? this.IntoClock.hashCode() : 0);
        hash = 79 * hash + (this.pictureRect != null ? this.pictureRect.hashCode() : 0);
        return hash;
    }

    public SkinRect getPictureRect() {
        return this.pictureRect;
    }

    public void setPictureRect(SkinRect pictureRect) {
        this.pictureRect = pictureRect;
    }

    public SkinRect measurePictureRect() {
        if (this.Src == null || this.skin == null) {
            return new SkinRect(0, 0);
        }
        SkinRect rect = null;
        if (this.pictureRect != null) {
            rect = new SkinRect();
            rect.right = this.pictureRect.right - this.pictureRect.left;
            rect.bottom = this.pictureRect.bottom - this.pictureRect.top;
        } else {
            try {
                Picture picture = SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.Src, this.skin.isPortrait());
                rect = picture != null ? picture.getSkinRect() : new SkinRect(0, 0);
            }
            catch (FileNotFoundException e) {
                rect = new SkinRect(0, 0);
                e.printStackTrace();
            }
            catch (IOException e) {
                rect = new SkinRect(0, 0);
                e.printStackTrace();
            }
        }
        return rect;
    }

    public Picture getSrcCachePicture() {
        if (this.Src != null) {
            try {
                return SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.Src, this.skin.isPortrait());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Picture getStopPlayingSrcCachePicture() {
        if (this.StopPlayingSrc != null) {
            try {
                return SkinHelper.getPictureByFilename(this.skin.getSkinZipFile(), this.StopPlayingSrc, this.skin.isPortrait());
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public void setActivityName(String ActivityName) {
        this.ActivityName = ActivityName;
    }

    public void setIdx(int Idx) {
        this.Idx = Idx;
    }

    public void setPkgName(String PkgName) {
        this.PkgName = PkgName;
    }

    public void setSrc(String Src) {
        this.Src = Src;
    }

    public void setStopPlayingSrc(String StopPlayingSrc) {
        this.StopPlayingSrc = StopPlayingSrc;
    }

    public String getIntoClock() {
        return this.IntoClock;
    }

    public void setIntoClock(String IntoClock) {
        this.IntoClock = IntoClock;
    }

    public int getIdx() {
        return this.Idx;
    }

    public String getStopPlayingSrc() {
        return this.StopPlayingSrc;
    }

    public String getSrc() {
        return this.Src;
    }

    public String getPkgName() {
        return this.PkgName;
    }

    public String getActivityName() {
        return this.ActivityName;
    }

    protected boolean setValue(String attrName, String attrValue) {
        if (attrName.equals("Visible")) {
            this.visible = Boolean.parseBoolean(attrValue);
        } else if (attrName.equals("Idx")) {
            this.Idx = Integer.parseInt(attrValue);
        } else if (attrName.equals("FunctionId")) {
            this.FunctionId = attrValue;
        } else if (attrName.equals("Src")) {
            this.Src = attrValue;
        } else if (attrName.equals("StopPlayingSrc")) {
            this.StopPlayingSrc = attrValue;
        } else if (attrName.equals("PkgName")) {
            this.PkgName = attrValue;
        } else if (attrName.equals("ActivityName")) {
            this.ActivityName = attrValue;
        } else if (attrName.equals("IntoClock")) {
            this.IntoClock = attrValue;
        } else if (attrName.equals("Name")) {
            this.name = attrValue;
        } else {
            return false;
        }
        return true;
    }

    protected void draw(SkinRender c) {
    }

    public void recycle() {
        this.Src = null;
        this.StopPlayingSrc = null;
        this.PkgName = null;
        this.ActivityName = null;
        this.IntoClock = null;
        this.pictureRect = null;
    }
}

