/*
 * Decompiled with CFR 0.152.
 */
package sina.mobile.skin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import sina.mobile.skin.AbSkinUnit;
import sina.mobile.skin.SkinButton;
import sina.mobile.skin.SkinHelper;
import sina.mobile.skin.SkinImage;
import sina.mobile.skin.SkinLayoutModel;
import sina.mobile.skin.SkinRect;
import sina.mobile.skin.SkinRender;
import sina.mobile.skin.SkinTextArea;
import sina.mobile.skin.Utility;
import sina.mobile.skin.weather.WeatherInfo;
import sina.mobile.tianqitong.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Skin
implements Cloneable {
    public static final int TYPE_4X2 = 0;
    public static final int TYPE_4X1 = 1;
    public static final int TYPE_5X2 = 2;
    public static final int TYPE_5X1 = 3;
    private ArrayList<AbSkinUnit> layoutUnits = new ArrayList();
    private int type = 0;
    private File skinZipFile = null;
    private boolean isPortrait = true;
    private WeatherInfo wi = null;

    public void recycle() {
        this.wi = null;
        this.skinZipFile = null;
        for (AbSkinUnit skinUnit : this.layoutUnits) {
            skinUnit.recycle();
        }
    }

    private Skin() {
    }

    public Skin clone() throws CloneNotSupportedException {
        Skin clone = (Skin)super.clone();
        clone.layoutUnits = new ArrayList();
        for (AbSkinUnit unit : this.layoutUnits) {
            AbSkinUnit u = unit.clone();
            u.setSkin(clone);
            clone.layoutUnits.add(u);
        }
        return clone;
    }

    public WeatherInfo getWeatherInfo() {
        return this.wi;
    }

    public void setWeatherInfo(WeatherInfo weatherInfo) {
        this.wi = weatherInfo;
    }

    public boolean isPortrait() {
        return this.isPortrait;
    }

    public void setPortrait(boolean isPortrait) {
        this.isPortrait = isPortrait;
    }

    public void setLayoutUnits(ArrayList<AbSkinUnit> layoutUntis) {
        this.layoutUnits = layoutUntis;
    }

    public ArrayList<AbSkinUnit> getSkinUnits() {
        return this.layoutUnits;
    }

    public static Skin getLandSkin(int type, File zipFile) {
        Skin skin = new Skin();
        skin.setType(type);
        skin.setSkinZipFile(zipFile);
        skin.setPortrait(false);
        return skin;
    }

    public static Skin getPortSkin(int type, File zipFile) {
        Skin skin = new Skin();
        skin.setType(type);
        skin.setSkinZipFile(zipFile);
        skin.setPortrait(true);
        return skin;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public File getSkinZipFile() {
        return this.skinZipFile;
    }

    public void setSkinZipFile(File skinZipFile) {
        this.skinZipFile = skinZipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseLayoutXml() throws XmlPullParserException, IOException {
        int i;
        File layoutFile = null;
        File cacheDir = SkinHelper.getCacheDir();
        File portLayout = new File(cacheDir, "layout-port.xml");
        File landLayout = new File(cacheDir, "layout-land.xml");
        File file = layoutFile = this.isPortrait() ? portLayout : landLayout;
        if (!layoutFile.exists()) {
            this.layoutUnits.clear();
            return;
        }
        String xmlContent = StringUtil.loadStringFromFile(layoutFile, System.getProperty("file.encoding"));
        String[] xmls = xmlContent.split("\n");
        StringBuilder sb = new StringBuilder();
        if (xmlContent.contains("xml version")) {
            for (i = 1; i < xmls.length; ++i) {
                sb.append(xmls[i]);
            }
        } else {
            for (i = 0; i < xmls.length; ++i) {
                sb.append(xmls[i]);
            }
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new ByteArrayInputStream(sb.toString().getBytes()));
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput(bis, System.getProperty("file.encoding"));
            int eventType = xpp.getEventType();
            block12: while (eventType != 1) {
                switch (eventType) {
                    case 2: {
                        AbSkinUnit aslu = null;
                        if (xpp.getName().equals("Image")) {
                            aslu = new SkinImage(this);
                        } else if (xpp.getName().equals("Text")) {
                            aslu = new SkinTextArea(this);
                        } else if (xpp.getName().equals("TextArea")) {
                            aslu = new SkinTextArea(this);
                        } else if (xpp.getName().equals("Button")) {
                            aslu = new SkinButton(this);
                        } else {
                            eventType = xpp.next();
                            continue block12;
                        }
                        if (aslu == null) continue block12;
                        for (int i2 = 0; i2 < xpp.getAttributeCount(); ++i2) {
                            String attrValue;
                            String attrName = xpp.getAttributeName(i2);
                            if (aslu.setValue(attrName, attrValue = xpp.getAttributeValue(i2))) continue;
                        }
                        if (!aslu.isVisible()) break;
                        this.layoutUnits.add(aslu);
                    }
                }
                eventType = xpp.next();
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkImage(String filename) throws FileNotFoundException, IOException {
        String tqtbmpfn;
        File cacheDir = SkinHelper.getCacheDir();
        File tqtbmp = null;
        File drawableDir = null;
        drawableDir = this.isPortrait() ? new File(cacheDir, "drawable-port") : new File(cacheDir, "drawable-land");
        if (!drawableDir.exists()) {
            drawableDir.mkdirs();
        }
        if ((tqtbmp = new File(drawableDir, tqtbmpfn = filename.substring(0, filename.length() - ".png".length()) + ".png")).isFile() && tqtbmp.exists()) {
            return true;
        }
        if (tqtbmp.exists()) {
            tqtbmp.delete();
        }
        File cacheFile = null;
        cacheFile = this.isPortrait() ? new File(cacheDir, "port_drawable_cache.txt") : new File(cacheDir, "land_drawable_cache.txt");
        if (cacheFile.isDirectory() || !cacheFile.exists()) {
            return false;
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(cacheFile));
            String zipEntryName = br.readLine();
            while (zipEntryName != null) {
                String[] tmp = Utility.split(zipEntryName, '/');
                if (tmp[1].equals(filename)) {
                    br.close();
                    boolean bl = true;
                    return bl;
                }
                zipEntryName = br.readLine();
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    public void draw(SkinRender render) {
        if (this.wi == null) {
            return;
        }
        this.layout();
        for (AbSkinUnit aslu : this.layoutUnits) {
            aslu.draw(render);
        }
    }

    private void layout() {
        HashMap<String, SkinLayoutModel> layoutId2UnitMap = new HashMap<String, SkinLayoutModel>();
        SkinRect bgRect = null;
        if (this.type == 0) {
            bgRect = this.isPortrait() ? new SkinRect(0, 0, SkinHelper.px("320"), SkinHelper.px("240")) : new SkinRect(0, 0, SkinHelper.px("480"), SkinHelper.px("160"));
        } else if (this.type == 1) {
            bgRect = this.isPortrait() ? new SkinRect(0, 0, SkinHelper.px("320"), SkinHelper.px("120")) : new SkinRect(0, 0, SkinHelper.px("480"), SkinHelper.px("80"));
        } else if (this.type == 3) {
            bgRect = this.isPortrait() ? new SkinRect(0, 0, SkinHelper.px("400"), SkinHelper.px("120")) : new SkinRect(0, 0, SkinHelper.px("560"), SkinHelper.px("80"));
        } else if (this.type == 2) {
            bgRect = this.isPortrait() ? new SkinRect(0, 0, SkinHelper.px("400"), SkinHelper.px("240")) : new SkinRect(0, 0, SkinHelper.px("560"), SkinHelper.px("160"));
        }
        for (AbSkinUnit skinLayoutUnit : this.layoutUnits) {
            int tty;
            int ttx;
            SkinLayoutModel aslu;
            SkinRect relativeRect;
            if (skinLayoutUnit instanceof SkinButton) {
                SkinButton button = (SkinButton)skinLayoutUnit;
                button.setPictureRect(button.measurePictureRect());
                continue;
            }
            SkinLayoutModel model = (SkinLayoutModel)skinLayoutUnit;
            model.setWeatherInfo(this.wi);
            model.setDrawRect(model.measureDrawRect());
            if (model.LayoutId != null && model.LayoutId.length() != 0) {
                layoutId2UnitMap.put(model.LayoutId, model);
            }
            int width = model.mDrawRect.right;
            int height = model.mDrawRect.bottom;
            int tx = 0;
            int ty = 0;
            if (model.x != Integer.MIN_VALUE) {
                tx = model.x;
            } else {
                relativeRect = null;
                relativeRect = model.DatumHLineLayoutId == null ? bgRect : ((aslu = (SkinLayoutModel)layoutId2UnitMap.get(model.DatumHLineLayoutId)) == null ? bgRect : aslu.mDrawRect);
                if (relativeRect == null) {
                    throw new IllegalStateException();
                }
                switch (model.DatumHLine) {
                    case 0: 
                    case 1: {
                        tx = relativeRect.left;
                        break;
                    }
                    case 2: {
                        tx = relativeRect.left + (relativeRect.right - relativeRect.left) / 2;
                        break;
                    }
                    case 4: {
                        tx = relativeRect.right;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (model.y != Integer.MIN_VALUE) {
                ty = model.y;
            } else {
                relativeRect = null;
                relativeRect = model.DatumVLineLayoutId == null ? bgRect : ((aslu = (SkinLayoutModel)layoutId2UnitMap.get(model.DatumVLineLayoutId)) == null ? bgRect : aslu.mDrawRect);
                if (relativeRect == null) {
                    throw new IllegalStateException();
                }
                switch (model.DatumVLine) {
                    case 0: 
                    case 8: {
                        ty = relativeRect.top;
                        break;
                    }
                    case 16: {
                        ty = relativeRect.top + (relativeRect.bottom - relativeRect.top) / 2;
                        break;
                    }
                    case 32: {
                        ty = relativeRect.bottom;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            int t = model.DatumPoint & 7;
            switch (t) {
                case 0: 
                case 1: {
                    ttx = tx;
                    break;
                }
                case 2: {
                    ttx = tx - width / 2;
                    break;
                }
                case 4: {
                    ttx = tx - width;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            t = model.DatumPoint & 0x38;
            switch (t) {
                case 0: 
                case 8: {
                    tty = ty;
                    break;
                }
                case 16: {
                    tty = ty - height / 2;
                    break;
                }
                case 32: {
                    tty = ty - height;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            model.mDrawRect.offset(ttx, tty);
            int dx = model.OffsetX;
            int dy = model.OffsetY;
            model.mDrawRect.offset(dx, dy);
        }
    }
}

