/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security.ruleset;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DefaultRule;
import com.sun.deploy.security.ruleset.ExceptionRule;
import com.sun.deploy.security.ruleset.Rule;
import com.sun.deploy.security.ruleset.RuleAction;
import com.sun.deploy.security.ruleset.RuleId;
import com.sun.deploy.security.ruleset.RuleSetParser;
import com.sun.deploy.security.ruleset.RunRule;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class DeploymentRuleSet {
    public static final String XML_FILENAME = "ruleset.xml";
    private static Rule[] rules;
    private static DeploymentRuleSet defaultRule;
    private static DeploymentRuleSet exceptionRule;
    private static boolean isInitialized;
    private static Exception initializationException;
    private static HashMap drsMap;

    public abstract boolean isCaSignedNever();

    public abstract boolean isSelfSignedNever();

    public abstract boolean isSSVModeNever();

    public abstract boolean isRunLocalAppletsNever();

    public abstract boolean isRunUntrustedNever();

    public abstract boolean isRunUntrustedMultiClick();

    public abstract boolean isSSVModeMultiClick();

    public abstract boolean isRevocationCheckBestEffort();

    public abstract boolean isExpiredBlocked();

    public abstract boolean isPermissionsManifestRequired();

    public abstract boolean isAskGrantShowSet();

    public abstract boolean isAskGrantSelfSignedSet();

    public abstract boolean isRuleRun();

    public abstract boolean isRuleBlock();

    public abstract String getVersionString();

    public abstract String getBlockString();

    public abstract Exception getException();

    public abstract boolean isLiveConnectAllowedUnchecked();

    public static DeploymentRuleSet getDefault() {
        if (defaultRule == null) {
            defaultRule = new DefaultRule();
        }
        return defaultRule;
    }

    private static DeploymentRuleSet getExceptionRule() {
        if (exceptionRule == null) {
            exceptionRule = new ExceptionRule();
        }
        return exceptionRule;
    }

    private static DeploymentRuleSet getDefaultOrException(RuleId ruleId) {
        try {
            if (ruleId.isException() || Environment.isGlobalException()) {
                Trace.println("Exception List entry exists for: " + ruleId.location + "\nno DRS rule applies, returning " + "Exception Rule", TraceLevel.RULESET);
                return DeploymentRuleSet.getExceptionRule();
            }
            Trace.println("no rule applies, returning Default Rule", TraceLevel.RULESET);
            return DeploymentRuleSet.getDefault();
        }
        catch (BlockedException blockedException) {
            return new BlockRule(blockedException.getMessage(), blockedException);
        }
    }

    public static DeploymentRuleSet findDRS(RuleId ruleId) {
        DeploymentRuleSet deploymentRuleSet = (DeploymentRuleSet)drsMap.get(ruleId);
        if (deploymentRuleSet == null) {
            deploymentRuleSet = DeploymentRuleSet.getDRS(ruleId);
            drsMap.put(ruleId, deploymentRuleSet);
        }
        return deploymentRuleSet;
    }

    private static DeploymentRuleSet getDRS(RuleId ruleId) {
        Trace.println("finding Deployment Rule Set for " + ruleId, TraceLevel.RULESET);
        DeploymentRuleSet.initialize();
        if (initializationException != null) {
            Trace.println("Exception parsing deployment rule set " + initializationException, TraceLevel.RULESET);
            Trace.ignored(initializationException);
            String string = ResourceManager.getString("deployment.blocked.ruleset.exception");
            if (initializationException instanceof BlockedException) {
                string = initializationException.getMessage();
            }
            return new BlockRule(string, initializationException);
        }
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].getId().contains(ruleId)) continue;
            Trace.println("found matching id, using rule: " + rules[i], TraceLevel.RULESET);
            RuleAction ruleAction = rules[i].getAction();
            if (ruleAction.isRun()) {
                return new RunRule(ruleAction.getVersionString(), ruleAction.getBlockedMessage());
            }
            if (ruleAction.isBlock()) {
                return new BlockRule(ruleAction.getBlockedMessage(), null);
            }
            return DeploymentRuleSet.getDefaultOrException(ruleId);
        }
        return DeploymentRuleSet.getDefaultOrException(ruleId);
    }

    public static synchronized void initialize() {
        if (!isInitialized) {
            rules = new Rule[0];
            final File file = Config.getDRSFile();
            if (file != null && file.exists()) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            DeploymentRuleSet.verifyRuleSetFile(file);
                            JarFile jarFile = new JarFile(file, false);
                            JarEntry jarEntry = jarFile.getJarEntry(DeploymentRuleSet.XML_FILENAME);
                            if (jarEntry != null) {
                                RuleSetParser ruleSetParser = new RuleSetParser();
                                DeploymentRuleSet.access$002(ruleSetParser.parse(jarFile.getInputStream(jarEntry), (int)jarEntry.getSize()));
                            }
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    initializationException = privilegedActionException.getException();
                }
                catch (Exception exception) {
                    initializationException = exception;
                }
            }
            isInitialized = true;
        }
    }

    public static boolean isRuleSetFileExists() {
        File file = Config.getDRSFile();
        return file != null && file.exists();
    }

    public static boolean installRuleSetFile(File file) {
        File file2 = Config.getDRSFile();
        try {
            Cache.copyFile(file, file2);
            return true;
        }
        catch (Throwable throwable) {
            Trace.println("could not copy Deployment Rule Set file from " + file + " to " + file2, TraceLevel.RULESET);
            return true;
        }
    }

    public static void verifyRuleSetFile(File file) {
        String string = null;
        Exception exception = null;
        if (Config.isJavaVersionAtLeast16()) {
            try {
                Object object;
                CodeSigner[] codeSignerArray;
                JarFile jarFile = new JarFile(file);
                JarEntry jarEntry = jarFile.getJarEntry(XML_FILENAME);
                if (jarEntry == null) {
                    String string2 = ResourceManager.getMessage("deployment.invalid.ruleset");
                    throw new BlockedException(string2, null);
                }
                try {
                    codeSignerArray = jarFile.getInputStream(jarEntry);
                    object = new byte[1024];
                    int n = ((byte[])object).length;
                    while (n != -1) {
                        n = codeSignerArray.read((byte[])object, 0, ((byte[])object).length);
                    }
                    codeSignerArray.close();
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                codeSignerArray = jarEntry.getCodeSigners();
                object = file.toURI().toURL();
                CodeSource codeSource = new CodeSource((URL)object, codeSignerArray);
                boolean bl = false;
                ValidationState validationState = TrustDecider.getJarValidationState(codeSource, null, null);
                if (validationState.trustDecision == 0L) {
                    string = "deployment.cannot.validate";
                } else if (validationState.certValidity != 0) {
                    string = "deployment.cannot.validate";
                } else if (!validationState.rootCAValid) {
                    string = "deployment.cannot.validate.selfsigned";
                } else if (!validationState.timeValid) {
                    string = "deployment.cannot.validate.expired";
                    exception = validationState.certExpiredException != null ? validationState.certExpiredException : validationState.certNotYetValidException;
                }
            }
            catch (IOException iOException) {
                string = "deployment.cannot.validate.exception";
                exception = iOException;
            }
            if (string != null) {
                throw new BlockedException(ResourceManager.getMessage(string), exception);
            }
            Trace.println("verification succeeded for signed Deployment Rule Set file " + file, TraceLevel.RULESET);
        } else {
            Trace.println("Deployment Rule Set verification skipped - not running JDK6 or later", TraceLevel.RULESET);
        }
    }

    public String toString() {
        return "DeploymentRuleSet: generic";
    }

    static /* synthetic */ Rule[] access$002(Rule[] ruleArray) {
        rules = ruleArray;
        return ruleArray;
    }

    static {
        defaultRule = null;
        exceptionRule = null;
        isInitialized = false;
        initializationException = null;
        drsMap = new HashMap();
    }
}

