/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TableViewBehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.util.Callback;

public class TreeTableViewBehavior<T>
extends TableViewBehaviorBase<TreeTableView<T>, TreeItem<T>, TreeTableColumn<T, ?>> {
    private final ChangeListener<TreeTableView.TreeTableViewSelectionModel<T>> selectionModelListener = new ChangeListener<TreeTableView.TreeTableViewSelectionModel<T>>(){

        @Override
        public void changed(ObservableValue<? extends TreeTableView.TreeTableViewSelectionModel<T>> observableValue, TreeTableView.TreeTableViewSelectionModel<T> treeTableViewSelectionModel, TreeTableView.TreeTableViewSelectionModel<T> treeTableViewSelectionModel2) {
            if (treeTableViewSelectionModel != null) {
                treeTableViewSelectionModel.getSelectedCells().removeListener(TreeTableViewBehavior.this.weakSelectedCellsListener);
            }
            if (treeTableViewSelectionModel2 != null) {
                treeTableViewSelectionModel2.getSelectedCells().addListener(TreeTableViewBehavior.this.weakSelectedCellsListener);
            }
        }
    };
    private final WeakChangeListener<TreeTableView.TreeTableViewSelectionModel<T>> weakSelectionModelListener = new WeakChangeListener<TreeTableView.TreeTableViewSelectionModel<TreeTableView.TreeTableViewSelectionModel<T>>>(this.selectionModelListener);

    @Override
    protected void callAction(String string) {
        if ("ExpandRow".equals(string)) {
            this.rightArrowPressed();
        } else if ("CollapseRow".equals(string)) {
            this.leftArrowPressed();
        } else if ("ExpandAll".equals(string)) {
            this.expandAll();
        } else {
            super.callAction(string);
        }
    }

    public TreeTableViewBehavior(TreeTableView<T> treeTableView) {
        super(treeTableView);
        treeTableView.selectionModelProperty().addListener(this.weakSelectionModelListener);
        if (this.getSelectionModel() != null) {
            treeTableView.getSelectionModel().getSelectedCells().addListener(this.selectedCellsListener);
        }
    }

    @Override
    protected int getItemCount() {
        return ((TreeTableView)this.getControl()).getExpandedItemCount();
    }

    @Override
    protected TableFocusModel getFocusModel() {
        return ((TreeTableView)this.getControl()).getFocusModel();
    }

    @Override
    protected TableSelectionModel<TreeItem<T>> getSelectionModel() {
        return ((TreeTableView)this.getControl()).getSelectionModel();
    }

    @Override
    protected ObservableList<TreeTablePosition<T, ?>> getSelectedCells() {
        return ((TreeTableView)this.getControl()).getSelectionModel().getSelectedCells();
    }

    @Override
    protected TablePositionBase getFocusedCell() {
        return ((TreeTableView)this.getControl()).getFocusModel().getFocusedCell();
    }

    @Override
    protected int getVisibleLeafIndex(TableColumnBase tableColumnBase) {
        return ((TreeTableView)this.getControl()).getVisibleLeafIndex((TreeTableColumn)tableColumnBase);
    }

    @Override
    protected TreeTableColumn getVisibleLeafColumn(int n) {
        return ((TreeTableView)this.getControl()).getVisibleLeafColumn(n);
    }

    @Override
    protected void editCell(int n, TableColumnBase tableColumnBase) {
        ((TreeTableView)this.getControl()).edit(n, (TreeTableColumn)tableColumnBase);
    }

    @Override
    protected ObservableList<TreeTableColumn<T, ?>> getVisibleLeafColumns() {
        return ((TreeTableView)this.getControl()).getVisibleLeafColumns();
    }

    @Override
    protected TablePositionBase<TreeTableColumn<T, ?>> getTablePosition(int n, TableColumnBase<TreeItem<T>, ?> tableColumnBase) {
        return new TreeTablePosition((TreeTableView)this.getControl(), n, (TreeTableColumn)tableColumnBase);
    }

    @Override
    protected void selectAllToFocus(boolean bl) {
        if (((TreeTableView)this.getControl()).getEditingCell() != null) {
            return;
        }
        super.selectAllToFocus(bl);
    }

    private void rightArrowPressed() {
        if (((TreeTableView)this.getControl()).getSelectionModel().isCellSelectionEnabled()) {
            this.selectRightCell();
        } else {
            this.expandRow();
        }
    }

    private void leftArrowPressed() {
        if (((TreeTableView)this.getControl()).getSelectionModel().isCellSelectionEnabled()) {
            this.selectLeftCell();
        } else {
            this.collapseRow();
        }
    }

    private void expandRow() {
        Callback callback = new Callback<TreeItem<T>, Integer>(){

            @Override
            public Integer call(TreeItem<T> treeItem) {
                return ((TreeTableView)TreeTableViewBehavior.this.getControl()).getRow(treeItem);
            }
        };
        TreeViewBehavior.expandRow(((TreeTableView)this.getControl()).getSelectionModel(), callback);
    }

    private void expandAll() {
        TreeViewBehavior.expandAll(((TreeTableView)this.getControl()).getRoot());
    }

    private void collapseRow() {
        TreeTableView treeTableView = (TreeTableView)this.getControl();
        TreeViewBehavior.collapseRow(treeTableView.getSelectionModel(), treeTableView.getRoot(), treeTableView.isShowRoot());
    }

    static {
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.LEFT, "CollapseRow"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.KP_LEFT, "CollapseRow"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.RIGHT, "ExpandRow"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.KP_RIGHT, "ExpandRow"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.MULTIPLY, "ExpandAll"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.ADD, "ExpandRow"));
        TABLE_VIEW_BINDINGS.add(0, new KeyBinding(KeyCode.SUBTRACT, "CollapseRow"));
    }
}

