/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public abstract class TableCellBehaviorBase<S, T, TC extends TableColumnBase<S, ?>, C extends IndexedCell<T>>
extends CellBehaviorBase<C> {
    private static final String ANCHOR_PROPERTY_KEY = "table.anchor";
    private boolean latePress = false;
    private boolean wasSelected = false;

    static TablePositionBase getAnchor(Control control, TablePositionBase tablePositionBase) {
        return TableCellBehaviorBase.hasAnchor(control) ? (TablePositionBase)control.getProperties().get(ANCHOR_PROPERTY_KEY) : tablePositionBase;
    }

    static void setAnchor(Control control, TablePositionBase tablePositionBase) {
        if (control != null && tablePositionBase == null) {
            TableCellBehaviorBase.removeAnchor(control);
        } else {
            control.getProperties().put(ANCHOR_PROPERTY_KEY, tablePositionBase);
        }
    }

    static boolean hasAnchor(Control control) {
        return control.getProperties().get(ANCHOR_PROPERTY_KEY) != null;
    }

    static void removeAnchor(Control control) {
        control.getProperties().remove(ANCHOR_PROPERTY_KEY);
    }

    public TableCellBehaviorBase(C c) {
        super(c, (List<KeyBinding>)Collections.EMPTY_LIST);
    }

    abstract Control getTableControl();

    abstract TableColumnBase<S, T> getTableColumn();

    abstract int getItemCount();

    abstract TableSelectionModel<S> getSelectionModel();

    abstract TableFocusModel<S, TC> getFocusModel();

    abstract TablePositionBase getFocusedCell();

    abstract boolean isTableRowSelected();

    abstract TableColumnBase<S, T> getVisibleLeafColumn(int var1);

    protected abstract int getVisibleLeafIndex(TableColumnBase<S, T> var1);

    abstract void focus(int var1, TableColumnBase<S, T> var2);

    abstract void edit(int var1, TableColumnBase<S, T> var2);

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = this.isSelected();
        if (this.isSelected()) {
            this.latePress = true;
            return;
        }
        this.doSelect(mouseEvent);
        if (IS_TOUCH_SUPPORTED && bl) {
            this.wasSelected = this.isSelected();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.latePress) {
            this.latePress = false;
            this.doSelect(mouseEvent);
        }
        this.wasSelected = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latePress = false;
        if (IS_TOUCH_SUPPORTED && !this.wasSelected && this.isSelected()) {
            this.getSelectionModel().clearSelection(((IndexedCell)this.getControl()).getIndex());
        }
    }

    private void doSelect(MouseEvent mouseEvent) {
        MouseButton mouseButton;
        IndexedCell indexedCell = (IndexedCell)this.getControl();
        if (!indexedCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        Control control = this.getTableControl();
        if (control == null) {
            return;
        }
        int n = this.getItemCount();
        if (indexedCell.getIndex() >= n) {
            return;
        }
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return;
        }
        boolean bl = this.isSelected();
        int n2 = indexedCell.getIndex();
        int n3 = this.getColumn();
        TableColumnBase<S, T> tableColumnBase = this.getTableColumn();
        TableFocusModel<S, TableColumnBase<S, T>> tableFocusModel = this.getFocusModel();
        if (tableFocusModel == null) {
            return;
        }
        TablePositionBase tablePositionBase = this.getFocusedCell();
        boolean bl2 = this.checkDisclosureNodeClick(mouseEvent);
        if (bl2) {
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!TableCellBehaviorBase.hasAnchor(control)) {
                TableCellBehaviorBase.setAnchor(control, tablePositionBase);
            }
        } else {
            TableCellBehaviorBase.removeAnchor(control);
        }
        if ((mouseButton = mouseEvent.getButton()) == MouseButton.PRIMARY || mouseButton == MouseButton.SECONDARY && !bl) {
            if (tableSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(mouseEvent);
            } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
                if (bl) {
                    tableSelectionModel.clearSelection(n2, tableColumnBase);
                    tableFocusModel.focus(n2, tableColumnBase);
                } else {
                    tableSelectionModel.select(n2, tableColumnBase);
                }
            } else if (mouseEvent.isShiftDown()) {
                TableColumnBase<S, T> tableColumnBase2;
                TablePositionBase tablePositionBase2 = TableCellBehaviorBase.getAnchor(control, tablePositionBase);
                int n4 = tablePositionBase2.getRow();
                boolean bl3 = n4 < n2;
                int n5 = Math.min(tablePositionBase2.getRow(), n2);
                int n6 = Math.max(tablePositionBase2.getRow(), n2);
                TableColumnBase<S, T> tableColumnBase3 = tablePositionBase2.getColumn() < n3 ? tablePositionBase2.getTableColumn() : tableColumnBase;
                TableColumnBase<S, T> tableColumnBase4 = tableColumnBase2 = tablePositionBase2.getColumn() >= n3 ? tablePositionBase2.getTableColumn() : tableColumnBase;
                if (tableSelectionModel.isCellSelectionEnabled()) {
                    tableSelectionModel.clearSelection();
                    tableSelectionModel.selectRange(n5, tableColumnBase3, n6, tableColumnBase2);
                } else {
                    ArrayList arrayList = new ArrayList(tableSelectionModel.getSelectedIndices());
                    int n7 = arrayList.size();
                    for (int i = 0; i < n7; ++i) {
                        int n8 = (Integer)arrayList.get(i);
                        if (n8 >= n5 && n8 <= n6) continue;
                        tableSelectionModel.clearSelection(n8);
                    }
                    if (n5 == n6) {
                        tableSelectionModel.select(n5);
                    } else if (bl3) {
                        tableSelectionModel.selectRange(n5, n6 + 1);
                    } else {
                        tableSelectionModel.selectRange(n6, n5 - 1);
                    }
                }
            } else {
                this.simpleSelect(mouseEvent);
            }
        }
    }

    protected void simpleSelect(MouseEvent mouseEvent) {
        TableColumnBase<S, T> tableColumnBase;
        int n;
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        boolean bl = tableSelectionModel.isSelected(n = ((IndexedCell)this.getControl()).getIndex(), tableColumnBase = this.getTableColumn());
        if (bl && (mouseEvent.isControlDown() || mouseEvent.isMetaDown())) {
            tableSelectionModel.clearSelection(n, tableColumnBase);
            bl = false;
        } else {
            tableSelectionModel.clearAndSelect(n, tableColumnBase);
        }
        if (mouseEvent.getButton() == MouseButton.PRIMARY) {
            if (mouseEvent.getClickCount() == 1 && bl) {
                this.edit(n, tableColumnBase);
            } else if (mouseEvent.getClickCount() == 1) {
                this.edit(-1, null);
            } else if (mouseEvent.getClickCount() == 2 && ((IndexedCell)this.getControl()).isEditable()) {
                this.edit(n, tableColumnBase);
            }
        }
    }

    protected boolean checkDisclosureNodeClick(MouseEvent mouseEvent) {
        return false;
    }

    private int getColumn() {
        if (this.getSelectionModel().isCellSelectionEnabled()) {
            TableColumnBase<S, T> tableColumnBase = this.getTableColumn();
            return this.getVisibleLeafIndex(tableColumnBase);
        }
        return -1;
    }

    private boolean isSelected() {
        TableSelectionModel<S> tableSelectionModel = this.getSelectionModel();
        if (tableSelectionModel == null) {
            return false;
        }
        if (tableSelectionModel.isCellSelectionEnabled()) {
            IndexedCell indexedCell = (IndexedCell)this.getControl();
            return indexedCell.isSelected();
        }
        return this.isTableRowSelected();
    }
}

