/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.accessible.win;

import com.sun.glass.ui.Window;
import com.sun.glass.ui.accessible.AccessibleLogger;
import com.sun.glass.ui.accessible.AccessibleRoot;
import com.sun.glass.ui.accessible.win.WinAccessibleBaseProvider;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import java.util.HashMap;

public final class WinAccessibleRoot
extends AccessibleRoot {
    private static final HashMap<Integer, NavigateDirection> directionMap = new HashMap();
    private long hwnd;
    private long nativeAccessible = this._createAccessible();

    private static native void _initIDs();

    private native long _createAccessible();

    private native void _setAccessibilityInitIsComplete(long var1, long var3);

    private native void _destroyAccessible(long var1);

    private native void _fireEvent(long var1, int var3);

    public WinAccessibleRoot(Object object, Window window) {
        super(object);
        this.hwnd = window.getNativeWindow();
    }

    long getNativeAccessible() {
        return this.nativeAccessible;
    }

    @Override
    public void setAccessibilityInitIsComplete() {
        this._setAccessibilityInitIsComplete(this.hwnd, this.nativeAccessible);
    }

    @Override
    public void destroyAccessible() {
        if (this.nativeAccessible != 0L) {
            this._destroyAccessible(this.nativeAccessible);
        }
    }

    @Override
    public void fireEvent(int n) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("eventID: " + n);
        this._fireEvent(this.nativeAccessible, n);
    }

    private long getHostHwnd() {
        AccessibleLogger.getLogger().fine("Returning hwnd: " + Long.toHexString(this.hwnd));
        return this.hwnd;
    }

    private long navigate(int n) {
        AccessibleLogger.getLogger().fine("direction: " + (Object)((Object)directionMap.get(n)));
        Object object = ((AccessibleProvider)this.node).navigate(directionMap.get(n));
        if (object == null) {
            AccessibleLogger.getLogger().fine("No object in that direction.");
            return 0L;
        }
        long l = ((WinAccessibleBaseProvider)object).getNativeAccessible();
        AccessibleLogger.getLogger().fine("nativeTarget:  " + Long.toHexString(l));
        return l;
    }

    static {
        WinAccessibleRoot._initIDs();
        for (NavigateDirection navigateDirection : NavigateDirection.values()) {
            directionMap.put(navigateDirection.ordinal(), navigateDirection);
        }
    }
}

