/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.accessible.win;

import com.sun.glass.ui.accessible.AccessibleBasePatternProvider;
import com.sun.glass.ui.accessible.AccessibleBaseProvider;
import com.sun.glass.ui.accessible.AccessibleLogger;
import com.sun.glass.ui.accessible.win.WinAccessibleBasePatternProvider;
import com.sun.glass.ui.accessible.win.WinAccessibleRoot;
import com.sun.javafx.accessible.providers.AccessibleProvider;
import com.sun.javafx.accessible.utils.NavigateDirection;
import java.util.HashMap;
import sun.util.logging.PlatformLogger;

public final class WinAccessibleBaseProvider
extends AccessibleBaseProvider {
    private static final HashMap<Integer, NavigateDirection> directionMap = new HashMap();
    private long nativeAccessible = this._createAccessible();

    private static native void _initIDs();

    private native long _createAccessible();

    private native void _destroyAccessible(long var1);

    private native void _fireEvent(long var1, int var3);

    private native void _firePropertyChange(long var1, int var3, int var4, int var5);

    private native void _firePropertyChange(long var1, int var3, boolean var4, boolean var5);

    public WinAccessibleBaseProvider(Object object) {
        super(object);
    }

    long getNativeAccessible() {
        return this.nativeAccessible;
    }

    @Override
    public void destroyAccessible() {
        this._destroyAccessible(this.nativeAccessible);
    }

    @Override
    public void fireEvent(int n) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("eventID: " + n);
        this._fireEvent(this.nativeAccessible, n);
    }

    @Override
    public void firePropertyChange(int n, int n2, int n3) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("propertyID: " + n);
        AccessibleLogger.getLogger().fine("old: " + n2);
        AccessibleLogger.getLogger().fine("new: " + n3);
        this._firePropertyChange(this.nativeAccessible, n, n2, n3);
    }

    @Override
    public void firePropertyChange(int n, boolean bl, boolean bl2) {
        AccessibleLogger.getLogger().fine("this: " + this);
        AccessibleLogger.getLogger().fine("nativeAccessible: " + Long.toHexString(this.nativeAccessible));
        AccessibleLogger.getLogger().fine("propertyID: " + n);
        AccessibleLogger.getLogger().fine("old: " + bl);
        AccessibleLogger.getLogger().fine("new: " + bl2);
        this._firePropertyChange(this.nativeAccessible, n, bl, bl2);
    }

    private long getFragmentRoot() {
        WinAccessibleRoot winAccessibleRoot = (WinAccessibleRoot)((AccessibleProvider)this.node).fragmentRoot();
        if (winAccessibleRoot == null) {
            return 0L;
        }
        long l = winAccessibleRoot.getNativeAccessible();
        AccessibleLogger.getLogger().fine("nativeRoot:  " + Long.toHexString(l));
        return l;
    }

    private long navigate(int n) {
        AccessibleLogger.getLogger().fine("direction: " + (Object)((Object)directionMap.get(n)));
        Object object = ((AccessibleProvider)this.node).navigate(directionMap.get(n));
        long l = 0L;
        if (object == null) {
            AccessibleLogger.getLogger().fine("No object in that direction.");
        } else {
            if (object instanceof WinAccessibleBaseProvider) {
                l = ((WinAccessibleBaseProvider)object).getNativeAccessible();
            } else if (object instanceof WinAccessibleRoot) {
                l = ((WinAccessibleRoot)object).getNativeAccessible();
            }
            if (l != 0L) {
                AccessibleLogger.getLogger().fine("nativeTarget:  " + Long.toHexString(l));
            }
        }
        return l;
    }

    private long getPatternProvider(int n) {
        long l = 0L;
        PlatformLogger platformLogger = AccessibleLogger.getLogger();
        platformLogger.fine("id: " + n);
        for (AccessibleBasePatternProvider accessibleBasePatternProvider : this.patternProviders) {
            platformLogger.fine("pattern.id" + ((WinAccessibleBasePatternProvider)accessibleBasePatternProvider).getPatternId());
            if (accessibleBasePatternProvider.getPatternId() != n || !(accessibleBasePatternProvider instanceof WinAccessibleBasePatternProvider)) continue;
            platformLogger.fine("Found matching id: " + n);
            platformLogger.fine("returning: " + ((WinAccessibleBasePatternProvider)accessibleBasePatternProvider).getNativeAccessible());
            l = ((WinAccessibleBasePatternProvider)accessibleBasePatternProvider).getNativeAccessible();
        }
        return l;
    }

    static {
        WinAccessibleBaseProvider._initIDs();
        for (NavigateDirection navigateDirection : NavigateDirection.values()) {
            directionMap.put(navigateDirection.ordinal(), navigateDirection);
        }
    }
}

