/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.DataType;
import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BIPUSH;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConstants;
import com.sun.org.apache.bcel.internal.generic.InstructionFactory;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.LDC;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.SIPUSH;
import com.sun.org.apache.bcel.internal.generic.Type;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Map;
import oracle.jrockit.jfr.JFRImpl;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.Bits;
import oracle.jrockit.jfr.events.ContentTypeImpl;
import oracle.jrockit.jfr.events.DynamicValueDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.EventHandlerImpl;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.RequestableEventEnvironment;
import oracle.jrockit.jfr.events.ValueDescriptor;

@Deprecated
public final class EventHandlerCreator {
    private final ObjectType byteBufferType = new ObjectType(ByteBuffer.class.getName());
    private final ObjectType jfrImplType = new ObjectType(JFRImpl.class.getName());
    private final ObjectType eventDescType = new ObjectType(JavaEventDescriptor.class.getName());
    private final ObjectType threadType = new ObjectType(Thread.class.getName());
    private final ObjectType stringType = new ObjectType(String.class.getName());
    private final ObjectType classType = new ObjectType(Class.class.getName());
    private final ObjectType objectType = new ObjectType(Object.class.getName());
    private final ObjectType reqEnvType = new ObjectType(RequestableEventEnvironment.class.getName());
    private final ArrayType poolsType = new ArrayType(StringConstantPool.class.getName(), 1);
    private final String utilName = Bits.class.getName();
    private final JFRImpl jfr;
    private final String name;
    private final JavaEventDescriptor descriptor;
    private final RequestableEventEnvironment requestEnv;
    private final Class<?> receiverClass;
    private final ObjectType receiverType;
    private final Map<String, StringConstantPool> pools;
    private final ArrayList<StringConstantPool> usedPools = new ArrayList();
    private static final File classDir;
    private static final Object workaroundSync;
    private InvokeInstruction put;
    private InvokeInstruction putInt;
    private InvokeInstruction putChar;
    private InvokeInstruction putShort;
    private InvokeInstruction putDouble;
    private InvokeInstruction putFloat;
    private InvokeInstruction putLong;

    public EventHandlerCreator(JFRImpl jFRImpl, JavaEventDescriptor javaEventDescriptor, Class<?> clazz, Map<String, StringConstantPool> map, RequestableEventEnvironment requestableEventEnvironment) {
        this.name = "oracle.jrockit.jfr.events.GeneratedEventHandler" + javaEventDescriptor.getId();
        this.descriptor = javaEventDescriptor;
        this.receiverClass = clazz;
        this.receiverType = new ObjectType(clazz.getName());
        this.jfr = jFRImpl;
        this.pools = map;
        this.requestEnv = requestableEventEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] generateBytes() {
        ClassGen classGen = new ClassGen(this.name, EventHandlerImpl.class.getName(), "<generated>", 32, null);
        InstructionFactory instructionFactory = new InstructionFactory(classGen);
        Object object = workaroundSync;
        synchronized (object) {
            this.generateConstructor(classGen, instructionFactory);
            this.generateWrite(classGen, instructionFactory);
        }
        return classGen.getJavaClass().getBytes();
    }

    private final Class<? extends EventHandlerImpl> generateClass() {
        Serializable serializable;
        final byte[] byArray = this.generateBytes();
        if (classDir != null) {
            serializable = new File(classDir, this.getName().concat(".class"));
            try (DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream((File)serializable));){
                dataOutputStream.write(byArray);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        serializable = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                return new EventInfoClassLoader(EventHandlerCreator.this.descriptor.getEventClass().getClassLoader()).defineClass(EventHandlerCreator.this.getName(), byArray);
            }
        });
        return ((Class)serializable).asSubclass(EventHandlerImpl.class);
    }

    public EventHandler createHandler() throws InvalidEventDefinitionException {
        Constructor<? extends EventHandlerImpl> constructor;
        Class<? extends EventHandlerImpl> clazz = this.generateClass();
        try {
            constructor = clazz.getConstructor(JFRImpl.class, JavaEventDescriptor.class, StringConstantPool[].class, RequestableEventEnvironment.class);
        }
        catch (Exception exception) {
            throw (Error)new InternalError(this.descriptor.getName()).initCause(exception);
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                constructor.setAccessible(true);
                return null;
            }
        });
        try {
            StringConstantPool[] stringConstantPoolArray = this.usedPools.isEmpty() ? null : this.usedPools.toArray(new StringConstantPool[this.usedPools.size()]);
            return constructor.newInstance(this.jfr, this.descriptor, stringConstantPoolArray, this.requestEnv);
        }
        catch (Throwable throwable) {
            throw new InvalidEventDefinitionException(this.descriptor.getName(), throwable);
        }
    }

    private void generateConstructor(ClassGen classGen, InstructionFactory instructionFactory) {
        ConstantPoolGen constantPoolGen = classGen.getConstantPool();
        InstructionList instructionList = new InstructionList();
        MethodGen methodGen = new MethodGen(1, Type.VOID, new Type[]{this.jfrImplType, this.eventDescType, this.poolsType, this.reqEnvType}, null, "<init>", classGen.getClassName(), instructionList, constantPoolGen);
        instructionList.append(new ALOAD(0));
        instructionList.append(new ALOAD(1));
        instructionList.append(new ALOAD(2));
        instructionList.append(new ALOAD(3));
        instructionList.append(new ALOAD(4));
        instructionList.append(instructionFactory.createInvoke(EventHandlerImpl.class.getName(), "<init>", Type.VOID, new Type[]{this.jfrImplType, this.eventDescType, this.poolsType, this.reqEnvType}, (short)183));
        instructionList.append(InstructionConstants.RETURN);
        methodGen.setMaxStack();
        methodGen.setMaxLocals();
        classGen.addMethod(methodGen.getMethod());
        instructionList.dispose();
    }

    private Instruction pushInt(ConstantPoolGen constantPoolGen, int n) {
        if (n <= 5 && n >= -1) {
            return new BIPUSH((byte)n);
        }
        if (n >= Short.MIN_VALUE && n < Short.MAX_VALUE) {
            return new SIPUSH((short)n);
        }
        return new LDC(constantPoolGen.addInteger(n));
    }

    private void generateWrite(ClassGen classGen, InstructionFactory instructionFactory) {
        Class<?> clazz;
        ConstantPoolGen constantPoolGen = classGen.getConstantPool();
        InstructionList instructionList = new InstructionList();
        MethodGen methodGen = new MethodGen(17, Type.VOID, new Type[]{this.objectType, Type.LONG, Type.LONG}, null, "write", classGen.getClassName(), instructionList, constantPoolGen);
        this.initPuts(instructionFactory);
        boolean bl = false;
        int n = 0;
        ALOAD aLOAD = new ALOAD(n++);
        ALOAD aLOAD2 = new ALOAD(n++);
        LLOAD lLOAD = new LLOAD(n++);
        int n2 = ++n;
        ++n;
        LLOAD lLOAD2 = new LLOAD(n2);
        ILOAD iLOAD = new ILOAD(++n);
        ISTORE iSTORE = new ISTORE(n++);
        ALOAD aLOAD3 = new ALOAD(n);
        ASTORE aSTORE = new ASTORE(n++);
        ALOAD aLOAD4 = new ALOAD(n);
        ASTORE aSTORE2 = new ASTORE(n++);
        ALOAD aLOAD5 = new ALOAD(n);
        ASTORE aSTORE3 = new ASTORE(n++);
        int n3 = 16;
        if (this.descriptor.hasStartTime()) {
            n3 += 8;
        }
        if (this.descriptor.hasThread()) {
            n3 += ContentTypeImpl.OSTHREAD.getType().getSize();
        }
        if (this.descriptor.hasStackTrace()) {
            n3 += ContentTypeImpl.STACKTRACE.getType().getSize();
        }
        instructionList.append(aLOAD2);
        instructionList.append(instructionFactory.createCast(this.objectType, this.receiverType));
        instructionList.append(aSTORE);
        instructionList.append(aLOAD);
        instructionList.append(instructionFactory.createGetField(EventHandlerImpl.class.getName(), "jfr", this.jfrImplType));
        instructionList.append(instructionFactory.createCast(this.jfrImplType, new ObjectType(this.jfr.getClass().getName())));
        instructionList.append(aSTORE2);
        int n4 = n;
        block8: for (ValueDescriptor object2 : this.descriptor.getValues()) {
            String string;
            Class<Object> instructionHandle2 = object2.getValueType();
            int n5 = 0;
            if (instructionHandle2 == String.class && (string = object2.getConstantPool()) != null && (clazz = this.pools.get(string)) != null) {
                StringConstantPool stringConstantPool;
                int n6;
                for (n6 = 0; n6 < this.usedPools.size() && (stringConstantPool = this.usedPools.get(n6)) != clazz; ++n6) {
                }
                if (n6 == this.usedPools.size()) {
                    this.usedPools.add((StringConstantPool)((Object)clazz));
                }
                n5 = 1;
                instructionList.append(aLOAD);
                instructionList.append(instructionFactory.createGetField(EventHandlerImpl.class.getName(), "pools", this.poolsType));
                instructionList.append(this.pushInt(constantPoolGen, n6));
                instructionList.append(InstructionConstants.AALOAD);
            }
            this.generateGetValue(classGen, constantPoolGen, instructionList, instructionFactory, object2, aLOAD3);
            if (instructionHandle2 == String.class && n5 != 0) {
                instructionList.append(instructionFactory.createInvoke(StringConstantPool.class.getName(), "asConstant", Type.INT, new Type[]{Type.STRING}, (short)182));
                instructionHandle2 = Integer.TYPE;
            }
            if (instructionHandle2 == String.class) {
                instructionList.append(InstructionConstants.DUP);
                instructionList.append(new ASTORE(n++));
                instructionList.append(instructionFactory.createInvoke(this.utilName, "length", Type.INT, new Type[]{this.stringType}, (short)184));
                if (bl) {
                    instructionList.append(iLOAD);
                    instructionList.append(InstructionFactory.createBinaryOperation("+", Type.INT));
                }
                instructionList.append(iSTORE);
                n3 += 4;
                bl = true;
                continue;
            }
            if (instructionHandle2 == Thread.class) {
                assert (ContentTypeImpl.JAVATHREAD.getType() == DataType.LONG);
                instructionList.append(instructionFactory.createInvoke(this.utilName, "threadID", Type.LONG, new Type[]{this.threadType}, (short)184));
                instructionList.append(new LSTORE(n++));
                ++n;
                n3 += 8;
                continue;
            }
            if (instructionHandle2 == Class.class) {
                instructionList.append(aLOAD4);
                instructionList.append(InstructionConstants.SWAP);
                assert (ContentTypeImpl.CLASS.getType() == DataType.U8);
                instructionList.append(instructionFactory.createInvoke(this.jfr.getClass().getName(), "classID", Type.LONG, new Type[]{this.classType}, (short)182));
                instructionList.append(new LSTORE(n++));
                ++n;
                n3 += 8;
                continue;
            }
            Type type = this.typeOf(instructionHandle2);
            switch (type.getType()) {
                case 7: {
                    instructionList.append(new DSTORE(n++));
                    ++n;
                    n3 += 8;
                    continue block8;
                }
                case 11: {
                    instructionList.append(new LSTORE(n++));
                    ++n;
                    n3 += 8;
                    continue block8;
                }
                case 6: {
                    instructionList.append(new FSTORE(n++));
                    n3 += 4;
                    continue block8;
                }
                case 10: {
                    instructionList.append(new ISTORE(n++));
                    n3 += 4;
                    continue block8;
                }
                case 5: 
                case 9: {
                    instructionList.append(new ISTORE(n++));
                    n3 += 2;
                    continue block8;
                }
                case 4: 
                case 8: {
                    instructionList.append(new ISTORE(n++));
                    ++n3;
                    continue block8;
                }
                default: {
                    throw new InternalError(type.getSignature());
                }
            }
        }
        instructionList.append(this.pushInt(constantPoolGen, n3));
        if (bl) {
            instructionList.append(iLOAD);
            instructionList.append(InstructionFactory.createBinaryOperation("+", Type.INT));
        }
        instructionList.append(iSTORE);
        int n7 = 0;
        int n8 = 0;
        if (this.descriptor.hasThread()) {
            n7 = n++;
            instructionList.append(aLOAD4);
            instructionList.append(instructionFactory.createInvoke(this.jfr.getClass().getName(), "threadID", Type.INT, Type.NO_ARGS, (short)182));
            instructionList.append(new ISTORE(n7));
        }
        if (this.descriptor.hasStackTrace()) {
            n8 = n++;
            ++n;
            instructionList.append(aLOAD);
            instructionList.append(instructionFactory.createInvoke(EventHandlerImpl.class.getName(), "stackTraceID", Type.LONG, Type.NO_ARGS, (short)182));
            instructionList.append(new LSTORE(n8));
        }
        instructionList.append(aLOAD4);
        instructionList.append(iLOAD);
        instructionList.append(instructionFactory.createInvoke(JFRImpl.class.getName(), "getThreadBuffer", this.byteBufferType, new Type[]{Type.INT}, (short)182));
        instructionList.append(InstructionConstants.DUP);
        InstructionHandle instructionHandle = instructionList.append(aSTORE3);
        this.put(instructionList, instructionFactory, (Type)Type.INT, iLOAD);
        this.put(instructionList, instructionFactory, (Type)Type.INT, this.pushInt(constantPoolGen, this.descriptor.getId()));
        this.put(instructionList, instructionFactory, (Type)Type.LONG, lLOAD2);
        if (this.descriptor.hasStartTime()) {
            this.put(instructionList, instructionFactory, (Type)Type.LONG, lLOAD);
        }
        if (n7 != 0) {
            this.put(instructionList, instructionFactory, (Type)Type.INT, new ILOAD(n7));
        }
        if (n8 != 0) {
            this.put(instructionList, instructionFactory, (Type)Type.LONG, new LLOAD(n8));
        }
        n = n4;
        for (ValueDescriptor valueDescriptor : this.descriptor.getValues()) {
            clazz = valueDescriptor.getValueType();
            if (clazz == String.class) {
                String string = valueDescriptor.getConstantPool();
                if (string != null && this.pools.get(string) != null) {
                    n = this.put(instructionList, instructionFactory, this.typeOf(Integer.TYPE), n);
                    continue;
                }
                this.putString(instructionList, instructionFactory, new ALOAD(n++));
                continue;
            }
            if (clazz == Thread.class || clazz == Class.class) {
                this.put(instructionList, instructionFactory, (Type)Type.LONG, new LLOAD(n++));
                ++n;
                continue;
            }
            n = this.put(instructionList, instructionFactory, this.typeOf(clazz), n);
        }
        InvokeInstruction invokeInstruction = instructionFactory.createInvoke(JFRImpl.class.getName(), "releaseThreadBuffer", Type.VOID, new Type[]{this.byteBufferType, Type.BOOLEAN}, (short)182);
        InstructionHandle instructionHandle2 = instructionList.getEnd();
        instructionList.append(InstructionConstants.POP);
        instructionList.append(aLOAD4);
        instructionList.append(aLOAD5);
        instructionList.append(this.pushInt(constantPoolGen, 1));
        instructionList.append(invokeInstruction);
        instructionList.append(InstructionConstants.RETURN);
        InstructionHandle instructionHandle3 = instructionList.append(aLOAD4);
        instructionList.append(aLOAD5);
        instructionList.append(this.pushInt(constantPoolGen, 0));
        instructionList.append(invokeInstruction);
        instructionList.append(InstructionConstants.ATHROW);
        methodGen.addExceptionHandler(instructionHandle.getNext(), instructionHandle2, instructionHandle3, null);
        methodGen.setMaxStack();
        methodGen.setMaxLocals();
        classGen.addMethod(methodGen.getMethod());
        instructionList.dispose();
    }

    private void initPuts(InstructionFactory instructionFactory) {
        this.put = instructionFactory.createInvoke(ByteBuffer.class.getName(), "put", this.byteBufferType, new Type[]{Type.BYTE}, (short)182);
        this.putInt = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putInt", this.byteBufferType, new Type[]{Type.INT}, (short)182);
        this.putLong = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putLong", this.byteBufferType, new Type[]{Type.LONG}, (short)182);
        this.putChar = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putChar", this.byteBufferType, new Type[]{Type.CHAR}, (short)182);
        this.putDouble = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putDouble", this.byteBufferType, new Type[]{Type.DOUBLE}, (short)182);
        this.putFloat = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putFloat", this.byteBufferType, new Type[]{Type.FLOAT}, (short)182);
        this.putShort = instructionFactory.createInvoke(ByteBuffer.class.getName(), "putShort", this.byteBufferType, new Type[]{Type.SHORT}, (short)182);
    }

    private void put(InstructionList instructionList, InstructionFactory instructionFactory, Type type, Instruction instruction) {
        instructionList.append(instruction);
        switch (type.getType()) {
            case 11: {
                instructionList.append(this.putLong);
                break;
            }
            case 6: {
                instructionList.append(this.putFloat);
                break;
            }
            case 7: {
                instructionList.append(this.putDouble);
                break;
            }
            case 10: {
                instructionList.append(this.putInt);
                break;
            }
            case 9: {
                instructionList.append(this.putShort);
                break;
            }
            case 5: {
                instructionList.append(this.putChar);
                break;
            }
            case 4: 
            case 8: {
                instructionList.append(this.put);
                break;
            }
            default: {
                throw new InternalError(type.getSignature());
            }
        }
    }

    private void putString(InstructionList instructionList, InstructionFactory instructionFactory, Instruction instruction) {
        instructionList.append(InstructionConstants.DUP);
        instructionList.append(instruction);
        instructionList.append(instructionFactory.createInvoke(this.utilName, "write", Type.VOID, new Type[]{this.byteBufferType, this.stringType}, (short)184));
    }

    private int put(InstructionList instructionList, InstructionFactory instructionFactory, Type type, int n) {
        switch (type.getType()) {
            case 11: {
                this.put(instructionList, instructionFactory, type, new LLOAD(n));
                return n + 2;
            }
            case 7: {
                this.put(instructionList, instructionFactory, type, new DLOAD(n));
                return n + 2;
            }
            case 6: {
                this.put(instructionList, instructionFactory, type, new FLOAD(n));
                return n + 1;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                this.put(instructionList, instructionFactory, type, new ILOAD(n));
                return n + 1;
            }
        }
        throw new InternalError(type.getSignature());
    }

    private Type typeOf(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            assert (clazz == String.class || clazz == Thread.class || clazz == Class.class);
            return new ObjectType(clazz.getName());
        }
        if (clazz == Integer.TYPE) {
            return Type.INT;
        }
        if (clazz == Short.TYPE) {
            return Type.SHORT;
        }
        if (clazz == Character.TYPE) {
            return Type.CHAR;
        }
        if (clazz == Boolean.TYPE) {
            return Type.BOOLEAN;
        }
        if (clazz == Long.TYPE) {
            return Type.LONG;
        }
        if (clazz == Float.TYPE) {
            return Type.FLOAT;
        }
        if (clazz == Double.TYPE) {
            return Type.DOUBLE;
        }
        if (clazz == Byte.TYPE) {
            return Type.BYTE;
        }
        throw new InternalError(clazz.getName());
    }

    private Type generateGetValue(ClassGen classGen, ConstantPoolGen constantPoolGen, InstructionList instructionList, InstructionFactory instructionFactory, ValueDescriptor valueDescriptor, ALOAD aLOAD) {
        Class<?> clazz = valueDescriptor.getValueType();
        Field field = valueDescriptor.getField();
        Type type = this.typeOf(clazz);
        instructionList.append(aLOAD);
        if (field != null) {
            Method method;
            String string = this.receiverClass.getName();
            if (Modifier.isPublic(field.getModifiers())) {
                instructionList.append(instructionFactory.createGetField(string, field.getName(), type));
                return type;
            }
            String string2 = field.getName();
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            try {
                method = field.getDeclaringClass().getMethod("get" + string2, new Class[0]);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(field.getName(), exception);
            }
            instructionList.append(instructionFactory.createInvoke(string, method.getName(), type, Type.NO_ARGS, (short)182));
        } else if (valueDescriptor instanceof DynamicValueDescriptor) {
            DynamicValueDescriptor dynamicValueDescriptor = (DynamicValueDescriptor)valueDescriptor;
            int n = dynamicValueDescriptor.getIndex();
            instructionList.append(this.pushInt(constantPoolGen, n));
            instructionList.append(InstructionConstants.AALOAD);
            if (clazz.isPrimitive()) {
                switch (type.getType()) {
                    case 11: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "longValue", Type.LONG, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                    case 6: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "floatValue", Type.FLOAT, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                    case 7: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "doubleValue", Type.DOUBLE, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                    case 4: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "booleanValue", Type.BOOLEAN, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                    case 5: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "charValue", Type.CHAR, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                    default: {
                        instructionList.append(instructionFactory.createInvoke(this.utilName, "intValue", Type.INT, new Type[]{this.objectType}, (short)184));
                        break;
                    }
                }
            } else {
                instructionList.append(instructionFactory.createCheckCast(new ObjectType(clazz.getName())));
            }
        } else {
            throw new InternalError("Bad value type " + valueDescriptor);
        }
        return type;
    }

    private String getName() {
        return this.name;
    }

    static {
        String string = System.getProperty("oracle.jrockit.jra.ClassGenDir");
        File file = null;
        if (string != null) {
            file = new File(string);
            if (!file.exists() && !file.mkdirs()) {
                throw new ExceptionInInitializerError("Could not create directory: " + file);
            }
            if (file.exists() && !file.isDirectory()) {
                throw new ExceptionInInitializerError(file + " is not a directory");
            }
        }
        classDir = file;
        workaroundSync = ClassGen.class;
    }

    private static final class EventInfoClassLoader
    extends SecureClassLoader {
        public EventInfoClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class<?> defineClass(String string, byte[] byArray) {
            CodeSource codeSource = new CodeSource(null, (Certificate[])null);
            return super.defineClass(string, byArray, 0, byArray.length, codeSource);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.oracle.jrockit.jfr.events"));
            ((PermissionCollection)permissions).add(new RuntimePermission("accessClassInPackage.oracle.jrockit.jfr"));
            return permissions;
        }
    }
}

