/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import java.io.IOException;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.PlatformComponent;
import java.lang.management.PlatformManagedObject;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.management.StandardMBean;
import sun.management.ManagementFactoryHelper;
import sun.misc.VM;

public class ManagementFactory {
    public static final String CLASS_LOADING_MXBEAN_NAME = "java.lang:type=ClassLoading";
    public static final String COMPILATION_MXBEAN_NAME = "java.lang:type=Compilation";
    public static final String MEMORY_MXBEAN_NAME = "java.lang:type=Memory";
    public static final String OPERATING_SYSTEM_MXBEAN_NAME = "java.lang:type=OperatingSystem";
    public static final String RUNTIME_MXBEAN_NAME = "java.lang:type=Runtime";
    public static final String THREAD_MXBEAN_NAME = "java.lang:type=Threading";
    public static final String GARBAGE_COLLECTOR_MXBEAN_DOMAIN_TYPE = "java.lang:type=GarbageCollector";
    public static final String MEMORY_MANAGER_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryManager";
    public static final String MEMORY_POOL_MXBEAN_DOMAIN_TYPE = "java.lang:type=MemoryPool";
    private static MBeanServer platformMBeanServer;
    private static final String NOTIF_EMITTER = "javax.management.NotificationEmitter";

    private ManagementFactory() {
    }

    public static ClassLoadingMXBean getClassLoadingMXBean() {
        return ManagementFactoryHelper.getClassLoadingMXBean();
    }

    public static MemoryMXBean getMemoryMXBean() {
        return ManagementFactoryHelper.getMemoryMXBean();
    }

    public static ThreadMXBean getThreadMXBean() {
        return ManagementFactoryHelper.getThreadMXBean();
    }

    public static RuntimeMXBean getRuntimeMXBean() {
        return ManagementFactoryHelper.getRuntimeMXBean();
    }

    public static CompilationMXBean getCompilationMXBean() {
        return ManagementFactoryHelper.getCompilationMXBean();
    }

    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        return ManagementFactoryHelper.getOperatingSystemMXBean();
    }

    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        return ManagementFactoryHelper.getMemoryPoolMXBeans();
    }

    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        return ManagementFactoryHelper.getMemoryManagerMXBeans();
    }

    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        return ManagementFactoryHelper.getGarbageCollectorMXBeans();
    }

    public static synchronized MBeanServer getPlatformMBeanServer() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            object = new MBeanServerPermission("createMBeanServer");
            securityManager.checkPermission((Permission)object);
        }
        if (platformMBeanServer == null) {
            platformMBeanServer = MBeanServerFactory.createMBeanServer();
            for (PlatformComponent platformComponent : PlatformComponent.values()) {
                List<? extends PlatformManagedObject> list = platformComponent.getMXBeans(platformComponent.getMXBeanInterface());
                for (PlatformManagedObject platformManagedObject : list) {
                    if (platformMBeanServer.isRegistered(platformManagedObject.getObjectName())) continue;
                    ManagementFactory.addMXBean(platformMBeanServer, platformManagedObject);
                }
            }
            object = ManagementFactoryHelper.getPlatformDynamicMBeans();
            for (Map.Entry entry : ((HashMap)object).entrySet()) {
                ManagementFactory.addDynamicMBean(platformMBeanServer, (DynamicMBean)entry.getValue(), (ObjectName)entry.getKey());
            }
        }
        return platformMBeanServer;
    }

    public static <T> T newPlatformMXBeanProxy(MBeanServerConnection mBeanServerConnection, String string, Class<T> clazz) throws IOException {
        final Class<T> clazz2 = clazz;
        ClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return clazz2.getClassLoader();
            }
        });
        if (!VM.isSystemDomainLoader(classLoader)) {
            throw new IllegalArgumentException(string + " is not a platform MXBean");
        }
        try {
            ObjectName objectName = new ObjectName(string);
            String string2 = clazz.getName();
            if (!mBeanServerConnection.isInstanceOf(objectName, string2)) {
                throw new IllegalArgumentException(string + " is not an instance of " + clazz);
            }
            boolean bl = mBeanServerConnection.isInstanceOf(objectName, NOTIF_EMITTER);
            return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, bl);
        }
        catch (InstanceNotFoundException | MalformedObjectNameException operationsException) {
            throw new IllegalArgumentException(operationsException);
        }
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(Class<T> clazz) {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        if (!platformComponent.isSingleton()) {
            throw new IllegalArgumentException(clazz.getName() + " can have zero or more than one instances");
        }
        return platformComponent.getSingletonMXBean(clazz);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(Class<T> clazz) {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        return Collections.unmodifiableList(platformComponent.getMXBeans(clazz));
    }

    public static <T extends PlatformManagedObject> T getPlatformMXBean(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        if (!platformComponent.isSingleton()) {
            throw new IllegalArgumentException(clazz.getName() + " can have zero or more than one instances");
        }
        return platformComponent.getSingletonMXBean(mBeanServerConnection, clazz);
    }

    public static <T extends PlatformManagedObject> List<T> getPlatformMXBeans(MBeanServerConnection mBeanServerConnection, Class<T> clazz) throws IOException {
        PlatformComponent platformComponent = PlatformComponent.getPlatformComponent(clazz);
        if (platformComponent == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a platform management interface");
        }
        return Collections.unmodifiableList(platformComponent.getMXBeans(mBeanServerConnection, clazz));
    }

    public static Set<Class<? extends PlatformManagedObject>> getPlatformManagementInterfaces() {
        HashSet<Class<? extends PlatformManagedObject>> hashSet = new HashSet<Class<? extends PlatformManagedObject>>();
        for (PlatformComponent platformComponent : PlatformComponent.values()) {
            hashSet.add(platformComponent.getMXBeanInterface());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private static void addMXBean(final MBeanServer mBeanServer, final PlatformManagedObject platformManagedObject) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    DynamicMBean dynamicMBean = platformManagedObject instanceof DynamicMBean ? (DynamicMBean)DynamicMBean.class.cast(platformManagedObject) : (platformManagedObject instanceof NotificationEmitter ? new StandardEmitterMBean(platformManagedObject, null, true, (NotificationEmitter)((Object)platformManagedObject)) : new StandardMBean(platformManagedObject, null, true));
                    mBeanServer.registerMBean(dynamicMBean, platformManagedObject.getObjectName());
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException.getException());
        }
    }

    private static void addDynamicMBean(final MBeanServer mBeanServer, final DynamicMBean dynamicMBean, final ObjectName objectName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
                    mBeanServer.registerMBean(dynamicMBean, objectName);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException.getException());
        }
    }
}

