/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.schemagen;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.Util;
import com.sun.xml.internal.bind.api.CompositeStructure;
import com.sun.xml.internal.bind.api.ErrorListener;
import com.sun.xml.internal.bind.v2.TODO;
import com.sun.xml.internal.bind.v2.model.core.Adapter;
import com.sun.xml.internal.bind.v2.model.core.ArrayInfo;
import com.sun.xml.internal.bind.v2.model.core.AttributePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.ClassInfo;
import com.sun.xml.internal.bind.v2.model.core.Element;
import com.sun.xml.internal.bind.v2.model.core.ElementInfo;
import com.sun.xml.internal.bind.v2.model.core.ElementPropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.EnumConstant;
import com.sun.xml.internal.bind.v2.model.core.EnumLeafInfo;
import com.sun.xml.internal.bind.v2.model.core.MapPropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.MaybeElement;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.NonElementRef;
import com.sun.xml.internal.bind.v2.model.core.PropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.ReferencePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfo;
import com.sun.xml.internal.bind.v2.model.core.TypeInfoSet;
import com.sun.xml.internal.bind.v2.model.core.TypeRef;
import com.sun.xml.internal.bind.v2.model.core.ValuePropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.WildcardMode;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.nav.Navigator;
import com.sun.xml.internal.bind.v2.runtime.SwaRefAdapter;
import com.sun.xml.internal.bind.v2.schemagen.FoolProofResolver;
import com.sun.xml.internal.bind.v2.schemagen.Form;
import com.sun.xml.internal.bind.v2.schemagen.GroupKind;
import com.sun.xml.internal.bind.v2.schemagen.Messages;
import com.sun.xml.internal.bind.v2.schemagen.MultiMap;
import com.sun.xml.internal.bind.v2.schemagen.Tree;
import com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator;
import com.sun.xml.internal.bind.v2.schemagen.episode.Bindings;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Annotated;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Any;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.AttrDecls;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.AttributeType;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ComplexType;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ComplexTypeHost;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ContentModelContainer;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.ExplicitGroup;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.List;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.LocalAttribute;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.LocalElement;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Schema;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleExtension;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleRestriction;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleType;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.SimpleTypeHost;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TopLevelElement;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TypeDefParticle;
import com.sun.xml.internal.bind.v2.schemagen.xmlschema.TypeHost;
import com.sun.xml.internal.bind.v2.util.CollisionCheckStack;
import com.sun.xml.internal.bind.v2.util.StackRecorder;
import com.sun.xml.internal.txw2.TXW;
import com.sun.xml.internal.txw2.TxwException;
import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.txw2.output.ResultFactory;
import com.sun.xml.internal.txw2.output.XmlSerializer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.MimeType;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXParseException;

public final class XmlSchemaGenerator<T, C, F, M> {
    private static final Logger logger = Util.getClassLogger();
    private final Map<String, Namespace> namespaces = new TreeMap<String, Namespace>(NAMESPACE_COMPARATOR);
    private ErrorListener errorListener;
    private Navigator<T, C, F, M> navigator;
    private final TypeInfoSet<T, C, F, M> types;
    private final NonElement<T, C> stringType;
    private final NonElement<T, C> anyType;
    private final CollisionCheckStack<ClassInfo<T, C>> collisionChecker = new CollisionCheckStack();
    private static final Comparator<String> NAMESPACE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return -string.compareTo(string2);
        }
    };
    private static final String newline = "\n";

    public XmlSchemaGenerator(Navigator<T, C, F, M> navigator, TypeInfoSet<T, C, F, M> typeInfoSet) {
        this.navigator = navigator;
        this.types = typeInfoSet;
        this.stringType = typeInfoSet.getTypeInfo(navigator.ref(String.class));
        this.anyType = typeInfoSet.getAnyTypeInfo();
        for (ClassInfo<T, Object> typeInfo : typeInfoSet.beans().values()) {
            this.add(typeInfo);
        }
        for (ElementInfo elementInfo : typeInfoSet.getElementMappings(null).values()) {
            this.add(elementInfo);
        }
        for (EnumLeafInfo enumLeafInfo : typeInfoSet.enums().values()) {
            this.add(enumLeafInfo);
        }
        for (ArrayInfo arrayInfo : typeInfoSet.arrays().values()) {
            this.add(arrayInfo);
        }
    }

    private Namespace getNamespace(String string) {
        Namespace namespace = this.namespaces.get(string);
        if (namespace == null) {
            namespace = new Namespace(string);
            this.namespaces.put(string, namespace);
        }
        return namespace;
    }

    public void add(ClassInfo<T, C> classInfo) {
        Object object;
        assert (classInfo != null);
        String string = null;
        if (classInfo.getClazz() == this.navigator.asDecl(CompositeStructure.class)) {
            return;
        }
        if (classInfo.isElement()) {
            string = classInfo.getElementName().getNamespaceURI();
            object = this.getNamespace(string);
            ((Namespace)object).classes.add(classInfo);
            ((Namespace)object).addDependencyTo(classInfo.getTypeName());
            this.add(classInfo.getElementName(), false, classInfo);
        }
        if ((object = classInfo.getTypeName()) != null) {
            string = ((QName)object).getNamespaceURI();
        } else if (string == null) {
            return;
        }
        Namespace namespace = this.getNamespace(string);
        namespace.classes.add(classInfo);
        for (PropertyInfo<T, C> propertyInfo : classInfo.getProperties()) {
            Object object2;
            Object object3;
            namespace.processForeignNamespaces(propertyInfo, 1);
            if (propertyInfo instanceof AttributePropertyInfo && ((String)(object3 = (object2 = (AttributePropertyInfo)propertyInfo).getXmlName().getNamespaceURI())).length() > 0) {
                this.getNamespace((String)object3).addGlobalAttribute(object2);
                namespace.addDependencyTo(object2.getXmlName());
            }
            if (propertyInfo instanceof ElementPropertyInfo) {
                object2 = (ElementPropertyInfo)propertyInfo;
                object3 = object2.getTypes().iterator();
                while (object3.hasNext()) {
                    TypeRef typeRef = (TypeRef)object3.next();
                    String string2 = typeRef.getTagName().getNamespaceURI();
                    if (string2.length() <= 0 || string2.equals(namespace.uri)) continue;
                    this.getNamespace(string2).addGlobalElement(typeRef);
                    namespace.addDependencyTo(typeRef.getTagName());
                }
            }
            if (this.generateSwaRefAdapter(propertyInfo)) {
                namespace.useSwaRef = true;
            }
            if ((object2 = propertyInfo.getExpectedMimeType()) == null) continue;
            namespace.useMimeNs = true;
        }
        ClassInfo<T, C> classInfo2 = classInfo.getBaseClass();
        if (classInfo2 != null) {
            this.add(classInfo2);
            namespace.addDependencyTo(classInfo2.getTypeName());
        }
    }

    public void add(ElementInfo<T, C> elementInfo) {
        assert (elementInfo != null);
        boolean bl = false;
        QName qName = elementInfo.getElementName();
        Namespace namespace = this.getNamespace(qName.getNamespaceURI());
        ElementInfo<T, Object> elementInfo2 = elementInfo.getScope() != null ? this.types.getElementInfo(elementInfo.getScope().getClazz(), qName) : this.types.getElementInfo(null, qName);
        XmlElement xmlElement = elementInfo2.getProperty().readAnnotation(XmlElement.class);
        bl = xmlElement == null ? false : xmlElement.nillable();
        MultiMap multiMap = namespace.elementDecls;
        String string = qName.getLocalPart();
        Namespace namespace2 = namespace;
        namespace2.getClass();
        multiMap.put(string, namespace2.new Namespace.ElementWithType(bl, elementInfo.getContentType()));
        namespace.processForeignNamespaces(elementInfo.getProperty(), 1);
    }

    public void add(EnumLeafInfo<T, C> enumLeafInfo) {
        Object object;
        assert (enumLeafInfo != null);
        String string = null;
        if (enumLeafInfo.isElement()) {
            string = enumLeafInfo.getElementName().getNamespaceURI();
            object = this.getNamespace(string);
            ((Namespace)object).enums.add(enumLeafInfo);
            ((Namespace)object).addDependencyTo(enumLeafInfo.getTypeName());
            this.add(enumLeafInfo.getElementName(), false, enumLeafInfo);
        }
        if ((object = enumLeafInfo.getTypeName()) != null) {
            string = ((QName)object).getNamespaceURI();
        } else if (string == null) {
            return;
        }
        Namespace namespace = this.getNamespace(string);
        namespace.enums.add(enumLeafInfo);
        namespace.addDependencyTo(enumLeafInfo.getBaseType().getTypeName());
    }

    public void add(ArrayInfo<T, C> arrayInfo) {
        assert (arrayInfo != null);
        String string = arrayInfo.getTypeName().getNamespaceURI();
        Namespace namespace = this.getNamespace(string);
        namespace.arrays.add(arrayInfo);
        namespace.addDependencyTo(arrayInfo.getItemType().getTypeName());
    }

    public void add(QName qName, boolean bl, NonElement<T, C> nonElement) {
        if (nonElement != null && nonElement.getType() == this.navigator.ref(CompositeStructure.class)) {
            return;
        }
        Namespace namespace = this.getNamespace(qName.getNamespaceURI());
        MultiMap multiMap = namespace.elementDecls;
        String string = qName.getLocalPart();
        Namespace namespace2 = namespace;
        namespace2.getClass();
        multiMap.put(string, namespace2.new Namespace.ElementWithType(bl, nonElement));
        if (nonElement != null) {
            namespace.addDependencyTo(nonElement.getTypeName());
        }
    }

    public void writeEpisodeFile(XmlSerializer xmlSerializer) {
        Bindings bindings = TXW.create(Bindings.class, xmlSerializer);
        if (this.namespaces.containsKey("")) {
            bindings._namespace("http://java.sun.com/xml/ns/jaxb", "jaxb");
        }
        bindings.version("2.1");
        for (Map.Entry<String, Namespace> entry : this.namespaces.entrySet()) {
            Bindings bindings2;
            String string;
            Bindings bindings3 = bindings.bindings();
            String string2 = entry.getKey();
            if (!string2.equals("")) {
                bindings3._namespace(string2, "tns");
                string = "tns:";
            } else {
                string = "";
            }
            bindings3.scd("x-schema::" + (string2.equals("") ? "" : "tns"));
            bindings3.schemaBindings().map(false);
            for (MaybeElement maybeElement : entry.getValue().classes) {
                if (maybeElement.getTypeName() == null) continue;
                if (maybeElement.getTypeName().getNamespaceURI().equals(string2)) {
                    bindings2 = bindings3.bindings();
                    bindings2.scd('~' + string + maybeElement.getTypeName().getLocalPart());
                    bindings2.klass().ref(maybeElement.getName());
                }
                if (!maybeElement.isElement() || !maybeElement.getElementName().getNamespaceURI().equals(string2)) continue;
                bindings2 = bindings3.bindings();
                bindings2.scd(string + maybeElement.getElementName().getLocalPart());
                bindings2.klass().ref(maybeElement.getName());
            }
            for (MaybeElement maybeElement : entry.getValue().enums) {
                if (maybeElement.getTypeName() == null) continue;
                bindings2 = bindings3.bindings();
                bindings2.scd('~' + string + maybeElement.getTypeName().getLocalPart());
                bindings2.klass().ref(this.navigator.getClassName(maybeElement.getClazz()));
            }
            bindings3.commit(true);
        }
        bindings.commit();
    }

    public void write(SchemaOutputResolver schemaOutputResolver, ErrorListener errorListener) throws IOException {
        Object object;
        Object object2;
        if (schemaOutputResolver == null) {
            throw new IllegalArgumentException();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Wrigin XML Schema for " + this.toString(), new StackRecorder());
        }
        schemaOutputResolver = new FoolProofResolver(schemaOutputResolver);
        this.errorListener = errorListener;
        Map<String, String> map = this.types.getSchemaLocations();
        HashMap<Namespace, Object> hashMap = new HashMap<Namespace, Object>();
        HashMap<Namespace, String> hashMap2 = new HashMap<Namespace, String>();
        this.namespaces.remove("http://www.w3.org/2001/XMLSchema");
        for (Namespace object3 : this.namespaces.values()) {
            object2 = map.get(object3.uri);
            if (object2 != null) {
                hashMap2.put(object3, (String)object2);
                continue;
            }
            object = schemaOutputResolver.createOutput(object3.uri, "schema" + (hashMap.size() + 1) + ".xsd");
            if (object == null) continue;
            hashMap.put(object3, object);
            hashMap2.put(object3, object.getSystemId());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = (Result)entry.getValue();
            ((Namespace)entry.getKey()).writeTo((Result)object2, hashMap2);
            if (!(object2 instanceof StreamResult)) continue;
            object = ((StreamResult)object2).getOutputStream();
            if (object != null) {
                ((OutputStream)object).close();
                continue;
            }
            Writer writer = ((StreamResult)object2).getWriter();
            if (writer == null) continue;
            writer.close();
        }
    }

    private boolean generateSwaRefAdapter(NonElementRef<T, C> nonElementRef) {
        return this.generateSwaRefAdapter(nonElementRef.getSource());
    }

    private boolean generateSwaRefAdapter(PropertyInfo<T, C> propertyInfo) {
        Adapter<T, C> adapter = propertyInfo.getAdapter();
        if (adapter == null) {
            return false;
        }
        C c = this.navigator.asDecl(SwaRefAdapter.class);
        if (c == null) {
            return false;
        }
        return c.equals(adapter.adapterType);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Namespace namespace : this.namespaces.values()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(namespace.uri).append('=').append(namespace);
        }
        return super.toString() + '[' + stringBuilder + ']';
    }

    private static String getProcessContentsModeName(WildcardMode wildcardMode) {
        switch (wildcardMode) {
            case LAX: 
            case SKIP: {
                return wildcardMode.name().toLowerCase();
            }
            case STRICT: {
                return null;
            }
        }
        throw new IllegalStateException();
    }

    protected static String relativize(String string, String string2) {
        try {
            assert (string != null);
            if (string2 == null) {
                return string;
            }
            URI uRI = new URI(com.sun.xml.internal.bind.v2.schemagen.Util.escapeURI(string));
            URI uRI2 = new URI(com.sun.xml.internal.bind.v2.schemagen.Util.escapeURI(string2));
            if (uRI.isOpaque() || uRI2.isOpaque()) {
                return string;
            }
            if (!com.sun.xml.internal.bind.v2.schemagen.Util.equalsIgnoreCase(uRI.getScheme(), uRI2.getScheme()) || !com.sun.xml.internal.bind.v2.schemagen.Util.equal(uRI.getAuthority(), uRI2.getAuthority())) {
                return string;
            }
            String string3 = uRI.getPath();
            String string4 = uRI2.getPath();
            if (!string4.endsWith("/")) {
                string4 = com.sun.xml.internal.bind.v2.schemagen.Util.normalizeUriPath(string4);
            }
            if (string3.equals(string4)) {
                return ".";
            }
            String string5 = XmlSchemaGenerator.calculateRelativePath(string3, string4, XmlSchemaGenerator.fixNull(uRI.getScheme()).equals("file"));
            if (string5 == null) {
                return string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string5);
            if (uRI.getQuery() != null) {
                stringBuilder.append('?').append(uRI.getQuery());
            }
            if (uRI.getFragment() != null) {
                stringBuilder.append('#').append(uRI.getFragment());
            }
            return stringBuilder.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError("Error escaping one of these uris:\n\t" + string + "\n\t" + string2);
        }
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String calculateRelativePath(String string, String string2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = File.pathSeparatorChar == ';';
        if (string2 == null) {
            return null;
        }
        if (bl && bl2 && XmlSchemaGenerator.startsWithIgnoreCase(string, string2) || string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return "../" + XmlSchemaGenerator.calculateRelativePath(string, com.sun.xml.internal.bind.v2.schemagen.Util.getParentUriPath(string2), bl);
    }

    private static boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    static /* synthetic */ NonElement access$900(XmlSchemaGenerator xmlSchemaGenerator) {
        return xmlSchemaGenerator.anyType;
    }

    private class Namespace {
        @NotNull
        final String uri;
        private final Set<Namespace> depends = new LinkedHashSet<Namespace>();
        private boolean selfReference;
        private final Set<ClassInfo<T, C>> classes = new LinkedHashSet();
        private final Set<EnumLeafInfo<T, C>> enums = new LinkedHashSet();
        private final Set<ArrayInfo<T, C>> arrays = new LinkedHashSet();
        private final MultiMap<String, AttributePropertyInfo<T, C>> attributeDecls = new MultiMap(null);
        private final MultiMap<String, com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration> elementDecls = new MultiMap(new ElementWithType(true, XmlSchemaGenerator.access$900(XmlSchemaGenerator.this)));
        private Form attributeFormDefault;
        private Form elementFormDefault;
        private boolean useSwaRef;
        private boolean useMimeNs;

        public Namespace(String string) {
            this.uri = string;
            assert (!XmlSchemaGenerator.this.namespaces.containsKey(string));
            XmlSchemaGenerator.this.namespaces.put(string, this);
        }

        private void processForeignNamespaces(PropertyInfo<T, C> propertyInfo, int n) {
            for (TypeInfo typeInfo : propertyInfo.ref()) {
                if (typeInfo instanceof ClassInfo && n > 0) {
                    java.util.List list = ((ClassInfo)typeInfo).getProperties();
                    for (PropertyInfo propertyInfo2 : list) {
                        this.processForeignNamespaces(propertyInfo2, --n);
                    }
                }
                if (typeInfo instanceof Element) {
                    this.addDependencyTo(((Element)typeInfo).getElementName());
                }
                if (!(typeInfo instanceof NonElement)) continue;
                this.addDependencyTo(((NonElement)typeInfo).getTypeName());
            }
        }

        private void addDependencyTo(@Nullable QName qName) {
            if (qName == null) {
                return;
            }
            String string = qName.getNamespaceURI();
            if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            if (string.equals(this.uri)) {
                this.selfReference = true;
                return;
            }
            this.depends.add(XmlSchemaGenerator.this.getNamespace(string));
        }

        private void writeTo(Result result, Map<Namespace, String> map) throws IOException {
            try {
                Annotated annotated;
                Schema schema = TXW.create(Schema.class, ResultFactory.createSerializer(result));
                Map<String, String> map2 = XmlSchemaGenerator.this.types.getXmlNs(this.uri);
                for (Map.Entry<String, String> object : map2.entrySet()) {
                    schema._namespace(object.getValue(), object.getKey());
                }
                if (this.useSwaRef) {
                    schema._namespace("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef");
                }
                if (this.useMimeNs) {
                    schema._namespace("http://www.w3.org/2005/05/xmlmime", "xmime");
                }
                this.attributeFormDefault = Form.get(XmlSchemaGenerator.this.types.getAttributeFormDefault(this.uri));
                this.attributeFormDefault.declare("attributeFormDefault", schema);
                this.elementFormDefault = Form.get(XmlSchemaGenerator.this.types.getElementFormDefault(this.uri));
                this.elementFormDefault.declare("elementFormDefault", schema);
                if (!map2.containsValue("http://www.w3.org/2001/XMLSchema") && !map2.containsKey("xs")) {
                    schema._namespace("http://www.w3.org/2001/XMLSchema", "xs");
                }
                schema.version("1.0");
                if (this.uri.length() != 0) {
                    schema.targetNamespace(this.uri);
                }
                for (Namespace namespace : this.depends) {
                    schema._namespace(namespace.uri);
                }
                if (this.selfReference && this.uri.length() != 0) {
                    schema._namespace(this.uri, "tns");
                }
                schema._pcdata(XmlSchemaGenerator.newline);
                for (Namespace namespace : this.depends) {
                    String string;
                    annotated = schema._import();
                    if (namespace.uri.length() != 0) {
                        annotated.namespace(namespace.uri);
                    }
                    if ((string = map.get(namespace)) != null && !string.equals("")) {
                        annotated.schemaLocation(XmlSchemaGenerator.relativize(string, result.getSystemId()));
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                if (this.useSwaRef) {
                    schema._import().namespace("http://ws-i.org/profiles/basic/1.1/xsd").schemaLocation("http://ws-i.org/profiles/basic/1.1/swaref.xsd");
                }
                if (this.useMimeNs) {
                    schema._import().namespace("http://www.w3.org/2005/05/xmlmime").schemaLocation("http://www.w3.org/2005/05/xmlmime");
                }
                for (Map.Entry entry : this.elementDecls.entrySet()) {
                    ((ElementDeclaration)entry.getValue()).writeTo((String)entry.getKey(), schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ClassInfo classInfo : this.classes) {
                    if (classInfo.getTypeName() == null) continue;
                    if (this.uri.equals(classInfo.getTypeName().getNamespaceURI())) {
                        this.writeClass(classInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (EnumLeafInfo enumLeafInfo : this.enums) {
                    if (enumLeafInfo.getTypeName() == null) continue;
                    if (this.uri.equals(enumLeafInfo.getTypeName().getNamespaceURI())) {
                        this.writeEnum(enumLeafInfo, schema);
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (ArrayInfo arrayInfo : this.arrays) {
                    this.writeArray(arrayInfo, schema);
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                for (Map.Entry entry : this.attributeDecls.entrySet()) {
                    annotated = schema.attribute();
                    annotated.name((String)entry.getKey());
                    if (entry.getValue() == null) {
                        this.writeTypeRef((TypeHost)((Object)annotated), XmlSchemaGenerator.this.stringType, "type");
                    } else {
                        this.writeAttributeTypeRef((AttributePropertyInfo)entry.getValue(), (AttributeType)((Object)annotated));
                    }
                    schema._pcdata(XmlSchemaGenerator.newline);
                }
                schema.commit();
            }
            catch (TxwException txwException) {
                logger.log(Level.INFO, txwException.getMessage(), txwException);
                throw new IOException(txwException.getMessage());
            }
        }

        private void writeTypeRef(TypeHost typeHost, NonElementRef<T, C> nonElementRef, String string) {
            switch (nonElementRef.getSource().id()) {
                case ID: {
                    typeHost._attribute(string, (Object)new QName("http://www.w3.org/2001/XMLSchema", "ID"));
                    return;
                }
                case IDREF: {
                    typeHost._attribute(string, (Object)new QName("http://www.w3.org/2001/XMLSchema", "IDREF"));
                    return;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            MimeType mimeType = nonElementRef.getSource().getExpectedMimeType();
            if (mimeType != null) {
                typeHost._attribute(new QName("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes", "xmime"), (Object)mimeType.toString());
            }
            if (XmlSchemaGenerator.this.generateSwaRefAdapter(nonElementRef)) {
                typeHost._attribute(string, (Object)new QName("http://ws-i.org/profiles/basic/1.1/xsd", "swaRef", "ref"));
                return;
            }
            if (nonElementRef.getSource().getSchemaType() != null) {
                typeHost._attribute(string, (Object)nonElementRef.getSource().getSchemaType());
                return;
            }
            this.writeTypeRef(typeHost, nonElementRef.getTarget(), string);
        }

        private void writeTypeRef(TypeHost typeHost, NonElement<T, C> nonElement, String string) {
            MaybeElement maybeElement;
            boolean bl;
            Element element = null;
            if (nonElement instanceof MaybeElement && (bl = (maybeElement = (MaybeElement)nonElement).isElement())) {
                element = maybeElement.asElement();
            }
            if (nonElement instanceof Element) {
                element = (Element)((Object)nonElement);
            }
            if (nonElement.getTypeName() == null) {
                if (element != null && element.getElementName() != null) {
                    typeHost.block();
                    if (nonElement instanceof ClassInfo) {
                        this.writeClass((ClassInfo)nonElement, typeHost);
                    } else {
                        this.writeEnum((EnumLeafInfo)nonElement, (SimpleTypeHost)typeHost);
                    }
                } else {
                    typeHost.block();
                    if (nonElement instanceof ClassInfo) {
                        if (XmlSchemaGenerator.this.collisionChecker.push((ClassInfo)nonElement)) {
                            XmlSchemaGenerator.this.errorListener.warning(new SAXParseException(Messages.ANONYMOUS_TYPE_CYCLE.format(XmlSchemaGenerator.this.collisionChecker.getCycleString()), null));
                        } else {
                            this.writeClass((ClassInfo)nonElement, typeHost);
                        }
                        XmlSchemaGenerator.this.collisionChecker.pop();
                    } else {
                        this.writeEnum((EnumLeafInfo)nonElement, (SimpleTypeHost)typeHost);
                    }
                }
            } else {
                typeHost._attribute(string, (Object)nonElement.getTypeName());
            }
        }

        private void writeArray(ArrayInfo<T, C> arrayInfo, Schema schema) {
            ComplexType complexType = schema.complexType().name(arrayInfo.getTypeName().getLocalPart());
            complexType._final("#all");
            LocalElement localElement = complexType.sequence().element().name("item");
            localElement.type(arrayInfo.getItemType().getTypeName());
            localElement.minOccurs(0).maxOccurs("unbounded");
            localElement.nillable(true);
            complexType.commit();
        }

        private void writeEnum(EnumLeafInfo<T, C> enumLeafInfo, SimpleTypeHost simpleTypeHost) {
            SimpleType simpleType = simpleTypeHost.simpleType();
            this.writeName(enumLeafInfo, simpleType);
            SimpleRestriction simpleRestriction = simpleType.restriction();
            this.writeTypeRef((TypeHost)simpleRestriction, enumLeafInfo.getBaseType(), "base");
            for (EnumConstant enumConstant : enumLeafInfo.getConstants()) {
                simpleRestriction.enumeration().value(enumConstant.getLexicalValue());
            }
            simpleType.commit();
        }

        private void writeClass(ClassInfo<T, C> classInfo, TypeHost typeHost) {
            Object object;
            if (this.containsValueProp(classInfo)) {
                if (classInfo.getProperties().size() == 1) {
                    ValuePropertyInfo valuePropertyInfo = (ValuePropertyInfo)classInfo.getProperties().get(0);
                    SimpleType simpleType = ((SimpleTypeHost)typeHost).simpleType();
                    this.writeName(classInfo, simpleType);
                    if (valuePropertyInfo.isCollection()) {
                        this.writeTypeRef((TypeHost)simpleType.list(), valuePropertyInfo.getTarget(), "itemType");
                    } else {
                        this.writeTypeRef((TypeHost)simpleType.restriction(), valuePropertyInfo.getTarget(), "base");
                    }
                    return;
                }
                ComplexType complexType = ((ComplexTypeHost)typeHost).complexType();
                this.writeName(classInfo, complexType);
                if (classInfo.isFinal()) {
                    complexType._final("extension restriction");
                }
                SimpleExtension simpleExtension = complexType.simpleContent().extension();
                simpleExtension.block();
                block4: for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                    switch (propertyInfo.kind()) {
                        case ATTRIBUTE: {
                            this.handleAttributeProp((AttributePropertyInfo)propertyInfo, simpleExtension);
                            continue block4;
                        }
                        case VALUE: {
                            TODO.checkSpec("what if vp.isCollection() == true?");
                            ValuePropertyInfo valuePropertyInfo = (ValuePropertyInfo)propertyInfo;
                            simpleExtension.base(valuePropertyInfo.getTarget().getTypeName());
                            continue block4;
                        }
                    }
                    assert (false);
                    throw new IllegalStateException();
                }
                simpleExtension.commit();
                TODO.schemaGenerator("figure out what to do if bc != null");
                TODO.checkSpec("handle sec 8.9.5.2, bullet #4");
                return;
            }
            ComplexType complexType = ((ComplexTypeHost)typeHost).complexType();
            this.writeName(classInfo, complexType);
            if (classInfo.isFinal()) {
                complexType._final("extension restriction");
            }
            if (classInfo.isAbstract()) {
                complexType._abstract(true);
            }
            Object object2 = complexType;
            Object object3 = complexType;
            ClassInfo classInfo2 = classInfo.getBaseClass();
            if (classInfo2 != null) {
                if (classInfo2.hasValueProperty()) {
                    object2 = object = complexType.simpleContent().extension();
                    object3 = null;
                    object.base(classInfo2.getTypeName());
                } else {
                    object2 = object = complexType.complexContent().extension();
                    object3 = object;
                    object.base(classInfo2.getTypeName());
                }
            }
            if (object3 != null) {
                object = new ArrayList();
                for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                    Tree tree;
                    if (propertyInfo instanceof ReferencePropertyInfo && ((ReferencePropertyInfo)propertyInfo).isMixed()) {
                        complexType.mixed(true);
                    }
                    if ((tree = this.buildPropertyContentModel(propertyInfo)) == null) continue;
                    ((ArrayList)object).add(tree);
                }
                Tree tree = Tree.makeGroup(classInfo.isOrdered() ? GroupKind.SEQUENCE : GroupKind.ALL, (java.util.List<Tree>)object);
                tree.write((TypeDefParticle)object3);
            }
            for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof AttributePropertyInfo)) continue;
                this.handleAttributeProp((AttributePropertyInfo)propertyInfo, (AttrDecls)object2);
            }
            if (classInfo.hasAttributeWildcard()) {
                object2.anyAttribute().namespace("##other").processContents("skip");
            }
            complexType.commit();
        }

        private void writeName(NonElement<T, C> nonElement, TypedXmlWriter typedXmlWriter) {
            QName qName = nonElement.getTypeName();
            if (qName != null) {
                typedXmlWriter._attribute("name", (Object)qName.getLocalPart());
            }
        }

        private boolean containsValueProp(ClassInfo<T, C> classInfo) {
            for (PropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof ValuePropertyInfo)) continue;
                return true;
            }
            return false;
        }

        private Tree buildPropertyContentModel(PropertyInfo<T, C> propertyInfo) {
            switch (propertyInfo.kind()) {
                case ELEMENT: {
                    return this.handleElementProp((ElementPropertyInfo)propertyInfo);
                }
                case ATTRIBUTE: {
                    return null;
                }
                case REFERENCE: {
                    return this.handleReferenceProp((ReferencePropertyInfo)propertyInfo);
                }
                case MAP: {
                    return this.handleMapProp((MapPropertyInfo)propertyInfo);
                }
                case VALUE: {
                    assert (false);
                    throw new IllegalStateException();
                }
            }
            assert (false);
            throw new IllegalStateException();
        }

        private Tree handleElementProp(final ElementPropertyInfo<T, C> elementPropertyInfo) {
            if (elementPropertyInfo.isValueList()) {
                return new Tree.Term(){

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        TypeRef typeRef = elementPropertyInfo.getTypes().get(0);
                        LocalElement localElement = contentModelContainer.element();
                        localElement.block();
                        QName qName = typeRef.getTagName();
                        localElement.name(qName.getLocalPart());
                        List list = localElement.simpleType().list();
                        Namespace.this.writeTypeRef(list, typeRef, "itemType");
                        Namespace.this.elementFormDefault.writeForm(localElement, qName);
                        this.writeOccurs(localElement, bl || !elementPropertyInfo.isRequired(), bl2);
                    }
                };
            }
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            for (final TypeRef object2 : elementPropertyInfo.getTypes()) {
                arrayList.add(new Tree.Term(){

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        TypeInfo typeInfo;
                        LocalElement localElement = contentModelContainer.element();
                        QName qName = object2.getTagName();
                        PropertyInfo propertyInfo = object2.getSource();
                        TypeInfo typeInfo2 = typeInfo = propertyInfo == null ? null : propertyInfo.parent();
                        if (Namespace.this.canBeDirectElementRef(object2, qName, typeInfo)) {
                            if (!object2.getTarget().isSimpleType() && object2.getTarget() instanceof ClassInfo && XmlSchemaGenerator.this.collisionChecker.findDuplicate((ClassInfo)object2.getTarget())) {
                                localElement.ref(new QName(Namespace.this.uri, qName.getLocalPart()));
                            } else {
                                TypeInfo typeInfo3;
                                Object object;
                                QName qName2 = null;
                                if (object2.getTarget() instanceof Element) {
                                    object = (Element)((Object)object2.getTarget());
                                    qName2 = object.getElementName();
                                }
                                if ((object = propertyInfo.ref()) != null && !object.isEmpty() && qName2 != null && ((typeInfo3 = (TypeInfo)object.iterator().next()) == null || typeInfo3 instanceof ClassInfoImpl)) {
                                    ClassInfoImpl classInfoImpl = (ClassInfoImpl)typeInfo3;
                                    if (classInfoImpl != null && classInfoImpl.getElementName() != null) {
                                        localElement.ref(new QName(classInfoImpl.getElementName().getNamespaceURI(), qName.getLocalPart()));
                                    } else {
                                        localElement.ref(new QName("", qName.getLocalPart()));
                                    }
                                } else {
                                    localElement.ref(qName);
                                }
                            }
                        } else {
                            localElement.name(qName.getLocalPart());
                            Namespace.this.writeTypeRef(localElement, object2, "type");
                            Namespace.this.elementFormDefault.writeForm(localElement, qName);
                        }
                        if (object2.isNillable()) {
                            localElement.nillable(true);
                        }
                        if (object2.getDefaultValue() != null) {
                            localElement._default(object2.getDefaultValue());
                        }
                        this.writeOccurs(localElement, bl, bl2);
                    }
                });
            }
            final Tree tree = Tree.makeGroup(GroupKind.CHOICE, arrayList).makeOptional(!elementPropertyInfo.isRequired()).makeRepeated(elementPropertyInfo.isCollection());
            final QName qName = elementPropertyInfo.getXmlName();
            if (qName != null) {
                return new Tree.Term(){

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        LocalElement localElement = contentModelContainer.element();
                        if (qName.getNamespaceURI().length() > 0 && !qName.getNamespaceURI().equals(Namespace.this.uri)) {
                            localElement.ref(new QName(qName.getNamespaceURI(), qName.getLocalPart()));
                            return;
                        }
                        localElement.name(qName.getLocalPart());
                        Namespace.this.elementFormDefault.writeForm(localElement, qName);
                        if (elementPropertyInfo.isCollectionNillable()) {
                            localElement.nillable(true);
                        }
                        this.writeOccurs(localElement, !elementPropertyInfo.isCollectionRequired(), bl2);
                        ComplexType complexType = localElement.complexType();
                        tree.write(complexType);
                    }
                };
            }
            return tree;
        }

        private boolean canBeDirectElementRef(TypeRef<T, C> typeRef, QName qName, TypeInfo typeInfo) {
            String string;
            Element element = null;
            ClassInfo classInfo = null;
            QName qName2 = null;
            if (typeRef.isNillable() || typeRef.getDefaultValue() != null) {
                return false;
            }
            if (typeRef.getTarget() instanceof Element) {
                element = (Element)((Object)typeRef.getTarget());
                qName2 = element.getElementName();
                if (element instanceof ClassInfo) {
                    classInfo = (ClassInfo)((Object)element);
                }
            }
            if (!((string = qName.getNamespaceURI()).equals(this.uri) || string.length() <= 0 || typeInfo instanceof ClassInfo && ((ClassInfo)typeInfo).getTypeName() == null)) {
                return true;
            }
            if (classInfo != null && qName2 != null && element.getScope() == null && qName2.getNamespaceURI() == null && qName2.equals(qName)) {
                return true;
            }
            if (element != null) {
                return qName2 != null && qName2.equals(qName);
            }
            return false;
        }

        private void handleAttributeProp(AttributePropertyInfo<T, C> attributePropertyInfo, AttrDecls attrDecls) {
            LocalAttribute localAttribute = attrDecls.attribute();
            String string = attributePropertyInfo.getXmlName().getNamespaceURI();
            if (string.equals("")) {
                localAttribute.name(attributePropertyInfo.getXmlName().getLocalPart());
                this.writeAttributeTypeRef(attributePropertyInfo, localAttribute);
                this.attributeFormDefault.writeForm(localAttribute, attributePropertyInfo.getXmlName());
            } else {
                localAttribute.ref(attributePropertyInfo.getXmlName());
            }
            if (attributePropertyInfo.isRequired()) {
                localAttribute.use("required");
            }
        }

        private void writeAttributeTypeRef(AttributePropertyInfo<T, C> attributePropertyInfo, AttributeType attributeType) {
            if (attributePropertyInfo.isCollection()) {
                this.writeTypeRef((TypeHost)attributeType.simpleType().list(), attributePropertyInfo, "itemType");
            } else {
                this.writeTypeRef((TypeHost)attributeType, attributePropertyInfo, "type");
            }
        }

        private Tree handleReferenceProp(final ReferencePropertyInfo<T, C> referencePropertyInfo) {
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            for (final Element object2 : referencePropertyInfo.getElements()) {
                arrayList.add(new Tree.Term(){

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        LocalElement localElement = contentModelContainer.element();
                        boolean bl3 = false;
                        QName qName = object2.getElementName();
                        if (object2.getScope() != null) {
                            boolean bl4 = qName.getNamespaceURI().equals(Namespace.this.uri);
                            boolean bl5 = qName.getNamespaceURI().equals("");
                            if (bl4 || bl5) {
                                if (bl5) {
                                    if (((Namespace)Namespace.this).elementFormDefault.isEffectivelyQualified) {
                                        localElement.form("unqualified");
                                    }
                                } else if (!((Namespace)Namespace.this).elementFormDefault.isEffectivelyQualified) {
                                    localElement.form("qualified");
                                }
                                bl3 = true;
                                localElement.name(qName.getLocalPart());
                                if (object2 instanceof ClassInfo) {
                                    Namespace.this.writeTypeRef(localElement, (ClassInfo)((Object)object2), "type");
                                } else {
                                    Namespace.this.writeTypeRef(localElement, ((ElementInfo)object2).getContentType(), "type");
                                }
                            }
                        }
                        if (!bl3) {
                            localElement.ref(qName);
                        }
                        this.writeOccurs(localElement, bl, bl2);
                    }
                });
            }
            Object object3 = referencePropertyInfo.getWildcard();
            if (object3 != null) {
                arrayList.add(new Tree.Term((WildcardMode)((Object)object3)){
                    final /* synthetic */ WildcardMode val$wc;
                    {
                        this.val$wc = wildcardMode;
                    }

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        Any any = contentModelContainer.any();
                        String string = XmlSchemaGenerator.getProcessContentsModeName(this.val$wc);
                        if (string != null) {
                            any.processContents(string);
                        }
                        any.namespace("##other");
                        this.writeOccurs(any, bl, bl2);
                    }
                });
            }
            final Tree tree = Tree.makeGroup(GroupKind.CHOICE, arrayList).makeRepeated(referencePropertyInfo.isCollection()).makeOptional(!referencePropertyInfo.isRequired());
            final QName qName = referencePropertyInfo.getXmlName();
            if (qName != null) {
                return new Tree.Term(){

                    @Override
                    protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                        LocalElement localElement = contentModelContainer.element().name(qName.getLocalPart());
                        Namespace.this.elementFormDefault.writeForm(localElement, qName);
                        if (referencePropertyInfo.isCollectionNillable()) {
                            localElement.nillable(true);
                        }
                        this.writeOccurs(localElement, true, bl2);
                        ComplexType complexType = localElement.complexType();
                        tree.write(complexType);
                    }
                };
            }
            return tree;
        }

        private Tree handleMapProp(final MapPropertyInfo<T, C> mapPropertyInfo) {
            return new Tree.Term(){

                @Override
                protected void write(ContentModelContainer contentModelContainer, boolean bl, boolean bl2) {
                    QName qName = mapPropertyInfo.getXmlName();
                    LocalElement localElement = contentModelContainer.element();
                    Namespace.this.elementFormDefault.writeForm(localElement, qName);
                    if (mapPropertyInfo.isCollectionNillable()) {
                        localElement.nillable(true);
                    }
                    localElement = localElement.name(qName.getLocalPart());
                    this.writeOccurs(localElement, bl, bl2);
                    ComplexType complexType = localElement.complexType();
                    localElement = complexType.sequence().element();
                    localElement.name("entry").minOccurs(0).maxOccurs("unbounded");
                    ExplicitGroup explicitGroup = localElement.complexType().sequence();
                    Namespace.this.writeKeyOrValue(explicitGroup, "key", mapPropertyInfo.getKeyType());
                    Namespace.this.writeKeyOrValue(explicitGroup, "value", mapPropertyInfo.getValueType());
                }
            };
        }

        private void writeKeyOrValue(ExplicitGroup explicitGroup, String string, NonElement<T, C> nonElement) {
            LocalElement localElement = explicitGroup.element().name(string);
            localElement.minOccurs(0);
            this.writeTypeRef((TypeHost)localElement, nonElement, "type");
        }

        public void addGlobalAttribute(AttributePropertyInfo<T, C> attributePropertyInfo) {
            this.attributeDecls.put(attributePropertyInfo.getXmlName().getLocalPart(), attributePropertyInfo);
            this.addDependencyTo(attributePropertyInfo.getTarget().getTypeName());
        }

        public void addGlobalElement(TypeRef<T, C> typeRef) {
            this.elementDecls.put(typeRef.getTagName().getLocalPart(), (com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration)new ElementWithType(false, typeRef.getTarget()));
            this.addDependencyTo(typeRef.getTarget().getTypeName());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[classes=").append(this.classes);
            stringBuilder.append(",elementDecls=").append(this.elementDecls);
            stringBuilder.append(",enums=").append(this.enums);
            stringBuilder.append("]");
            return super.toString();
        }

        abstract class ElementDeclaration {
            ElementDeclaration() {
            }

            public abstract boolean equals(Object var1);

            public abstract int hashCode();

            public abstract void writeTo(String var1, Schema var2);
        }

        /*
         * Signature claims super is com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace.ElementDeclaration, not com.sun.xml.internal.bind.v2.schemagen.XmlSchemaGenerator$Namespace$ElementDeclaration - discarding signature.
         */
        class ElementWithType
        extends ElementDeclaration {
            private final boolean nillable;
            private final NonElement<T, C> type;

            public ElementWithType(boolean bl, NonElement<T, C> nonElement) {
                this.type = nonElement;
                this.nillable = bl;
            }

            @Override
            public void writeTo(String string, Schema schema) {
                TopLevelElement topLevelElement = schema.element().name(string);
                if (this.nillable) {
                    topLevelElement.nillable(true);
                }
                if (this.type != null) {
                    Namespace.this.writeTypeRef(topLevelElement, this.type, "type");
                } else {
                    topLevelElement.complexType();
                }
                topLevelElement.commit();
            }

            @Override
            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ElementWithType elementWithType = (ElementWithType)object;
                return this.type.equals(elementWithType.type);
            }

            @Override
            public int hashCode() {
                return this.type.hashCode();
            }
        }
    }
}

