/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.utils;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;

public final class XMLSecurityManager {
    private final int[] values = new int[Limit.values().length];
    private State[] states = new State[Limit.values().length];
    private boolean[] isSet = new boolean[Limit.values().length];
    private int indexEntityCountInfo = 10000;
    private String printEntityCountInfo = "";

    public XMLSecurityManager() {
        this(false);
    }

    public XMLSecurityManager(boolean bl) {
        for (Limit limit : Limit.values()) {
            if (bl) {
                this.values[limit.ordinal()] = limit.secureValue();
                this.states[limit.ordinal()] = State.FSP;
                continue;
            }
            this.values[limit.ordinal()] = limit.defaultValue();
            this.states[limit.ordinal()] = State.DEFAULT;
        }
        this.readSystemProperties();
    }

    public void setSecureProcessing(boolean bl) {
        for (Limit limit : Limit.values()) {
            if (bl) {
                this.setLimit(limit.ordinal(), State.FSP, limit.secureValue());
                continue;
            }
            this.setLimit(limit.ordinal(), State.FSP, limit.defaultValue());
        }
    }

    public boolean setLimit(String string, State state, Object object) {
        int n = this.getIndex(string);
        if (n > -1) {
            this.setLimit(n, state, object);
            return true;
        }
        return false;
    }

    public void setLimit(Limit limit, State state, int n) {
        this.setLimit(limit.ordinal(), state, n);
    }

    public void setLimit(int n, State state, Object object) {
        if (n == this.indexEntityCountInfo) {
            this.printEntityCountInfo = (String)object;
        } else {
            int n2 = 0;
            try {
                n2 = Integer.parseInt((String)object);
                if (n2 < 0) {
                    n2 = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.setLimit(n, state, n2);
        }
    }

    public void setLimit(int n, State state, int n2) {
        if (n == this.indexEntityCountInfo) {
            this.printEntityCountInfo = "yes";
        } else if (state.compareTo(this.states[n]) >= 0) {
            this.values[n] = n2;
            this.states[n] = state;
            this.isSet[n] = true;
        }
    }

    public String getLimitAsString(String string) {
        int n = this.getIndex(string);
        if (n > -1) {
            return this.getLimitValueByIndex(n);
        }
        return null;
    }

    public String getLimitValueAsString(Limit limit) {
        return Integer.toString(this.values[limit.ordinal()]);
    }

    public int getLimit(Limit limit) {
        return this.values[limit.ordinal()];
    }

    public int getLimitByIndex(int n) {
        return this.values[n];
    }

    public String getLimitValueByIndex(int n) {
        if (n == this.indexEntityCountInfo) {
            return this.printEntityCountInfo;
        }
        return Integer.toString(this.values[n]);
    }

    public State getState(Limit limit) {
        return this.states[limit.ordinal()];
    }

    public String getStateLiteral(Limit limit) {
        return this.states[limit.ordinal()].literal();
    }

    public int getIndex(String string) {
        for (Limit limit : Limit.values()) {
            if (!limit.equalsAPIPropertyName(string)) continue;
            return limit.ordinal();
        }
        if (string.equals("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo")) {
            return this.indexEntityCountInfo;
        }
        return -1;
    }

    public boolean isSet(int n) {
        return this.isSet[n];
    }

    public boolean printEntityCountInfo() {
        return this.printEntityCountInfo.equals("yes");
    }

    private void readSystemProperties() {
        for (Limit limit : Limit.values()) {
            if (this.getSystemProperty(limit, limit.systemProperty())) continue;
            for (NameMap nameMap : NameMap.values()) {
                String string = nameMap.getOldName(limit.systemProperty());
                if (string == null) continue;
                this.getSystemProperty(limit, string);
            }
        }
    }

    private boolean getSystemProperty(Limit limit, String string) {
        try {
            String string2 = SecuritySupport.getSystemProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.values[limit.ordinal()] = Integer.parseInt(string2);
                this.states[limit.ordinal()] = State.SYSTEMPROPERTY;
                return true;
            }
            string2 = SecuritySupport.readJAXPProperty(string);
            if (string2 != null && !string2.equals("")) {
                this.values[limit.ordinal()] = Integer.parseInt(string2);
                this.states[limit.ordinal()] = State.JAXPDOTPROPERTIES;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid setting for system property: " + limit.systemProperty());
        }
        return false;
    }

    public static enum Limit {
        ENTITY_EXPANSION_LIMIT("http://www.oracle.com/xml/jaxp/properties/entityExpansionLimit", "jdk.xml.entityExpansionLimit", 0, 64000),
        MAX_OCCUR_NODE_LIMIT("http://www.oracle.com/xml/jaxp/properties/maxOccurLimit", "jdk.xml.maxOccurLimit", 0, 5000),
        ELEMENT_ATTRIBUTE_LIMIT("http://www.oracle.com/xml/jaxp/properties/elementAttributeLimit", "jdk.xml.elementAttributeLimit", 0, 10000),
        TOTAL_ENTITY_SIZE_LIMIT("http://www.oracle.com/xml/jaxp/properties/totalEntitySizeLimit", "jdk.xml.totalEntitySizeLimit", 0, 50000000),
        GENERAL_ENTITY_SIZE_LIMIT("http://www.oracle.com/xml/jaxp/properties/maxGeneralEntitySizeLimit", "jdk.xml.maxGeneralEntitySizeLimit", 0, 0),
        PARAMETER_ENTITY_SIZE_LIMIT("http://www.oracle.com/xml/jaxp/properties/maxParameterEntitySizeLimit", "jdk.xml.maxParameterEntitySizeLimit", 0, 1000000);

        final String apiProperty;
        final String systemProperty;
        final int defaultValue;
        final int secureValue;

        private Limit(String string2, String string3, int n2, int n3) {
            this.apiProperty = string2;
            this.systemProperty = string3;
            this.defaultValue = n2;
            this.secureValue = n3;
        }

        public boolean equalsAPIPropertyName(String string) {
            return string == null ? false : this.apiProperty.equals(string);
        }

        public boolean equalsSystemPropertyName(String string) {
            return string == null ? false : this.systemProperty.equals(string);
        }

        public String apiProperty() {
            return this.apiProperty;
        }

        String systemProperty() {
            return this.systemProperty;
        }

        int defaultValue() {
            return this.defaultValue;
        }

        int secureValue() {
            return this.secureValue;
        }
    }

    public static enum NameMap {
        ENTITY_EXPANSION_LIMIT("jdk.xml.entityExpansionLimit", "entityExpansionLimit"),
        MAX_OCCUR_NODE_LIMIT("jdk.xml.maxOccurLimit", "maxOccurLimit"),
        ELEMENT_ATTRIBUTE_LIMIT("jdk.xml.elementAttributeLimit", "elementAttributeLimit");

        final String newName;
        final String oldName;

        private NameMap(String string2, String string3) {
            this.newName = string2;
            this.oldName = string3;
        }

        String getOldName(String string) {
            if (string.equals(this.newName)) {
                return this.oldName;
            }
            return null;
        }
    }

    public static enum State {
        DEFAULT("default"),
        FSP("FEATURE_SECURE_PROCESSING"),
        JAXPDOTPROPERTIES("jaxp.properties"),
        SYSTEMPROPERTY("system property"),
        APIPROPERTY("property");

        final String literal;

        private State(String string2) {
            this.literal = string2;
        }

        String literal() {
            return this.literal;
        }
    }
}

