/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.util.Objects;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.runtime.PropertyDescriptor;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptFunction;
import jdk.nashorn.internal.runtime.ScriptObject;

public abstract class Property {
    public static final int WRITABLE_ENUMERABLE_CONFIGURABLE = 0;
    public static final int NOT_WRITABLE = 1;
    public static final int NOT_ENUMERABLE = 2;
    public static final int NOT_CONFIGURABLE = 4;
    private static final int MODIFY_MASK = 7;
    public static final int IS_SPILL = 8;
    public static final int IS_PARAMETER = 16;
    public static final int HAS_ARGUMENTS = 32;
    public static final int IS_ALWAYS_OBJECT = 64;
    public static final int CAN_BE_PRIMITIVE = 128;
    public static final int CAN_BE_UNDEFINED = 256;
    public static final int IS_FUNCTION_DECLARATION = 512;
    private final String key;
    protected int flags;
    private final int slot;

    Property(String key, int flags, int slot) {
        assert (key != null);
        this.key = key;
        this.flags = flags;
        this.slot = slot;
    }

    Property(Property property) {
        this.key = property.key;
        this.flags = property.flags;
        this.slot = property.slot;
    }

    abstract Property copy();

    static int mergeFlags(PropertyDescriptor oldDesc, PropertyDescriptor newDesc) {
        boolean value;
        int propFlags = 0;
        boolean bl = value = newDesc.has("configurable") ? newDesc.isConfigurable() : oldDesc.isConfigurable();
        if (!value) {
            propFlags |= 4;
        }
        boolean bl2 = value = newDesc.has("enumerable") ? newDesc.isEnumerable() : oldDesc.isEnumerable();
        if (!value) {
            propFlags |= 2;
        }
        boolean bl3 = value = newDesc.has("writable") ? newDesc.isWritable() : oldDesc.isWritable();
        if (!value) {
            propFlags |= 1;
        }
        return propFlags;
    }

    static int toFlags(PropertyDescriptor desc) {
        int propFlags = 0;
        if (!desc.isConfigurable()) {
            propFlags |= 4;
        }
        if (!desc.isEnumerable()) {
            propFlags |= 2;
        }
        if (!desc.isWritable()) {
            propFlags |= 1;
        }
        return propFlags;
    }

    public boolean hasGetterFunction(ScriptObject obj) {
        return false;
    }

    public boolean hasSetterFunction(ScriptObject obj) {
        return false;
    }

    public boolean isWritable() {
        return (this.flags & 1) == 0;
    }

    public boolean isConfigurable() {
        return (this.flags & 4) == 0;
    }

    public boolean isEnumerable() {
        return (this.flags & 2) == 0;
    }

    public boolean isParameter() {
        return (this.flags & 0x10) == 16;
    }

    public boolean hasArguments() {
        return (this.flags & 0x20) == 32;
    }

    public boolean isSpill() {
        return (this.flags & 8) == 8;
    }

    public int getSpillCount() {
        return this.isSpill() ? 1 : 0;
    }

    public Property addFlags(int propertyFlags) {
        if ((this.flags & propertyFlags) != propertyFlags) {
            Property cloned = this.copy();
            cloned.flags |= propertyFlags;
            return cloned;
        }
        return this;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getModifyFlags() {
        return this.flags & 7;
    }

    public Property removeFlags(int propertyFlags) {
        if ((this.flags & propertyFlags) != 0) {
            Property cloned = this.copy();
            cloned.flags &= ~propertyFlags;
            return cloned;
        }
        return this;
    }

    public Property setFlags(int propertyFlags) {
        if (this.flags != propertyFlags) {
            Property cloned = this.copy();
            cloned.flags &= 0xFFFFFFF8;
            cloned.flags |= propertyFlags & 7;
            return cloned;
        }
        return this;
    }

    public abstract MethodHandle getGetter(Class<?> var1);

    public String getKey() {
        return this.key;
    }

    public int getSlot() {
        return this.slot;
    }

    public abstract void setObjectValue(ScriptObject var1, ScriptObject var2, Object var3, boolean var4);

    public abstract Object getObjectValue(ScriptObject var1, ScriptObject var2);

    public abstract MethodHandle getSetter(Class<?> var1, PropertyMap var2);

    public ScriptFunction getGetterFunction(ScriptObject obj) {
        return null;
    }

    public ScriptFunction getSetterFunction(ScriptObject obj) {
        return null;
    }

    public int hashCode() {
        Class<?> type = this.getCurrentType();
        return Objects.hashCode(this.key) ^ this.flags ^ this.getSlot() ^ (type == null ? 0 : type.hashCode());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Property otherProperty = (Property)other;
        return this.getFlags() == otherProperty.getFlags() && this.getSlot() == otherProperty.getSlot() && this.getCurrentType() == otherProperty.getCurrentType() && this.getKey().equals(otherProperty.getKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Class<?> type = this.getCurrentType();
        sb.append(this.getKey()).append("(0x").append(Integer.toHexString(this.flags)).append(") ").append(this.getClass().getSimpleName()).append(" {").append(type == null ? "UNDEFINED" : Type.typeFor(type).getDescriptor()).append('}');
        if (this.slot != -1) {
            sb.append('[');
            sb.append(this.slot);
            sb.append(']');
        }
        return sb.toString();
    }

    public Class<?> getCurrentType() {
        return Object.class;
    }

    public boolean canChangeType() {
        return false;
    }

    public boolean isAlwaysObject() {
        return (this.flags & 0x40) == 64;
    }

    public boolean canBePrimitive() {
        return (this.flags & 0x80) == 128;
    }

    public boolean canBeUndefined() {
        return (this.flags & 0x100) == 256;
    }

    public boolean isFunctionDeclaration() {
        return (this.flags & 0x200) == 512;
    }
}

