/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.misc;

import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.pointers.NullPointer;
import org.xvolks.jnative.pointers.Pointer;

public class SecurityAttributes {
    private int nLength = 12;
    private Pointer lpSecurityDescriptor = new NullPointer();
    private boolean bInheritHandle = true;
    private Pointer self;

    public Pointer getPointer() {
        return this.self;
    }

    public void dispose() throws NativeException {
        this.self.dispose();
        this.lpSecurityDescriptor.dispose();
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        catch (NativeException e) {
            e.printStackTrace();
        }
    }

    public void setNLength(int nLength) throws NativeException {
        this.nLength = nLength;
        this.self.setIntAt(0, nLength);
    }

    public int getNLength() throws NativeException {
        this.nLength = this.self.getAsInt(0);
        return this.nLength;
    }

    public void setLpSecurityDescriptor(Pointer lpSecurityDescriptor) throws NativeException {
        this.lpSecurityDescriptor = lpSecurityDescriptor;
        this.self.setIntAt(4, lpSecurityDescriptor.getPointer());
    }

    public Pointer getLpSecurityDescriptor() {
        return this.lpSecurityDescriptor;
    }

    public void setBInheritHandle(boolean bInheritHandle) throws NativeException {
        this.bInheritHandle = bInheritHandle;
        this.lpSecurityDescriptor.setIntAt(8, bInheritHandle ? 1 : 0);
    }

    public boolean isBInheritHandle() throws NativeException {
        this.bInheritHandle = this.lpSecurityDescriptor.getAsInt(8) != 0;
        return this.bInheritHandle;
    }
}

