/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.typebrowser.business;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.com.typebrowser.business.CLSID;
import org.xvolks.jnative.com.typebrowser.business.TypeLibNotFoundException;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.HKEY;
import org.xvolks.jnative.misc.REGSAM;
import org.xvolks.jnative.misc.registry.RegKey;
import org.xvolks.jnative.util.Advapi32;
import org.xvolks.test.JNativeTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLSIDs {
    private final List<CLSID> cLSIDs = new ArrayList<CLSID>();

    public static void main(String[] args) throws NativeException, IllegalAccessException, IOException {
        System.getProperties().put("jnative.debug", "true");
        System.getProperties().put("jnative.loadNative", "manual");
        JNative.getLogger().log(JNativeLogger.SEVERITY.INFO, "CLSIDs list tester");
        JNativeTester.loadLib();
        new CLSIDs().initialize();
    }

    public CLSIDs() throws NativeException, IllegalAccessException {
        this.initialize();
    }

    private void initialize() throws NativeException, IllegalAccessException {
        HKEY hKey = Advapi32.RegOpenKeyEx(HKEY.HKEY_CLASSES_ROOT, "CLSID", REGSAM.KEY_READ);
        int i = 0;
        RegKey lKey = null;
        long start = System.currentTimeMillis();
        while (true) {
            if ((lKey = Advapi32.RegEnumKeyEx(hKey, i, null)).getErrorCode() != 0) break;
            String guid = lKey.getLpValueName().getAsString();
            try {
                CLSID clsid = new CLSID(guid);
                this.cLSIDs.add(clsid);
            }
            catch (TypeLibNotFoundException e) {
                JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, e);
            }
            ++i;
        }
        JNative.getLogger().log("Exiting code " + lKey.getErrorCode() + ", after " + i + " iterations.");
        long end = System.currentTimeMillis();
        JNative.getLogger().log("Took : " + (end - start));
    }

    public List<CLSID> getCLSIDs() {
        return this.cLSIDs;
    }
}

