/*
 * Decompiled with CFR 0.152.
 */
package org.xvolks.jnative.com.typebrowser.business;

import java.util.ArrayList;
import java.util.List;
import org.xvolks.jnative.JNative;
import org.xvolks.jnative.com.typebrowser.business.TypeLibNotFoundException;
import org.xvolks.jnative.exceptions.NativeException;
import org.xvolks.jnative.logging.JNativeLogger;
import org.xvolks.jnative.misc.HKEY;
import org.xvolks.jnative.misc.REGSAM;
import org.xvolks.jnative.misc.registry.RegKey;
import org.xvolks.jnative.pointers.Pointer;
import org.xvolks.jnative.util.Advapi32;
import org.xvolks.jnative.util.ole.Ole32;
import org.xvolks.jnative.util.ole.Oleaut32;

public class CLSID {
    private final String guid;
    private final boolean control;
    private final String description;
    private final String progID;
    private final String inprocServer32;
    private final String typeLib;
    private final List<Integer> majorVersion = new ArrayList<Integer>();
    private final List<Integer> minorVersion = new ArrayList<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CLSID(String guid) throws NativeException, IllegalAccessException, TypeLibNotFoundException {
        this.guid = guid;
        this.description = Advapi32.RegQueryDefaultValue(HKEY.HKEY_CLASSES_ROOT, "CLSID\\" + guid);
        this.control = Advapi32.isKeyExists(HKEY.HKEY_CLASSES_ROOT, "CLSID\\" + guid + "\\Control");
        this.progID = Advapi32.RegQueryDefaultValue(HKEY.HKEY_CLASSES_ROOT, "CLSID\\" + guid + "\\ProgID");
        this.inprocServer32 = Advapi32.RegQueryDefaultValue(HKEY.HKEY_CLASSES_ROOT, "CLSID\\" + guid + "\\InprocServer32");
        this.typeLib = Advapi32.RegQueryDefaultValue(HKEY.HKEY_CLASSES_ROOT, "CLSID\\" + guid + "\\TypeLib");
        if (this.typeLib == null) {
            throw new TypeLibNotFoundException();
        }
        HKEY typeInfo = Advapi32.RegOpenKeyEx(HKEY.HKEY_CLASSES_ROOT, "TypeLib\\" + this.typeLib, REGSAM.KEY_READ);
        if (this.progID != null && this.progID.indexOf("Shell.Explorer.2") != -1) {
            JNative.getLogger().log(guid);
        }
        if (typeInfo == null) {
            JNative.getLogger().log(JNativeLogger.SEVERITY.DEBUG, guid + " has no typeLib");
            return;
        }
        try {
            int dwIndex = 0;
            RegKey lKey = Advapi32.RegEnumKeyEx(typeInfo, dwIndex++, null);
            while (lKey.getErrorCode() == 0) {
                String version = lKey.getLpValueName().getAsString();
                try {
                    if (version.indexOf(46) != -1) {
                        this.majorVersion.add(Integer.parseInt(version.substring(0, version.indexOf(46))));
                        this.minorVersion.add(Integer.parseInt(version.substring(1 + version.indexOf(46))));
                    } else {
                        this.majorVersion.add(Integer.parseInt(version));
                    }
                }
                catch (NumberFormatException e) {
                    JNative.getLogger().log("Guid : " + guid + ", TypeLib : " + this.typeLib + " has no version information !!!");
                    throw new TypeLibNotFoundException();
                }
                lKey = Advapi32.RegEnumKeyEx(typeInfo, dwIndex++, null);
            }
            Object var8_7 = null;
            if (typeInfo == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (typeInfo == null) throw throwable;
            Advapi32.RegCloseKey(typeInfo);
            throw throwable;
        }
        Advapi32.RegCloseKey(typeInfo);
    }

    public String toString() {
        return this.guid + "-" + this.control + "-" + this.description + "-" + this.progID + "-" + this.inprocServer32;
    }

    public String getGuid() {
        return this.guid;
    }

    public boolean isControl() {
        return this.control;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProgID() {
        return this.progID;
    }

    public String getInprocServer32() {
        return this.inprocServer32;
    }

    public void loadRegType() throws NativeException, IllegalAccessException {
        if (this.majorVersion.size() != 1 || this.minorVersion.size() >= 2) {
            throw new IllegalArgumentException("Multi-version activex are not supported yet");
        }
        Pointer pointer = Oleaut32.LoadRegTypeLib(Ole32.CLSIDFromString(this.getGuid()).getPointer(), this.majorVersion.get(0), this.minorVersion.get(0), 0);
    }
}

