/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public final class BooleanConverter
extends AbstractConverter {
    public static final Object NO_DEFAULT = new Object();
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};
    static /* synthetic */ Class class$java$lang$Boolean;

    public BooleanConverter() {
        super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    public BooleanConverter(Object defaultValue) {
        super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings, Object defaultValue) {
        super(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BooleanConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
        if (defaultValue != NO_DEFAULT) {
            this.setDefaultValue(defaultValue);
        }
    }

    protected Object convertToType(Class type, Object value) throws Throwable {
        String stringValue = value.toString().toLowerCase();
        int i = 0;
        while (i < this.trueStrings.length) {
            if (this.trueStrings[i].equals(stringValue)) {
                return Boolean.TRUE;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.falseStrings.length) {
            if (this.falseStrings[i2].equals(stringValue)) {
                return Boolean.FALSE;
            }
            ++i2;
        }
        throw new ConversionException("Cna't convert value '" + value + "' to a Boolean");
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        int i = 0;
        while (i < src.length) {
            dst[i] = src[i].toLowerCase();
            ++i;
        }
        return dst;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

