/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.support;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public final class FormHelper {
    public static Pattern P_SPACE = Pattern.compile("\\s+");
    public static Pattern P_DIV = Pattern.compile("\\-{3,}");
    public static Pattern P_DATE_DIV = Pattern.compile("\\s*[-]{1,}\\s*");
    public static Pattern P_ACCOUNT = Pattern.compile("[\\w\\.\\-]+@\\w[\\w\\.]+\\.\\w+");
    public static Pattern P_PASSWORD = Pattern.compile("[^\\s]{6,30}");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static List<String[]> parseArea(String text) {
        text = text.replace(" ", "");
        String[] arr = P_SPACE.split(text);
        ArrayList<String[]> list = new ArrayList<String[]>(arr.length);
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(P_DIV.split(str));
            ++n2;
        }
        return list;
    }

    public static boolean checkAccount(String account) {
        return P_ACCOUNT.matcher(account).matches();
    }

    public static boolean checkPassword(String password) {
        return P_PASSWORD.matcher(password).matches();
    }

    public static Date parseDate(String yyyy_MM_dd) {
        String[] arr = P_DATE_DIV.split(yyyy_MM_dd);
        try {
            if (arr.length == 3) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(arr[0]).append("-");
                if (arr[1].length() == 1) {
                    buffer.append("0");
                }
                buffer.append(arr[1]).append("-");
                if (arr[2].length() == 1) {
                    buffer.append("0");
                }
                buffer.append(arr[2]);
                return sdf.parse(buffer.toString());
            }
        }
        catch (ParseException e) {
            e.printStackTrace(System.out);
        }
        return FormHelper.getCalendar().getTime();
    }

    public static String formatDate(Date date) throws Exception {
        return sdf.format(date);
    }

    public static Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        c.clear();
        c.set(y, m, d, 0, 0, 0);
        return c;
    }

    public static Calendar getMonday() {
        Calendar c = Calendar.getInstance();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        c.clear();
        c.set(y, m, d, 0, 0, 0);
        if (c.get(7) == 1) {
            c.add(5, -1);
        }
        c.set(7, 2);
        return c;
    }
}

