/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.logicimpl;

import com.coyousoft.yundama.constant.Dao;
import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterDayCode;
import com.coyousoft.yundama.logic.MasterLogic;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MasterLogicImpl
implements MasterLogic {
    private static final Log log = LogFactory.getLog(MasterLogic.class);
    private static Map<String, Master> cacheMap = new HashMap<String, Master>(2048);
    private static Map<Integer, Master> id$cacheMap = new HashMap<Integer, Master>(2048);

    @Override
    public void create(Master master) throws Exception {
        Dao.masterDao.create(master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(List<Master> masterList) throws Exception {
        for (Master master : masterList) {
            Master dbMaster = Dao.masterDao.fetchByAccount(master.getMasterAccount());
            if (dbMaster == null) {
                this.create(master);
                continue;
            }
            master.setMasterId(dbMaster.getMasterId());
            Dao.masterDao.update(master);
            Map<String, Master> map = cacheMap;
            synchronized (map) {
                cacheMap.put(master.getMasterAccount(), master);
                id$cacheMap.put(master.getMasterId(), master);
            }
        }
    }

    @Override
    public int remove(Integer masterId) throws Exception {
        return Dao.masterDao.remove(masterId);
    }

    @Override
    public int update(Master master) throws Exception {
        return Dao.masterDao.update(master);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Master fetch(Integer masterId) throws Exception {
        Master master = id$cacheMap.get(masterId);
        if (master == null) {
            Map<String, Master> map = cacheMap;
            synchronized (map) {
                master = Dao.masterDao.fetch(masterId);
                if (master != null) {
                    cacheMap.put(master.getMasterAccount(), master);
                    id$cacheMap.put(master.getMasterId(), master);
                }
            }
        }
        master.setLastUseDate(new Date());
        return master;
    }

    @Override
    public List<Master> export(int offset, int limit) throws Exception {
        return Dao.masterDao.export(offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws Exception {
        Map<String, Master> map = cacheMap;
        synchronized (map) {
            Iterator<Map.Entry<String, Master>> itr = cacheMap.entrySet().iterator();
            Master master = null;
            while (itr.hasNext()) {
                master = itr.next().getValue();
                if (this.checkPlayCode(master)) continue;
                itr.remove();
            }
            Iterator<Map.Entry<Integer, Master>> idItr = id$cacheMap.entrySet().iterator();
            while (idItr.hasNext()) {
                master = idItr.next().getValue();
                if (this.checkPlayCode(master)) continue;
                idItr.remove();
            }
        }
    }

    private boolean checkPlayCode(Master master) {
        return master.getLastUseDate() == null || System.currentTimeMillis() - master.getLastUseDate().getTime() <= 600000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Master fetchByAccount(String masterAccount, String masterPassword) throws Exception {
        if (masterAccount == null || masterPassword == null || "".equals(masterAccount.trim()) || "".equals(masterPassword.trim())) {
            return null;
        }
        Master master = cacheMap.get(masterAccount);
        if (master == null) {
            Map<String, Master> map = cacheMap;
            synchronized (map) {
                master = Dao.masterDao.fetchByAccount(masterAccount);
                if (master != null) {
                    cacheMap.put(master.getMasterAccount(), master);
                    id$cacheMap.put(master.getMasterId(), master);
                }
            }
        }
        if (master != null && master.getMasterPassword().equals(masterPassword)) {
            master.setLastUseDate(new Date());
            return master;
        }
        log.error("ERROR_MASTER - " + masterAccount + " - " + masterPassword);
        return null;
    }

    @Override
    public List<MasterDayCode> fetchList(Date beginDate, Date endDate) throws Exception {
        return Dao.masterDao.fetchList(beginDate, endDate);
    }

    @Override
    public void updateBalance(List<Master> masterList) throws Exception {
        Dao.masterDao.updateBalance(masterList);
        Master cache = null;
        for (Master master : masterList) {
            cache = id$cacheMap.get(master.getMasterId());
            if (cache == null) continue;
            cache.setMasterBalance(master.getMasterBalance());
        }
    }

    @Override
    public void updateBalance(Integer masterId) throws Exception {
        ArrayList<Master> masterList = new ArrayList<Master>(1024);
        masterList.add(new Master().setMasterId(masterId).setMasterBalance(Dao.masterBillDao.sumBalance(masterId)));
        Logic.masterLogic.updateBalance(masterList);
    }
}

