/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.logicimpl;

import com.coyousoft.yundama.constant.Dao;
import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterBill;
import com.coyousoft.yundama.entity.MasterDayCode;
import com.coyousoft.yundama.logic.MasterBillLogic;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sysolar.sun.config.FileConfig;

public final class MasterBillLogicImpl
implements MasterBillLogic {
    private static Set<Long> set = new HashSet<Long>(12);

    @Override
    public void create(MasterBill masterBill) throws Exception {
        Dao.masterBillDao.create(masterBill);
    }

    @Override
    public void create(List<MasterBill> masterBillList) throws Exception {
        Dao.masterBillDao.create(masterBillList);
    }

    @Override
    public int remove(Integer billId) throws Exception {
        MasterBill bill = Dao.masterBillDao.fetch(billId);
        set.remove(bill.getBillDate().getTime());
        return Dao.masterBillDao.remove(billId);
    }

    @Override
    public int update(MasterBill masterBill) throws Exception {
        return Dao.masterBillDao.update(masterBill);
    }

    @Override
    public MasterBill fetch(Integer billId) throws Exception {
        return Dao.masterBillDao.fetch(billId);
    }

    @Override
    public List<MasterBill> export(int offset, int limit) throws Exception {
        return Dao.masterBillDao.export(offset, limit);
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public synchronized void fresh() throws Exception {
        Calendar c = Calendar.getInstance();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        c.clear();
        c.set(y, m, d, 0, 0, 0);
        ArrayList<MasterBill> billUpdateList = new ArrayList<MasterBill>(1024);
        ArrayList<MasterBill> billCreateList = new ArrayList<MasterBill>(1024);
        HashSet<Integer> masterIdSet = new HashSet<Integer>(1024);
        int i = 10;
        while (i >= 0) {
            c.clear();
            c.set(y, m, d, 0, 0, 0);
            if (i > 0) {
                c.add(5, -1 * i);
            }
            if (i <= 0 || set.add(c.getTime().getTime())) {
                List<MasterDayCode> masterDayCodeList = Dao.masterDayCodeDao.fetchList(c.getTime());
                Map<Integer, MasterBill> masterBillMap = null;
                masterBillMap = Dao.masterBillDao.fetchMapByBillDate(c.getTime(), 2);
                StringBuilder buffer = new StringBuilder(1024);
                MasterBill oldMasterBill = null;
                MasterBill newMasterBill = null;
                Integer masterId = null;
                for (MasterDayCode masterDayCode : masterDayCodeList) {
                    masterId = masterDayCode.getMasterId();
                    oldMasterBill = masterBillMap.get(masterId);
                    Double codePrice = masterDayCode.getCodePrice();
                    if (codePrice == null) {
                        Master master = Logic.masterLogic.fetch(masterId);
                        codePrice = master.getCodePrice();
                    }
                    buffer.delete(0, buffer.length());
                    buffer.append("\u3010\u5343\u7801\u4ef7\u683c\u3011").append(codePrice).append(" \u5143\u3010\u6210\u529f\u6253\u7801\u3011 ").append(masterDayCode.getCodeNum()).append(" \u4e2a");
                    double billAmount = -1.0 * codePrice * (double)masterDayCode.getCodeNum().intValue() / 1000.0;
                    newMasterBill = new MasterBill().setMasterId(masterId).setBillDate(c.getTime()).setBillAmount(billAmount).setBillType(2).setBillInfo(buffer.toString());
                    if (oldMasterBill == null) {
                        billCreateList.add(newMasterBill);
                        masterIdSet.add(masterId);
                        continue;
                    }
                    if (!(Math.abs(billAmount - oldMasterBill.getBillAmount()) > 0.01)) continue;
                    billUpdateList.add(newMasterBill);
                    masterIdSet.add(masterId);
                }
            }
            --i;
        }
        Dao.masterBillDao.updateBillAmount(billUpdateList);
        Dao.masterBillDao.create(billCreateList);
        ArrayList<Master> masterList = new ArrayList<Master>(1024);
        for (Integer id : masterIdSet) {
            masterList.add(new Master().setMasterId(id).setMasterBalance(Dao.masterBillDao.sumBalance(id)));
        }
        Logic.masterLogic.updateBalance(masterList);
    }

    @Override
    public List<MasterBill> fetchListByMasterId(Integer masterId) throws Exception {
        int masterBillListNum = FileConfig.getInteger((String)"masterBillListNum", (Integer)30);
        return Dao.masterBillDao.fetchListByMasterId(masterId, masterBillListNum);
    }

    @Override
    public void doCharge(Integer masterId, Double billAmount) throws Exception {
        Date date = new Date();
        MasterBill masterBill = new MasterBill();
        masterBill.setMasterId(masterId).setBillDate(date).setBillAmount(billAmount).setBillType(1).setBillInfo("\u5145\u503c").setBillCdate(date);
        Dao.masterBillDao.create(masterBill);
        Calendar c = Calendar.getInstance();
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        c.clear();
        c.set(y, m, d, 0, 0, 0);
        MasterBill codeBill = Dao.masterBillDao.fetchByBillDate(masterId, c.getTime(), 2);
        if (codeBill != null) {
            this.remove(codeBill.getBillId());
        }
        this.fresh();
        Logic.masterLogic.updateBalance(masterId);
    }
}

