/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.logicimpl;

import com.coyousoft.yundama.constant.Dao;
import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.AnswerDayCode;
import com.coyousoft.yundama.entity.DayCode;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterDayCode;
import com.coyousoft.yundama.logic.DayCodeLogic;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.config.FileConfig;
import org.sysolar.util.file.FileIO;

public final class DayCodeLogicImpl
implements DayCodeLogic {
    private static final Log log = LogFactory.getLog(DayCodeLogic.class);
    private static final String SRC_TABLE_NAME = "DAY_CODE";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static final Set<String> cacheSet = new HashSet<String>(256);
    private static Map<Integer, DayCode> totalCacheMap = new HashMap<Integer, DayCode>(8192);
    private static List<DayCode> cacheList = new ArrayList<DayCode>(8192);
    private static Map<Integer, DayCode> takedCacheMap = new HashMap<Integer, DayCode>(1024);
    private static Map<Integer, DayCode> answeredCacheMap = new HashMap<Integer, DayCode>(1024);
    private static List<DayCode> wrongCacheList = new ArrayList<DayCode>(1024);
    private static final Pattern pTableName = Pattern.compile("DAY_CODE_(\\d{8})");
    public static Map<String, Answer> onlineCacheMap = new HashMap<String, Answer>(1024);
    private static Map<Integer, DayCode> outDateCacheMap = new HashMap<Integer, DayCode>(1024);
    private static int onlineInterval = 60000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(DayCode dayCode) throws Exception {
        Object object;
        if (this.isMore()) {
            dayCode.setCodeStatus(1).setAnswerDate(new Date());
            Dao.dayCodeDao.create(dayCode, true);
        } else {
            Dao.dayCodeDao.create(dayCode, true);
            object = cacheList;
            synchronized (object) {
                dayCode.setCodeStatus(0);
                cacheList.add(dayCode);
            }
        }
        object = totalCacheMap;
        synchronized (object) {
            totalCacheMap.put(dayCode.getCodeId(), dayCode);
        }
    }

    @Override
    public boolean isMore() {
        Integer answerAverageCodeNum = FileConfig.getInteger((String)"answerAverageCodeNum", (Integer)6);
        return cacheList.size() >= onlineCacheMap.size() * answerAverageCodeNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onlyCreate(DayCode dayCode) throws Exception {
        Dao.dayCodeDao.create(dayCode, true);
        Map<Integer, DayCode> map = totalCacheMap;
        synchronized (map) {
            totalCacheMap.put(dayCode.getCodeId(), dayCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DayCode fetch(Answer answer) throws Exception {
        DayCode dayCode = null;
        Object object = cacheList;
        synchronized (object) {
            do {
                if (cacheList.size() != 0) continue;
                return null;
            } while ((dayCode = cacheList.remove(cacheList.size() - 1)).getOutDate().getTime() <= System.currentTimeMillis() || dayCode.getCodeStatus() == 4);
            dayCode.setAnswerId(answer.getAnswerId());
            dayCode.setTakeDate(new Date()).setCodeStatus(1);
            if (log.isDebugEnabled()) {
                log.debug(dayCode.toString());
            }
        }
        if (dayCode == null) return dayCode;
        object = takedCacheMap;
        synchronized (object) {
            takedCacheMap.put(dayCode.getCodeId(), dayCode);
            return dayCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCodeText(Integer codeId, String codeText) throws Exception {
        DayCode dayCode = null;
        Map<Integer, DayCode> map = takedCacheMap;
        synchronized (map) {
            dayCode = takedCacheMap.get(codeId);
            if (dayCode == null) {
                outDateCacheMap.put(codeId, new DayCode().setCodeId(codeId).setCodeText(codeText).setAnswerDate(new Date()).setCodeStatus(1).setTableName(this.getTableName()));
                return;
            }
            takedCacheMap.remove(codeId);
        }
        if (this.isTimeout(dayCode)) {
            dayCode.setCodeStatus(3);
        } else {
            dayCode.setCodeStatus(2);
        }
        if (codeText != null) {
            codeText = codeText.trim();
        }
        dayCode.setCodeText(codeText).setAnswerDate(new Date()).setByteString(null);
        map = answeredCacheMap;
        synchronized (map) {
            answeredCacheMap.put(dayCode.getCodeId(), dayCode);
        }
    }

    @Override
    public List<DayCode> fetchCodeTextList(Integer[] codeIdArr, Master master) throws Exception {
        ArrayList<DayCode> dayCodeList = new ArrayList<DayCode>(codeIdArr.length);
        DayCode dayCode = null;
        Integer[] integerArray = codeIdArr;
        int n = codeIdArr.length;
        int n2 = 0;
        while (n2 < n) {
            Integer codeId = integerArray[n2];
            if (codeId < 0) {
                dayCode = master.getMasterBalance() == null || master.getMasterBalance() < 0.0 ? new DayCode().setCodeId(codeId).setMasterId(master.getMasterId()).setCodeStatus(-1).setCodeText("....") : new DayCode().setCodeId(codeId).setMasterId(master.getMasterId()).setCodeStatus(4).setCodeText("....");
                dayCodeList.add(dayCode);
            } else {
                dayCode = answeredCacheMap.get(codeId);
                if (dayCode == null) {
                    dayCode = totalCacheMap.get(codeId);
                    if (dayCode == null) {
                        dayCode = new DayCode().setCodeId(codeId).setMasterId(master.getMasterId()).setCodeStatus(3).setCodeText("SRES");
                        dayCodeList.add(dayCode);
                    } else if (dayCode.getCodeStatus() == 4) {
                        dayCodeList.add(dayCode.setCodeText("DISC"));
                    } else if (this.isTimeout(dayCode)) {
                        dayCode.setCodeStatus(3).setCodeText("SOUT");
                    }
                } else if (dayCode.getMasterId().equals(master.getMasterId())) {
                    dayCodeList.add(dayCode);
                }
            }
            ++n2;
        }
        if (log.isDebugEnabled()) {
            log.debug(dayCodeList);
        }
        return dayCodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCodeStatus(DayCode dayCode, Integer masterId) throws Exception {
        if (dayCode.getCodeStatus() == null || dayCode.getCodeStatus() != 3) {
            return;
        }
        DayCode cache = answeredCacheMap.get(dayCode.getCodeId());
        if (log.isDebugEnabled()) {
            log.debug(cache);
        }
        if (cache != null && cache.getMasterId().equals(masterId)) {
            Integer codeStatus = dayCode.getCodeStatus();
            if (codeStatus != 2 && cache.getCodeType() != null && cache.getCodeType() == 100) {
                Master master = Logic.masterLogic.fetch(masterId);
                if (master.getWrongCodeRate() != null && master.getWrongCodeRate() > master.getSysWrongCodeRate() && cache.getCodeText().length() >= 4) {
                    codeStatus = 2;
                }
                if (log.isDebugEnabled()) {
                    log.debug(master);
                }
            }
            cache.setCodeStatus(codeStatus);
            return;
        }
        List<DayCode> list = wrongCacheList;
        synchronized (list) {
            wrongCacheList.add(dayCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean rightNow) throws Exception {
        Iterator<Map.Entry<Object, Object>> itr;
        List<DayCode> list2;
        List<DayCode> dayCodeList;
        Iterator<Object> itr2;
        DayCode dayCode = null;
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(12);
        if (log.isDebugEnabled()) {
            log.debug("answeredCacheMap.size = " + answeredCacheMap.size());
        }
        Map<Integer, DayCode> map2 = answeredCacheMap;
        synchronized (map2) {
            itr2 = answeredCacheMap.entrySet().iterator();
            while (itr2.hasNext()) {
                dayCode = itr2.next().getValue();
                if (!rightNow && !this.isTimeout(dayCode)) continue;
                dayCodeList = (ArrayList<DayCode>)map.get(dayCode.getTableName());
                if (dayCodeList == null) {
                    dayCodeList = new ArrayList<DayCode>(answeredCacheMap.size());
                    map.put(dayCode.getTableName(), dayCodeList);
                }
                if (dayCode.getCodeText() == null || dayCode.getCodeText().trim().equals("")) {
                    dayCode.setCodeStatus(4);
                }
                dayCodeList.add(dayCode);
                itr2.remove();
            }
        }
        for (List<DayCode> list2 : map.values()) {
            Dao.dayCodeDao.updateCodeText(list2);
        }
        if (log.isDebugEnabled()) {
            log.debug("takedCacheMap.size = " + takedCacheMap.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("outDateCacheMap.size = " + outDateCacheMap.size());
        }
        map.clear();
        list2 = outDateCacheMap;
        synchronized (list2) {
            itr2 = outDateCacheMap.entrySet().iterator();
            while (itr2.hasNext()) {
                dayCode = itr2.next().getValue();
                dayCodeList = (List)map.get(dayCode.getTableName());
                if (dayCodeList == null) {
                    dayCodeList = new ArrayList(outDateCacheMap.size());
                    map.put(dayCode.getTableName(), dayCodeList);
                }
                dayCodeList.add(dayCode);
                itr2.remove();
            }
        }
        for (List<DayCode> list2 : map.values()) {
            Dao.dayCodeDao.updateAnswerDate(list2);
        }
        map.clear();
        list2 = takedCacheMap;
        synchronized (list2) {
            itr2 = takedCacheMap.entrySet().iterator();
            while (itr2.hasNext()) {
                dayCode = itr2.next().getValue();
                if (!rightNow && !this.isTimeout(dayCode)) continue;
                if (this.isTimeout(dayCode)) {
                    dayCode.setCodeStatus(5).setCodeText("SOUT");
                }
                if ((dayCodeList = (List)map.get(dayCode.getTableName())) == null) {
                    dayCodeList = new ArrayList(takedCacheMap.size());
                    map.put(dayCode.getTableName(), dayCodeList);
                }
                dayCodeList.add(dayCode);
                itr2.remove();
            }
        }
        for (List<DayCode> list2 : map.values()) {
            Dao.dayCodeDao.updateAnswerId(list2);
        }
        if (log.isDebugEnabled()) {
            log.debug("wrongCacheList.size = " + wrongCacheList.size());
        }
        map.clear();
        list2 = wrongCacheList;
        synchronized (list2) {
            itr2 = wrongCacheList.iterator();
            while (itr2.hasNext()) {
                dayCode = (DayCode)itr2.next();
                itr2.remove();
                if (dayCode.getTableName() == null) {
                    log.error("ERROR dayCode : " + dayCode);
                    continue;
                }
                dayCodeList = (List)map.get(dayCode.getTableName());
                if (dayCodeList == null) {
                    dayCodeList = new ArrayList(wrongCacheList.size());
                    map.put(dayCode.getTableName(), dayCodeList);
                }
                dayCodeList.add(dayCode);
            }
        }
        for (List<DayCode> list2 : map.values()) {
            Dao.dayCodeDao.updateCodeStatus(list2);
        }
        if (log.isDebugEnabled()) {
            log.debug("cacheList.size = " + cacheList.size());
        }
        list2 = cacheList;
        synchronized (list2) {
            itr2 = cacheList.iterator();
            while (itr2.hasNext()) {
                dayCode = (DayCode)itr2.next();
                if (dayCode.getOutDate().getTime() > System.currentTimeMillis()) continue;
                dayCode.setByteString(null).setCodeText(null);
                itr2.remove();
            }
        }
        map.clear();
        ArrayList<DayCode> wrongList = new ArrayList<DayCode>(128);
        HashMap<Integer, Integer> masterWrongCodeNumMap = new HashMap<Integer, Integer>(1024);
        HashMap<Integer, Integer> answerWrongCodeNumMap = new HashMap<Integer, Integer>(1024);
        Map<String, Answer> map3 = totalCacheMap;
        synchronized (map3) {
            itr = totalCacheMap.entrySet().iterator();
            while (itr.hasNext()) {
                dayCode = itr.next().getValue();
                if (!this.isTimeout(dayCode)) continue;
                dayCode.setByteString(null).setCodeText(null);
                itr.remove();
                if (dayCode.getCodeStatus() != null && dayCode.getCodeStatus() == 2) {
                    ArrayList<DayCode> dayCodeList2 = (ArrayList<DayCode>)map.get(dayCode.getTableName());
                    if (dayCodeList2 == null) {
                        dayCodeList2 = new ArrayList<DayCode>(totalCacheMap.size());
                        map.put(dayCode.getTableName(), dayCodeList2);
                    }
                    dayCodeList2.add(dayCode);
                    continue;
                }
                wrongList.add(dayCode);
                if (dayCode.getCodeStatus() == null || dayCode.getCodeStatus() != 3) continue;
                Integer wrongCodeNum = (Integer)masterWrongCodeNumMap.get(dayCode.getMasterId());
                if (wrongCodeNum == null) {
                    wrongCodeNum = 0;
                }
                wrongCodeNum = wrongCodeNum + 1;
                masterWrongCodeNumMap.put(dayCode.getMasterId(), wrongCodeNum);
                wrongCodeNum = (Integer)answerWrongCodeNumMap.get(dayCode.getAnswerId());
                if (wrongCodeNum == null) {
                    wrongCodeNum = 0;
                }
                wrongCodeNum = wrongCodeNum + 1;
                answerWrongCodeNumMap.put(dayCode.getAnswerId(), wrongCodeNum);
            }
        }
        map3 = wrongCacheList;
        synchronized (map3) {
            wrongCacheList.addAll(wrongList);
        }
        for (List list3 : map.values()) {
            if (list3.size() <= 0) continue;
            String tableName = ((DayCode)list3.get(0)).getTableName();
            String day = tableName.substring(tableName.length() - 8);
            Date codeDate = sdf.parse(day);
            HashMap<Integer, Integer> masterCodeNumMap = new HashMap<Integer, Integer>(1024);
            HashMap<Integer, Integer> answerCodeNumMap = new HashMap<Integer, Integer>(1024);
            for (DayCode code : list3) {
                Integer codeNum = (Integer)masterCodeNumMap.get(code.getMasterId());
                masterCodeNumMap.put(code.getMasterId(), codeNum == null ? 1 : codeNum + 1);
                codeNum = (Integer)answerCodeNumMap.get(code.getAnswerId());
                answerCodeNumMap.put(code.getAnswerId(), codeNum == null ? 1 : codeNum + 1);
            }
            Set<Integer> masterIdSet = Dao.masterDayCodeDao.fetchListByCodeDate(codeDate);
            ArrayList<MasterDayCode> updateList = new ArrayList<MasterDayCode>(list3.size());
            ArrayList<MasterDayCode> createList = new ArrayList<MasterDayCode>(list3.size());
            MasterDayCode masterDayCode = null;
            for (Map.Entry entry : masterCodeNumMap.entrySet()) {
                Master master = Logic.masterLogic.fetch((Integer)entry.getKey());
                Integer codeNum = (Integer)entry.getValue();
                Integer wrongCodeNum = (Integer)masterWrongCodeNumMap.get(master.getMasterId());
                if (wrongCodeNum == null) {
                    wrongCodeNum = 0;
                }
                masterDayCode = new MasterDayCode().setCodeNum(codeNum).setWrongCodeNum(wrongCodeNum).setCodePrice(master.getCodePrice()).setMasterId(master.getMasterId()).setCodeDate(codeDate);
                if (masterIdSet.contains(master.getMasterId())) {
                    updateList.add(masterDayCode);
                } else {
                    createList.add(masterDayCode);
                }
                try {
                    Double sysWrongCodeRate = FileConfig.getDouble((String)master.getMasterAccount());
                    if (sysWrongCodeRate == null) {
                        sysWrongCodeRate = FileConfig.getDouble((String)"sysWrongCodeRate", (Double)0.3);
                    }
                    master.setSysWrongCodeRate(sysWrongCodeRate);
                    MasterDayCode cacheMDC = master.getMasterDayCodeList().get(0);
                    cacheMDC.setCodeNum(cacheMDC.getCodeNum() + codeNum).setWrongCodeNum(cacheMDC.getWrongCodeNum() + wrongCodeNum);
                    master.setWrongCodeRate((double)cacheMDC.getWrongCodeNum().intValue() / ((double)cacheMDC.getCodeNum().intValue() + 1.0));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    master.setWrongCodeRate(0.0);
                }
            }
            Dao.masterDayCodeDao.updateCodeNum(updateList);
            Dao.masterDayCodeDao.create(createList);
            Set<Integer> answerIdSet = Dao.answerDayCodeDao.fetchListByCodeDate(codeDate);
            ArrayList<AnswerDayCode> updList = new ArrayList<AnswerDayCode>(list3.size());
            ArrayList<AnswerDayCode> crtList = new ArrayList<AnswerDayCode>(list3.size());
            AnswerDayCode answerDayCode = null;
            for (Map.Entry entry : answerCodeNumMap.entrySet()) {
                Integer wrongCodeNum = (Integer)answerWrongCodeNumMap.get(entry.getKey());
                if (wrongCodeNum == null) {
                    wrongCodeNum = 0;
                }
                answerDayCode = new AnswerDayCode().setAnswerId((Integer)entry.getKey()).setCodeNum((Integer)entry.getValue()).setWrongCodeNum(wrongCodeNum).setCodeDate(codeDate);
                Calendar c = Calendar.getInstance();
                int hour = c.get(11);
                int nightBeginHour = FileConfig.getInteger((String)"nightBeginHour", (Integer)0);
                int nightEndHour = FileConfig.getInteger((String)"nightEndHour", (Integer)7);
                if (hour >= nightBeginHour && hour <= nightEndHour) {
                    answerDayCode.setNightCodeNum((Integer)entry.getValue());
                } else {
                    answerDayCode.setNightCodeNum(0);
                }
                if (answerIdSet.contains(answerDayCode.getAnswerId())) {
                    updList.add(answerDayCode);
                    continue;
                }
                crtList.add(answerDayCode);
            }
            Dao.answerDayCodeDao.updateCodeNum(updList);
            Dao.answerDayCodeDao.create(crtList);
        }
        map3 = onlineCacheMap;
        synchronized (map3) {
            itr = onlineCacheMap.entrySet().iterator();
            while (itr.hasNext()) {
                Answer e = (Answer)itr.next().getValue();
                if (System.currentTimeMillis() - e.getAnswerCdate().getTime() <= (long)onlineInterval) continue;
                itr.remove();
            }
        }
        Logic.masterBillLogic.fresh();
        System.gc();
    }

    private boolean isTimeout(DayCode dayCode) {
        return dayCode == null || dayCode.getOutDate().getTime() + 5000L < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTableName(Date date) throws Exception {
        StringBuilder buffer = new StringBuilder();
        buffer.append(SRC_TABLE_NAME).append("_").append(sdf.format(date));
        String tableName = buffer.toString();
        if (!cacheSet.contains(tableName)) {
            Set<String> set = cacheSet;
            synchronized (set) {
                if (!Dao.dayCodeDao.checkTable(tableName)) {
                    Dao.dayCodeDao.createTable(tableName);
                }
                cacheSet.add(tableName);
            }
        }
        return tableName;
    }

    @Override
    public String getTableName() throws Exception {
        return this.getTableName(new Date());
    }

    @Override
    public void create(List<DayCode> dayCodeList) throws Exception {
        Dao.dayCodeDao.create(dayCodeList);
    }

    @Override
    public int remove(Integer codeId) throws Exception {
        return Dao.dayCodeDao.remove(codeId);
    }

    @Override
    public int update(DayCode dayCode) throws Exception {
        return Dao.dayCodeDao.update(dayCode);
    }

    @Override
    public DayCode fetch(Integer codeId) throws Exception {
        return Dao.dayCodeDao.fetch(codeId);
    }

    @Override
    public List<DayCode> export(int offset, int limit) throws Exception {
        return Dao.dayCodeDao.export(offset, limit);
    }

    @Override
    public List<DayCode> fetchListByMasterId(String tableName, Integer masterId) throws Exception {
        return Dao.dayCodeDao.fetchListByMasterId(tableName, masterId, 2, 100);
    }

    @Override
    public List<DayCode> fetchListByAnswerId(String tableName, Integer answerId) throws Exception {
        return Dao.dayCodeDao.fetchListByAnswerId(tableName, answerId, 100);
    }

    @Override
    public List<DayCode> fetchLisForSuperAdmin(String tableName) throws Exception {
        return Dao.dayCodeDao.fetchLisForSuperAdmin(tableName, 100);
    }

    @Override
    public int[] getCacheSize() {
        return new int[]{cacheList.size(), takedCacheMap.size(), answeredCacheMap.size(), wrongCacheList.size(), totalCacheMap.size(), onlineCacheMap.size()};
    }

    @Override
    public int getCacheListSize() {
        return cacheList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOnline(Answer answer) {
        Answer cache = onlineCacheMap.get(answer.getAnswerAccount());
        if (cache != null) {
            cache.setAnswerCdate(new Date());
            return true;
        }
        if (this.isHungry()) {
            Map<String, Answer> map = onlineCacheMap;
            synchronized (map) {
                if (this.isHungry()) {
                    answer.setAnswerCdate(new Date());
                    onlineCacheMap.put(answer.getAnswerAccount(), answer);
                }
            }
        }
        return false;
    }

    private boolean isHungry() {
        if (FileConfig.getInteger((String)"perAnswerCodeNum", (Integer)0) == 0) {
            return true;
        }
        double perAnswerCodeNum = 1.0 * (double)cacheList.size() / (double)onlineCacheMap.size();
        double config = FileConfig.getDouble((String)"perAnswerCodeNum", (Double)1.0);
        return onlineCacheMap.size() < 3 || perAnswerCodeNum > config;
    }

    @Override
    public void removeCodeImgFile$Table() throws Exception {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(AppContext.getAppRootPath()).append("\\codeImage\\");
        File[] dirArr = FileIO.listDirs((String)buffer.toString());
        if (dirArr.length <= 7) {
            return;
        }
        File[] fileArray = dirArr;
        int n = dirArr.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            Matcher mTableName = pTableName.matcher(dir.getName());
            if (!mTableName.find()) {
                log.error("Error Table Name: " + dir);
            } else {
                String tableName = mTableName.group();
                String yyyyMMdd = mTableName.group(1);
                Date tableDate = sdf.parse(yyyyMMdd);
                Calendar c = Calendar.getInstance();
                c.add(5, -7);
                if (tableDate.getTime() <= c.getTimeInMillis()) {
                    try {
                        Dao.dayCodeDao.removeTable(tableName);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                    FileIO.removeDirectory((File)dir);
                }
            }
            ++n2;
        }
    }
}

