/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.logicimpl;

import com.coyousoft.yundama.constant.Dao;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.AnswerDayCode;
import com.coyousoft.yundama.logic.AnswerLogic;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AnswerLogicImpl
implements AnswerLogic {
    private static final Log log = LogFactory.getLog(AnswerLogic.class);
    private static final Map<String, Answer> cacheMap = new HashMap<String, Answer>(4096);

    @Override
    public void create(Answer answer) throws Exception {
        Dao.answerDao.create(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(List<Answer> answerList, Integer adminId) throws Exception {
        for (Answer answer : answerList) {
            Answer dbAnswer = Dao.answerDao.fetchByAccount(answer.getAnswerAccount());
            if (dbAnswer == null) {
                this.create(answer);
                continue;
            }
            if (!dbAnswer.getAdminId().equals(adminId)) continue;
            answer.setAnswerId(dbAnswer.getAnswerId());
            Dao.answerDao.update(answer);
            Map<String, Answer> map = cacheMap;
            synchronized (map) {
                cacheMap.put(answer.getAnswerAccount(), answer);
            }
        }
    }

    @Override
    public int remove(Integer answerId) throws Exception {
        return Dao.answerDao.remove(answerId);
    }

    @Override
    public int update(Answer answer) throws Exception {
        return Dao.answerDao.update(answer);
    }

    @Override
    public Answer fetch(Integer answerId) throws Exception {
        return Dao.answerDao.fetch(answerId);
    }

    @Override
    public List<Answer> export(int offset, int limit) throws Exception {
        return Dao.answerDao.export(offset, limit);
    }

    @Override
    public void flush() throws Exception {
    }

    @Override
    public Answer fetchByAccount(String answerAccount, String answerPassword) throws Exception {
        if (answerPassword == null || "".equals(answerPassword.trim())) {
            return null;
        }
        Answer answer = this.fetchByAccount(answerAccount);
        if (answer == null || !answer.getAnswerPassword().equals(answerPassword)) {
            log.error("ERROR_WRONG_ANSWER - " + answerAccount + " - " + answerPassword);
            return null;
        }
        return answer;
    }

    @Override
    public List<AnswerDayCode> fetchList(Integer adminId, Date beginDate, Date endDate) throws Exception {
        return Dao.answerDao.fetchList(adminId, beginDate, endDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Answer fetchByAccount(String answerAccount) throws Exception {
        if (answerAccount == null || "".equals(answerAccount.trim())) {
            return null;
        }
        Answer answer = cacheMap.get(answerAccount);
        if (answer == null) {
            Map<String, Answer> map = cacheMap;
            synchronized (map) {
                answer = Dao.answerDao.fetchByAccount(answerAccount);
                if (answer != null) {
                    cacheMap.put(answerAccount, answer);
                }
            }
        }
        return answer;
    }
}

