/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.MasterDayCodeDao;
import com.coyousoft.yundama.entity.MasterDayCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class MasterDayCodeDaoImpl
implements MasterDayCodeDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(MasterDayCodeDao.class);

    @Override
    public void create(MasterDayCode masterDayCode) throws Exception {
        this.create(masterDayCode, false);
    }

    @Override
    public void create(MasterDayCode masterDayCode, boolean setId) throws Exception {
        this.dao.update("insert into MASTER_DAY_CODE ( DAY_ID,MASTER_ID,CODE_DATE,CODE_NUM,CODE_PRICE,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )", masterDayCode.setDefault().toArray());
        if (setId) {
            masterDayCode.setDayId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<MasterDayCode> masterDayCodeList) throws Exception {
        if (masterDayCodeList == null || masterDayCodeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterDayCodeList.size());
        for (MasterDayCode masterDayCode : masterDayCodeList) {
            params.add(masterDayCode.setDefault().toArray());
        }
        this.dao.update("insert into MASTER_DAY_CODE ( DAY_ID,MASTER_ID,CODE_DATE,CODE_NUM,CODE_PRICE,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer dayId) throws Exception {
        return this.dao.update("delete from MASTER_DAY_CODE where DAY_ID=?", new Object[]{dayId});
    }

    @Override
    public int update(MasterDayCode masterDayCode) throws Exception {
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update MASTER_DAY_CODE set ");
        if (masterDayCode.getMasterId() != null) {
            buffer.append("MASTER_ID=?,");
            params.add(masterDayCode.getMasterId());
        }
        if (masterDayCode.getCodeDate() != null) {
            buffer.append("CODE_DATE=?,");
            params.add(masterDayCode.getCodeDate());
        }
        if (masterDayCode.getCodeNum() != null) {
            buffer.append("CODE_NUM=?,");
            params.add(masterDayCode.getCodeNum());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where DAY_ID = ?");
        params.add(masterDayCode.getDayId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public MasterDayCode fetch(Integer dayId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from MASTER_DAY_CODE where DAY_ID=?", new Object[]{dayId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new MasterDayCode().fill(row);
        }
        return null;
    }

    @Override
    public List<MasterDayCode> export(int offset, int limit) throws Exception {
        ArrayList<MasterDayCode> list = new ArrayList<MasterDayCode>(limit);
        for (Map row : this.dao.queryForList("select * from MASTER_DAY_CODE order by DAY_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new MasterDayCode().fill(row));
        }
        return list;
    }

    @Override
    public Set<Integer> fetchListByCodeDate(Date codeDate) throws Exception {
        HashSet<Integer> set = new HashSet<Integer>(1024);
        MasterDayCode masterDayCode = new MasterDayCode();
        for (Map row : this.dao.queryForList("select MASTER_ID from MASTER_DAY_CODE where CODE_DATE=?", new Object[]{codeDate})) {
            set.add(masterDayCode.fill(row).getMasterId());
        }
        return set;
    }

    @Override
    public void updateCodeNum(List<MasterDayCode> masterDayCodeList) throws Exception {
        if (masterDayCodeList == null || masterDayCodeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterDayCodeList.size());
        for (MasterDayCode masterDayCode : masterDayCodeList) {
            params.add(new Object[]{masterDayCode.getCodeNum(), masterDayCode.getWrongCodeNum(), masterDayCode.getCodePrice(), masterDayCode.getMasterId(), masterDayCode.getCodeDate()});
        }
        this.dao.update("update MASTER_DAY_CODE set CODE_NUM=CODE_NUM + ?,WRONG_CODE_NUM=WRONG_CODE_NUM + ?,CODE_PRICE=? where MASTER_ID=? and CODE_DATE=?", params);
    }

    @Override
    public List<MasterDayCode> fetchListByMasterId(Integer masterId, Date beginDate, Date endDate) throws Exception {
        ArrayList<MasterDayCode> list = new ArrayList<MasterDayCode>(31);
        for (Map row : this.dao.queryForList("select * from MASTER_DAY_CODE where MASTER_ID=? and CODE_DATE >=? and CODE_DATE <=? order by DAY_ID asc", new Object[]{masterId, beginDate, endDate})) {
            list.add(new MasterDayCode().fill(row));
        }
        return list;
    }

    @Override
    public List<MasterDayCode> fetchList(Date codeDate) throws Exception {
        ArrayList<MasterDayCode> list = new ArrayList<MasterDayCode>(31);
        for (Map row : this.dao.queryForList("select * from MASTER_DAY_CODE where CODE_DATE=?", new Object[]{codeDate})) {
            list.add(new MasterDayCode().fill(row));
        }
        return list;
    }
}

