/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.MasterDao;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterDayCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class MasterDaoImpl
implements MasterDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(MasterDao.class);

    @Override
    public void create(Master master) throws Exception {
        this.create(master, false);
    }

    @Override
    public void create(Master master, boolean setId) throws Exception {
        this.dao.update("insert into MASTER ( MASTER_ID,ADMIN_ID,MASTER_ACCOUNT,MASTER_PASSWORD,MASTER_CDATE,MASTER_NAME,MASTER_QQ,MASTER_PHONE,MASTER_TYPE,CODE_PRICE,MASTER_BALANCE ) values ( ?,?,?,?,?,?,?,?,?,?,? )", master.setDefault().toArray());
        if (setId) {
            master.setMasterId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<Master> masterList) throws Exception {
        if (masterList == null || masterList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterList.size());
        for (Master master : masterList) {
            params.add(master.setDefault().toArray());
        }
        this.dao.update("insert into MASTER ( MASTER_ID,ADMIN_ID,MASTER_ACCOUNT,MASTER_PASSWORD,MASTER_CDATE,MASTER_NAME,MASTER_QQ,MASTER_PHONE,MASTER_TYPE,CODE_PRICE,MASTER_BALANCE ) values ( ?,?,?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer masterId) throws Exception {
        return this.dao.update("delete from MASTER where MASTER_ID=?", new Object[]{masterId});
    }

    @Override
    public int update(Master master) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update MASTER set ");
        if (master.getMasterPassword() != null) {
            buffer.append("MASTER_PASSWORD=?,");
            params.add(master.getMasterPassword());
        }
        if (master.getMasterCdate() != null) {
            buffer.append("MASTER_CDATE=?,");
            params.add(master.getMasterCdate());
        }
        if (master.getMasterName() != null) {
            buffer.append("MASTER_NAME=?,");
            params.add(master.getMasterName());
        }
        if (master.getMasterQq() != null) {
            buffer.append("MASTER_QQ=?,");
            params.add(master.getMasterQq());
        }
        if (master.getMasterPhone() != null) {
            buffer.append("MASTER_PHONE=?,");
            params.add(master.getMasterPhone());
        }
        if (master.getMasterType() != null) {
            buffer.append("MASTER_TYPE=?,");
            params.add(master.getMasterType());
        }
        if (master.getCodePrice() != null) {
            buffer.append("CODE_PRICE=?,");
            params.add(master.getCodePrice());
        }
        if (master.getMasterBalance() != null) {
            buffer.append("MASTER_BALANCE=?,");
            params.add(master.getMasterBalance());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where MASTER_ID = ?");
        params.add(master.getMasterId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public Master fetch(Integer masterId) throws Exception {
        Master master = null;
        MasterDayCode masterDayCode = null;
        for (Map row : this.dao.queryForList("select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join MASTER_DAY_CODE T2 on T1.MASTER_ID=T2.MASTER_ID where T1.MASTER_ID=? order by DAY_ID desc limit 0,1", new Object[]{masterId})) {
            master = new Master().fill(row);
            masterDayCode = new MasterDayCode().fill(row);
            if (masterDayCode.getCodeNum() == null) {
                masterDayCode.setCodeNum(0);
            }
            if (masterDayCode.getWrongCodeNum() == null) {
                masterDayCode.setWrongCodeNum(0);
            }
            master.add(masterDayCode);
        }
        return master;
    }

    @Override
    public List<Master> export(int offset, int limit) throws Exception {
        ArrayList<Master> list = new ArrayList<Master>(limit);
        for (Map row : this.dao.queryForList("select * from MASTER order by MASTER_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new Master().fill(row));
        }
        return list;
    }

    @Override
    public Master fetchByAccount(String masterAccount) throws Exception {
        Master master = null;
        MasterDayCode masterDayCode = null;
        for (Map row : this.dao.queryForList("select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join MASTER_DAY_CODE T2 on T1.MASTER_ID=T2.MASTER_ID where T1.MASTER_ACCOUNT=? order by DAY_ID desc limit 0,1", new Object[]{masterAccount})) {
            master = new Master().fill(row);
            masterDayCode = new MasterDayCode().fill(row);
            if (masterDayCode.getCodeNum() == null) {
                masterDayCode.setCodeNum(0);
            }
            if (masterDayCode.getWrongCodeNum() == null) {
                masterDayCode.setWrongCodeNum(0);
            }
            master.add(masterDayCode);
        }
        return master;
    }

    @Override
    public List<MasterDayCode> fetchList(Date beginDate, Date endDate) throws Exception {
        ArrayList<MasterDayCode> list = new ArrayList<MasterDayCode>(1024);
        for (Map row : this.dao.queryForList("select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join ( select MASTER_ID,sum(CODE_NUM) CODE_NUM,sum(WRONG_CODE_NUM) WRONG_CODE_NUM from MASTER_DAY_CODE where CODE_DATE >=? and CODE_DATE <=? group by MASTER_ID) T2 on T1.MASTER_ID=T2.MASTER_ID order by T2.CODE_NUM desc,T1.MASTER_ID desc", new Object[]{beginDate, endDate})) {
            list.add(new MasterDayCode().fill(row, true));
        }
        return list;
    }

    @Override
    public void updateBalance(List<Master> masterList) throws Exception {
        if (masterList == null || masterList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterList.size());
        for (Master master : masterList) {
            params.add(new Object[]{master.getMasterBalance(), master.getMasterId()});
        }
        this.dao.update("update MASTER set MASTER_BALANCE=? where MASTER_ID=?", params);
    }
}

