/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.MasterBillDao;
import com.coyousoft.yundama.entity.MasterBill;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class MasterBillDaoImpl
implements MasterBillDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(MasterBillDao.class);

    @Override
    public void create(MasterBill masterBill) throws Exception {
        this.create(masterBill, false);
    }

    @Override
    public void create(MasterBill masterBill, boolean setId) throws Exception {
        this.dao.update("insert into MASTER_BILL ( BILL_ID,MASTER_ID,BILL_DATE,BILL_TYPE,BILL_AMOUNT,BILL_CDATE,BILL_INFO ) values ( ?,?,?,?,?,?,? )", masterBill.setDefault().toArray());
        if (setId) {
            masterBill.setBillId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<MasterBill> masterBillList) throws Exception {
        if (masterBillList == null || masterBillList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterBillList.size());
        for (MasterBill masterBill : masterBillList) {
            params.add(masterBill.setDefault().toArray());
        }
        this.dao.update("insert into MASTER_BILL ( BILL_ID,MASTER_ID,BILL_DATE,BILL_TYPE,BILL_AMOUNT,BILL_CDATE,BILL_INFO ) values ( ?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer billId) throws Exception {
        return this.dao.update("delete from MASTER_BILL where BILL_ID=?", new Object[]{billId});
    }

    @Override
    public int update(MasterBill masterBill) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update MASTER_BILL set ");
        if (masterBill.getMasterId() != null) {
            buffer.append("MASTER_ID=?,");
            params.add(masterBill.getMasterId());
        }
        if (masterBill.getBillDate() != null) {
            buffer.append("BILL_DATE=?,");
            params.add(masterBill.getBillDate());
        }
        if (masterBill.getBillType() != null) {
            buffer.append("BILL_TYPE=?,");
            params.add(masterBill.getBillType());
        }
        if (masterBill.getBillAmount() != null) {
            buffer.append("BILL_AMOUNT=?,");
            params.add(masterBill.getBillAmount());
        }
        if (masterBill.getBillCdate() != null) {
            buffer.append("BILL_CDATE=?,");
            params.add(masterBill.getBillCdate());
        }
        if (masterBill.getBillInfo() != null) {
            buffer.append("BILL_INFO=?,");
            params.add(masterBill.getBillInfo());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where BILL_ID = ?");
        params.add(masterBill.getBillId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public MasterBill fetch(Integer billId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from MASTER_BILL where BILL_ID=?", new Object[]{billId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new MasterBill().fill(row);
        }
        return null;
    }

    @Override
    public List<MasterBill> export(int offset, int limit) throws Exception {
        ArrayList<MasterBill> list = new ArrayList<MasterBill>(limit);
        for (Map row : this.dao.queryForList("select * from MASTER_BILL order by BILL_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new MasterBill().fill(row));
        }
        return list;
    }

    @Override
    public double sumBalance(Integer masterId) throws Exception {
        return this.dao.queryForNumber("select sum(BILL_AMOUNT) BILL_AMOUNT from MASTER_BILL where MASTER_ID=?", new Object[]{masterId}).doubleValue();
    }

    @Override
    public void updateBillAmount(List<MasterBill> masterBillList) throws Exception {
        if (masterBillList == null || masterBillList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(masterBillList.size());
        for (MasterBill masterBill : masterBillList) {
            params.add(new Object[]{masterBill.getBillAmount(), masterBill.getBillInfo(), masterBill.getMasterId(), masterBill.getBillDate(), masterBill.getBillType()});
        }
        this.dao.update("update MASTER_BILL set BILL_AMOUNT=?,BILL_INFO=? where MASTER_ID=? and BILL_DATE=? and BILL_TYPE=?", params);
    }

    @Override
    public Map<Integer, MasterBill> fetchMapByBillDate(Date billDate, Integer billType) throws Exception {
        HashMap<Integer, MasterBill> map = new HashMap<Integer, MasterBill>(1024);
        MasterBill masterBill = null;
        for (Map row : this.dao.queryForList("select * from MASTER_BILL where BILL_DATE=? and BILL_TYPE=?", new Object[]{billDate, billType})) {
            masterBill = new MasterBill().fill(row);
            map.put(masterBill.getMasterId(), masterBill);
        }
        return map;
    }

    @Override
    public List<MasterBill> fetchListByMasterId(Integer masterId, int listNum) throws Exception {
        ArrayList<MasterBill> list = new ArrayList<MasterBill>(1024);
        for (Map row : this.dao.queryForList("select * from MASTER_BILL where MASTER_ID=? order by BILL_ID desc limit 0,?", new Object[]{masterId, listNum})) {
            list.add(new MasterBill().fill(row));
        }
        return list;
    }

    @Override
    public MasterBill fetchByBillDate(Integer masterId, Date billDate, Integer billType) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from MASTER_BILL where MASTER_ID=? and BILL_DATE=? and BILL_TYPE=?", new Object[]{masterId, billDate, billType}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new MasterBill().fill(row);
        }
        return null;
    }
}

