/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.DayCodeDao;
import com.coyousoft.yundama.entity.DayCode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class DayCodeDaoImpl
implements DayCodeDao {
    private static final String SRC_TABLE_NAME = "DAY_CODE";
    private final JdbcOperations dao = AppContext.getJdbcOperations(DayCodeDao.class);

    @Override
    public void create(DayCode dayCode) throws Exception {
        this.create(dayCode, false);
    }

    @Override
    public void create(DayCode dayCode, boolean setId) throws Exception {
        String sql = "insert into DAY_CODE ( CODE_ID,MASTER_ID,ANSWER_ID,CODE_TYPE,CODE_STATUS,CODE_PRIORITY,CODE_TEXT,CREATE_DATE,OUT_DATE,TAKE_DATE,ANSWER_DATE,CODE_MUM,PLAY_TIMES ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )".replace(SRC_TABLE_NAME, dayCode.getTableName());
        this.dao.update(sql, dayCode.setDefault().toArray());
        if (setId) {
            dayCode.setCodeId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<DayCode> dayCodeList) throws Exception {
        if (dayCodeList == null || dayCodeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(dayCodeList.size());
        for (DayCode dayCode : dayCodeList) {
            params.add(dayCode.setDefault().toArray());
        }
        this.dao.update("insert into DAY_CODE ( CODE_ID,MASTER_ID,ANSWER_ID,CODE_TYPE,CODE_STATUS,CODE_PRIORITY,CODE_TEXT,CREATE_DATE,OUT_DATE,TAKE_DATE,ANSWER_DATE,CODE_MUM,PLAY_TIMES ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer codeId) throws Exception {
        return this.dao.update("delete from DAY_CODE where CODE_ID=?", new Object[]{codeId});
    }

    @Override
    public int update(DayCode dayCode) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update DAY_CODE set ");
        if (dayCode.getMasterId() != null) {
            buffer.append("MASTER_ID=?,");
            params.add(dayCode.getMasterId());
        }
        if (dayCode.getAnswerId() != null) {
            buffer.append("ANSWER_ID=?,");
            params.add(dayCode.getAnswerId());
        }
        if (dayCode.getCodeType() != null) {
            buffer.append("CODE_TYPE=?,");
            params.add(dayCode.getCodeType());
        }
        if (dayCode.getCodeStatus() != null) {
            buffer.append("CODE_STATUS=?,");
            params.add(dayCode.getCodeStatus());
        }
        if (dayCode.getCodeText() != null) {
            buffer.append("CODE_TEXT=?,");
            params.add(dayCode.getCodeText());
        }
        if (dayCode.getCreateDate() != null) {
            buffer.append("CREATE_DATE=?,");
            params.add(dayCode.getCreateDate());
        }
        if (dayCode.getOutDate() != null) {
            buffer.append("OUT_DATE=?,");
            params.add(dayCode.getOutDate());
        }
        if (dayCode.getTakeDate() != null) {
            buffer.append("TAKE_DATE=?,");
            params.add(dayCode.getTakeDate());
        }
        if (dayCode.getAnswerDate() != null) {
            buffer.append("ANSWER_DATE=?,");
            params.add(dayCode.getAnswerDate());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where CODE_ID = ?");
        params.add(dayCode.getCodeId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public DayCode fetch(Integer codeId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from DAY_CODE where CODE_ID=?", new Object[]{codeId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new DayCode().fill(row);
        }
        return null;
    }

    @Override
    public List<DayCode> export(int offset, int limit) throws Exception {
        ArrayList<DayCode> list = new ArrayList<DayCode>(limit);
        for (Map row : this.dao.queryForList("select * from DAY_CODE order by CODE_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new DayCode().fill(row));
        }
        return list;
    }

    @Override
    public boolean checkTable(String tableName) throws Exception {
        String sql = "select max(CODE_ID) from DAY_CODE where 1=0".replace(SRC_TABLE_NAME, tableName);
        try {
            this.dao.queryForInt(sql, new Object[0]);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1146) {
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public void createTable(String tableName) throws Exception {
        String sql = "create table DAY_CODE ( CODE_ID int not null auto_increment,MASTER_ID int not null,ANSWER_ID int,CODE_TYPE int not null,CODE_STATUS int not null default 0,CODE_PRIORITY int not null default 1,CODE_TEXT varchar(30),CREATE_DATE datetime not null,OUT_DATE datetime not null,TAKE_DATE datetime,ANSWER_DATE datetime,CODE_MUM varchar(30),PLAY_TIMES int,primary key (CODE_ID) ) ENGINE=MyISAM".replace(SRC_TABLE_NAME, tableName);
        this.dao.update(sql, new Object[0]);
    }

    @Override
    public List<DayCode> fetchList(String tableName, Integer codeStatus, Date outDate, int limit) throws Exception {
        String sql = "select * from DAY_CODE where CODE_STATUS=? and OUT_DATE < ? order by CODE_ID desc limit ?".replace(SRC_TABLE_NAME, tableName);
        ArrayList<DayCode> list = new ArrayList<DayCode>(limit);
        for (Map row : this.dao.queryForList(sql, new Object[]{codeStatus, outDate, limit})) {
            list.add(new DayCode().fill(row).setTableName(tableName));
        }
        return list;
    }

    @Override
    public void updateCodeText(List<DayCode> dayCodeList) throws Exception {
        if (dayCodeList == null || dayCodeList.size() == 0) {
            return;
        }
        String sql = "update DAY_CODE set ANSWER_ID=?,CODE_TEXT=?,TAKE_DATE=?,ANSWER_DATE=?,CODE_STATUS=? where CODE_ID=?".replace(SRC_TABLE_NAME, dayCodeList.get(0).getTableName());
        ArrayList<Object[]> params = new ArrayList<Object[]>(dayCodeList.size());
        for (DayCode dayCode : dayCodeList) {
            params.add(new Object[]{dayCode.getAnswerId(), dayCode.getCodeText(), dayCode.getTakeDate(), dayCode.getAnswerDate(), dayCode.getCodeStatus(), dayCode.getCodeId()});
        }
        this.dao.update(sql, params);
    }

    @Override
    public void updateAnswerId(List<DayCode> dayCodeList) throws Exception {
        if (dayCodeList == null || dayCodeList.size() == 0) {
            return;
        }
        String sql = "update DAY_CODE set ANSWER_ID=?,TAKE_DATE=?,CODE_STATUS=? where CODE_ID=?".replace(SRC_TABLE_NAME, dayCodeList.get(0).getTableName());
        ArrayList<Object[]> params = new ArrayList<Object[]>(dayCodeList.size());
        for (DayCode dayCode : dayCodeList) {
            params.add(new Object[]{dayCode.getAnswerId(), dayCode.getTakeDate(), dayCode.getCodeStatus(), dayCode.getCodeId()});
        }
        this.dao.update(sql, params);
    }

    @Override
    public void updateAnswerDate(List<DayCode> dayCodeList) throws Exception {
        if (dayCodeList == null || dayCodeList.size() == 0) {
            return;
        }
        String sql = "update DAY_CODE set CODE_TEXT=?,ANSWER_DATE=?,CODE_STATUS=? where CODE_ID=?".replace(SRC_TABLE_NAME, dayCodeList.get(0).getTableName());
        ArrayList<Object[]> params = new ArrayList<Object[]>(dayCodeList.size());
        for (DayCode dayCode : dayCodeList) {
            params.add(new Object[]{dayCode.getCodeText(), dayCode.getAnswerDate(), dayCode.getCodeStatus(), dayCode.getCodeId()});
        }
        this.dao.update(sql, params);
    }

    @Override
    public void updateCodeStatus(List<DayCode> dayCodeList) throws Exception {
        if (dayCodeList == null || dayCodeList.size() == 0) {
            return;
        }
        String sql = "update DAY_CODE set CODE_STATUS=? where CODE_ID=?".replace(SRC_TABLE_NAME, dayCodeList.get(0).getTableName());
        ArrayList<Object[]> params = new ArrayList<Object[]>(dayCodeList.size());
        for (DayCode dayCode : dayCodeList) {
            params.add(new Object[]{dayCode.getCodeStatus(), dayCode.getCodeId()});
        }
        this.dao.update(sql, params);
    }

    @Override
    public List<DayCode> fetchListByMasterId(String tableName, Integer masterId, Integer codeStatus, int size) throws Exception {
        String sql = "select * from DAY_CODE where MASTER_ID=? and CODE_STATUS=? order by CODE_ID desc limit 0,?".replace(SRC_TABLE_NAME, tableName);
        ArrayList<DayCode> list = new ArrayList<DayCode>(size);
        StringBuilder buffer = new StringBuilder(256);
        DayCode dayCode = null;
        for (Map row : this.dao.queryForList(sql, new Object[]{masterId, codeStatus, size})) {
            dayCode = new DayCode().fill(row).setTableName(tableName);
            buffer.delete(0, buffer.length());
            buffer.append("/codeImage/").append(tableName).append("/").append(dayCode.getCodeId() / 10000).append("/").append(dayCode.getCodeId()).append(".jpg");
            dayCode.setImgUrl(buffer.toString());
            list.add(dayCode);
        }
        return list;
    }

    @Override
    public List<DayCode> fetchLisForSuperAdmin(String tableName, int size) throws Exception {
        String sql = "select T1.*,T2.MASTER_ID,T2.MASTER_ACCOUNT,T2.MASTER_NAME,T3.ANSWER_ID,T3.ANSWER_ACCOUNT from DAY_CODE T1 inner join MASTER T2 on T1.MASTER_ID=T2.MASTER_ID left join ANSWER T3 on T1.ANSWER_ID=T3.ANSWER_ID order by CODE_ID desc limit 0,?".replace(SRC_TABLE_NAME, tableName);
        ArrayList<DayCode> list = new ArrayList<DayCode>(size);
        StringBuilder buffer = new StringBuilder(256);
        DayCode dayCode = null;
        for (Map row : this.dao.queryForList(sql, new Object[]{size})) {
            dayCode = new DayCode().fill(row, true, true).setTableName(tableName);
            buffer.delete(0, buffer.length());
            buffer.append("/codeImage/").append(tableName).append("/").append(dayCode.getCodeId() / 10000).append("/").append(dayCode.getCodeId()).append(".jpg");
            dayCode.setImgUrl(buffer.toString());
            list.add(dayCode);
        }
        return list;
    }

    @Override
    public List<DayCode> fetchListByAnswerId(String tableName, Integer answerId, int size) throws Exception {
        String sql = "select * from DAY_CODE where ANSWER_ID=? order by CODE_ID desc limit 0,?".replace(SRC_TABLE_NAME, tableName);
        ArrayList<DayCode> list = new ArrayList<DayCode>(size);
        StringBuilder buffer = new StringBuilder(256);
        DayCode dayCode = null;
        for (Map row : this.dao.queryForList(sql, new Object[]{answerId, size})) {
            dayCode = new DayCode().fill(row).setTableName(tableName);
            buffer.delete(0, buffer.length());
            buffer.append("/codeImage/").append(tableName).append("/").append(dayCode.getCodeId() / 10000).append("/").append(dayCode.getCodeId()).append(".jpg");
            dayCode.setImgUrl(buffer.toString());
            list.add(dayCode);
        }
        return list;
    }

    @Override
    public void removeTable(String tableName) throws Exception {
        String sql = "drop table DAY_CODE".replace(SRC_TABLE_NAME, tableName);
        this.dao.update(sql, new Object[0]);
    }
}

