/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.AnswerDayCodeDao;
import com.coyousoft.yundama.entity.AnswerDayCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class AnswerDayCodeDaoImpl
implements AnswerDayCodeDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(AnswerDayCodeDao.class);

    @Override
    public void create(AnswerDayCode answerDayCode) throws Exception {
        this.create(answerDayCode, false);
    }

    @Override
    public void create(AnswerDayCode answerDayCode, boolean setId) throws Exception {
        this.dao.update("insert into ANSWER_DAY_CODE ( DAY_ID,ANSWER_ID,CODE_DATE,CODE_NUM,NIGHT_CODE_NUM,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )", answerDayCode.setDefault().toArray());
        if (setId) {
            answerDayCode.setDayId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<AnswerDayCode> answerDayCodeList) throws Exception {
        if (answerDayCodeList == null || answerDayCodeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(answerDayCodeList.size());
        for (AnswerDayCode answerDayCode : answerDayCodeList) {
            params.add(answerDayCode.setDefault().toArray());
        }
        this.dao.update("insert into ANSWER_DAY_CODE ( DAY_ID,ANSWER_ID,CODE_DATE,CODE_NUM,NIGHT_CODE_NUM,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer dayId) throws Exception {
        return this.dao.update("delete from ANSWER_DAY_CODE where DAY_ID=?", new Object[]{dayId});
    }

    @Override
    public int update(AnswerDayCode answerDayCode) throws Exception {
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update ANSWER_DAY_CODE set ");
        if (answerDayCode.getAnswerId() != null) {
            buffer.append("ANSWER_ID=?,");
            params.add(answerDayCode.getAnswerId());
        }
        if (answerDayCode.getCodeDate() != null) {
            buffer.append("CODE_DATE=?,");
            params.add(answerDayCode.getCodeDate());
        }
        if (answerDayCode.getCodeNum() != null) {
            buffer.append("CODE_NUM=?,");
            params.add(answerDayCode.getCodeNum());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where DAY_ID = ?");
        params.add(answerDayCode.getDayId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public AnswerDayCode fetch(Integer dayId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from ANSWER_DAY_CODE where DAY_ID=?", new Object[]{dayId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new AnswerDayCode().fill(row);
        }
        return null;
    }

    @Override
    public List<AnswerDayCode> export(int offset, int limit) throws Exception {
        ArrayList<AnswerDayCode> list = new ArrayList<AnswerDayCode>(limit);
        for (Map row : this.dao.queryForList("select * from ANSWER_DAY_CODE order by DAY_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new AnswerDayCode().fill(row));
        }
        return list;
    }

    @Override
    public Set<Integer> fetchListByCodeDate(Date codeDate) throws Exception {
        HashSet<Integer> set = new HashSet<Integer>(8192);
        AnswerDayCode answerDayCode = new AnswerDayCode();
        for (Map row : this.dao.queryForList("select ANSWER_ID from ANSWER_DAY_CODE where CODE_DATE=?", new Object[]{codeDate})) {
            set.add(answerDayCode.fill(row).getAnswerId());
        }
        return set;
    }

    @Override
    public void updateCodeNum(List<AnswerDayCode> answerDayCodeList) throws Exception {
        if (answerDayCodeList == null || answerDayCodeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(answerDayCodeList.size());
        for (AnswerDayCode answerDayCode : answerDayCodeList) {
            params.add(new Object[]{answerDayCode.getCodeNum(), answerDayCode.getWrongCodeNum(), answerDayCode.getNightCodeNum(), answerDayCode.getAnswerId(), answerDayCode.getCodeDate()});
        }
        this.dao.update("update ANSWER_DAY_CODE set CODE_NUM=CODE_NUM + ?,WRONG_CODE_NUM=WRONG_CODE_NUM + ?,NIGHT_CODE_NUM=NIGHT_CODE_NUM + ? where ANSWER_ID=? and CODE_DATE=?", params);
    }

    @Override
    public List<AnswerDayCode> fetchListByAnswerId(Integer answerId, Date beginDate, Date endDate) throws Exception {
        ArrayList<AnswerDayCode> list = new ArrayList<AnswerDayCode>(31);
        for (Map row : this.dao.queryForList("select * from ANSWER_DAY_CODE where ANSWER_ID=? and CODE_DATE >=? and CODE_DATE <=? order by DAY_ID asc", new Object[]{answerId, beginDate, endDate})) {
            list.add(new AnswerDayCode().fill(row));
        }
        return list;
    }
}

