/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.AnswerDao;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.AnswerDayCode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class AnswerDaoImpl
implements AnswerDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(AnswerDao.class);

    @Override
    public void create(Answer answer) throws Exception {
        this.create(answer, false);
    }

    @Override
    public void create(Answer answer, boolean setId) throws Exception {
        this.dao.update("insert into ANSWER ( ANSWER_ID,ADMIN_ID,ANSWER_ACCOUNT,ANSWER_PASSWORD,ANSWER_TYPE,ANSWER_CDATE,ANSWER_ORDER,ANSWER_QQ,ANSWER_ZHIFUBAO ) values ( ?,?,?,?,?,?,?,?,? )", answer.setDefault().toArray());
        if (setId) {
            answer.setAnswerId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<Answer> answerList) throws Exception {
        if (answerList == null || answerList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(answerList.size());
        for (Answer answer : answerList) {
            params.add(answer.setDefault().toArray());
        }
        this.dao.update("insert into ANSWER ( ANSWER_ID,ADMIN_ID,ANSWER_ACCOUNT,ANSWER_PASSWORD,ANSWER_TYPE,ANSWER_CDATE,ANSWER_ORDER,ANSWER_QQ,ANSWER_ZHIFUBAO ) values ( ?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer answerId) throws Exception {
        return this.dao.update("delete from ANSWER where ANSWER_ID=?", new Object[]{answerId});
    }

    @Override
    public int update(Answer answer) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update ANSWER set ");
        if (answer.getAnswerPassword() != null) {
            buffer.append("ANSWER_PASSWORD=?,");
            params.add(answer.getAnswerPassword());
        }
        if (answer.getAnswerType() != null) {
            buffer.append("ANSWER_TYPE=?,");
            params.add(answer.getAnswerType());
        }
        if (answer.getAnswerCdate() != null) {
            buffer.append("ANSWER_CDATE=?,");
            params.add(answer.getAnswerCdate());
        }
        if (answer.getAnswerOrder() != null) {
            buffer.append("ANSWER_ORDER=?,");
            params.add(answer.getAnswerOrder());
        }
        if (answer.getAnswerQq() != null) {
            buffer.append("ANSWER_QQ=?,");
            params.add(answer.getAnswerQq());
        }
        if (answer.getAnswerZhifubao() != null) {
            buffer.append("ANSWER_ZHIFUBAO=?,");
            params.add(answer.getAnswerZhifubao());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where ANSWER_ID = ?");
        params.add(answer.getAnswerId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public Answer fetch(Integer answerId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from ANSWER where ANSWER_ID=?", new Object[]{answerId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Answer().fill(row);
        }
        return null;
    }

    @Override
    public List<Answer> export(int offset, int limit) throws Exception {
        ArrayList<Answer> list = new ArrayList<Answer>(limit);
        for (Map row : this.dao.queryForList("select * from ANSWER order by ANSWER_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new Answer().fill(row));
        }
        return list;
    }

    @Override
    public Answer fetchByAccount(String answerAccount) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from ANSWER where ANSWER_ACCOUNT=?", new Object[]{answerAccount}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Answer().fill(row);
        }
        return null;
    }

    @Override
    public List<AnswerDayCode> fetchList(Integer adminId, Date beginDate, Date endDate) throws Exception {
        ArrayList<AnswerDayCode> list = new ArrayList<AnswerDayCode>(8192);
        for (Map row : this.dao.queryForList("select B1.*,B2.CODE_NUM,B2.WRONG_CODE_NUM,B2.NIGHT_CODE_NUM from ANSWER B1 left join ( select T1.ANSWER_ID,sum(T2.CODE_NUM) CODE_NUM,sum(T2.WRONG_CODE_NUM) WRONG_CODE_NUM,sum(T2.NIGHT_CODE_NUM) NIGHT_CODE_NUM from ANSWER T1 inner join ANSWER_DAY_CODE T2 on T1.ANSWER_ID=T2.ANSWER_ID where T1.ADMIN_ID=? and T2.CODE_DATE >=? and T2.CODE_DATE <=? group by T1.ANSWER_ID) B2 on B1.ANSWER_ID=B2.ANSWER_ID where B1.ADMIN_ID=? order by B1.ANSWER_ORDER asc,B1.ANSWER_ID desc", new Object[]{adminId, beginDate, endDate, adminId})) {
            list.add(new AnswerDayCode().fill(row, true));
        }
        return list;
    }
}

