/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.AgencyBillDao;
import com.coyousoft.yundama.entity.AgencyBill;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class AgencyBillDaoImpl
implements AgencyBillDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(AgencyBillDao.class);

    @Override
    public void create(AgencyBill agencyBill) throws Exception {
        this.create(agencyBill, false);
    }

    @Override
    public void create(AgencyBill agencyBill, boolean setId) throws Exception {
        this.dao.update("insert into AGENCY_BILL ( BILL_ID,ADMIN_ID ) values ( ?,? )", agencyBill.setDefault().toArray());
        if (setId) {
            agencyBill.setBillId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<AgencyBill> agencyBillList) throws Exception {
        if (agencyBillList == null || agencyBillList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(agencyBillList.size());
        for (AgencyBill agencyBill : agencyBillList) {
            params.add(agencyBill.setDefault().toArray());
        }
        this.dao.update("insert into AGENCY_BILL ( BILL_ID,ADMIN_ID ) values ( ?,? )", params);
    }

    @Override
    public int remove(Integer billId) throws Exception {
        return this.dao.update("delete from AGENCY_BILL where BILL_ID=?", new Object[]{billId});
    }

    @Override
    public int update(AgencyBill agencyBill) throws Exception {
        ArrayList<Integer> params = new ArrayList<Integer>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update AGENCY_BILL set ");
        if (agencyBill.getAdminId() != null) {
            buffer.append("ADMIN_ID=?,");
            params.add(agencyBill.getAdminId());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where BILL_ID = ?");
        params.add(agencyBill.getBillId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public AgencyBill fetch(Integer billId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from AGENCY_BILL where BILL_ID=?", new Object[]{billId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new AgencyBill().fill(row);
        }
        return null;
    }

    @Override
    public List<AgencyBill> export(int offset, int limit) throws Exception {
        ArrayList<AgencyBill> list = new ArrayList<AgencyBill>(limit);
        for (Map row : this.dao.queryForList("select * from AGENCY_BILL order by BILL_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new AgencyBill().fill(row));
        }
        return list;
    }
}

