/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.daoimpl;

import com.coyousoft.yundama.dao.AdminDao;
import com.coyousoft.yundama.entity.Admin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class AdminDaoImpl
implements AdminDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(AdminDao.class);

    @Override
    public void create(Admin admin) throws Exception {
        this.create(admin, false);
    }

    @Override
    public void create(Admin admin, boolean setId) throws Exception {
        this.dao.update("insert into ADMIN ( ADMIN_ID,ADMIN_ACCOUNT,ADMIN_PASSWORD,ADMIN_TYPE,ADMIN_NAME,ADMIN_CDATE ) values ( ?,?,?,?,?,? )", admin.setDefault().toArray());
        if (setId) {
            admin.setAdminId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<Admin> adminList) throws Exception {
        if (adminList == null || adminList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(adminList.size());
        for (Admin admin : adminList) {
            params.add(admin.setDefault().toArray());
        }
        this.dao.update("insert into ADMIN ( ADMIN_ID,ADMIN_ACCOUNT,ADMIN_PASSWORD,ADMIN_TYPE,ADMIN_NAME,ADMIN_CDATE ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer adminId) throws Exception {
        return this.dao.update("delete from ADMIN where ADMIN_ID=?", new Object[]{adminId});
    }

    @Override
    public int update(Admin admin) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update ADMIN set ");
        if (admin.getAdminAccount() != null) {
            buffer.append("ADMIN_ACCOUNT=?,");
            params.add(admin.getAdminAccount());
        }
        if (admin.getAdminPassword() != null) {
            buffer.append("ADMIN_PASSWORD=?,");
            params.add(admin.getAdminPassword());
        }
        if (admin.getAdminType() != null) {
            buffer.append("ADMIN_TYPE=?,");
            params.add(admin.getAdminType());
        }
        if (admin.getAdminName() != null) {
            buffer.append("ADMIN_NAME=?,");
            params.add(admin.getAdminName());
        }
        if (admin.getAdminCdate() != null) {
            buffer.append("ADMIN_CDATE=?,");
            params.add(admin.getAdminCdate());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where ADMIN_ID = ?");
        params.add(admin.getAdminId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public Admin fetch(Integer adminId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from ADMIN where ADMIN_ID=?", new Object[]{adminId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Admin().fill(row);
        }
        return null;
    }

    @Override
    public List<Admin> export(int offset, int limit) throws Exception {
        ArrayList<Admin> list = new ArrayList<Admin>(limit);
        for (Map row : this.dao.queryForList("select * from ADMIN order by ADMIN_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new Admin().fill(row));
        }
        return list;
    }

    @Override
    public Admin fetchByAccount(String adminAccount) throws Exception {
        if (adminAccount == null || "".equals(adminAccount.trim())) {
            return null;
        }
        Iterator iterator = this.dao.queryForList("select * from ADMIN where ADMIN_ACCOUNT=?", new Object[]{adminAccount}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Admin().fill(row);
        }
        return null;
    }

    @Override
    public List<Admin> fetchList(Integer adminType) throws Exception {
        ArrayList<Admin> list = new ArrayList<Admin>(128);
        for (Map row : this.dao.queryForList("select * from ADMIN where ADMIN_TYPE=? order by ADMIN_ID desc", new Object[]{adminType})) {
            list.add(new Admin().fill(row));
        }
        return list;
    }
}

